/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.importdata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.common.utils.LocalDateUtils;

public abstract class AbstractBatchImportPlugin
extends BatchImportPlugin {
    public static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999.99");
    public static final BigDecimal MAX_TEN_VALUE = new BigDecimal("9999999999");
    public static final String INT_REGEX = "^[1-9]\\d*|0$";
    public static final String DOUBLE_REGEX = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*$";
    public static final String MSG_TYPE_1 = "1";
    public static final String MSG_TYPE_2 = "2";
    public static final String MSG_TYPE_3 = "3";

    public abstract void recombine(List<ImportBillData> var1, ImportLogger var2);

    public Map<String, Object> getCurrentOption() {
        Map option = this.ctx.getOption();
        return option;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.recombine(rowdatas, logger);
        return super.save(rowdatas, logger);
    }

    public DataResultVo checkOrg(String orgNumber, String entityNum, String permItemId) {
        Long orgId = (Long)TaxcOrgDataServiceHelper.queryTaxcOrgIdByOrgNum((String)orgNumber).getData();
        if (orgId == null || orgId == 0L) {
            return DataResultVo.fail(String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7.\u7f16\u7801\u4e3a\uff1a\u3010%s\u3011\u662f\u7684\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"AbstractBatchImportPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), orgNumber));
        }
        Integer hasPermResult = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)"tccit", (String)entityNum, (String)permItemId);
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)orgId).getData()).booleanValue() || hasPermResult == 0) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e", (String)"AbstractBatchImportPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        TaxResult result = TaxcLicenseCheckDataServiceHelper.check((Long)orgId, (String)"tccit");
        if (result != null && Boolean.TRUE.equals(result.getData())) {
            return DataResultVo.fail(result.getMessage());
        }
        return DataResultVo.ok();
    }

    public DataResultVo validDate(String datestr, String name, Integer index) {
        Date date;
        if (StringUtil.isEmpty((CharSequence)datestr)) {
            return DataResultVo.fail("");
        }
        try {
            LocalDate parse = LocalDate.parse(datestr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            date = LocalDateUtils.localDate2Date(parse);
        }
        catch (DateTimeParseException e) {
            return DataResultVo.fail(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"AbstractBatchImportPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), name), index);
        }
        return DataResultVo.success("", date);
    }

    public Map<String, String> getAllProperties(ImportBillData billdata) {
        ImportEntityMapping entityMapping = billdata.getEntityMapping();
        DynamicObjectType entityType = entityMapping.getEntityType();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityType.getName());
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            for (IDataEntityProperty property : mainPros) {
                if (property instanceof DynamicCollectionProperty) {
                    DynamicObjectType dynamicCollectionItemPropertyType = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType();
                    DataEntityPropertyCollection detailPros = dynamicCollectionItemPropertyType.getProperties();
                    for (IDataEntityProperty detailProperty : detailPros) {
                        if (detailProperty.getDisplayName() == null) continue;
                        result.put(detailProperty.getName(), detailProperty.getDisplayName().getLocaleValue());
                    }
                }
                if (property.getDisplayName() == null) continue;
                result.put(property.getName(), property.getDisplayName().getLocaleValue());
            }
        }
        return result;
    }

    public Map<String, String> getComboItemMap(ImportBillData billdata, String comboItem) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        ImportEntityMapping entityMapping = billdata.getEntityMapping();
        DynamicObjectType entityType = entityMapping.getEntityType();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityType.getName());
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            for (IDataEntityProperty property : mainPros) {
                if (property instanceof DynamicCollectionProperty) {
                    DynamicObjectType dynamicCollectionItemPropertyType = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType();
                    DataEntityPropertyCollection detailPros = dynamicCollectionItemPropertyType.getProperties();
                    for (IDataEntityProperty detailProperty : detailPros) {
                        if (!detailProperty.getName().equals(comboItem) || !(detailProperty instanceof ComboProp)) continue;
                        return ((ComboProp)detailProperty).getComboItems().stream().collect(Collectors.toMap(s -> s.getValue(), s -> s.getName().getLocaleValue()));
                    }
                    continue;
                }
                if (!property.getName().equals(comboItem) || !(property instanceof ComboProp)) continue;
                return ((ComboProp)property).getComboItems().stream().collect(Collectors.toMap(s -> s.getValue(), s -> s.getName().getLocaleValue()));
            }
        }
        return result;
    }

    public boolean largeMaxValue(BigDecimal amount) {
        return amount != null && amount.compareTo(MAX_VALUE) > 0;
    }

    private String getMsgTips(String name, String msgType) {
        if (MSG_TYPE_1.equals(msgType)) {
            return String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\uff1a\u3010%s\u3011\u6570\u503c\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc713\u4f4d\u5b57\u7b26", (String)"AbstractBatchImportPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), name);
        }
        if (MSG_TYPE_2.equals(msgType)) {
            return String.format(ResManager.loadKDString((String)"\u6839\u636e\u8ba1\u7b97\u89c4\u5219\uff0c\u5b57\u6bb5\uff1a\u3010%s\u3011\u6574\u6570\u4f4d\u8d85\u8fc713\u4f4d\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539", (String)"AbstractBatchImportPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]), name);
        }
        return String.format(ResManager.loadKDString((String)"%s\u6570\u503c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6570\u503c\u9650\u5236\u4e3a\u6574\u657013\u4f4d\uff0c\u5c0f\u65702\u4f4d", (String)"AbstractBatchImportPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]), name);
    }

    public boolean hasMaxValue(ImportBillData billdata, ImportLogger logger, String msgType) {
        int index = billdata.getStartIndex();
        Map<String, String> allProperties = this.getAllProperties(billdata);
        ImportEntityMapping entityMapping = billdata.getEntityMapping();
        JSONObject data = billdata.getData();
        boolean hasMax = false;
        for (Map.Entry entry : entityMapping.getCols().entrySet()) {
            ImportEntityMapping.ColInfo value = (ImportEntityMapping.ColInfo)entry.getValue();
            if (!value.getProperty().getPropertyType().equals(BigDecimal.class) || !this.largeMaxValue(data.getBigDecimal((String)entry.getKey()))) continue;
            String msg = this.getMsgTips(allProperties.get(entry.getKey()), msgType);
            logger.log(Integer.valueOf(index), msg).fail();
            hasMax = true;
        }
        for (Map.Entry entry : entityMapping.getEntries().entrySet()) {
            String key = (String)entry.getKey();
            ImportEntityMapping value = (ImportEntityMapping)entry.getValue();
            for (Map.Entry infoEntry : value.getCols().entrySet()) {
                ImportEntityMapping.ColInfo value1 = (ImportEntityMapping.ColInfo)infoEntry.getValue();
                if (!value1.getProperty().getPropertyType().equals(BigDecimal.class)) continue;
                JSONArray jsonArray = (JSONArray)data.get((Object)key);
                int subIndex = billdata.getStartIndex();
                for (Object o : jsonArray) {
                    if (this.largeMaxValue(((JSONObject)o).getBigDecimal((String)infoEntry.getKey()))) {
                        String msg = this.getMsgTips(allProperties.get(entry.getKey()), msgType);
                        logger.log(Integer.valueOf(subIndex), msg).fail();
                        hasMax = true;
                    }
                    ++subIndex;
                }
            }
        }
        return hasMax;
    }

    public boolean isInteger(String value) {
        return value != null && value.matches(INT_REGEX);
    }

    public boolean isNumeric(String value) {
        return value != null && value.matches(DOUBLE_REGEX) || this.isInteger(value);
    }

    public BigDecimal bigDecimalDivide(BigDecimal a, BigDecimal b, int scale, int roundingMode) {
        if (a.compareTo(BigDecimal.ZERO) == 0 || b.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return a.divide(b, scale, roundingMode);
    }
}

