/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.importdata;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tccit.formplugin.importdata.ExtendIImportPlugin;

public class AssetLossImportFormPlugin
extends ExtendIImportPlugin {
    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        Object assetno = data.get("assetno");
        if (assetno instanceof JSONObject && data.get("org") != null) {
            Optional<DynamicObject> accountOrg;
            String accountOrgNumber;
            if (data.get("accountorg") == null) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165[\u6838\u7b97\u7ec4\u7ec7]", (String)"AssetLossImportFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0])));
                return false;
            }
            String orgNumber = ((JSONObject)data).getJSONObject("org").getString("number");
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgNums(Arrays.asList(orgNumber, accountOrgNumber = ((JSONObject)data).getJSONObject("accountorg").getString("number")));
            if (!result.isSuccess() || result.getData() == null) {
                return super.beforeImportData(data, option, importlogs);
            }
            List dataList = (List)result.getData();
            Optional<DynamicObject> org = dataList.stream().filter(e -> orgNumber.equals(e.getString("taxorg.org.number"))).findFirst();
            if (!org.isPresent()) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7", (String)"AssetLossImportFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0])));
                return false;
            }
            TaxResult orgTakeRelationObj = TaxOrgTakeRelationServiceHelper.getOrgTakeRelationObj(Collections.singletonList(org.get().getLong("taxorg.id")), (Date)new Date(), (Date)new Date());
            if (!orgTakeRelationObj.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)orgTakeRelationObj.getData()))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0e\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"AssetLossImportFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0])));
            }
            if (!(accountOrg = ((List)orgTakeRelationObj.getData()).stream().filter(e -> accountOrgNumber.equals(e.getString("number"))).findFirst()).isPresent()) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0e\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"AssetLossImportFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0])));
                return false;
            }
            String assetcode = ((JSONObject)assetno).getString("assetcode");
            QFilter q1 = new QFilter("assetsnumber", "=", (Object)assetcode);
            QFilter q2 = new QFilter("assetcode", "=", (Object)assetcode);
            QFilter q3 = new QFilter("org", "=", (Object)accountOrg.get().getLong("id"));
            QFilter q4 = new QFilter("taxorg", "=", (Object)accountOrg.get().getLong("id"));
            BigDecimal assetorigin = ((JSONObject)data).getBigDecimal("assetorigin");
            String name = ((JSONObject)data).getString("name");
            Date cleanupdate = ((JSONObject)data).getDate("cleanupdate");
            DynamicObject zjData = QueryServiceHelper.queryOne((String)"tccit_tax_acce_diff", (String)"assetsvalue,assetsname,zctype,swjsljzjtxe,acceleratedepretype", (QFilter[])new QFilter[]{q1, q3});
            DynamicObject qdData = QueryServiceHelper.queryOne((String)"tdm_asset_data", (String)"id,assetsvalue,assetname,cleaningdate,assetclass", (QFilter[])new QFilter[]{q2, q4});
            if (qdData == null) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0e\u8d44\u4ea7\u7f16\u7801\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"AssetLossImportFormPlugin_3", (String)"taxc-tccit", (Object[])new Object[0])));
                return false;
            }
            ((JSONObject)assetno).put("id", (Object)qdData.getString("id"));
            data.put("assetorigin", this.getAssetorigin(zjData, qdData, assetorigin));
            data.put("ljjszjtxe", zjData != null ? zjData.getBigDecimal("swjsljzjtxe") : BigDecimal.ZERO);
            data.put("jszjqc", zjData != null ? zjData.getString("acceleratedepretype") : "");
            data.put("name", this.getName(zjData, qdData, name));
            data.put("zctype", zjData != null ? zjData.getString("zctype") : "");
            data.put("cleanupdate", this.getCleanupdate(qdData, cleanupdate));
        }
        data.put("source", "import");
        return super.beforeImportData(data, option, importlogs);
    }

    private BigDecimal getAssetorigin(DynamicObject zjData, DynamicObject qdData, BigDecimal assetorigin) {
        Optional<BigDecimal> zjAssetsvalue = Optional.ofNullable(zjData).map(s -> s.getBigDecimal("assetsvalue")).filter(s -> s != null && s.compareTo(BigDecimal.ZERO) != 0);
        Optional<BigDecimal> qdAssetsvalue = Optional.ofNullable(qdData).map(s -> s.getBigDecimal("assetsvalue")).filter(s -> s != null && s.compareTo(BigDecimal.ZERO) != 0);
        return zjAssetsvalue.isPresent() ? zjAssetsvalue.get() : (qdAssetsvalue.isPresent() ? qdAssetsvalue.get() : assetorigin);
    }

    private String getName(DynamicObject zjData, DynamicObject qdData, String name) {
        Optional<String> zjAssetsName = Optional.ofNullable(zjData).map(s -> s.getString("assetsname")).filter(Objects::nonNull);
        Optional<String> qdAssetsName = Optional.ofNullable(qdData).map(s -> s.getString("assetname")).filter(Objects::nonNull);
        return zjAssetsName.isPresent() ? zjAssetsName.get() : (qdAssetsName.isPresent() ? qdAssetsName.get() : name);
    }

    private Date getCleanupdate(DynamicObject qdData, Date clearupdate) {
        return Optional.ofNullable(qdData).map(s -> s.getDate("cleaningdate")).filter(Objects::nonNull).orElseGet(() -> clearupdate);
    }
}

