/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.importdata;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.formplugin.importdata.AbstractBatchImportPlugin;

public class CommissionsFeesImportPlugin
extends AbstractBatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(CommissionsFeesImportPlugin.class);

    public String getDefaultKeyFields() {
        return "billno";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData billdata = it.next();
            int index = billdata.getStartIndex();
            Map<String, String> allProperties = this.getAllProperties(billdata);
            JSONObject data = billdata.getData();
            String orgNumebr = Optional.ofNullable((JSONObject)data.get((Object)"org")).map(s -> s.getString("number")).orElseThrow(() -> new KDBizException("org number can not empty!"));
            DataResultVo dataResultVo = this.checkOrg(orgNumebr, "tccit_commissions_fees", "47156aff000000ac");
            if (!dataResultVo.getSuccess().booleanValue()) {
                logger.log(Integer.valueOf(index), dataResultVo.getMessage()).fail();
                it.remove();
                continue;
            }
            String type = data.getString("type");
            if (!Lists.newArrayList((Object[])new String[]{"1", "2"}).contains(type)) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u4f63\u91d1\u624b\u7eed\u8d39\u7c7b\u578b\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879\uff1a%s", (String)"CommissionsFeesImportPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), type)).fail();
                it.remove();
                continue;
            }
            DataResultVo dataResultVo1 = this.validDate(data.getString("businessdate"), ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"CommissionsFeesImportPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]), index);
            if (!dataResultVo1.getSuccess().booleanValue()) {
                logger.log(Integer.valueOf(index), dataResultVo1.getMessage()).fail();
                it.remove();
                continue;
            }
            String msg = Lists.newArrayList((Object[])new String[]{"name", "remark"}).stream().filter(s -> StringUtil.length((CharSequence)data.getString(s)) > 100).map(s -> (String)allProperties.get(s)).collect(Collectors.joining());
            if (StringUtil.isNotBlank((CharSequence)msg)) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"%s\u8d85\u8fc7100\u4e2a\u5b57\u7b26\u9650\u5236", (String)"CommissionsFeesImportPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                it.remove();
                continue;
            }
            boolean hasMaxValue = this.hasMaxValue(billdata, logger, "3");
            if (!hasMaxValue) continue;
            it.remove();
        }
    }

    @Override
    public void recombine(List<ImportBillData> rowdatas, ImportLogger logger) {
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            String type = data.getString("type");
            if ("1".equals(type)) {
                data.put("rate", (Object)0.05);
            } else if ("2".equals(type)) {
                data.put("rate", (Object)0.1);
            }
            data.put("datasource", (Object)"import");
        }
    }
}

