/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.importdata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.taxbook.DevelopJjkcService;
import kd.taxc.tccit.common.enums.DevJjkcAmtMapEnum;
import kd.taxc.tccit.common.enums.DevJjkcEntryTypeEnum;
import kd.taxc.tccit.formplugin.importdata.AbstractBatchImportPlugin;

public class DevelopJjkcEditImportPlugin
extends AbstractBatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(DevelopJjkcEditImportPlugin.class);
    public static final String BY_SEASONAL = "1";
    public static final String BY_YEAR = "2";
    public static final String DEDUCTION_TYPE_1 = "1";
    public static final String DEDUCTION_TYPE_2 = "2";
    public static final String DEDUCTION_TYPE_3 = "3";
    private static final Map<String, DevJjkcEntryTypeEnum> SUM_MAPPING = new HashMap(){
        {
            this.put("1", DevJjkcEntryTypeEnum.RGRYFY_ENTITY);
            this.put("2", DevJjkcEntryTypeEnum.ZJTRFY_ENTITY);
            this.put(DevelopJjkcEditImportPlugin.DEDUCTION_TYPE_3, DevJjkcEntryTypeEnum.ZJFY_ENTITY);
            this.put("4", DevJjkcEntryTypeEnum.WXZCTXFY_ENTITY);
            this.put("5", DevJjkcEntryTypeEnum.XCPSJFY_ENTITY);
            this.put("6", DevJjkcEntryTypeEnum.QTXGFY_ENTITY);
            this.put("7", DevJjkcEntryTypeEnum.XETZHFY_ENTITY);
        }
    };

    protected boolean isForceBatch() {
        return true;
    }

    public String getDefaultKeyFields() {
        return "org,year,declaretype";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Map<String, Object> currentOption = this.getCurrentOption();
        String importtype = (String)currentOption.get("importtype");
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData billdata = it.next();
            int index = billdata.getStartIndex();
            Map<String, String> allProperties = this.getAllProperties(billdata);
            Map<String, String> rgryfyitemComboItemMap = this.getComboItemMap(billdata, "rgryfyitemtype");
            Map<String, String> zjtrfyitemComboItemMap = this.getComboItemMap(billdata, "zjtrfyitemtype");
            Map<String, String> zjfyitemComboItemMap = this.getComboItemMap(billdata, "zjfyitemtype");
            Map<String, String> wxzctxfyitemComboItemMap = this.getComboItemMap(billdata, "wxzctxfyitemtype");
            Map<String, String> xcpsjfyitemComboItemMap = this.getComboItemMap(billdata, "xcpsjfyitemtype");
            Map<String, String> qtxgfyitemComboItemMap = this.getComboItemMap(billdata, "qtxgfyitemtype");
            Map<String, String> xetzhfyitemComboItemMap = this.getComboItemMap(billdata, "xetzhfyitemtype");
            Map<String, String> wtyfxmmxitemComboItemMap = this.getComboItemMap(billdata, "wtyfxmmxitemtype");
            Map<String, String> yffyjjkcjejsitemComboItemMap = this.getComboItemMap(billdata, "yffyjjkcjejsitemtype");
            try {
                boolean hasMaxValue;
                BigDecimal row2;
                BigDecimal row3;
                JSONArray wtyfxmmxentity;
                JSONObject data = billdata.getData();
                String orgNumebr = Optional.ofNullable((JSONObject)data.get((Object)"org")).map(s -> s.getString("number")).orElseThrow(() -> new KDBizException("org number can not empty!"));
                DataResultVo dataResultVo = this.checkOrg(orgNumebr, "tccit_develop_jjkc", "47156aff000000ac");
                if (!dataResultVo.getSuccess().booleanValue()) {
                    logger.log(Integer.valueOf(index), dataResultVo.getMessage()).fail();
                    it.remove();
                    continue;
                }
                DataResultVo dataResultVo1 = this.validDate(data.getString("year"), allProperties.get("year"), index);
                if (!dataResultVo1.getSuccess().booleanValue()) {
                    logger.log(Integer.valueOf(index), dataResultVo1.getMessage()).fail();
                    it.remove();
                    continue;
                }
                String declaretype = data.getString("declaretype");
                if (!Lists.newArrayList((Object[])new String[]{"1", "2"}).contains(declaretype)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7533\u62a5\u7c7b\u578b\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5", (String)"DevelopJjkcEditImportPlugin_0", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                String deductiontype = data.getString("deductiontype");
                if ("2".equals(declaretype) && !Lists.newArrayList((Object[])new String[]{"1", "2", DEDUCTION_TYPE_3}).contains(deductiontype)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u7c7b\u578b\u4e3a\u6c47\u7b97\u6e05\u7f34\uff0c\u7814\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u7c7b\u578b\uff08\u6c47\u7b97\u6e05\u7f34\uff09\u8f93\u5165\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u4fee\u6539", (String)"DevelopJjkcEditImportPlugin_1", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                String jjkcbljjsff = Optional.ofNullable((JSONObject)data.get((Object)"jjkcbljjsff")).map(s -> s.getString("number")).orElseGet(() -> null);
                Date year = DateUtils.getFirstDateOfYear((Date)data.getDate("year"));
                List<String> jjkcbljjsffTypes = DevelopJjkcService.queryjjkcMethod(year);
                if ("2".equals(declaretype) && !jjkcbljjsffTypes.contains(jjkcbljjsff)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u7c7b\u578b\u4e3a\u6c47\u7b97\u6e05\u7f34\uff0c\u3010\u52a0\u8ba1\u6263\u9664\u6bd4\u4f8b\u53ca\u8ba1\u7b97\u65b9\u6cd5.\u7f16\u7801\u3011\u8f93\u5165\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u4fee\u6539", (String)"DevelopJjkcEditImportPlugin_2", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                String yjdeductiontype = Optional.ofNullable((JSONObject)data.get((Object)"yjdeductiontype")).map(s -> s.getString("number")).orElseGet(() -> null);
                if ("1".equals(declaretype) && !Lists.newArrayList((Object[])new String[]{"JJKC011", "JJKC012", "JJKC013", "JJKC021", "JJKC022", "JJKC023"}).contains(yjdeductiontype)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u7c7b\u578b\u4e3a\u9884\u7f34\uff0c\u7814\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u7c7b\u578b\uff08\u9884\u7f34\uff09\u8f93\u5165\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u4fee\u6539", (String)"DevelopJjkcEditImportPlugin_3", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                if ("1".equals(declaretype)) {
                    Long discountId = this.getDiscountId(DateUtils.getFirstDateOfYear((Date)year), yjdeductiontype);
                    if (discountId == null) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5bf9\u5e94\u7533\u62a5\u5e74\u5ea6\u7684\u9884\u7f34\u6263\u9664\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"DevelopJjkcEditImportPlugin_4", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                        it.remove();
                        continue;
                    }
                    JSONObject yjdeductiontypeObj = (JSONObject)data.get((Object)"yjdeductiontype");
                    yjdeductiontypeObj.put("id", (Object)discountId);
                }
                String ismanufacturerate = data.getString("ismanufacturerate");
                if ("1".equals(declaretype) && !Lists.newArrayList((Object[])new String[]{"0", "1"}).contains(ismanufacturerate)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f53\u7533\u62a5\u7c7b\u578b\u4e3a\u9884\u7f34\u65f6\uff0c\u9002\u7528100%\u52a0\u8ba1\u6263\u9664\u8bf7\u9009\u62e9\uff1a\u662f\u6216\u5426", (String)"DevelopJjkcEditImportPlugin_5", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                boolean isUpdate = Lists.newArrayList((Object[])new String[]{"override", "overridenew"}).contains(importtype);
                boolean exists = DevelopJjkcService.isExists(orgNumebr, year, declaretype, deductiontype);
                if (!isUpdate && exists) {
                    if ("1".equals(deductiontype) || "2".equals(deductiontype)) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u3010\u5f00\u53d1\u65b0\u6280\u672f\u3001\u65b0\u4ea7\u54c1\u3001\u65b0\u5de5\u827a\u53d1\u751f\u7684\u7814\u7a76\u5f00\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u3011\u6216\u3010\u79d1\u6280\u578b\u4e2d\u5c0f\u4f01\u4e1a\u5f00\u53d1\u65b0\u6280\u672f\u3001\u65b0\u4ea7\u54c1\u3001\u65b0\u5de5\u827a\u53d1\u751f\u7684\u7814\u7a76\u5f00\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u3011\u7684\u6570\u636e\uff0c\u5f53\u524d\u7814\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u7c7b\u578b\u65e0\u6cd5\u5f15\u5165", (String)"DevelopJjkcEditImportPlugin_6", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    } else {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u3010\u4f01\u4e1a\u4e3a\u83b7\u5f97\u521b\u65b0\u6027\u3001\u521b\u610f\u6027\u3001\u7a81\u7834\u6027\u7684\u4ea7\u54c1\u8fdb\u884c\u521b\u610f\u8bbe\u8ba1\u6d3b\u52a8\u800c\u53d1\u751f\u7684\u76f8\u5173\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u3011\uff0c\u5f53\u524d\u7814\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u7c7b\u578b\u65e0\u6cd5\u4fdd\u5b58", (String)"DevelopJjkcEditImportPlugin_7", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    }
                    it.remove();
                    continue;
                }
                if (this.checkEntity(DevJjkcEntryTypeEnum.RGRYFY_ENTITY.getEntryName(), DevJjkcEntryTypeEnum.RGRYFY_ENTITY.getItemTypeField(), Lists.newArrayList((Object[])new String[]{"1", "2", DEDUCTION_TYPE_3}), DevJjkcEntryTypeEnum.RGRYFY_ENTITY.getAmountField(), logger, it, index, rgryfyitemComboItemMap, data) || this.checkEntity(DevJjkcEntryTypeEnum.ZJTRFY_ENTITY.getEntryName(), DevJjkcEntryTypeEnum.ZJTRFY_ENTITY.getItemTypeField(), Lists.newArrayList((Object[])new String[]{"1", "2", DEDUCTION_TYPE_3, "4", "5", "6", "7", "8"}), DevJjkcEntryTypeEnum.ZJTRFY_ENTITY.getAmountField(), logger, it, index, zjtrfyitemComboItemMap, data) || this.checkEntity(DevJjkcEntryTypeEnum.ZJFY_ENTITY.getEntryName(), DevJjkcEntryTypeEnum.ZJFY_ENTITY.getItemTypeField(), Lists.newArrayList((Object[])new String[]{"1", "2"}), DevJjkcEntryTypeEnum.ZJFY_ENTITY.getAmountField(), logger, it, index, zjfyitemComboItemMap, data) || this.checkEntity(DevJjkcEntryTypeEnum.WXZCTXFY_ENTITY.getEntryName(), DevJjkcEntryTypeEnum.WXZCTXFY_ENTITY.getItemTypeField(), Lists.newArrayList((Object[])new String[]{"1", "2", DEDUCTION_TYPE_3}), DevJjkcEntryTypeEnum.WXZCTXFY_ENTITY.getAmountField(), logger, it, index, wxzctxfyitemComboItemMap, data) || this.checkEntity(DevJjkcEntryTypeEnum.XCPSJFY_ENTITY.getEntryName(), DevJjkcEntryTypeEnum.XCPSJFY_ENTITY.getItemTypeField(), Lists.newArrayList((Object[])new String[]{"1", "2", DEDUCTION_TYPE_3, "4"}), DevJjkcEntryTypeEnum.XCPSJFY_ENTITY.getAmountField(), logger, it, index, xcpsjfyitemComboItemMap, data) || this.checkEntity(DevJjkcEntryTypeEnum.QTXGFY_ENTITY.getEntryName(), DevJjkcEntryTypeEnum.QTXGFY_ENTITY.getItemTypeField(), Lists.newArrayList((Object[])new String[]{"1", "2", DEDUCTION_TYPE_3, "4", "5"}), DevJjkcEntryTypeEnum.QTXGFY_ENTITY.getAmountField(), logger, it, index, qtxgfyitemComboItemMap, data) || this.checkEntity(DevJjkcEntryTypeEnum.XETZHFY_ENTITY.getEntryName(), DevJjkcEntryTypeEnum.XETZHFY_ENTITY.getItemTypeField(), Lists.newArrayList((Object[])new String[]{"1"}), DevJjkcEntryTypeEnum.XETZHFY_ENTITY.getAmountField(), logger, it, index, xetzhfyitemComboItemMap, data) || this.checkEntity(DevJjkcEntryTypeEnum.WTYFXMMX_ENTITY.getEntryName(), DevJjkcEntryTypeEnum.WTYFXMMX_ENTITY.getItemTypeField(), Lists.newArrayList((Object[])new String[]{"1", "2", DEDUCTION_TYPE_3, "4"}), DevJjkcEntryTypeEnum.WTYFXMMX_ENTITY.getAmountField(), logger, it, index, wtyfxmmxitemComboItemMap, data)) continue;
                if (year.before(DateUtils.stringToDate((String)"2023-01-01"))) {
                    if (this.checkEntity(DevJjkcEntryTypeEnum.YFFYJJKCJEJS_ENTITY.getEntryName(), DevJjkcEntryTypeEnum.YFFYJJKCJEJS_ENTITY.getItemTypeField(), Lists.newArrayList((Object[])new String[]{"2", DEDUCTION_TYPE_3, "4", "5", "7", "9", "10", "12", "13", "16", "17"}), DevJjkcEntryTypeEnum.YFFYJJKCJEJS_ENTITY.getAmountField(), logger, it, index, yffyjjkcjejsitemComboItemMap, data)) {
                        continue;
                    }
                } else {
                    if (this.checkEntity(DevJjkcEntryTypeEnum.YFFYJJKCJEJS_ENTITY.getEntryName(), DevJjkcEntryTypeEnum.YFFYJJKCJEJS_ENTITY.getItemTypeField(), Lists.newArrayList((Object[])new String[]{"2", DEDUCTION_TYPE_3, "4", "5", "7", "9", "10"}), DevJjkcEntryTypeEnum.YFFYJJKCJEJS_ENTITY.getAmountField(), logger, it, index, yffyjjkcjejsitemComboItemMap, data)) continue;
                    JSONArray entitys = data.getJSONArray(DevJjkcEntryTypeEnum.YFFYJJKCJEJS_ENTITY.getEntryName());
                    ArrayList excludes = Lists.newArrayList((Object[])new String[]{"12", "13", "16", "17"});
                    entitys.removeIf(s -> excludes.contains(((JSONObject)s).getString(DevJjkcEntryTypeEnum.YFFYJJKCJEJS_ENTITY.getItemTypeField())));
                }
                if ((wtyfxmmxentity = data.getJSONArray("wtyfxmmxentity")) != null && (row3 = wtyfxmmxentity.stream().filter(s -> ((JSONObject)s).getString("wtyfxmmxitemtype").equals(DEDUCTION_TYPE_3)).map(s -> ((JSONObject)s).getBigDecimal("wtyfxmmxamount")).findFirst().orElseGet(() -> BigDecimal.ZERO)).compareTo(row2 = wtyfxmmxentity.stream().filter(s -> ((JSONObject)s).getString("wtyfxmmxitemtype").equals("2")).map(s -> ((JSONObject)s).getBigDecimal("wtyfxmmxamount")).findFirst().orElseGet(() -> BigDecimal.ZERO)) > 0) {
                    logger.log(Integer.valueOf(index + 2), ResManager.loadKDString((String)"\u8be5\u91d1\u989d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u3010\u59d4\u6258\u5883\u5916\u673a\u6784\u8fdb\u884c\u7814\u53d1\u6d3b\u52a8\u53d1\u751f\u7684\u8d39\u7528\u3011", (String)"DevelopJjkcEditImportPlugin_8", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                if ("1".equals(declaretype)) {
                    data.put("deductiontype", null);
                    data.put("jjkcbljjsff", null);
                }
                if ("2".equals(declaretype)) {
                    data.put("yjdeductiontype", null);
                    data.put("ismanufacturerate", null);
                }
                if (!(hasMaxValue = this.hasMaxValue(billdata, logger, "1"))) continue;
                it.remove();
            }
            catch (Exception e) {
                logger.log(Integer.valueOf(index), e.getMessage()).fail();
                it.remove();
            }
        }
    }

    private boolean checkEntity(String entryentity, String itemType, List<String> mustInputs, String amountField, ImportLogger logger, Iterator<ImportBillData> it, int index, Map<String, String> rgryfyitemComboItemMap, JSONObject data) {
        JSONArray entitys = data.getJSONArray(entryentity);
        if (entitys != null) {
            Map<String, List<Object>> itemtypeMap = entitys.stream().collect(Collectors.groupingBy(s -> ((JSONObject)s).getString(itemType)));
            Set itemtypekeys = itemtypeMap.entrySet().stream().filter(s -> ((List)s.getValue()).size() > 1).map(s -> (String)s.getKey()).collect(Collectors.toSet());
            if (itemtypekeys != null && itemtypekeys.size() > 0) {
                String msg = itemtypekeys.stream().map(s -> (String)rgryfyitemComboItemMap.get(s)).collect(Collectors.joining(","));
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String)"DevelopJjkcEditImportPlugin_9", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                it.remove();
                return true;
            }
            if (!itemtypeMap.keySet().containsAll(mustInputs)) {
                String msg = mustInputs.stream().map(s -> (String)rgryfyitemComboItemMap.get(s)).collect(Collectors.joining(","));
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6536\u5165\u9879\u76ee\u7c7b\u578b\uff1a%s\u4e3a\u5fc5\u5f55\u9879\uff0c\u8bf7\u68c0\u67e5", (String)"DevelopJjkcEditImportPlugin_10", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                it.remove();
                return true;
            }
            int tempindex = index;
            boolean flag = false;
            for (Object o : entitys) {
                JSONObject o1 = (JSONObject)o;
                if (!("yffyjjkcjejsentity".equals(entryentity) || this.isNumeric(o1.getString(amountField)) && o1.getBigDecimal(amountField).compareTo(BigDecimal.ZERO) >= 0)) {
                    logger.log(Integer.valueOf(tempindex), ResManager.loadKDString((String)"\u91d1\u989d\u5217\u8f93\u5165\u6570\u503c\u8981\u5927\u4e8e\u7b49\u4e8e0", (String)"DevelopJjkcEditImportPlugin_11", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    flag = true;
                }
                ++tempindex;
            }
            if (flag) {
                it.remove();
            }
            return flag;
        }
        return false;
    }

    @Override
    public void recombine(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            boolean bl;
            JSONObject o1;
            DevJjkcEntryTypeEnum[] values;
            ImportBillData rowdata = it.next();
            int index = rowdata.getStartIndex();
            JSONObject data = rowdata.getData();
            Date year = DateUtils.getFirstDateOfYear((Date)data.getDate("year"));
            data.put("year", (Object)year);
            for (DevJjkcEntryTypeEnum devJjkcEntryTypeEnum : values = DevJjkcEntryTypeEnum.values()) {
                JSONArray entity = data.getJSONArray(devJjkcEntryTypeEnum.getEntryName());
                Function<String, JSONObject> rowFunction = t -> this.createRow(devJjkcEntryTypeEnum.getItemTypeField(), devJjkcEntryTypeEnum.getAmountField(), devJjkcEntryTypeEnum.getTypeField(), (String)t, BigDecimal.ZERO, devJjkcEntryTypeEnum.getEntryTypeValue());
                data.put(devJjkcEntryTypeEnum.getEntryName(), (Object)this.completesItems(entity, devJjkcEntryTypeEnum.getItemTypeField(), devJjkcEntryTypeEnum.getRowCount(), rowFunction));
            }
            ArrayList needSums = Lists.newArrayList((Object[])new DevJjkcEntryTypeEnum[]{DevJjkcEntryTypeEnum.RGRYFY_ENTITY, DevJjkcEntryTypeEnum.ZJTRFY_ENTITY, DevJjkcEntryTypeEnum.ZJFY_ENTITY, DevJjkcEntryTypeEnum.WXZCTXFY_ENTITY, DevJjkcEntryTypeEnum.XCPSJFY_ENTITY, DevJjkcEntryTypeEnum.QTXGFY_ENTITY, DevJjkcEntryTypeEnum.WTYFXMMX_ENTITY, DevJjkcEntryTypeEnum.ZZYFHZ_ENTITY, DevJjkcEntryTypeEnum.YFFYJJKCJEJS_ENTITY});
            BigDecimal entrySum8 = BigDecimal.ZERO;
            BigDecimal row1 = BigDecimal.ZERO;
            for (DevJjkcEntryTypeEnum need : needSums) {
                String entryName = need.getEntryName();
                JSONArray jsonArray = data.getJSONArray(entryName);
                if (need == DevJjkcEntryTypeEnum.YFFYJJKCJEJS_ENTITY) {
                    Object row2 = BigDecimal.ZERO;
                    BigDecimal row3 = BigDecimal.ZERO;
                    BigDecimal row6 = BigDecimal.ZERO;
                    BigDecimal row7 = BigDecimal.ZERO;
                    BigDecimal row8 = BigDecimal.ZERO;
                    BigDecimal row9 = BigDecimal.ZERO;
                    BigDecimal row10 = BigDecimal.ZERO;
                    BigDecimal row11 = BigDecimal.ZERO;
                    BigDecimal rate = BigDecimal.ZERO;
                    for (Object o : jsonArray) {
                        JSONObject o12 = (JSONObject)o;
                        if ("1".equals(o12.getString(need.getItemTypeField()))) {
                            row1 = entrySum8;
                            o12.put(need.getAmountField(), (Object)row1);
                        }
                        if ("2".equals(o12.getString(need.getItemTypeField()))) {
                            row2 = o12.getBigDecimal(need.getAmountField());
                        }
                        if (DEDUCTION_TYPE_3.equals(o12.getString(need.getItemTypeField()))) {
                            row3 = o12.getBigDecimal(need.getAmountField());
                        }
                        if ("6".equals(o12.getString(need.getItemTypeField()))) {
                            row6 = jsonArray.stream().filter(s -> need.getSumRows().contains(((JSONObject)s).getString(need.getItemTypeField()))).map(s -> ((JSONObject)s).getBigDecimal(need.getAmountField())).reduce(BigDecimal.ZERO, BigDecimal::add);
                            o12.put(need.getAmountField(), (Object)row6);
                        }
                        if ("7".equals(o12.getString(need.getItemTypeField()))) {
                            row7 = o12.getBigDecimal(need.getAmountField());
                        }
                        if ("8".equals(o12.getString(need.getItemTypeField()))) {
                            row8 = row6.subtract(row7);
                            o12.put(need.getAmountField(), (Object)row8);
                        }
                        if ("9".equals(o12.getString(need.getItemTypeField()))) {
                            row9 = o12.getBigDecimal(need.getAmountField());
                        }
                        if ("10".equals(o12.getString(need.getItemTypeField()))) {
                            row10 = o12.getBigDecimal(need.getAmountField());
                        }
                        if ("11".equals(o12.getString(need.getItemTypeField()))) {
                            row11 = row8.subtract(row9).subtract(row10);
                            o12.put(need.getAmountField(), (Object)row11);
                        }
                        if ("14".equals(o12.getString(need.getItemTypeField()))) {
                            List list = AssistService.queryAssistParams((String)"YFFY-JJKC", null, (String)DateUtils.format((Date)year), (String)DateUtils.format((Date)year));
                            rate = list != null && list.size() > 0 ? new BigDecimal((String)list.get(0)) : BigDecimal.ZERO;
                            o12.put(need.getAmountField(), (Object)rate);
                        }
                        if ("15".equals(o12.getString(need.getItemTypeField()))) {
                            o12.put(need.getAmountField(), (Object)row11.multiply(rate).divide(new BigDecimal("100"), 2, 4));
                        }
                        if (!"18".equals(o12.getString(need.getItemTypeField()))) continue;
                        o12.put(need.getAmountField(), (Object)(row11.compareTo(BigDecimal.ZERO) < 0 ? row11.abs() : BigDecimal.ZERO));
                    }
                    if (row1.compareTo(((BigDecimal)row2).add(row3)) >= 0) continue;
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u3010\u5176\u4e2d\uff1a\u672c\u5e74\u8d39\u7528\u5316\u91d1\u989d\u3011+\u3010\u5176\u4e2d\uff1a\u672c\u5e74\u8d44\u672c\u5316\u91d1\u989d\u3011\u5e94\u7b49\u4e8e\u5e74\u5ea6\u7814\u53d1\u8d39\u7528\u5c0f\u8ba1\uff08\u4eba\u5458\u4eba\u5de5\u8d39\u7528+\u76f4\u63a5\u6295\u5165\u8d39\u7528+\u6298\u65e7\u8d39\u7528+\u65e0\u5f62\u8d44\u4ea7\u644a\u9500\u8d39\u7528+\u65b0\u4ea7\u54c1\u8bbe\u8ba1\u8d39\u7528\u7b49+\u7ecf\u9650\u989d\u8c03\u6574\u540e\u7684\u5176\u4ed6\u76f8\u5173\u8d39\u7528+\uff08\u4e00\uff09\u59d4\u6258\u5883\u5185\u673a\u6784\u6216\u4e2a\u4eba\u8fdb\u884c\u7814\u53d1\u6d3b\u52a8\u6240\u53d1\u751f\u7684\u8d39\u7528*80%+\u5176\u4e2d\uff1a\u5141\u8bb8\u52a0\u8ba1\u6263\u9664\u7684\u59d4\u6258\u5883\u5916\u673a\u6784\u8fdb\u884c\u7814\u53d1\u6d3b\u52a8\u53d1\u751f\u7684\u8d39\u7528\uff09", (String)"DevelopJjkcEditImportPlugin_12", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    it.remove();
                    break;
                }
                if (need == DevJjkcEntryTypeEnum.ZZYFHZ_ENTITY) {
                    for (Object o : jsonArray) {
                        JSONObject o13 = (JSONObject)o;
                        String itemTypeValue = o13.getString(need.getItemTypeField());
                        if (!"8".equals(itemTypeValue)) {
                            DevJjkcEntryTypeEnum devJjkcEntryTypeEnum = SUM_MAPPING.get(itemTypeValue);
                            BigDecimal entrySum = this.getEntrySum(devJjkcEntryTypeEnum.getToSumRow(), data.getJSONArray(devJjkcEntryTypeEnum.getEntryName()), devJjkcEntryTypeEnum.getItemTypeField(), devJjkcEntryTypeEnum.getAmountField());
                            o13.put(need.getAmountField(), (Object)entrySum);
                            entrySum8 = entrySum8.add(entrySum);
                            continue;
                        }
                        o13.put(need.getAmountField(), (Object)entrySum8);
                    }
                    continue;
                }
                Predicate<JSONObject> predicate = s -> need.getSumRows().contains(s.getString(need.getItemTypeField()));
                BigDecimal sum = jsonArray.stream().filter(s -> predicate.test((JSONObject)s)).map(s -> ((JSONObject)s).getBigDecimal(need.getAmountField())).reduce(BigDecimal.ZERO, BigDecimal::add);
                for (Object o : jsonArray) {
                    o1 = (JSONObject)o;
                    if (!o1.getString(need.getItemTypeField()).equals(need.getToSumRow())) continue;
                    o1.put(need.getAmountField(), (Object)sum);
                }
            }
            if (bl = this.hasMaxValue(rowdata, logger, "2")) {
                it.remove();
                continue;
            }
            for (DevJjkcEntryTypeEnum value3 : values) {
                JSONArray jsonArray = data.getJSONArray(value3.getEntryName());
                for (Object o : jsonArray) {
                    o1 = (JSONObject)o;
                    BigDecimal amount = o1.getBigDecimal(value3.getAmountField());
                    Integer rowNum = o1.getInteger("rowNum");
                    DevJjkcAmtMapEnum devJjkcAmtMapEnum = DevJjkcAmtMapEnum.byAmt(value3.getAmountField(), rowNum - 1);
                    data.put(devJjkcAmtMapEnum.getSaveKey(), (Object)amount);
                }
            }
        }
    }

    private BigDecimal getEntrySum(String type, JSONArray jsonArray, String itemTypeField, String amountField) {
        return jsonArray.stream().filter(s -> ((JSONObject)s).getString(itemTypeField).equals(type)).map(s -> ((JSONObject)s).getBigDecimal(amountField)).findFirst().orElseGet(() -> BigDecimal.ZERO);
    }

    public JSONObject createRow(String itemTypeField, String amountField, String typeField, String itemType, BigDecimal amount, String type) {
        JSONObject row = new JSONObject();
        row.put(itemTypeField, (Object)itemType);
        row.put(amountField, (Object)amount);
        row.put(typeField, (Object)type);
        return row;
    }

    public JSONArray completesItems(JSONArray entryentity, String type, int rows, Function<String, JSONObject> rowFunction) {
        JSONArray row = entryentity;
        if (row == null) {
            row = new JSONArray();
            List allTypes = IntStream.rangeClosed(1, rows).boxed().map(s -> String.valueOf(s)).collect(Collectors.toList());
            for (String t : allTypes) {
                row.add((Object)rowFunction.apply(t));
            }
        } else {
            List types = row.stream().map(s -> ((JSONObject)s).getString(type)).collect(Collectors.toList());
            List allTypes = IntStream.rangeClosed(1, rows).boxed().map(s -> String.valueOf(s)).collect(Collectors.toList());
            allTypes.removeAll(types);
            if (allTypes != null && allTypes.size() > 0) {
                for (String t : allTypes) {
                    row.add((Object)rowFunction.apply(t));
                }
            }
        }
        row = row.stream().sorted(Comparator.comparing(s -> ((JSONObject)s).getInteger(type))).collect(Collectors.toCollection(JSONArray::new));
        row.stream().forEach(s -> ((JSONObject)s).put("rowNum", (Object)((JSONObject)s).getInteger(type)));
        return row;
    }

    private Long getDiscountId(Date year, String number) {
        QFilter q0 = new QFilter("number", "=", (Object)number);
        QFilter q1 = new QFilter("type", "=", (Object)"yhxm");
        QFilter q2 = new QFilter("longnumber", "like", (Object)"YJ-JJKC2021%");
        QFilter q3 = new QFilter("template", "=", (Object)"qysdsyj");
        QFilter q4 = new QFilter("start", "<=", (Object)year).and(new QFilter("end", ">=", (Object)year).or(new QFilter("end", "is null", null)));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tpo_discount_tree", (String)"id", (QFilter[])new QFilter[]{q0, q1, q2, q3, q4});
        return CollectionUtils.isEmpty((Collection)objects) ? null : Long.valueOf(((DynamicObject)objects.get(0)).getLong("id"));
    }
}

