/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.importdata;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tccit.formplugin.importdata.ExtendIImportPlugin;
import org.apache.commons.lang3.math.NumberUtils;

public class EquityIncentiveImportPlugin
extends ExtendIImportPlugin {
    private static Log logger = LogFactory.getLog(EquityIncentiveImportPlugin.class);
    private static final String INCENTIVESTATE = "incentivestate";
    private static final String GPRICE = "gprice";
    private static final String PRICESUM = "pricesum";
    private static final String XPRICE = "xprice";
    private static final String OUTMONEY = "outmoney";

    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        if ("grant".equals(data.get(INCENTIVESTATE))) {
            if (null == data.get(GPRICE)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u3010\u6388\u4e88\u4ef7\u683c\uff08\u6bcf\u80a1\uff09\u3011\u5b57\u6bb5\u7684\u503c", (String)"EquityIncentiveImportPlugin_0", (String)"taxc-tccit", (Object[])new Object[0])));
            }
            if (null == data.get(PRICESUM)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u3010\u6388\u4e88\u91d1\u989d\u5408\u8ba1\u3011\u5b57\u6bb5\u7684\u503c", (String)"EquityIncentiveImportPlugin_1", (String)"taxc-tccit", (Object[])new Object[0])));
            }
            if (this.largeZero(data.get(XPRICE))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u80a1\u6743\u6fc0\u52b1\u72b6\u6001\u4e3a\u6388\u4e88\uff0c\u8bf7\u52ff\u5f55\u5165\u3010\u884c\u6743\u4ef7\u683c\uff08\u6bcf\u80a1\uff09\u3011\u5b57\u6bb5\u7684\u503c", (String)"EquityIncentiveImportPlugin_2", (String)"taxc-tccit", (Object[])new Object[0])));
            }
            if (this.largeZero(data.get(OUTMONEY))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u80a1\u6743\u6fc0\u52b1\u72b6\u6001\u4e3a\u6388\u4e88\uff0c\u8bf7\u52ff\u5f55\u5165\u3010\u80a1\u6743\u6fc0\u52b1\u652f\u51fa\u91d1\u989d\u3011\u5b57\u6bb5\u7684\u503c", (String)"EquityIncentiveImportPlugin_3", (String)"taxc-tccit", (Object[])new Object[0])));
            }
        }
        if ("exercise".equals(data.get(INCENTIVESTATE))) {
            if (null == data.get(XPRICE)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u3010\u884c\u6743\u4ef7\u683c\uff08\u6bcf\u80a1\uff09\u3011\u5b57\u6bb5\u7684\u503c", (String)"EquityIncentiveImportPlugin_4", (String)"taxc-tccit", (Object[])new Object[0])));
            }
            if (null == data.get(OUTMONEY)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u3010\u80a1\u6743\u6fc0\u52b1\u652f\u51fa\u91d1\u989d\u3011\u5b57\u6bb5\u7684\u503c", (String)"EquityIncentiveImportPlugin_5", (String)"taxc-tccit", (Object[])new Object[0])));
            }
            if (this.largeZero(data.get(GPRICE))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u80a1\u6743\u6fc0\u52b1\u72b6\u6001\u4e3a\u884c\u6743\uff0c\u8bf7\u52ff\u5f55\u5165\u3010\u6388\u4e88\u4ef7\u683c\uff08\u6bcf\u80a1\uff09\u3011\u5b57\u6bb5\u7684\u503c", (String)"EquityIncentiveImportPlugin_6", (String)"taxc-tccit", (Object[])new Object[0])));
            }
            if (this.largeZero(data.get(PRICESUM))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u80a1\u6743\u6fc0\u52b1\u72b6\u6001\u4e3a\u884c\u6743\uff0c\u8bf7\u52ff\u5f55\u5165\u3010\u6388\u4e88\u91d1\u989d\u5408\u8ba1\u3011\u5b57\u6bb5\u7684\u503c", (String)"EquityIncentiveImportPlugin_7", (String)"taxc-tccit", (Object[])new Object[0])));
            }
        }
        if (!importlogs.isEmpty()) {
            return false;
        }
        return super.beforeImportData(data, option, importlogs);
    }

    private boolean largeZero(Object data) {
        if (data == null) {
            return false;
        }
        boolean digits = NumberUtils.isDigits((String)data.toString());
        if (digits) {
            BigDecimal bigDecimal = new BigDecimal(data.toString());
            return bigDecimal.compareTo(BigDecimal.ZERO) > 0;
        }
        return false;
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"EquityIncentiveImportPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]));
        if (data.get("taxperiod") != null) {
            String accountingperiod = data.get("taxperiod").toString();
            Date accountingperiod1 = null;
            try {
                accountingperiod1 = sdf.parse(accountingperiod);
            }
            catch (ParseException e) {
                logger.info(accountingperiod + " format yyyy-MM-dd exception", (Object)e);
            }
            try {
                if (accountingperiod1 == null) {
                    accountingperiod1 = sdf1.parse(accountingperiod);
                }
            }
            catch (ParseException e) {
                logger.info(accountingperiod + " format yyyy/MM/dd exception", (Object)e);
            }
            try {
                if (accountingperiod1 == null) {
                    accountingperiod1 = sdf2.parse(accountingperiod);
                }
            }
            catch (ParseException e) {
                logger.info(accountingperiod + " format yyyy\u5e74MM\u6708 exception", (Object)e);
            }
            if (accountingperiod1 != null) {
                Calendar monthCalendar = Calendar.getInstance();
                monthCalendar.setTime(accountingperiod1);
                monthCalendar.set(monthCalendar.get(1), 1, 2, 0, 0, 0);
                Date time = monthCalendar.getTime();
                data.put("taxperiod", time);
            }
        }
        return super.importData(data, option, importlogs);
    }
}

