/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.importdata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.common.utils.BigDecimalUtils;
import kd.taxc.tccit.formplugin.importdata.ExtendIImportPlugin;

public class GetReduceImportFormPlugin
extends ExtendIImportPlugin {
    private BigDecimal getBigDecimal(JSONObject jsonObject, String field) {
        return Optional.ofNullable(jsonObject.getString(field)).filter(s -> BigDecimalUtils.checkNumeric(s)).map(s -> jsonObject.getBigDecimal(field)).orElseGet(() -> BigDecimal.ZERO);
    }

    private DataResultVo isDate(String text) {
        Date date;
        if (StringUtil.isEmpty((CharSequence)text)) {
            return DataResultVo.fail("");
        }
        try {
            date = DateUtils.stringToDate2((String)text);
        }
        catch (Exception e) {
            return DataResultVo.fail(e.getMessage());
        }
        return DataResultVo.success("", date);
    }

    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        JSONArray entryentity = (JSONArray)data.get("entryentity");
        if (entryentity.size() == 0) {
            return true;
        }
        for (Object object : entryentity) {
            JSONObject jsonObject = (JSONObject)object;
            BigDecimal income = this.getBigDecimal(jsonObject, "income");
            BigDecimal cost = this.getBigDecimal(jsonObject, "cost");
            BigDecimal relaxtax = this.getBigDecimal(jsonObject, "relaxtax");
            BigDecimal qjfyfte = this.getBigDecimal(jsonObject, "qjfyfte");
            BigDecimal nstz = this.getBigDecimal(jsonObject, "nstz");
            BigDecimal xmsde = this.getBigDecimal(jsonObject, "xmsde");
            BigDecimal total = income.subtract(cost).subtract(relaxtax).subtract(qjfyfte).add(nstz);
            if (total.compareTo(xmsde) != 0) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u9879\u76ee\u6240\u5f97\u989d \u5e94\u7b49\u4e8e \u9879\u76ee\u6536\u5165-\u9879\u76ee\u6210\u672c-\u76f8\u5173\u7a0e\u8d39-\u671f\u95f4\u8d39\u7528\u5206\u644a\u989d+\u7eb3\u7a0e\u8c03\u6574\u989d", (String)"GetReduceImportFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0])));
                return false;
            }
            String number = jsonObject.getJSONObject("nreducename").getString("number");
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_discount_tree", (String)"projtype", (QFilter[])qFilter.toArray());
            String projtype = dynamicObject.getString("projtype");
            boolean symble = false;
            String dnyhbl = jsonObject.getString("dnyhbl");
            if (!"40401".equals(number) && !"40402".equals(number)) {
                if (data.get("firstyear") == null) {
                    return true;
                }
                String firstyear = (String)data.get("firstyear");
                String year = jsonObject.getString("year");
                DataResultVo isFirstyear = this.isDate(firstyear);
                DataResultVo isYear = this.isDate(year);
                if (!isFirstyear.getSuccess().booleanValue()) {
                    importlogs.add(new ImportLogger.ImportLog(isFirstyear.getMessage()));
                    return false;
                }
                if (!isYear.getSuccess().booleanValue()) {
                    importlogs.add(new ImportLogger.ImportLog(isYear.getMessage()));
                    return false;
                }
                Date firstyearDate = DateUtils.stringToDate2((String)firstyear);
                Date yearDate = DateUtils.stringToDate2((String)year);
                int subyear = DateUtils.getYearOfDate((Date)yearDate) - DateUtils.getYearOfDate((Date)firstyearDate);
                if (subyear < 0) {
                    if (!"\u2014\u2014".equals(dnyhbl)) {
                        symble = true;
                    }
                } else if ("1".equals(projtype)) {
                    if (!"1".equals(dnyhbl)) {
                        symble = true;
                    }
                } else if ("4".equals(projtype)) {
                    if (!"0.5".equals(dnyhbl)) {
                        symble = true;
                    }
                } else if ("7".equals(projtype)) {
                    if (subyear >= 0 && subyear <= 1) {
                        if (!"1".equals(dnyhbl)) {
                            symble = true;
                        }
                    } else if (subyear >= 2 && subyear <= 4) {
                        if (!"0.5".equals(dnyhbl)) {
                            symble = true;
                        }
                    } else if (!"\u2014\u2014".equals(dnyhbl)) {
                        symble = true;
                    }
                } else if ("5".equals(projtype)) {
                    if (subyear >= 0 && subyear <= 2) {
                        if (!"1".equals(dnyhbl)) {
                            symble = true;
                        }
                    } else if (subyear >= 3 && subyear <= 5) {
                        if (!"0.5".equals(dnyhbl)) {
                            symble = true;
                        }
                    } else if (!"\u2014\u2014".equals(dnyhbl)) {
                        symble = true;
                    }
                } else if ("8".equals(projtype)) {
                    if (subyear >= 0 && subyear <= 4) {
                        if (!"1".equals(dnyhbl)) {
                            symble = true;
                        }
                    } else if (subyear >= 5 && subyear <= 9) {
                        if (!"0.5".equals(dnyhbl)) {
                            symble = true;
                        }
                    } else if (!"\u2014\u2014".equals(dnyhbl)) {
                        symble = true;
                    }
                } else if ("9".equals(projtype)) {
                    if (!"0.5".equals(dnyhbl) && !"1".equals(dnyhbl)) {
                        symble = true;
                    }
                } else if ("13".equals(projtype)) {
                    if (subyear < 11) {
                        if (!"1".equals(dnyhbl)) {
                            symble = true;
                        }
                    } else if (!"\u2014\u2014".equals(dnyhbl)) {
                        symble = true;
                    }
                }
            } else {
                if ("40401".equals(number)) {
                    if (!"0.5or1".equals(dnyhbl)) {
                        symble = true;
                    }
                } else if (!"1or0.5".equals(dnyhbl)) {
                    symble = true;
                }
                data.put("firstyear", "1999-01-01");
            }
            if (!symble) continue;
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u5e74\u4f18\u60e0\u6bd4\u4f8b\u5e94\u548c\u4f18\u60e0\u9879\u76ee\u7684\u4f18\u60e0\u7c7b\u578b\u76f8\u5339\u914d", (String)"GetReduceImportFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0])));
            return false;
        }
        return super.beforeImportData(data, option, importlogs);
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        return super.importData(data, option, importlogs);
    }
}

