/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.importdata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.taxbook.GovSubsidyDeferService;
import kd.taxc.tccit.formplugin.importdata.AbstractBatchImportPlugin;

public class GovSubsidyDeferImportPlugin
extends AbstractBatchImportPlugin {
    private static GovSubsidyDeferService deferService = new GovSubsidyDeferService();

    protected boolean isForceBatch() {
        return true;
    }

    public String getDefaultKeyFields() {
        return "org,billno";
    }

    public List<String> getDefaultLockUIs() {
        return Collections.singletonList("keyfields");
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData billdata = it.next();
            int index = billdata.getStartIndex();
            Map<String, String> allProperties = this.getAllProperties(billdata);
            try {
                boolean hasMaxValue;
                JSONArray carryFwdLoss;
                Date contractend;
                JSONObject data = billdata.getData();
                String orgNumebr = Optional.ofNullable((JSONObject)data.get((Object)"org")).map(s -> s.getString("number")).orElseThrow(() -> new KDBizException("org number can not empty!"));
                DataResultVo dataResultVo = this.checkOrg(orgNumebr, "tccit_gov_subsidy_defer", "47156aff000000ac");
                if (!dataResultVo.getSuccess().booleanValue()) {
                    logger.log(Integer.valueOf(index), dataResultVo.getMessage()).fail();
                    it.remove();
                    continue;
                }
                BigDecimal totalamt = Optional.ofNullable(data.getString("totalamt")).filter(s -> this.isNumeric((String)s)).map(s -> new BigDecimal((String)s)).orElseGet(() -> BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(totalamt) >= 0) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"%s\u5e94\u4e3a\u5927\u4e8e0\u7684\u6570\u503c", (String)"GovSubsidyDeferImportPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), allProperties.get("totalamt"))).fail();
                    it.remove();
                    continue;
                }
                Set collect1 = Lists.newArrayList((Object[])new String[]{"contractstart", "contractend"}).stream().map(s -> this.validDate(data.getString(s), (String)allProperties.get(s), index)).filter(s -> s.getSuccess() == false).collect(Collectors.toSet());
                if (collect1 != null && collect1.size() > 0) {
                    String msg = collect1.stream().map(s -> s.getMessage()).collect(Collectors.joining(","));
                    logger.log(Integer.valueOf(index), msg).fail();
                    it.remove();
                    continue;
                }
                Date contractstart = data.getDate("contractstart");
                if (contractstart.after(contractend = data.getDate("contractend"))) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5408\u540c\u671f\u95f4\uff08\u6b62\uff09\u7684\u65f6\u95f4\u5e94\u665a\u4e8e\u665a\u4e8e\u5408\u540c\u671f\u95f4\uff08\u8d77\uff09\u7684\u65f6\u95f4", (String)"GovSubsidyDeferImportPlugin_1", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                String accountingmethod = data.getString("accountingmethod");
                if (!Lists.newArrayList((Object[])new String[]{"1", "2"}).contains(accountingmethod)) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u65b9\u5f0f\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879\uff1a%s", (String)"GovSubsidyDeferImportPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), accountingmethod)).fail();
                    it.remove();
                    continue;
                }
                JSONArray recSubsidy = data.getJSONArray("tccit_rec_subsidy");
                BigDecimal sumSAmount = BigDecimal.ZERO;
                if (recSubsidy != null) {
                    int recSubIndex = index;
                    boolean recFlag = false;
                    for (Object o : recSubsidy) {
                        DataResultVo dataResultVo1;
                        JSONObject o1 = (JSONObject)o;
                        Set collect = Lists.newArrayList((Object[])new String[]{"s_bookeddate", "s_amount"}).stream().filter(s -> Objects.isNull(o1.get(s))).collect(Collectors.toSet());
                        if (collect != null && collect.size() > 0) {
                            String msg = collect.stream().map(s -> (String)allProperties.get(s)).collect(Collectors.joining(","));
                            logger.log(Integer.valueOf(recSubIndex), String.format(ResManager.loadKDString((String)"%s\u5c1a\u672a\u5f55\u5165", (String)"GovSubsidyDeferImportPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                            recFlag = true;
                        }
                        if (!this.isNumeric(o1.getString("s_amount")) || BigDecimal.ZERO.compareTo(o1.getBigDecimal("s_amount")) > 0) {
                            logger.log(Integer.valueOf(recSubIndex), String.format(ResManager.loadKDString((String)"%s\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c", (String)"GovSubsidyDeferImportPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), allProperties.get("s_amount"))).fail();
                            recFlag = true;
                        }
                        if (!(dataResultVo1 = this.validDate(o1.getString("s_bookeddate"), allProperties.get("s_bookeddate"), recSubIndex)).getSuccess().booleanValue()) {
                            logger.log(Integer.valueOf(recSubIndex), dataResultVo1.getMessage()).fail();
                            recFlag = true;
                        }
                        ++recSubIndex;
                    }
                    if (recFlag) {
                        it.remove();
                        continue;
                    }
                    sumSAmount = recSubsidy.stream().map(s -> ((JSONObject)s).getBigDecimal("s_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (sumSAmount.compareTo(totalamt) > 0) {
                        logger.log(Integer.valueOf(recSubIndex), ResManager.loadKDString((String)"\u6536\u5230\u8865\u52a9\u91d1\u989d\u5408\u8ba1\u4e0d\u5f97\u8d85\u8fc7\u5408\u540c\u603b\u91d1\u989d", (String)"GovSubsidyDeferImportPlugin_5", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                        it.remove();
                        continue;
                    }
                }
                if ((carryFwdLoss = data.getJSONArray("tccit_carry_fwd_loss")) != null) {
                    Object o;
                    int carryIndex = index;
                    boolean carryFlag = false;
                    o = carryFwdLoss.iterator();
                    while (o.hasNext()) {
                        DataResultVo dataResultVo1;
                        Object o2 = o.next();
                        JSONObject o1 = (JSONObject)o2;
                        Set collect = Lists.newArrayList((Object[])new String[]{"j_bookeddate", "j_amount"}).stream().filter(s -> Objects.isNull(o1.get(s))).collect(Collectors.toSet());
                        if (collect != null && collect.size() > 0) {
                            String msg = collect.stream().map(s -> (String)allProperties.get(s)).collect(Collectors.joining(","));
                            logger.log(Integer.valueOf(carryIndex), String.format(ResManager.loadKDString((String)"%s\u5c1a\u672a\u5f55\u5165", (String)"GovSubsidyDeferImportPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                            carryFlag = true;
                        }
                        if (!this.isNumeric(o1.getString("j_amount")) || BigDecimal.ZERO.compareTo(o1.getBigDecimal("j_amount")) > 0) {
                            logger.log(Integer.valueOf(carryIndex), String.format(ResManager.loadKDString((String)"%s\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c", (String)"GovSubsidyDeferImportPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), allProperties.get("j_amount"))).fail();
                            carryFlag = true;
                        }
                        if (!(dataResultVo1 = this.validDate(o1.getString("j_bookeddate"), allProperties.get("j_bookeddate"), carryIndex)).getSuccess().booleanValue()) {
                            logger.log(Integer.valueOf(carryIndex), dataResultVo1.getMessage()).fail();
                            carryFlag = true;
                        }
                        ++carryIndex;
                    }
                    if (carryFlag) {
                        it.remove();
                        continue;
                    }
                    BigDecimal sumJAmount = carryFwdLoss.stream().map(s -> ((JSONObject)s).getBigDecimal("j_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (sumJAmount.compareTo(sumSAmount) > 0) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u7ed3\u8f6c\u635f\u76ca\u91d1\u989d\u5408\u8ba1\u4e0d\u5f97\u8d85\u8fc7\u6536\u5230\u8865\u52a9\u91d1\u989d\u5408\u8ba1\u6570", (String)"GovSubsidyDeferImportPlugin_6", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                        it.remove();
                        continue;
                    }
                }
                if (!(hasMaxValue = this.hasMaxValue(billdata, logger, "1"))) continue;
                it.remove();
            }
            catch (Exception e) {
                logger.log(Integer.valueOf(index), e.getMessage()).fail();
                it.remove();
            }
        }
    }

    @Override
    public void recombine(List<ImportBillData> rowdatas, ImportLogger logger) {
        Map<String, Object> currentOption = this.getCurrentOption();
        String importtype = (String)currentOption.get("importtype");
        for (ImportBillData rowdata : rowdatas) {
            DynamicObject object;
            JSONObject data = rowdata.getData();
            String billno = (String)data.get((Object)"billno");
            String orgNumebr = Optional.ofNullable((JSONObject)data.get((Object)"org")).map(s -> s.getString("number")).orElseThrow(() -> new KDBizException("org number can not empty!"));
            if (Lists.newArrayList((Object[])new String[]{"override", "overridenew"}).contains(importtype) && (object = deferService.queryByUnionKey(orgNumebr, billno)) != null) {
                DynamicObjectCollection subsidy = object.getDynamicObjectCollection("tccit_rec_subsidy");
                subsidy.clear();
                DynamicObjectCollection fwdloss = object.getDynamicObjectCollection("tccit_carry_fwd_loss");
                fwdloss.clear();
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
            JSONArray recSubsidy = data.getJSONArray("tccit_rec_subsidy");
            BigDecimal sumSAmount = BigDecimal.ZERO;
            if (recSubsidy != null) {
                sumSAmount = recSubsidy.stream().filter(s -> Objects.nonNull(((JSONObject)s).get((Object)"s_amount"))).map(s -> ((JSONObject)s).getBigDecimal("s_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            JSONArray carryFwdLoss = data.getJSONArray("tccit_carry_fwd_loss");
            BigDecimal sumJAmount = BigDecimal.ZERO;
            if (carryFwdLoss != null) {
                sumJAmount = carryFwdLoss.stream().map(s -> ((JSONObject)s).getBigDecimal("j_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            data.put("ljsdbzamount", (Object)sumSAmount);
            data.put("ljjzsyamount", (Object)sumJAmount);
            data.put("sywjzamount", (Object)sumSAmount.subtract(sumJAmount));
        }
    }
}

