/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.importdata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.taxbook.HighTechAccountService;
import kd.taxc.tccit.formplugin.importdata.AbstractBatchImportPlugin;

public class HighTechAccountImportPlugin
extends AbstractBatchImportPlugin {
    private HighTechAccountService highTechAccountService = new HighTechAccountService();
    private static final BigDecimal ZERO_POINT_TWO = new BigDecimal("0.2");
    private static final BigDecimal ZERO_POINT_FOUR = new BigDecimal("0.4");
    private static final BigDecimal ZERO_POINT_SIX = new BigDecimal("0.6");
    private static final BigDecimal ZERO_POINT_EIGHT = new BigDecimal("0.8");

    protected boolean isForceBatch() {
        return true;
    }

    public String getDefaultKeyFields() {
        return "org,year";
    }

    public List<String> getDefaultLockUIs() {
        return Collections.singletonList("keyfields");
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Map<String, Object> currentOption = this.getCurrentOption();
        String importtype = (String)currentOption.get("importtype");
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData billdata = it.next();
            int index = billdata.getStartIndex();
            Map<String, String> allProperties = this.getAllProperties(billdata);
            Map<String, String> incomeComboItemMap = this.getComboItemMap(billdata, "incometype");
            Map<String, String> developComboItemMap = this.getComboItemMap(billdata, "developtype");
            try {
                boolean hasMaxValue;
                JSONArray developentryentity;
                JSONObject data = billdata.getData();
                String orgNumebr = Optional.ofNullable((JSONObject)data.get((Object)"org")).map(s -> s.getString("number")).orElseThrow(() -> new KDBizException("org number can not empty!"));
                DataResultVo dataResultVo = this.checkOrg(orgNumebr, "tccit_high_tech_account", "47156aff000000ac");
                if (!dataResultVo.getSuccess().booleanValue()) {
                    logger.log(Integer.valueOf(index), dataResultVo.getMessage()).fail();
                    it.remove();
                    continue;
                }
                DataResultVo dataResultVo1 = this.validDate(data.getString("year"), allProperties.get("year"), index);
                if (!dataResultVo1.getSuccess().booleanValue()) {
                    logger.log(Integer.valueOf(index), dataResultVo1.getMessage()).fail();
                    it.remove();
                    continue;
                }
                Date year = data.getDate("year");
                DynamicObject object = this.highTechAccountService.queryOne(orgNumebr, year);
                boolean isUpdate = Lists.newArrayList((Object[])new String[]{"override", "overridenew"}).contains(importtype);
                if (!isUpdate && object != null) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7%s\u5e74\u5df2\u5b58\u5728\u9ad8\u65b0\u6280\u672f\u4f01\u4e1a\u4f18\u60e0\u60c5\u51b5\u53f0\u8d26\uff0c\u8bf7\u52ff\u91cd\u590d\u65b0\u5efa\u6863\u6848", (String)"HighTechAccountImportPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), DateUtils.format((Date)year, (String)"yyyy"))).fail();
                    it.remove();
                    continue;
                }
                Set names = Lists.newArrayList((Object[])new String[]{"peoples", "totalpeoples"}).stream().filter(s -> StringUtil.isBlank((CharSequence)data.getString(s)) || !this.isInteger(data.getString(s)) || data.getBigDecimal(s).compareTo(BigDecimal.ZERO) < 0 || data.getBigDecimal(s).compareTo(MAX_TEN_VALUE) > 0).collect(Collectors.toSet());
                if (names != null && names.size() > 0) {
                    String msg = names.stream().map(s -> (String)allProperties.get(s)).collect(Collectors.joining(","));
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"%s\u5e94\u4e3a\u6b63\u6574\u6570\uff0c\u4e14\u4e0d\u8d85\u8fc710\u4f4d\u5b57\u7b26", (String)"HighTechAccountImportPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                    it.remove();
                    continue;
                }
                JSONArray incomeentryentity = data.getJSONArray("incomeentryentity");
                if (incomeentryentity != null) {
                    Map<String, List<Object>> incometypeMap = incomeentryentity.stream().collect(Collectors.groupingBy(s -> ((JSONObject)s).getString("incometype")));
                    Set incometypes = incometypeMap.entrySet().stream().filter(s -> ((List)s.getValue()).size() > 1).map(s -> (String)s.getKey()).collect(Collectors.toSet());
                    if (incometypes != null && incometypes.size() > 0) {
                        String msg = incometypes.stream().map(s -> (String)incomeComboItemMap.get(s)).collect(Collectors.joining(","));
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String)"HighTechAccountImportPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                        it.remove();
                        continue;
                    }
                    if (!incometypeMap.keySet().containsAll(Lists.newArrayList((Object[])new String[]{"1", "2", "4", "5"}))) {
                        String msg = Lists.newArrayList((Object[])new String[]{"1", "2", "4", "5"}).stream().map(s -> (String)incomeComboItemMap.get(s)).collect(Collectors.joining(","));
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6536\u5165\u9879\u76ee\u7c7b\u578b\uff1a%s\u4e3a\u5fc5\u5f55\u9879\uff0c\u8bf7\u68c0\u67e5", (String)"HighTechAccountImportPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                        it.remove();
                        continue;
                    }
                    int incomeindex = index;
                    boolean incomeFlag = false;
                    for (Object o : incomeentryentity) {
                        JSONObject o1 = (JSONObject)o;
                        if (!this.isNumeric(o1.getString("incomerate"))) {
                            logger.log(Integer.valueOf(incomeindex), String.format(ResManager.loadKDString((String)"%s\u5e94\u4e3a\u6570\u503c", (String)"HighTechAccountImportPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), allProperties.get("incomerate"))).fail();
                            incomeFlag = true;
                        }
                        ++incomeindex;
                    }
                    if (incomeFlag) {
                        it.remove();
                        continue;
                    }
                    BigDecimal bnsrze = incomeentryentity.stream().filter(s -> ((JSONObject)s).getString("incometype").equals("4")).map(s -> ((JSONObject)s).getBigDecimal("incomerate")).findFirst().orElseGet(() -> BigDecimal.ZERO);
                    BigDecimal bnbzssr = incomeentryentity.stream().filter(s -> ((JSONObject)s).getString("incometype").equals("5")).map(s -> ((JSONObject)s).getBigDecimal("incomerate")).findFirst().orElseGet(() -> BigDecimal.ZERO);
                    if (bnbzssr.compareTo(bnsrze) > 0) {
                        logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u672c\u5e74\u4e0d\u5f81\u7a0e\u6536\u5165\u4e0d\u80fd\u5927\u4e8e\u672c\u5e74\u6536\u5165\u603b\u989d", (String)"HighTechAccountImportPlugin_5", (String)"taxc-tccit", (Object[])new Object[0])).fail();
                        it.remove();
                        continue;
                    }
                }
                if ((developentryentity = data.getJSONArray("developentryentity")) != null) {
                    Map<String, List<Object>> developtypeMap = developentryentity.stream().collect(Collectors.groupingBy(s -> ((JSONObject)s).getString("developtype")));
                    Set developtypes = developtypeMap.entrySet().stream().filter(s -> ((List)s.getValue()).size() > 1).map(s -> (String)s.getKey()).collect(Collectors.toSet());
                    if (developtypes != null && developtypes.size() > 0) {
                        String msg = developtypes.stream().map(s -> (String)developComboItemMap.get(s)).collect(Collectors.joining(","));
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a\u3010%s\u3011\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (String)"HighTechAccountImportPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                        it.remove();
                        continue;
                    }
                    ArrayList mustInputItems = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "10", "11", "15"});
                    if (!developtypeMap.keySet().containsAll(mustInputItems)) {
                        String msg = mustInputItems.stream().map(s -> (String)incomeComboItemMap.get(s)).collect(Collectors.joining(","));
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7814\u53d1\u8d39\u7528\u9879\u76ee\u7c7b\u578b\uff1a%s\u4e3a\u5fc5\u5f55\u9879\uff0c\u8bf7\u68c0\u67e5", (String)"HighTechAccountImportPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                        it.remove();
                        continue;
                    }
                    int developindex = index;
                    boolean developFlag = false;
                    for (Object o : developentryentity) {
                        JSONObject o1 = (JSONObject)o;
                        Set columns = Lists.newArrayList((Object[])new String[]{"curryear", "pretwoyear", "prethreeyear"}).stream().filter(s -> !this.isNumeric(o1.getString(s))).collect(Collectors.toSet());
                        if (columns != null && columns.size() > 0) {
                            String msg = columns.stream().map(s -> (String)allProperties.get(s)).collect(Collectors.joining(","));
                            logger.log(Integer.valueOf(developindex), String.format(ResManager.loadKDString((String)"%s\u5e94\u4e3a\u6570\u503c", (String)"HighTechAccountImportPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), msg)).fail();
                            developFlag = true;
                        }
                        ++developindex;
                    }
                    if (developFlag) {
                        it.remove();
                        continue;
                    }
                }
                if (!(hasMaxValue = this.hasMaxValue(billdata, logger, "1"))) continue;
                it.remove();
            }
            catch (Exception e) {
                logger.log(Integer.valueOf(index), e.getMessage()).fail();
                it.remove();
            }
        }
    }

    @Override
    public void recombine(List<ImportBillData> rowdatas, ImportLogger logger) {
        Map<String, Object> currentOption = this.getCurrentOption();
        String importtype = (String)currentOption.get("importtype");
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            boolean hasMaxValue;
            JSONArray developentryentity;
            JSONArray incomeentryentity;
            DynamicObject object;
            ImportBillData rowdata = it.next();
            JSONObject data = rowdata.getData();
            data.put("year", (Object)DateUtils.getFirstDateOfYear((Date)data.getDate("year")));
            data.put("keyrate1", (Object)this.getKeyRate1(data));
            data.put("peoplerate", (Object)this.getKeyRate1(data));
            String orgNumebr = Optional.ofNullable((JSONObject)data.get((Object)"org")).map(s -> s.getString("number")).orElseThrow(() -> new KDBizException("org number can not empty!"));
            if (Lists.newArrayList((Object[])new String[]{"override", "overridenew"}).contains(importtype) && (object = this.highTechAccountService.queryOne(orgNumebr, data.getDate("year"))) != null) {
                object.getDynamicObjectCollection("incomeentryentity").clear();
                object.getDynamicObjectCollection("developentryentity").clear();
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
            if ((incomeentryentity = data.getJSONArray("incomeentryentity")) != null) {
                incomeentryentity = this.completesItems(incomeentryentity, "incometype", 7, t -> this.createIncomeRow((String)t, BigDecimal.ZERO));
                BigDecimal amount1 = BigDecimal.ZERO;
                BigDecimal amount2 = BigDecimal.ZERO;
                BigDecimal amount3 = BigDecimal.ZERO;
                BigDecimal amount4 = BigDecimal.ZERO;
                BigDecimal amount5 = BigDecimal.ZERO;
                BigDecimal amount6 = BigDecimal.ZERO;
                BigDecimal amount7 = BigDecimal.ZERO;
                for (Object o : incomeentryentity) {
                    JSONObject row = (JSONObject)o;
                    String incometype = row.getString("incometype");
                    if ("1".equals(incometype)) {
                        amount1 = row.getBigDecimal("incomerate");
                    }
                    if ("2".equals(incometype)) {
                        amount2 = row.getBigDecimal("incomerate");
                    }
                    if ("3".equals(incometype)) {
                        amount3 = amount1.add(amount2);
                        row.put("incomerate", (Object)amount3);
                    }
                    if ("4".equals(incometype)) {
                        amount4 = row.getBigDecimal("incomerate");
                    }
                    if ("5".equals(incometype)) {
                        amount5 = row.getBigDecimal("incomerate");
                    }
                    if ("6".equals(incometype)) {
                        amount6 = amount4.subtract(amount5);
                        row.put("incomerate", (Object)amount6);
                    }
                    if (!"7".equals(incometype)) continue;
                    amount7 = this.bigDecimalDivide(amount3, amount6, 4, 4);
                    row.put("incomerate", (Object)amount7);
                    data.put("keyrate2", (Object)amount7);
                }
                data.put("incomeentryentity", (Object)incomeentryentity);
            }
            if ((developentryentity = data.getJSONArray("developentryentity")) != null) {
                developentryentity = this.completesItems(developentryentity, "developtype", 16, t -> this.createDevelopRow((String)t, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                BigDecimal curryearSum1_6 = BigDecimal.ZERO;
                BigDecimal pretwoyearSum1_6 = BigDecimal.ZERO;
                BigDecimal prethreeyearSum1_6 = BigDecimal.ZERO;
                for (Object o : developentryentity) {
                    Map<String, BigDecimal> entryToTransferMap;
                    JSONObject row = (JSONObject)o;
                    String developtype = row.getString("developtype");
                    if (Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "15"}).contains(developtype)) {
                        if (Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6"}).contains(developtype)) {
                            curryearSum1_6 = curryearSum1_6.add(row.getBigDecimal("curryear"));
                            pretwoyearSum1_6 = pretwoyearSum1_6.add(row.getBigDecimal("pretwoyear"));
                            prethreeyearSum1_6 = prethreeyearSum1_6.add(row.getBigDecimal("prethreeyear"));
                        }
                        if ("8".equals(developtype)) {
                            entryToTransferMap = this.entryToTransferMap(developentryentity);
                            row.put("curryear", (Object)BigDecimalUtil.min((Object)curryearSum1_6.multiply(ZERO_POINT_TWO).divide(ZERO_POINT_EIGHT, 2, 4), (Object)entryToTransferMap.get("7_curryear")));
                            row.put("pretwoyear", (Object)BigDecimalUtil.min((Object)pretwoyearSum1_6.multiply(ZERO_POINT_TWO).divide(ZERO_POINT_EIGHT, 2, 4), (Object)entryToTransferMap.get("7_pretwoyear")));
                            row.put("prethreeyear", (Object)BigDecimalUtil.min((Object)prethreeyearSum1_6.multiply(ZERO_POINT_TWO).divide(ZERO_POINT_EIGHT, 2, 4), (Object)entryToTransferMap.get("7_prethreeyear")));
                        }
                        if ("9".equals(developtype)) {
                            entryToTransferMap = this.entryToTransferMap(developentryentity);
                            row.put("curryear", (Object)curryearSum1_6.add(entryToTransferMap.get("8_curryear")));
                            row.put("pretwoyear", (Object)pretwoyearSum1_6.add(entryToTransferMap.get("8_pretwoyear")));
                            row.put("prethreeyear", (Object)prethreeyearSum1_6.add(entryToTransferMap.get("8_prethreeyear")));
                        }
                        if ("12".equals(developtype)) {
                            entryToTransferMap = this.entryToTransferMap(developentryentity);
                            row.put("curryear", (Object)BigDecimalUtil.min((Object)curryearSum1_6.add(entryToTransferMap.get("7_curryear")).multiply(ZERO_POINT_FOUR).divide(ZERO_POINT_SIX, 2, 4), (Object)entryToTransferMap.get("11_curryear")));
                            row.put("pretwoyear", (Object)BigDecimalUtil.min((Object)pretwoyearSum1_6.add(entryToTransferMap.get("7_pretwoyear")).multiply(ZERO_POINT_FOUR).divide(ZERO_POINT_SIX, 2, 4), (Object)entryToTransferMap.get("11_pretwoyear")));
                            row.put("prethreeyear", (Object)BigDecimalUtil.min((Object)prethreeyearSum1_6.add(entryToTransferMap.get("7_prethreeyear")).multiply(ZERO_POINT_FOUR).divide(ZERO_POINT_SIX, 2, 4), (Object)entryToTransferMap.get("11_prethreeyear")));
                        }
                        row.put("developrate", (Object)this.getRowSum(row));
                    }
                    if ("13".equals(developtype)) {
                        entryToTransferMap = this.entryToTransferMap(developentryentity);
                        row.put("curryear", (Object)entryToTransferMap.get("10_curryear").add(entryToTransferMap.get("12_curryear")).multiply(ZERO_POINT_EIGHT).setScale(2, 4));
                        row.put("pretwoyear", (Object)entryToTransferMap.get("10_pretwoyear").add(entryToTransferMap.get("12_pretwoyear")).multiply(ZERO_POINT_EIGHT).setScale(2, 4));
                        row.put("prethreeyear", (Object)entryToTransferMap.get("10_prethreeyear").add(entryToTransferMap.get("12_prethreeyear")).multiply(ZERO_POINT_EIGHT).setScale(2, 4));
                        row.put("developrate", (Object)this.getRowSum(row));
                    }
                    if ("14".equals(developtype)) {
                        entryToTransferMap = this.entryToTransferMap(developentryentity);
                        row.put("curryear", (Object)entryToTransferMap.get("9_curryear").add(entryToTransferMap.get("13_curryear")));
                        row.put("pretwoyear", (Object)entryToTransferMap.get("9_pretwoyear").add(entryToTransferMap.get("13_pretwoyear")));
                        row.put("prethreeyear", (Object)entryToTransferMap.get("9_prethreeyear").add(entryToTransferMap.get("13_prethreeyear")));
                        row.put("developrate", (Object)entryToTransferMap.get("9_developrate").add(entryToTransferMap.get("13_developrate")));
                    }
                    if (!"16".equals(developtype)) continue;
                    entryToTransferMap = this.entryToTransferMap(developentryentity);
                    BigDecimal rate = this.bigDecimalDivide(entryToTransferMap.get("14_developrate"), entryToTransferMap.get("15_developrate"), 4, 4);
                    row.put("developrate", (Object)rate);
                    data.put("keyrate3", (Object)rate);
                }
            }
            if (hasMaxValue = this.hasMaxValue(rowdata, logger, "1")) {
                it.remove();
                continue;
            }
            data.put("developentryentity", (Object)developentryentity);
        }
    }

    private Map<String, BigDecimal> entryToTransferMap(JSONArray developentryentity) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
        for (Object o : developentryentity) {
            JSONObject row = (JSONObject)o;
            String developtype = row.getString("developtype");
            ArrayList columns = Lists.newArrayList((Object[])new String[]{"curryear", "pretwoyear", "prethreeyear", "developrate"});
            for (String column : columns) {
                BigDecimal bigDecimal = row.getBigDecimal(column);
                map.put(developtype + "_" + column, bigDecimal);
            }
        }
        return map;
    }

    private BigDecimal getKeyRate1(JSONObject data) {
        BigDecimal peoples = data.getBigDecimal("peoples");
        BigDecimal totalpeoples = data.getBigDecimal("totalpeoples");
        return this.bigDecimalDivide(peoples, totalpeoples, 4, 4);
    }

    public JSONObject createIncomeRow(String incometype, BigDecimal amount) {
        JSONObject row = new JSONObject();
        row.put("incometype", (Object)incometype);
        row.put("incomerate", (Object)amount);
        return row;
    }

    public JSONObject createDevelopRow(String incometype, BigDecimal curryear, BigDecimal pretwoyear, BigDecimal prethreeyear, BigDecimal developrate) {
        JSONObject row = new JSONObject();
        row.put("developtype", (Object)incometype);
        row.put("curryear", (Object)curryear);
        row.put("pretwoyear", (Object)pretwoyear);
        row.put("prethreeyear", (Object)prethreeyear);
        row.put("developrate", (Object)developrate);
        return row;
    }

    public BigDecimal getRowSum(JSONObject jsonObject) {
        return Lists.newArrayList((Object[])new String[]{"curryear", "pretwoyear", "prethreeyear"}).stream().map(s -> jsonObject.getBigDecimal(s)).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4);
    }

    public JSONArray completesItems(JSONArray entryentity, String type, int rows, Function<String, JSONObject> rowFunction) {
        List types = entryentity.stream().map(s -> ((JSONObject)s).getString(type)).collect(Collectors.toList());
        List allTypes = IntStream.rangeClosed(1, rows).boxed().map(s -> String.valueOf(s)).collect(Collectors.toList());
        allTypes.removeAll(types);
        if (allTypes != null && allTypes.size() > 0) {
            for (String t : allTypes) {
                entryentity.add((Object)rowFunction.apply(t));
            }
            entryentity = entryentity.stream().sorted(Comparator.comparing(s -> ((JSONObject)s).getInteger(type))).collect(Collectors.toCollection(JSONArray::new));
            entryentity.stream().forEach(s -> ((JSONObject)s).put("rowNum", (Object)((JSONObject)s).getInteger(type)));
        }
        return entryentity;
    }
}

