/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.importdata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.formplugin.importdata.ExtendIImportPlugin;

public class OtherTaxDeductionImportPlugin
extends ExtendIImportPlugin {
    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        JSONObject org = (JSONObject)data.get("org");
        String yearStr = (String)data.get("year");
        Date date = DateUtils.stringToDate((String)yearStr);
        Date startDate = DateUtils.getFirstDateOfYear((Date)date);
        Date endDate = DateUtils.getLastDateOfYear((Date)date);
        JSONArray entryentity = (JSONArray)data.get("entryentity");
        if (entryentity.size() == 0) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u4f18\u60e0\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtherTaxDeductionImportPlugin_0", (String)"taxc-tccit", (Object[])new Object[0])));
            return false;
        }
        Map<String, DynamicObject> allProjects = this.getAllProject();
        HashMap<String, JSONObject> projectNames = new HashMap<String, JSONObject>(entryentity.size());
        for (Object object : entryentity) {
            JSONObject obj = (JSONObject)object;
            JSONObject project = obj.getJSONObject("project");
            String projectName = project.getString("projectname");
            if (!allProjects.containsKey(projectName)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u4f18\u60e0\u9879\u76ee\u4e0d\u5b58\u5728\u6216\u4e0d\u5728\u6709\u6548\u671f\u5185\u3002", (String)"OtherTaxDeductionImportPlugin_1", (String)"taxc-tccit", (Object[])new Object[0])));
                return false;
            }
            if (Lists.newArrayList((Object[])new String[]{"400", "500"}).contains(allProjects.get(projectName).getString("number")) && OrgGroupService.exists(org.getString("number"), new Date()).booleanValue()) {
                importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7\u4e3a\u4f01\u4e1a\u6240\u5f97\u7a0e\u6c47\u603b\u7eb3\u7a0e\u5206\u652f\u673a\u6784\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u3010%2$s\u3011", (String)"OtherTaxDeductionImportPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), org.getString("number"), projectName)));
                return false;
            }
            if (projectNames.containsKey(projectName) || this.checkProject(org.getString("number"), projectName, startDate, endDate)) {
                String msg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u4f18\u60e0\u9879\u76ee:%s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherTaxDeductionImportPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), projectName);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
            projectNames.put(projectName, obj);
            String jmse = obj.getString("jmse");
            String type = obj.getString("type");
            String jmbl = obj.getString("jmbl");
            DynamicObject projectObj = allProjects.get(projectName);
            String code = projectObj.getString("number");
            if (!"400".equals(code) && !"500".equals(code) && StringUtils.isNotBlank((CharSequence)jmbl)) {
                String msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u65e0\u9700\u586b\u5217\u51cf\u514d\u6bd4\u4f8b\u3002", (String)"OtherTaxDeductionImportPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), projectName);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
            if (!"400".equals(code) && !"500".equals(code) && StringUtils.isNotBlank((CharSequence)jmse) && new BigDecimal(jmse).compareTo(BigDecimal.ZERO) < 0) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5728\u3010\u51cf\u514d\u7a0e\u989d\u3011\u4e0b\u586b\u5199\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c\u3002", (String)"OtherTaxDeductionImportPlugin_5", (String)"taxc-tccit", (Object[])new Object[0])));
                return false;
            }
            if (("400".equals(code) || "500".equals(code)) && StringUtils.isBlank((CharSequence)jmbl)) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u3010\u51cf\u514d\u6bd4\u4f8b\u3011\u3002", (String)"OtherTaxDeductionImportPlugin_6", (String)"taxc-tccit", (Object[])new Object[0])));
                return false;
            }
            if (("400".equals(code) || "500".equals(code)) && StringUtils.isNotBlank((CharSequence)jmse)) {
                String msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u65e0\u9700\u586b\u5217\u51cf\u514d\u7a0e\u989d\u3002", (String)"OtherTaxDeductionImportPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]), projectName);
                importlogs.add(new ImportLogger.ImportLog(msg));
                return false;
            }
            if (("500".equals(code) || "qt".equals(type)) && (!"500".equals(code) || !"qt".equals(type))) continue;
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u4f18\u60e0\u9879\u76ee\u4e0e\u4f18\u60e0\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u586b\u5217\u7684\u5185\u5bb9\u3002", (String)"OtherTaxDeductionImportPlugin_8", (String)"taxc-tccit", (Object[])new Object[0])));
            return false;
        }
        return super.beforeImportData(data, option, importlogs);
    }

    private boolean checkProject(String orgNumber, String projectName, Date startDate, Date endDate) {
        QFilter filter = new QFilter("org.number", "=", (Object)orgNumber);
        filter.and(new QFilter("year", ">=", (Object)startDate));
        filter.and(new QFilter("year", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"tccit_other_deductions", (String)"id,entryentity.project", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> ids = new ArrayList<Long>(col.size());
        for (DynamicObject object : col) {
            ids.add(object.getLong("entryentity.project"));
        }
        QFilter entryFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection projectCol = QueryServiceHelper.query((String)"tpo_tccit_bizdef_entry", (String)"id,number,projectname", (QFilter[])new QFilter[]{entryFilter});
        for (DynamicObject object : projectCol) {
            if (projectName == null || !projectName.equals(object.getString("projectname"))) continue;
            return true;
        }
        return false;
    }

    private Map<String, DynamicObject> getAllProject() {
        Date now = new Date();
        QFilter filter = new QFilter("bizdef", "=", (Object)1117362391152070656L);
        filter.and(new QFilter("validfrom", "<=", (Object)now));
        filter.and(new QFilter("expired", ">=", (Object)now).or(new QFilter("expired", "is null", null)));
        DynamicObjectCollection projectCol = QueryServiceHelper.query((String)"tpo_tccit_bizdef_entry", (String)"id,number,projectname", (QFilter[])new QFilter[]{filter});
        HashMap<String, DynamicObject> projects = new HashMap<String, DynamicObject>(projectCol.size());
        for (DynamicObject obj : projectCol) {
            projects.put(obj.getString("projectname"), obj);
        }
        return projects;
    }
}

