/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.importdata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tccit.formplugin.importdata.ExtendIImportPlugin;

public class SalaryIntedeductImportPlugin
extends ExtendIImportPlugin {
    private static final String TCCIT_SALARY_INTEDEDUCT = "tccit_salary_intededuct";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String ORG = "org";
    private static final String BILLNO = "billno";
    private static final String PROJECTNAME = "projectname";
    private static final String COSTTYPE = "costtype";
    private static final String ACCOUNTDATE = "accountdate";
    private static final String ACCOUNTTYPE = "accounttype";
    private static final String SALARYPAYTYPE = "salarypaytype";
    private static final String PRETAXDEDUCTDATE = "pretaxdeductdate";
    private static final String MONEY = "money";
    private static final Map<String, String> MUSTINPUTMAP = new HashMap<String, String>();

    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        DynamicObject bill = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCCIT_SALARY_INTEDEDUCT));
        data.put(BILLNO, this.getNumber(bill));
        this.validate(data, importlogs);
        if (ObjectUtils.isEmpty((Object)data.get(ORG))) {
            return false;
        }
        return super.beforeImportData(data, option, importlogs);
    }

    private String getNumber(DynamicObject bill) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.getNumber(TCCIT_SALARY_INTEDEDUCT, bill, null);
    }

    private void validate(Map<String, Object> data, List<ImportLogger.ImportLog> importlogs) {
        MUSTINPUTMAP.forEach((k, v) -> {
            if (ObjectUtils.isEmpty(data.get(k))) {
                importlogs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u5c1a\u672a\u5f55\u5165", (String)"SalaryIntedeductImportPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]), v)));
            }
        });
        if (!importlogs.isEmpty()) {
            return;
        }
        String orgnumber = String.valueOf(((Map)data.get(ORG)).get("number"));
        DynamicObject query = QueryServiceHelper.queryOne((String)BASTAX_TAXORG, (String)"taxpayer,org.number,org.name", (QFilter[])new QFilter[]{new QFilter("org.number", "=", (Object)orgnumber)});
        if (null == query) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u7ec4\u7ec7\u3011\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6", (String)"SalaryIntedeductImportPlugin_8", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
        Object orgname = ((Map)data.get(ORG)).get("name");
        if (null != orgname && !String.valueOf(orgname).equals(query.get("org.name"))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u3010\u7ec4\u7ec7\u3011\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6", (String)"SalaryIntedeductImportPlugin_9", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
        if ("sjzf".equals(data.get(ACCOUNTTYPE))) {
            if (ObjectUtils.isEmpty((Object)data.get(PRETAXDEDUCTDATE))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7a0e\u524d\u6263\u9664\u5e74\u5ea6\u7684\u503c", (String)"SalaryIntedeductImportPlugin_10", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
        } else if (!ObjectUtils.isEmpty((Object)data.get(PRETAXDEDUCTDATE))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7c7b\u578b\u4e0d\u662f\u5b9e\u9645\u652f\u4ed8\uff0c\u65e0\u9700\u586b\u5199\u7a0e\u524d\u6263\u9664\u5e74\u5ea6\u7684\u503c", (String)"SalaryIntedeductImportPlugin_11", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
        if ("gzxj".equals(data.get(COSTTYPE)) && "sjzf".equals(data.get(ACCOUNTTYPE))) {
            if (ObjectUtils.isEmpty((Object)data.get(SALARYPAYTYPE))) {
                importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5de5\u8d44\u85aa\u91d1\u652f\u4ed8\u7c7b\u578b\u7684\u503c", (String)"SalaryIntedeductImportPlugin_12", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
        } else if (!ObjectUtils.isEmpty((Object)data.get(SALARYPAYTYPE))) {
            importlogs.add(new ImportLogger.ImportLog(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u65e0\u9700\u5f55\u5165\u5de5\u8d44\u85aa\u91d1\u652f\u4ed8\u7c7b\u578b", (String)"SalaryIntedeductImportPlugin_13", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
    }

    static {
        MUSTINPUTMAP.put(ORG, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"SalaryIntedeductImportPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        MUSTINPUTMAP.put(BILLNO, ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u7801", (String)"SalaryIntedeductImportPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        MUSTINPUTMAP.put(PROJECTNAME, ResManager.loadKDString((String)"\u4e1a\u52a1\u540d\u79f0", (String)"SalaryIntedeductImportPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
        MUSTINPUTMAP.put(COSTTYPE, ResManager.loadKDString((String)"\u8d39\u7528\u7c7b\u578b", (String)"SalaryIntedeductImportPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
        MUSTINPUTMAP.put(ACCOUNTDATE, ResManager.loadKDString((String)"\u4f1a\u8ba1\u6838\u7b97\u65e5\u671f", (String)"SalaryIntedeductImportPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]));
        MUSTINPUTMAP.put(ACCOUNTTYPE, ResManager.loadKDString((String)"\u6838\u7b97\u7c7b\u578b", (String)"SalaryIntedeductImportPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]));
        MUSTINPUTMAP.put(MONEY, ResManager.loadKDString((String)"\u91d1\u989d", (String)"SalaryIntedeductImportPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
    }
}

