/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.policy;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.formplugin.account.AbstractEngine;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractPolicyPlugin
extends AbstractEngine {
    private static Log LOGGER = LogFactory.getLog(AbstractPolicyPlugin.class);
    protected static final String ENTRY = "apitudeentryentity";
    protected static final String[] TCTB_FIELDS = new String[]{"registertype", "codeandname", "accountingstandards", "apitudeentryentity"};
    protected Map<String, String> ICONS = new HashMap<String, String>(){
        {
            this.put("1", "/icons/pc/other/cwy_kjl_36_36.png");
            this.put("2", "/icons/pc/other/swy_ckl_36_36.png");
            this.put("3", "/icons/pc/other/swy_shbzl_36_36.png");
            this.put("4", "/icons/pc/other/swy_qtl_36_36.png");
            this.put("5", "/icons/pc/other/swy_nsxydj_36_36.png");
        }
    };

    public abstract void initCustom(String var1, String var2, String var3);

    @Override
    public void afterBindData(EventObject e) {
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        int index = 0;
        for (DynamicObject object : dynamicObject.getDynamicObjectCollection(ENTRY)) {
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>();
            propertiesMap.put("src", this.ICONS.get(object.getString("apitudetype")));
            pmap.put("imageap1", propertiesMap);
            client.invokeControlMethod(ENTRY, "setCustomProperties", new Object[]{index++, pmap});
        }
    }

    protected void initCommonData(String entity, String orgid, String startDate, String endDate, Boolean isYear) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        Date start = DateUtils.stringToDate((String)startDate);
        Date end = DateUtils.stringToDate((String)endDate);
        QFilter q1 = null;
        if (!isYear.booleanValue()) {
            q1 = DeadlineService.getQFilter(start, end);
        }
        QFilter periodFilter = new QFilter("startdate", "=", (Object)start).and(new QFilter("enddate", "=", (Object)end));
        this.getModel().setValue("startdate", (Object)start);
        this.getModel().setValue("enddate", (Object)end);
        this.getModel().setValue("orgid", (Object)orgid);
        this.getModel().setValue("status", (Object)"1");
        DynamicObject org = OrgGroupService.loadTaxMainByOrgId(orgid);
        this.getModel().setValue("illegal", org != null ? org.get("restrictbanindustry") : null);
        if ("tccit_seasonal_policy".equals(entity)) {
            String yjprofitslogic = (String)SystemParamUtil.getAppParameter((String)"tccit", (String)"yjprofitslogic", (long)Long.parseLong(orgid));
            this.getModel().setValue("yjprofitslogic", (Object)(StringUtil.isBlank((CharSequence)yjprofitslogic) ? "bnlje" : yjprofitslogic));
        }
        this.initDeclareCompanyType(orgid, endDate);
        DynamicObject dObj = null;
        if ("tccit_seasonal_policy".equals(entity)) {
            QFilter[] qFilterArray;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)customParams.getOrDefault("draftpurpose", "nssb"));
            if (q1 == null) {
                QFilter[] qFilterArray2 = new QFilter[3];
                qFilterArray2[0] = orgFilter;
                qFilterArray2[1] = periodFilter;
                qFilterArray = qFilterArray2;
                qFilterArray2[2] = draftpurposeFilter;
            } else {
                QFilter[] qFilterArray3 = new QFilter[4];
                qFilterArray3[0] = orgFilter;
                qFilterArray3[1] = periodFilter;
                qFilterArray3[2] = q1;
                qFilterArray = qFilterArray3;
                qFilterArray3[3] = draftpurposeFilter;
            }
            dObj = QueryServiceHelper.queryOne((String)entity, (String)"id", (QFilter[])qFilterArray);
        } else {
            QFilter[] qFilterArray;
            if (q1 == null) {
                QFilter[] qFilterArray4 = new QFilter[2];
                qFilterArray4[0] = orgFilter;
                qFilterArray = qFilterArray4;
                qFilterArray4[1] = periodFilter;
            } else {
                QFilter[] qFilterArray5 = new QFilter[3];
                qFilterArray5[0] = orgFilter;
                qFilterArray5[1] = periodFilter;
                qFilterArray = qFilterArray5;
                qFilterArray5[2] = q1;
            }
            dObj = QueryServiceHelper.queryOne((String)entity, (String)"id", (QFilter[])qFilterArray);
        }
        if (null == dObj) {
            DynamicObject dTctb = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgid)).getData();
            if (null == dTctb) {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.showErrorNotification(ResManager.loadKDString((String)"\u4fe1\u606f\u4e0d\u5168\u5bfc\u81f4\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u5230\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u4e2d\u5b8c\u5584\u76f8\u5173\u7a0e\u52a1\u4fe1\u606f", (String)"AbstractPolicyPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                    this.getView().sendFormAction(parentView);
                }
                return;
            }
            this.initAptitude(entity, dTctb, startDate, endDate);
            this.initCustom(orgid, startDate, endDate);
        }
    }

    private void initAptitude(String entity, DynamicObject dTctb, String startDate, String endDate) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(ENTRY);
        DataEntityPropertyCollection propertyCollection = entityType.getProperties();
        for (IDataEntityProperty property : mainPros) {
            if (!ENTRY.equals(property.getName())) {
                if (!Arrays.asList(TCTB_FIELDS).contains(property.getName())) continue;
                Object object = dTctb.get(property.getName());
                if (property instanceof BasedataProp) {
                    if (!(object instanceof DynamicObject)) continue;
                    DynamicObject dyo = (DynamicObject)object;
                    this.getModel().setValue(property.getName(), dyo.get("id"));
                    continue;
                }
                this.getModel().setValue(property.getName(), object);
                continue;
            }
            DynamicObjectCollection entryid = dTctb.getDynamicObjectCollection(ENTRY);
            this.getModel().deleteEntryData(ENTRY);
            for (DynamicObject d : entryid) {
                Date apitudestartdate = d.getDate("apitudestartdate");
                Date apitudeenddate = d.getDate("apitudeenddate");
                if (apitudestartdate.compareTo(DateUtils.stringToDate((String)endDate)) > 0 || apitudeenddate != null && apitudeenddate.compareTo(DateUtils.stringToDate((String)startDate)) < 0) continue;
                int index = this.getModel().createNewEntryRow(ENTRY);
                for (IDataEntityProperty entityProperty : propertyCollection) {
                    if (entityProperty.getName().equals("id") || entityProperty.getName().equals("exporttype") || entityProperty.getName().equals("creditrating") || !d.getDynamicObjectType().getProperties().containsKey((Object)entityProperty.getName())) continue;
                    this.getModel().getEntryRowEntity(ENTRY, index).set(entityProperty.getName(), d.get(entityProperty.getName()));
                }
            }
        }
    }

    public void setChildVisible() {
        DynamicObjectCollection aptitudeCollection = this.getModel().getEntryEntity(ENTRY);
        int aptitudeIndex = 0;
        CardEntry aptitudeEntry = (CardEntry)this.getControl(ENTRY);
        for (DynamicObject object : aptitudeCollection) {
            boolean yxsy = object.getBoolean("yxsy");
            aptitudeEntry.setChildVisible(yxsy, aptitudeIndex++, new String[]{"prioritytion"});
        }
    }

    private void initDeclareCompanyType(String orgid, String endDate) {
        DynamicObjectCollection objects = OrgGroupService.getOrgGroup(orgid, endDate, "qysds", "2");
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            DynamicObject dynamicObject = (DynamicObject)objects.get(0);
            this.setDeclareTypeAndCache(dynamicObject.getString("kdqjyqylx"));
        } else {
            this.setDeclareTypeAndCache("100");
        }
    }

    private void setDeclareTypeAndCache(String declaretype) {
        this.getModel().setValue("declaretype", (Object)declaretype);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put("declaretype", declaretype);
        }
    }
}

