/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.policy;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.dto.DeclareCellDataParamsDto;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareCellServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.util.calculate.CalculateUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.apitude.ApitudeService;
import kd.taxc.tccit.business.draft.DraftService;
import kd.taxc.tccit.business.draft.TypesProviderService;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.policy.YearPolicyService;
import kd.taxc.tccit.business.sbb.SbbQueryService;
import kd.taxc.tccit.common.enums.YearReportPreSelectEnum;
import kd.taxc.tccit.common.utils.BigDecimalUtils;
import kd.taxc.tccit.common.utils.LocalDateUtils;
import kd.taxc.tccit.formplugin.policy.AbstractPolicyPlugin;

public class TccitPolicyPlugin
extends AbstractPolicyPlugin
implements IBillPlugin {
    private static final String ENTITY = "tccit_policy_confirm";
    private static final String ENTRY_DECLARE = "entryentity";
    private static final String DECLARE_ID = "declareid";
    private static final String SELECTALL_BOOLEN = "selectall_boolen";
    private static final String[] DRAFT_LIST = new String[]{"income1", "income2", "income3", "income4", "income5", "income6", "income7", "income8", "income9", "other5", "deduct1", "deduct2", "deduct3", "deduct4", "deduct5", "deduct6", "deduct7", "deduct8", "deduct9", "deduct10", "deduct11", "deduct12", "deduct13", "asset1", "asset2", "asset3", "other1", "other2", "other3", "incomeother", "other4", "other5", "other6", "other7", "other8", "tssx1", "deduct16", "tssxother", "spectz", "othertz", "yhsx1", "yhsx2", "yhsx3", "yhsx4", "yhsx5", "dksszbjtz", "assetexpense", "taxcredit"};
    private static final String[] CHANGE_LIST = new String[]{"deductway", "softtype", "mbkstype", "illegal"};

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        String orgid = customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0";
        this.getPageCache().put("orgid", orgid);
        this.getPageCache().put("skssqq", skssqq);
        this.getPageCache().put("skssqz", skssqz);
        DynamicObject templateObject = TemplateUtilsOld.getTemplateObject((String)"qysdsnb", (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
        DynamicObject templateObjectDg = TemplateUtilsOld.getTemplateObject((String)"qysdsnb_dg", (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
        if (null == templateObject || null == templateObjectDg) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5386\u53f2\u7533\u62a5\u8868\u6a21\u677f,\u8bf7\u5148\u914d\u7f6e\u7533\u62a5\u6a21\u677f", (String)"TccitPolicyPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("softtype");
        comboEdit.setComboItems(this.setSoftTypeList(orgid, skssqq, skssqz));
        this.initCommonData(ENTITY, orgid, skssqq, skssqz, Boolean.TRUE);
        this.getModel().setValue("illegal", (Object)this.InitIllegal(orgid, skssqq, skssqz));
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            IPageCache parentCache = (IPageCache)parentView.getService(IPageCache.class);
            parentCache.put("childPageId", this.getView().getPageId());
        }
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("gdentryentity");
        entryGrid.addPackageDataListener(s -> this.packageData((PackageDataEvent)s));
    }

    public IPageCache getPageCache() {
        return super.getPageCache();
    }

    public void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        String key = columnDesc.getKey();
        DynamicObject d = e.getRowData();
        if (("nationality".equals(key) || "fidtype".equals(key) || "idnumber".equals(key)) && "count".equals(d.getString("fidtype"))) {
            e.setFormatValue((Object)"*");
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        String orgid = customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0";
        ComboEdit comboEdit = (ComboEdit)this.getControl("softtype");
        comboEdit.setComboItems(this.setSoftTypeList(orgid, skssqq, skssqz));
        this.setChildVisible();
    }

    @Override
    public void initCustom(String orgid, String startDate, String endDate) {
        String declaretype = (String)this.getModel().getValue("declaretype");
        this.initDeclare();
        this.initTreeentryentity(orgid, endDate);
        this.initRate(orgid, endDate, declaretype);
        this.initShareHolderEntryEntity();
        String lastYearStartDate = DateUtils.format((Date)DateUtils.addYear((Date)DateUtils.stringToDate2((String)startDate), (int)-1));
        String lastYearEndDate = DateUtils.format((Date)DateUtils.addYear((Date)DateUtils.stringToDate2((String)endDate), (int)-1));
        HashMap<String, String> extendParams = new HashMap<String, String>(16);
        extendParams.put("declarestatus", "declared");
        DynamicObject result = YbnsrServiceHelper.queryYbnsrWithEx((String)orgid, (String)"qysdsnb", (String)lastYearStartDate, (String)lastYearEndDate, extendParams);
        if (result == null) {
            return;
        }
        String reportId = String.valueOf(result.get("id"));
        this.getPageCache().put("reportId", reportId);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("select", (IFormPlugin)this);
        String msg1 = ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u6839\u636e\u4e0a\u5e74\u7533\u62a5\u4e8b\u9879\u5bf9\u6d89\u7a0e\u4e8b\u9879\u8fdb\u884c\u9884\u52fe\u9009\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"TccitPolicyPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]);
        this.getView().showConfirm(msg1, MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("Yes".equals(evt.getResultValue())) {
            Long reportId = Long.parseLong(this.getPageCache().get("reportId"));
            DeclareCellDataParamsDto paramsDto = new DeclareCellDataParamsDto();
            paramsDto.setSbbId(reportId);
            ArrayList cellKeys = new ArrayList(YearReportPreSelectEnum.values().length);
            HashMap<String, String> formulas = new HashMap<String, String>(YearReportPreSelectEnum.values().length);
            for (YearReportPreSelectEnum num : YearReportPreSelectEnum.values()) {
                formulas.put(num.getReportKey(), num.getSelectRule());
                cellKeys.addAll(CalculateUtil.getParamsKeyFromFormula((String)num.getSelectRule()));
            }
            paramsDto.setCellKeys(cellKeys);
            TaxResult result = DeclareCellServiceHelper.getDeclareCellValueStr((DeclareCellDataParamsDto)paramsDto);
            HashMap data = new HashMap((Map)result.getData());
            Map newFormulas = CalculateUtil.resetFormulas(data, formulas);
            Map calResult = CalculateUtil.getCalResult((Map)newFormulas);
            Date lastYearStartDate = DateUtils.addYear((Date)DateUtils.stringToDate2((String)this.getPageCache().get("skssqq")), (int)-1);
            Date lastYearEndDate = DateUtils.addYear((Date)DateUtils.stringToDate2((String)this.getPageCache().get("skssqz")), (int)-1);
            DynamicObjectCollection objCollection = DraftService.getZctzExpenseSum(Long.parseLong(this.getPageCache().get("orgid")), lastYearStartDate, lastYearEndDate);
            if (null != objCollection && objCollection.size() > 0) {
                Object zlzc = "false";
                for (DynamicObject obj : objCollection) {
                    if (obj.getBigDecimal("zzje").compareTo(BigDecimal.ZERO) == 0 && obj.getBigDecimal("taxamount").compareTo(BigDecimal.ZERO) == 0) continue;
                    zlzc = "true";
                    break;
                }
                calResult.put("assetexpense", zlzc);
            }
            this.getPageCache().put("batchSelect", "true");
            for (Map.Entry entry : calResult.entrySet()) {
                if (!"true".equals(entry.getValue())) continue;
                this.getModel().setValue((String)entry.getKey(), (Object)true);
            }
            this.getPageCache().remove("batchSelect");
            this.initDeclare();
            String msg = ResManager.loadKDString((String)"\u6d89\u7a0e\u4e8b\u9879\u9884\u52fe\u9009\u5b8c\u6210\u3002", (String)"TccitPolicyPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]);
            this.saveDatas(msg);
        }
    }

    private void initRate(String orgid, String endDate, String declareType) {
        Date startyear = DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)endDate));
        Date endyear = DateUtils.getLastDateOfYear((Date)DateUtils.stringToDate((String)endDate));
        int monthDiff = DateUtils.getMonthDiff((Date)startyear, (Date)endyear);
        Date s1 = DateUtils.addMonth((Date)startyear, (int)(-monthDiff));
        Date s2 = DateUtils.getLastDateOfMonth2((Date)DateUtils.addMonth((Date)endyear, (int)(-monthDiff)));
        if ("210".equals(declareType)) {
            QFilter q1 = QFilter.of((String)"orgid =? and startdate=? and enddate=? and declaretype = ?", (Object[])new Object[]{Long.parseLong(orgid), s1, s2, "210"});
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY, (String)"zjgftbl,czjzfpbl,fzjgftbl", (QFilter[])new QFilter[]{q1});
            this.getModel().setValue("zjgftbl", (Object)(dynamicObject == null ? BigDecimal.valueOf(0.25) : dynamicObject.getBigDecimal("zjgftbl")));
            this.getModel().setValue("czjzfpbl", (Object)(dynamicObject == null ? BigDecimal.valueOf(0.25) : dynamicObject.getBigDecimal("czjzfpbl")));
            this.getModel().setValue("fzjgftbl", (Object)(dynamicObject == null ? BigDecimal.valueOf(0.5) : dynamicObject.getBigDecimal("fzjgftbl")));
        } else {
            this.getModel().setValue("zjgftbl", (Object)BigDecimal.ZERO);
            this.getModel().setValue("czjzfpbl", (Object)BigDecimal.ZERO);
            this.getModel().setValue("fzjgftbl", (Object)BigDecimal.ZERO);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Comparable<BigDecimal> newValue;
        ChangeData[] changeSet;
        String key = e.getProperty().getName();
        if (Arrays.asList(DRAFT_LIST).contains(key) && this.getView().getFormShowParameter().getCustomParams().get(SELECTALL_BOOLEN) == null && StringUtils.isEmpty((Object)this.getPageCache().get("batchSelect"))) {
            this.initDeclare();
            this.saveDatas("");
        }
        if (Arrays.asList(CHANGE_LIST).contains(key)) {
            if ("softtype".equals(key)) {
                this.initDeclare();
            }
            this.saveDatas("");
        }
        if ("selectall".equals(key)) {
            this.getView().getFormShowParameter().getCustomParams().put(SELECTALL_BOOLEN, Boolean.TRUE);
            changeSet = e.getChangeSet();
            newValue = (Boolean)changeSet[0].getNewValue();
            Arrays.stream(DRAFT_LIST).forEach(arg_0 -> this.lambda$propertyChanged$1((Boolean)newValue, arg_0));
            this.getView().getFormShowParameter().getCustomParams().remove(SELECTALL_BOOLEN);
            this.initDeclare();
            this.saveDatas("");
        }
        if ("curryeardividendsum".equals(key)) {
            changeSet = e.getChangeSet();
            newValue = (BigDecimal)changeSet[0].getNewValue();
            if (newValue != null && (((BigDecimal)newValue).compareTo(BigDecimal.ZERO) < 0 || BigDecimalUtils.largeMaxValue((BigDecimal)newValue))) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5f55\u5165\u91d1\u989d\u4e0d\u5f97\u4e3a\u8d1f\u6570\u4e14\u4e0d\u80fd\u8d85\u8fc713\u4f4d\u6574\u6570", (String)"TccitPolicyPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
            DynamicObjectCollection gdentryentity = this.getModel().getEntryEntity("gdentryentity");
            if (CollectionUtils.isEmpty((Collection)gdentryentity)) {
                return;
            }
            BigDecimal curryeardividendsum = (BigDecimal)this.getModel().getValue("curryeardividendsum");
            BigDecimal tempSum = BigDecimal.ZERO;
            DynamicObject lastRow = gdentryentity.stream().max(Comparator.comparing(s -> s.getInt("seq"))).get();
            for (DynamicObject row : gdentryentity) {
                BigDecimal investrate = row.getBigDecimal("investrate").divide(new BigDecimal("100"), 4, 4);
                BigDecimal amount = curryeardividendsum.multiply(investrate).setScale(2, 4);
                row.set("curryeardividend", (Object)(row.get("seq").equals(lastRow.get("seq")) ? curryeardividendsum.subtract(tempSum) : amount));
                tempSum = tempSum.add(amount);
            }
            this.getView().updateView("gdentryentity");
        }
        if ("curryeardividend".equals(key)) {
            BigDecimal sumAmount;
            changeSet = e.getChangeSet();
            newValue = (BigDecimal)changeSet[0].getNewValue();
            int rowIndex = changeSet[0].getRowIndex();
            if (newValue != null && (((BigDecimal)newValue).compareTo(BigDecimal.ZERO) < 0 || BigDecimalUtils.largeMaxValue(newValue))) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5f55\u5165\u91d1\u989d\u4e0d\u5f97\u4e3a\u8d1f\u6570\u4e14\u4e0d\u80fd\u8d85\u8fc713\u4f4d\u6574\u6570", (String)"TccitPolicyPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
            DynamicObjectCollection gdentryentity = this.getModel().getEntryEntity("gdentryentity");
            DynamicObject lastRow = gdentryentity.stream().max(Comparator.comparing(s -> s.getInt("seq"))).get();
            BigDecimal curryeardividendsum = (BigDecimal)this.getModel().getValue("curryeardividendsum");
            if (lastRow != null && rowIndex + 1 == lastRow.getInt("seq") && (sumAmount = gdentryentity.stream().map(s -> s.getBigDecimal("curryeardividend")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(curryeardividendsum) > 0) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5f55\u5165\u91d1\u989d\u7684\u5408\u8ba1\u4e0d\u5f97\u8d85\u8fc7\u5f53\u5e74\u5206\u914d\u5168\u90e8\u80a1\u4e1c\u80a1\u606f\u7ea2\u5229\u603b\u989d", (String)"TccitPolicyPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
            sumAmount = gdentryentity.stream().filter(s -> !s.getString("seq").equals(lastRow.getString("seq"))).map(s -> s.getBigDecimal("curryeardividend")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (sumAmount.compareTo(curryeardividendsum) > 0) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5f55\u5165\u91d1\u989d\u7684\u5408\u8ba1\u4e0d\u5f97\u8d85\u8fc7\u5f53\u5e74\u5206\u914d\u5168\u90e8\u80a1\u4e1c\u80a1\u606f\u7ea2\u5229\u603b\u989d", (String)"TccitPolicyPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
            if (lastRow != null) {
                lastRow.set("curryeardividend", (Object)curryeardividendsum.subtract(sumAmount));
                this.getView().updateView("gdentryentity");
            }
        }
        if ("zjgftbl".equals(key) || "czjzfpbl".equals(key)) {
            BigDecimal zjgftbl = Optional.ofNullable((BigDecimal)this.getModel().getValue("zjgftbl")).orElseGet(() -> BigDecimal.ZERO);
            BigDecimal czjzfpbl = Optional.ofNullable((BigDecimal)this.getModel().getValue("czjzfpbl")).orElseGet(() -> BigDecimal.ZERO);
            ChangeData[] changeSet2 = e.getChangeSet();
            ChangeData changeData = changeSet2[0];
            BigDecimal newValue2 = (BigDecimal)changeData.getNewValue();
            if (newValue2 != null && (newValue2.compareTo(BigDecimal.ZERO) < 0 || newValue2.compareTo(BigDecimal.ONE) >= 0)) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u51650~1\u4ee5\u5185\u7684\u6570\u503c", (String)"TccitPolicyPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
            BigDecimal sum = zjgftbl.add(czjzfpbl);
            if (sum.compareTo(BigDecimal.ONE) > 0) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u603b\u673a\u6784\u5206\u644a\u6bd4\u4f8b\u3001\u8d22\u653f\u96c6\u4e2d\u5206\u914d\u6bd4\u4f8b\u3001\u5206\u652f\u673a\u6784\u5206\u644a\u6bd4\u4f8b\u76f8\u52a0\u5927\u4e8e1", (String)"TccitPolicyPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void saveDatas(String msg) {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY, (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
        boolean success = operationResult.isSuccess();
        if (success) {
            msg = StringUtil.isBlank((CharSequence)msg) ? ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TccitPolicyPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]) : msg;
            this.getView().showSuccessNotification(msg);
        } else {
            this.getView().showErrorNotification(((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
        }
    }

    private void initTreeentryentity(String orgid, String endDate) {
        String declaretype = (String)this.getModel().getValue("declaretype");
        if ("210".equals(declaretype) || "220".equals(declaretype) || "230".equals(declaretype)) {
            DynamicObjectCollection objects = OrgGroupService.getOrgGroupDynamicObjects(orgid, endDate, "qysds", "2");
            DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
            DynamicObjectType dynamicObjectType = treeentryentity.getDynamicObjectType();
            long[] pks = DBServiceHelper.genLongIds((String)"tccit_policy_confirm.treeentryentity", (int)objects.size());
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(pks.length);
            this.getModel().beginInit();
            for (int i = 0; i < pks.length; ++i) {
                map.put(((DynamicObject)objects.get(i)).getLong("orgrow.id"), i);
                DynamicObject dd = new DynamicObject(dynamicObjectType);
                dd.set("id", (Object)pks[i]);
                if (i != 0) {
                    Integer a = (Integer)map.get(((DynamicObject)objects.get(i)).getLong("orgrow.pid"));
                    dd.set("pid", a == null ? null : Long.valueOf(pks[a]));
                }
                int row = this.getModel().createNewEntryRow("treeentryentity", dd);
                this.getModel().setValue("taxorg", (Object)((DynamicObject)objects.get(i)).getLong("orgrow.orgid"), row);
                this.getModel().setValue("declaration", (Object)((DynamicObject)objects.get(i)).getString("declare"), row);
                this.getModel().setValue("shareid", (Object)((DynamicObject)objects.get(i)).getString("share"), row);
                this.getModel().setValue("kdqjyqylx", (Object)((DynamicObject)objects.get(i)).getString("kdqjyqylx"), row);
            }
            this.getModel().endInit();
            this.getView().updateView("treeentryentity");
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
            treeEntry.setCollapse(false);
        }
    }

    private void initDeclare() {
        DynamicObject dPolicy = this.getModel().getDataEntity(true);
        DynamicObjectCollection deList = TypesProviderService.getTypes(dPolicy, null, "sbb", "number");
        this.getModel().deleteEntryData(ENTRY_DECLARE);
        if (!deList.isEmpty()) {
            List collect = deList.stream().filter(s -> s.getLong("id") != 22000001L && s.getLong("id") != 22000002L).collect(Collectors.toList());
            this.getModel().beginInit();
            for (DynamicObject d : collect) {
                int index = this.getModel().createNewEntryRow(ENTRY_DECLARE);
                this.getModel().setValue(DECLARE_ID, (Object)d.getLong("id"), index);
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRY_DECLARE);
        }
    }

    private List<ComboItem> setSoftTypeList(String orgid, String startDate, String endDate) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        DynamicObjectCollection apitudeEntryEntity = ApitudeService.getApitudeEntryEntity(Long.valueOf(orgid));
        DynamicObjectCollection filter = new DynamicObjectCollection();
        apitudeEntryEntity.stream().filter(s -> s.getString("apitudetype").equals("1")).forEach(s -> filter.add(s));
        if (CollectionUtils.isEmpty((Collection)filter)) {
            return list;
        }
        DynamicObject suitOne = ApitudeService.findSuitOne(filter, DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
        if (suitOne == null) {
            return list;
        }
        DynamicObject companytype = suitOne.getDynamicObject("companytype");
        if (companytype == null) {
            return list;
        }
        this.getModel().setValue("softtype", (Object)companytype.getString("number"));
        List ids = filter.stream().map(s -> s.getDynamicObject("companytype")).map(s -> s.get("id")).collect(Collectors.toList());
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tpo_tccit_bizdef_entry"));
        Arrays.stream(load).forEach(s -> list.add(TccitPolicyPlugin.getComboItem(s.getString("projectname"), s.getString("number"))));
        return list;
    }

    public static ComboItem getComboItem(String desc, String value) {
        return new ComboItem(new LocaleString(desc), value);
    }

    private boolean InitIllegal(String orgid, String startDate, String endDate) {
        Date lastQuarterEnd;
        Date lastQuarterBegin;
        Date lastYearEnd;
        Date skssqq = DateUtils.stringToDate((String)startDate);
        Date skssqz = DateUtils.stringToDate((String)endDate);
        int yearOfDate = DateUtils.getYearOfDate((Date)skssqq);
        Date lastYearBegin = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 12, 1));
        DynamicObjectCollection temp = SbbQueryService.getNsrxxObjectByMonthOrSeasonal(orgid, lastYearBegin, lastYearEnd = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 12, 31)), lastQuarterBegin = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 10, 1)), lastQuarterEnd = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 12, 31)));
        if (CollectionUtils.isEmpty((Collection)temp)) {
            return false;
        }
        String id = ((DynamicObject)temp.get(0)).getString("id");
        return Optional.ofNullable(SbbQueryService.getQysdsDetailObject(id, "gjxzhjzhy", "tccit_qysds_zb")).map(s -> s.getBoolean("gjxzhjzhy")).orElseGet(() -> false);
    }

    private void initShareHolderEntryEntity() {
        String orgid = this.getPageCache().get("orgid");
        DynamicObjectCollection shareHolderEntry = ApitudeService.getShareHolderEntry(Long.valueOf(orgid));
        shareHolderEntry.sort(Comparator.comparing(d -> d.getBigDecimal("investrate")).reversed());
        if (CollectionUtils.isEmpty((Collection)shareHolderEntry)) {
            return;
        }
        List collects = shareHolderEntry.stream().limit(10L).collect(Collectors.toList());
        BigDecimal suminvestrate = collects.stream().map(s -> s.getBigDecimal("investrate")).reduce(BigDecimal.ZERO, BigDecimal::add);
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("gdentryentity");
        Boolean less100 = suminvestrate.compareTo(BigDecimal.valueOf(100L)) < 0;
        model.batchCreateNewEntryRow("gdentryentity", less100 != false ? collects.size() + 1 : collects.size());
        int rowIndex = 0;
        for (DynamicObject dynamicObject : collects) {
            model.setValue("gdname", (Object)dynamicObject.getString("name"), rowIndex);
            model.setValue("fidtype", (Object)dynamicObject.getString("fidtype"), rowIndex);
            model.setValue("idnumber", (Object)dynamicObject.getString("idnumber"), rowIndex);
            model.setValue("investrate", (Object)dynamicObject.getBigDecimal("investrate"), rowIndex);
            model.setValue("nationality", (Object)dynamicObject.getDynamicObject("nationality"), rowIndex);
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("gdentryentity");
        if (less100.booleanValue()) {
            this.appendRow(model, rowIndex);
        }
    }

    private void appendRow(IDataModel model, int rowIndex) {
        DynamicObjectCollection gdentryentity = this.getModel().getEntryEntity("gdentryentity");
        model.setValue("gdname", (Object)ResManager.loadKDString((String)"\u5176\u4f59\u80a1\u4e1c\u5408\u8ba1", (String)"TccitPolicyPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue("fidtype", (Object)"count", rowIndex);
        model.setValue("idnumber", (Object)"", rowIndex);
        BigDecimal sumInvestrate = gdentryentity.stream().map(s -> s.getBigDecimal("investrate")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("investrate", (Object)BigDecimal.valueOf(100L).subtract(sumInvestrate), rowIndex);
        BigDecimal curryeardividendsum = (BigDecimal)this.getModel().getValue("curryeardividendsum");
        BigDecimal sumAmount = gdentryentity.stream().map(s -> s.getBigDecimal("curryeardividend")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("curryeardividend", (Object)curryeardividendsum.subtract(sumAmount), rowIndex);
        model.setValue("nationality", (Object)0L, rowIndex);
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }

    public void deleteData(EngineModel model) {
        String orgId = model.getOrgId();
        String startDate = model.getStartDate();
        String endDate = model.getEndDate();
        YearPolicyService.clearCurrentPeriod(Long.parseLong(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
    }

    private /* synthetic */ void lambda$propertyChanged$1(Boolean newValue, String s) {
        this.getModel().setValue(s, (Object)newValue);
    }
}

