/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.policy;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.apitude.ApitudeService;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.sbb.SbbQueryService;
import kd.taxc.tccit.common.utils.LocalDateUtils;
import kd.taxc.tccit.formplugin.policy.AbstractPolicyPlugin;

public class TccitPolicySbbPlugin
extends AbstractPolicyPlugin
implements IBillPlugin {
    private static final String ENTITY = "tccit_policy_confirm2";
    private static final String ORGID = "orgid";
    private static final String[] CHANGE_LIST = new String[]{"illegal"};

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        String orgid = customParams.get(ORGID) != null ? (String)customParams.get(ORGID) : "0";
        this.getPageCache().put(ORGID, orgid);
        DynamicObject templateObject = TemplateUtilsOld.getTemplateObject((String)"qysdsnb", (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
        DynamicObject templateObjectDg = TemplateUtilsOld.getTemplateObject((String)"qysdsnb_dg", (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
        if (null == templateObject || null == templateObjectDg) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5386\u53f2\u7533\u62a5\u8868\u6a21\u677f,\u8bf7\u5148\u914d\u7f6e\u7533\u62a5\u6a21\u677f", (String)"TccitPolicySbbPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        this.initCommonData(ENTITY, orgid, skssqq, skssqz, Boolean.TRUE);
        this.getModel().setValue(CHANGE_LIST[0], (Object)(this.InitIllegal(orgid, skssqq, skssqz) ? "1" : "0"));
        if (this.getView().getParentView() != null) {
            IPageCache parentCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
            parentCache.put("childPageId", this.getView().getPageId());
        }
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("gdentryentity");
        entryGrid.addPackageDataListener(s -> this.packageData((PackageDataEvent)s));
    }

    public void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        String key = columnDesc.getKey();
        DynamicObject d = e.getRowData();
        if (("nationality".equals(key) || "fidtype".equals(key) || "idnumber".equals(key)) && "count".equals(d.getString("fidtype"))) {
            e.setFormatValue((Object)"*");
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setChildVisible();
    }

    @Override
    public void initCustom(String orgid, String startDate, String endDate) {
        this.initTreeentryentity(orgid, endDate);
        this.initShareHolderEntryEntity();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (Collections.singletonList(CHANGE_LIST).contains(key)) {
            this.saveDatas();
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void saveDatas() {
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY, (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TccitPolicySbbPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        } else {
            this.getView().getParentView().showErrorNotification(((OperateErrorInfo)((ValidateResult)operationResult.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
        }
    }

    private void initTreeentryentity(String orgid, String endDate) {
        String declaretype = (String)this.getModel().getValue("declaretype");
        if ("210".equals(declaretype) || "220".equals(declaretype)) {
            DynamicObjectCollection objects = OrgGroupService.getOrgGroupDynamicObjects(orgid, endDate, "qysds", "2");
            DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
            DynamicObjectType dynamicObjectType = treeentryentity.getDynamicObjectType();
            long[] pks = DBServiceHelper.genLongIds((String)"tccit_seasonal_policy.treeentryentity", (int)objects.size());
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(pks.length);
            this.getModel().beginInit();
            for (int i = 0; i < pks.length; ++i) {
                map.put(((DynamicObject)objects.get(i)).getLong("orgrow.id"), i);
                DynamicObject dd = new DynamicObject(dynamicObjectType);
                dd.set("id", (Object)pks[i]);
                if (i != 0) {
                    Integer a = (Integer)map.get(((DynamicObject)objects.get(i)).getLong("orgrow.pid"));
                    dd.set("pid", a == null ? null : Long.valueOf(pks[a]));
                }
                int row = this.getModel().createNewEntryRow("treeentryentity", dd);
                this.getModel().setValue("taxorg", (Object)((DynamicObject)objects.get(i)).getLong("orgrow.orgid"), row);
                this.getModel().setValue("declaration", (Object)((DynamicObject)objects.get(i)).getString("declare"), row);
                this.getModel().setValue("shareid", (Object)((DynamicObject)objects.get(i)).getString("share"), row);
            }
            this.getModel().endInit();
            this.getView().updateView("treeentryentity");
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
            treeEntry.setCollapse(false);
        }
    }

    private boolean InitIllegal(String orgid, String startDate, String endDate) {
        Date lastQuarterEnd;
        Date lastQuarterBegin;
        Date lastYearEnd;
        QFilter orgidFilter = new QFilter(ORGID, "=", (Object)Long.parseLong(orgid));
        Date skssqq = DateUtils.stringToDate((String)startDate);
        Date skssqz = DateUtils.stringToDate((String)endDate);
        QFilter timeFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
        DynamicObjectCollection queryList = QueryServiceHelper.query((String)"tccit_policy_confirm", (String)CHANGE_LIST[0], (QFilter[])new QFilter[]{orgidFilter, timeFilter});
        if (!CollectionUtils.isEmpty((Collection)queryList)) {
            return ((DynamicObject)queryList.get(0)).getBoolean(CHANGE_LIST[0]);
        }
        int yearOfDate = DateUtils.getYearOfDate((Date)skssqq);
        Date lastYearBegin = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 12, 1));
        DynamicObjectCollection temp = SbbQueryService.getNsrxxObjectByMonthOrSeasonal(orgid, lastYearBegin, lastYearEnd = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 12, 31)), lastQuarterBegin = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 10, 1)), lastQuarterEnd = LocalDateUtils.localDate2Date(LocalDate.of(yearOfDate, 12, 31)));
        if (CollectionUtils.isEmpty((Collection)temp)) {
            return false;
        }
        String id = ((DynamicObject)temp.get(0)).getString("id");
        return Optional.ofNullable(SbbQueryService.getQysdsDetailObject(id, "gjxzhjzhy", "tccit_qysds_zb")).map(s -> s.getBoolean("gjxzhjzhy")).orElseGet(() -> false);
    }

    private String getQysdsZb(String sbbid, String column) {
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter rowFilter = new QFilter("ewblxh", "=", (Object)"1");
        DynamicObject dynamiczb = QueryServiceHelper.queryOne((String)"tccit_qysds_zb", (String)column, (QFilter[])new QFilter[]{rowFilter, sbbidFilter});
        return dynamiczb != null && dynamiczb.getBoolean(column) ? "1" : "0";
    }

    private void initShareHolderEntryEntity() {
        String orgid = this.getPageCache().get(ORGID);
        DynamicObjectCollection shareHolderEntry = ApitudeService.getShareHolderEntry(Long.valueOf(orgid));
        shareHolderEntry.sort(Comparator.comparing(d -> d.getBigDecimal("investrate")).reversed());
        if (CollectionUtils.isEmpty((Collection)shareHolderEntry)) {
            return;
        }
        List collects = shareHolderEntry.stream().limit(10L).collect(Collectors.toList());
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("gdentryentity");
        if (shareHolderEntry.size() > 10) {
            model.batchCreateNewEntryRow("gdentryentity", collects.size() + 1);
        } else {
            model.batchCreateNewEntryRow("gdentryentity", collects.size());
        }
        int rowIndex = 0;
        for (DynamicObject dynamicObject : collects) {
            model.setValue("gdname", (Object)dynamicObject.getString("name"), rowIndex);
            model.setValue("fidtype", (Object)dynamicObject.getString("fidtype"), rowIndex);
            model.setValue("idnumber", (Object)dynamicObject.getString("idnumber"), rowIndex);
            model.setValue("investrate", (Object)dynamicObject.getBigDecimal("investrate"), rowIndex);
            model.setValue("nationality", (Object)dynamicObject.getDynamicObject("nationality"), rowIndex);
            ++rowIndex;
        }
        if (shareHolderEntry.size() > 10) {
            this.appendRow(model, rowIndex);
        }
        model.endInit();
        this.getView().updateView("gdentryentity");
    }

    private void appendRow(IDataModel model, int rowIndex) {
        DynamicObjectCollection gdentryentity = this.getModel().getEntryEntity("gdentryentity");
        model.setValue("gdname", (Object)ResManager.loadKDString((String)"\u5176\u4f59\u80a1\u4e1c\u5408\u8ba1", (String)"TccitPolicySbbPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), rowIndex);
        model.setValue("fidtype", (Object)"count", rowIndex);
        model.setValue("idnumber", (Object)"", rowIndex);
        BigDecimal sumInvestrate = gdentryentity.stream().map(s -> s.getBigDecimal("investrate")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("investrate", (Object)new BigDecimal("100").subtract(sumInvestrate), rowIndex);
        model.setValue("nationality", (Object)0L, rowIndex);
    }

    public void deleteData(EngineModel model) {
    }
}

