/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.rule;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.tccit.business.rule.RuleQueryService;

public class NewTccitnbRuleQueryPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static Log logger = LogFactory.getLog(NewTccitnbRuleQueryPlugin.class);
    private static Set<String> profigsKeys = Sets.newHashSet((Object[])new String[]{"cardflexpanelap12", "cardflexpanelap22", "cardentryflexpanelap42", "cardentryflexpanelap2", "cardflexpanelap4", "image", "cardentryflexpanelap32", "cardflexpanelap32", "cardentryflexpanelap52", "flex"});
    private static final String SHOWDISABLE = "showdisable";
    private static final String ORG = "org";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"toolbar"});
        this.addClickListeners(profigsKeys.toArray(new String[0]));
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(ORG, (Object)PermissionUtils.getDefaultOrgId());
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        this.createTree(org, false);
    }

    private void createTree(DynamicObject org, boolean showdisable) {
        List<TreeNode> nodeList = RuleQueryService.getNodeList(org, showdisable);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        IPageCache cache = this.getPageCache();
        TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)cache, (boolean)false);
        TreeUtils.expand((TreeView)treeView, (IPageCache)cache, (int)1);
        treeView.focusNode(nodeList.get(0));
        this.refreshRules("0");
        this.getPageCache().put("currentnodeid", "0");
    }

    private void createTreeCache(DynamicObject org, boolean showdisable, String currentnode) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List<TreeNode> nodeList = RuleQueryService.getNodeList(org, showdisable);
        TreeNode foucsnode = new TreeNode();
        for (TreeNode node : nodeList) {
            if (!node.getId().equals(currentnode)) continue;
            foucsnode = node;
        }
        IPageCache cache = this.getPageCache();
        TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)cache, (boolean)false);
        TreeUtils.expand((TreeView)treeView, (IPageCache)cache, (int)1);
        treeView.focusNode(foucsnode);
        this.refreshRules(currentnode);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"treeviewap")) {
            String id = (String)evt.getNodeId();
            this.getPageCache().put("currentnodeid", id);
            this.refreshRules(id);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
        String name = e.getProperty().getName();
        if (ORG.equals(name) || SHOWDISABLE.equals(name)) {
            DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
            String currentnode = this.getPageCache().get("currentnodeid");
            this.createTreeCache(org, showdisable, currentnode);
            this.refreshRules(currentnode);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("refresh")) {
            Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
            DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
            String currentnode = this.getPageCache().get("currentnodeid");
            this.createTreeCache(org, showdisable, currentnode);
        }
    }

    private void refreshRules(String id) {
        Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
        if (id.equals("0")) {
            this.loadhjAllCard(showdisable);
        } else {
            String currenttype = this.getType(Long.parseLong(id));
            List<Long> list = RuleQueryService.getChildList(id, null);
            this.loadCard(list, showdisable, currenttype);
        }
    }

    private String getType(Long id) {
        QFilter filter1 = new QFilter("entryid", "=", (Object)id);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"tccit_rule_nbchild", (String)"type", (QFilter[])new QFilter[]{filter1});
        String type = dyo.getString("type");
        return type;
    }

    private void loadhjAllCard(boolean showdisable) {
        List<Long> ssyhlist = RuleQueryService.getChildList("0", "ssyh");
        List<Long> otherlist = RuleQueryService.getChildList("0", "notssyh");
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        this.getModel().deleteEntryData("entity");
        if (this.getModel().getDataEntityType().getProperty("entity") != null) {
            DynamicObjectCollection ssyhrules;
            DynamicObjectCollection otherules = RuleQueryService.getrules(otherlist, org, showdisable);
            if (!otherules.isEmpty()) {
                Map<Long, String> items = RuleQueryService.getYearItemRules(otherules.stream().map(s -> s.getLong("item")).collect(Collectors.toList()));
                this.getModel().beginInit();
                for (DynamicObject rule : otherules) {
                    int row = this.getModel().createNewEntryRow("entity");
                    this.getModel().setValue("ruleid", rule.get("id"), row);
                    this.getModel().setValue("rulename", rule.get("name"), row);
                    this.getModel().setValue("rulemodifydate", rule.get("modifytime"), row);
                    this.getModel().setValue("sourcetype", (Object)this.getType(Long.parseLong(rule.getString("item"))), row);
                    this.getModel().setValue("type", (Object)items.get(rule.getLong("item")), row);
                    this.getModel().setValue("profitsenable", rule.get("enable"), row);
                    this.getModel().setValue("ruletype", rule.get("ruletype"), row);
                    this.setBackgroundAndImage(row, rule.getString("ruletype"));
                }
                this.getModel().endInit();
                this.getView().updateView("entity");
            }
            if (!(ssyhrules = RuleQueryService.getrules(ssyhlist, org, showdisable)).isEmpty()) {
                Map<Long, String> items = RuleQueryService.getDiscountItemRules(ssyhrules.stream().map(s -> s.getLong("item")).collect(Collectors.toList()));
                this.getModel().beginInit();
                for (DynamicObject rule : ssyhrules) {
                    int row = this.getModel().createNewEntryRow("entity");
                    this.getModel().setValue("ruleid", rule.get("id"), row);
                    this.getModel().setValue("rulename", rule.get("name"), row);
                    this.getModel().setValue("rulemodifydate", rule.get("modifytime"), row);
                    this.getModel().setValue("type", (Object)items.get(rule.getLong("item")), row);
                    this.getModel().setValue("profitsenable", rule.get("enable"), row);
                    this.getModel().setValue("ruletype", rule.get("ruletype"), row);
                    this.getModel().setValue("sourcetype", (Object)this.getType(Long.parseLong(rule.getString("item"))), row);
                    this.setBackgroundAndImage(row, rule.getString("ruletype"));
                }
                this.getModel().endInit();
                this.getView().updateView("entity");
            }
        }
    }

    private void loadCard(List<Long> number, boolean showdisable, String type) {
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        this.getModel().deleteEntryData("entity");
        if (this.getModel().getDataEntityType().getProperty("entity") != null) {
            DynamicObjectCollection rules = RuleQueryService.getrules(number, org, showdisable);
            Map<Long, String> yearItemRules = RuleQueryService.getYearItemRules(rules.stream().map(s -> s.getLong("item")).collect(Collectors.toList()));
            Map<Long, String> discountItemRules = RuleQueryService.getDiscountItemRules(rules.stream().map(s -> s.getLong("item")).collect(Collectors.toList()));
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("entity");
                this.getModel().setValue("ruleid", rule.get("id"), row);
                this.getModel().setValue("rulename", rule.get("name"), row);
                this.getModel().setValue("rulemodifydate", rule.get("modifytime"), row);
                String projname = type.equals("ssyh") ? discountItemRules.get(rule.getLong("item")) : yearItemRules.get(rule.getLong("item"));
                this.getModel().setValue("type", (Object)projname, row);
                this.getModel().setValue("profitsenable", rule.get("enable"), row);
                this.getModel().setValue("ruletype", rule.get("ruletype"), row);
                this.getModel().setValue("sourcetype", (Object)this.getType(Long.parseLong(rule.getString("item"))), row);
                this.setBackgroundAndImage(row, rule.getString("ruletype"));
            }
            this.getModel().endInit();
            this.getView().updateView("entity");
        }
    }

    private void setBackgroundAndImage(int row, String ruletype) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        if ("private".equals(ruletype)) {
            propertiesMap.put("bc", "#FFF2E9");
            propertiesMap.put("src", "/icons/pc/label/swy_zy_61_61.png");
        } else {
            propertiesMap.put("bc", "#E7F0FF");
            propertiesMap.put("src", "/icons/pc/label/swy_fp_61_61.png");
        }
        pmap.put("currentflex", propertiesMap);
        pmap.put("currentimage", propertiesMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod("entity", "setCustomProperties", new Object[]{row, pmap});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (profigsKeys.contains(key)) {
            Object type;
            EntryGrid itemsEntity = (EntryGrid)this.getControl("entity");
            int[] selectRows = itemsEntity.getSelectRows();
            Object pkid = selectRows.length > 0 ? this.getModel().getValue("ruleid", selectRows[0]) : null;
            Object object = type = selectRows.length > 0 ? this.getModel().getValue("sourcetype", selectRows[0]) : null;
            if (key.contains("profits") && !"flex".equals(key)) {
                pkid = null;
            }
            this.openRuleForm("tccit_year_rule", pkid, type);
        }
    }

    private void openRuleForm(String formId, Object pkid, Object type) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(formId);
        if (pkid == null) {
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkid);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("pkid", pkid);
        customParams.put("type", type);
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

