/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.rule;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;

public class NewTccittzQueryPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static Set<String> profigsKeys = Sets.newHashSet((Object[])new String[]{"cardflexpanelap12", "cardflexpanelap22", "cardentryflexpanelap42", "cardentryflexpanelap2", "cardflexpanelap4", "image", "cardentryflexpanelap32", "cardflexpanelap32", "cardentryflexpanelap52", "flex"});
    private static final String SHOWDISABLE = "showdisable";
    private static final String ORG = "org";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"toolbar"});
        this.addClickListeners(profigsKeys.toArray(new String[0]));
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(ORG, (Object)PermissionUtils.getDefaultOrgId());
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        this.createTree(org, false);
    }

    private void createTree(DynamicObject org, boolean showdisable) {
        List<TreeNode> nodeList = this.getNodeList(org, showdisable);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        IPageCache cache = this.getPageCache();
        TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)cache, (boolean)false);
        TreeUtils.expand((TreeView)treeView, (IPageCache)cache, (int)1);
        treeView.focusNode(nodeList.get(0));
        this.refreshRules("0");
        this.getPageCache().put("currentnode", nodeList.get(0).getId());
    }

    private void createTreeCache(DynamicObject org, boolean showdisable, String currentnode) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List<TreeNode> nodeList = this.getNodeListCache(org, showdisable);
        TreeNode foucsnode = new TreeNode();
        for (TreeNode node : nodeList) {
            if (!node.getId().equals(currentnode)) continue;
            foucsnode = node;
        }
        IPageCache cache = this.getPageCache();
        TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)cache, (boolean)false);
        TreeUtils.expand((TreeView)treeView, (IPageCache)cache, (int)1);
        treeView.focusNode(foucsnode);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"treeviewap")) {
            String id = (String)evt.getNodeId();
            this.getPageCache().put("currentnode", id);
            this.refreshRules(id);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
        String name = e.getProperty().getName();
        if (ORG.equals(name) || SHOWDISABLE.equals(name)) {
            DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
            String currentnode = this.getPageCache().get("currentnode");
            this.createTreeCache(org, showdisable, currentnode);
            this.refreshRules(currentnode);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("refresh")) {
            Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
            DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
            String currentnode = this.getPageCache().get("currentnode");
            this.createTreeCache(org, showdisable, currentnode);
            this.refreshRules(currentnode);
        }
    }

    private void refreshRules(String number) {
        Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
        String schildlist = this.getPageCache().get(number);
        List list = SerializationUtils.fromJsonStringToList((String)schildlist, Long.class);
        this.loadCard(list, showdisable);
    }

    private void loadCard(List<Long> number, boolean showdisable) {
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        DynamicObject query = null;
        this.getModel().deleteEntryData("entity");
        if (this.getModel().getDataEntityType().getProperty("entity") != null) {
            DynamicObjectCollection rules = NewTccittzQueryPlugin.getrules(number, org, showdisable);
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("entity");
                this.getModel().setValue("ruleid", rule.get("id"), row);
                this.getModel().setValue("rulename", rule.get("name"), row);
                this.getModel().setValue("rulemodifydate", rule.get("modifytime"), row);
                query = QueryServiceHelper.queryOne((String)"tpo_standingbook_items", (String)"subtable.projname as projname", (QFilter[])new QFilter[]{new QFilter("subtable.id", "=", rule.get("standingbooks"))});
                String projname = query.getString("projname");
                this.getModel().setValue("type", (Object)projname, row);
                this.getModel().setValue("profitsenable", rule.get("enable"), row);
                this.getModel().setValue("ruletype", rule.get("ruletype"), row);
                this.setBackgroundAndImage(row, rule.getString("ruletype"));
            }
            this.getModel().endInit();
            this.getView().updateView("entity");
        }
    }

    private static DynamicObjectCollection getrules(List<Long> number, DynamicObject org, boolean showdisable) {
        DynamicObjectCollection rules = new DynamicObjectCollection();
        if (null != org) {
            ArrayList<Long> ruleids = new ArrayList<Long>();
            ArrayList sbxPlanQfilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("orgentity.org", "=", org.get("id")).and(new QFilter("ruleentity.type", "=", (Object)"standbook"))});
            DynamicObjectCollection sharingRules = QueryServiceHelper.query((String)"tccit_sbx_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid,ruleentity.type as type", (QFilter[])sbxPlanQfilters.toArray(new QFilter[0]));
            for (DynamicObject sharingRule : sharingRules) {
                Long ruleid = sharingRule.getLong("ruleid");
                ruleids.add(ruleid);
            }
            for (Long id : number) {
                DynamicObjectCollection rule;
                QFilter qFilter3 = new QFilter(ORG, "=", org.get("id"));
                QFilter qFilter4 = new QFilter("ruletype", "=", (Object)"private");
                QFilter qFilter5 = new QFilter("standingbooks", "=", (Object)id);
                QFilter qFilter6 = new QFilter("enable", "in", (Object)"1");
                QFilter qFilter7 = new QFilter("id", "in", ruleids);
                if (showdisable) {
                    QFilter[] allfilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).or(qFilter7).and(qFilter5)};
                    rule = QueryServiceHelper.query((String)"tccit_standbook_rule_item", (String)"id,enable,ruletype,name,modifytime,standingbooks", (QFilter[])allfilter);
                    rules.addAll((Collection)rule);
                    continue;
                }
                QFilter[] enalbefilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).and(qFilter6).or(qFilter7).and(qFilter5).and(qFilter6)};
                rule = QueryServiceHelper.query((String)"tccit_standbook_rule_item", (String)"id,enable,ruletype,name,modifytime,standingbooks", (QFilter[])enalbefilter);
                rules.addAll((Collection)rule);
            }
        }
        return rules;
    }

    private void setBackgroundAndImage(int row, String ruletype) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        if ("private".equals(ruletype)) {
            propertiesMap.put("bc", "#FFF2E9");
            propertiesMap.put("src", "/icons/pc/label/swy_zy_61_61.png");
        } else {
            propertiesMap.put("bc", "#E7F0FF");
            propertiesMap.put("src", "/icons/pc/label/swy_fp_61_61.png");
        }
        pmap.put("currentflex", propertiesMap);
        pmap.put("currentimage", propertiesMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod("entity", "setCustomProperties", new Object[]{row, pmap});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (profigsKeys.contains(key)) {
            Object pkid;
            EntryGrid itemsEntity = (EntryGrid)this.getControl("entity");
            int[] selectRows = itemsEntity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("ruleid", selectRows[0]) : null;
            if (key.contains("profits") && !"flex".equals(key)) {
                pkid = null;
            }
            this.openRuleForm("tccit_standbook_rule_item", pkid);
        }
    }

    private void openRuleForm(String formId, Object pkid) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(formId);
        if (pkid == null) {
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkid);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("pkid", pkid);
        customParams.put("ruletype", this.getView().getFormShowParameter().getCustomParams().get("ruletype"));
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Long> searchAllLeaf(Long currentid) {
        QFilter filter1 = new QFilter("subtable.parentid", "=", (Object)currentid);
        ArrayList<Long> leaflist = new ArrayList<Long>();
        DynamicObjectCollection dcs1 = null;
        dcs1 = QueryServiceHelper.query((String)"tpo_standingbook_items", (String)"subtable.id as id", (QFilter[])new QFilter[]{filter1});
        if (dcs1.isEmpty()) {
            leaflist.add(currentid);
        } else {
            for (DynamicObject child : dcs1) {
                Long childid = Long.parseLong(child.getString("id"));
                List<Long> curentchildlist = this.searchAllLeaf(childid);
                String schildlist = SerializationUtils.toJsonString(curentchildlist);
                this.getPageCache().put(child.getString("id"), schildlist);
                if (1 == curentchildlist.size()) {
                    leaflist.add(childid);
                    continue;
                }
                leaflist.addAll(this.searchAllLeaf(childid));
            }
        }
        return leaflist;
    }

    public List<TreeNode> getNodeList(DynamicObject org, boolean showdisable) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        ArrayList list = new ArrayList();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        int sumchild = 0;
        TreeNode root = new TreeNode();
        root.setId("0");
        QFilter filter1 = new QFilter("subtable.projnumber", "like", (Object)"%2021%");
        QFilter filter2 = new QFilter("subtable.typecopy", "in", (Object)"zfjgsys");
        QFilter filter3 = new QFilter("subtable.parentid", "=", (Object)0L);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"tpo_standingbook_items", (String)"subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{filter1, filter2});
        collection.addAll((Collection)res);
        DynamicObject zfjgsys = QueryServiceHelper.queryOne((String)"tpo_standingbook_items", (String)"subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{filter1, filter2, filter3});
        String zfjgsysId = zfjgsys.getString("id");
        List<Long> accerlist = this.searchAllLeaf(Long.parseLong(zfjgsysId));
        String acceschildlist = SerializationUtils.toJsonString(accerlist);
        this.getPageCache().put(zfjgsysId, acceschildlist);
        for (DynamicObject entry : collection) {
            String Id = entry.getString("id");
            String name = entry.getString("projname");
            String parentid = entry.getString("parentid");
            TreeNode leftRoot = new TreeNode();
            leftRoot.setParentid(parentid);
            leftRoot.setId(Id);
            String schildlist = this.getPageCache().get(Id);
            List childlist = SerializationUtils.fromJsonStringToList((String)schildlist, Long.class);
            int currentunm = NewTccittzQueryPlugin.getrules(childlist, org, showdisable).size();
            if (parentid.equals("0")) {
                sumchild += currentunm;
                list.addAll(childlist);
            }
            String num = String.valueOf(currentunm);
            leftRoot.setText(name + "(" + num + ")");
            nodeList.add(leftRoot);
        }
        root.setText(String.format(ResManager.loadKDString((String)"\u5168\u90e8(%s)", (String)"NewTccittzQueryPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), sumchild));
        String schildlist = SerializationUtils.toJsonString(list);
        this.getPageCache().put("0", schildlist);
        nodeList.add(root);
        return nodeList;
    }

    public List<TreeNode> getNodeListCache(DynamicObject org, boolean showdisable) {
        int sum = 0;
        TreeNode root = new TreeNode();
        root.setId("0");
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        nodeList.add(root);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        QFilter filter1 = new QFilter("subtable.projnumber", "like", (Object)"%2021%");
        QFilter filter2 = new QFilter("subtable.typecopy", "in", (Object)"zfjgsys");
        DynamicObjectCollection res = QueryServiceHelper.query((String)"tpo_standingbook_items", (String)"subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{filter1, filter2});
        collection.addAll((Collection)res);
        for (DynamicObject entry : collection) {
            String Id = entry.getString("id");
            String name = entry.getString("projname");
            String parentid = entry.getString("parentid");
            TreeNode leftRoot = new TreeNode();
            leftRoot.setParentid(parentid);
            leftRoot.setId(Id);
            String schildlist = this.getPageCache().get(Id);
            List childlist = SerializationUtils.fromJsonStringToList((String)schildlist, Long.class);
            int currentunm = NewTccittzQueryPlugin.getrules(childlist, org, showdisable).size();
            if (parentid.equals("0")) {
                sum += currentunm;
            }
            String num = String.valueOf(currentunm);
            leftRoot.setText(name + "(" + num + ")");
            nodeList.add(leftRoot);
        }
        root.setText(String.format(ResManager.loadKDString((String)"\u5168\u90e8(%s)", (String)"NewTccittzQueryPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), sum));
        nodeList.add(root);
        return nodeList;
    }
}

