/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.rule;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;

public class NewTccityjRuleQueryPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static Set<String> profigsKeys = Sets.newHashSet((Object[])new String[]{"cardflexpanelap12", "cardflexpanelap22", "cardentryflexpanelap42", "cardentryflexpanelap2", "cardflexpanelap4", "image", "cardentryflexpanelap32", "cardflexpanelap32", "cardentryflexpanelap52", "flex"});
    private static final String SHOWDISABLE = "showdisable";
    private static final String ORG = "org";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(profigsKeys.toArray(new String[0]));
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(ORG, (Object)PermissionUtils.getDefaultOrgId());
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        this.createTree(org, false);
    }

    private void createTree(DynamicObject org, boolean showdisable) {
        List<TreeNode> nodeList = this.getNodeList(org, showdisable);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        IPageCache cache = this.getPageCache();
        TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)cache, (boolean)false);
        TreeUtils.expand((TreeView)treeView, (IPageCache)cache, (int)1);
        treeView.focusNode(nodeList.get(0));
        this.refreshRules("0");
        this.getPageCache().put("currentnode", nodeList.get(0).getId());
    }

    private void createTreeCache(DynamicObject org, boolean showdisable, String currentnode) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List<TreeNode> nodeList = this.getNodeListCache(org, showdisable);
        TreeNode foucsnode = new TreeNode();
        for (TreeNode node : nodeList) {
            if (!node.getId().equals(currentnode)) continue;
            foucsnode = node;
        }
        IPageCache cache = this.getPageCache();
        TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)cache, (boolean)false);
        TreeUtils.expand((TreeView)treeView, (IPageCache)cache, (int)1);
        treeView.focusNode(foucsnode);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"treeviewap")) {
            String id = (String)evt.getNodeId();
            this.getPageCache().put("currentnode", id);
            this.refreshRules(id);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
        String name = e.getProperty().getName();
        if (ORG.equals(name) || SHOWDISABLE.equals(name)) {
            DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
            String currentnode = this.getPageCache().get("currentnode");
            this.createTreeCache(org, showdisable, currentnode);
            this.refreshRules(currentnode);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("refresh")) {
            Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
            DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
            String currentnode = this.getPageCache().get("currentnode");
            this.createTreeCache(org, showdisable, currentnode);
            this.refreshRules(currentnode);
        }
    }

    private void refreshRules(String number) {
        Boolean showdisable = (Boolean)this.getModel().getValue(SHOWDISABLE);
        String schildlist = this.getPageCache().get(number);
        if (number.equals("0")) {
            String profitstjosn = this.getPageCache().get("profitslist");
            String accelistjosn = this.getPageCache().get("accelist");
            String yhxmlistjosn = this.getPageCache().get("yhxmlist");
            String nstzlistjosn = this.getPageCache().get("nstzlist");
            List profitst = SerializationUtils.fromJsonStringToList((String)profitstjosn, Long.class);
            List accelist = SerializationUtils.fromJsonStringToList((String)accelistjosn, Long.class);
            List yhxmlist = SerializationUtils.fromJsonStringToList((String)yhxmlistjosn, Long.class);
            List nstzlist = SerializationUtils.fromJsonStringToList((String)nstzlistjosn, Long.class);
            this.loadyjAllCard(profitst, accelist, yhxmlist, nstzlist, showdisable);
        } else {
            String map = this.getPageCache().get("typemap");
            Map currenttypes = (Map)SerializationUtils.fromJsonString((String)map, Map.class);
            String currenttype = (String)currenttypes.get(number);
            List list = SerializationUtils.fromJsonStringToList((String)schildlist, Long.class);
            this.loadCard(list, showdisable, currenttype);
        }
    }

    private void loadyjAllCard(List<Long> profitslist, List<Long> accelist, List<Long> yhxmlist, List<Long> nstzlist, boolean showdisable) {
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        DynamicObject query = null;
        this.getModel().deleteEntryData("entity");
        if (this.getModel().getDataEntityType().getProperty("entity") != null) {
            DynamicObjectCollection profitsrules = NewTccityjRuleQueryPlugin.getrules(profitslist, org, showdisable, "profits");
            this.getModel().beginInit();
            for (Object rule : profitsrules) {
                int row = this.getModel().createNewEntryRow("entity");
                this.getModel().setValue("ruleid", rule.get("id"), row);
                this.getModel().setValue("rulename", rule.get("name"), row);
                this.getModel().setValue("rulemodifydate", rule.get("modifytime"), row);
                query = QueryServiceHelper.queryOne((String)"tpo_tccit_yearitems", (String)"subtable.projname as projname", (QFilter[])new QFilter[]{new QFilter("subtable.id", "=", rule.get("item"))});
                String projname = query.getString("projname");
                this.getModel().setValue("type", (Object)projname, row);
                this.getModel().setValue("profitsenable", rule.get("enable"), row);
                this.getModel().setValue("ruletype", rule.get("ruletype"), row);
                this.setBackgroundAndImage(row, rule.getString("ruletype"));
            }
            DynamicObjectCollection yhxmrules = NewTccityjRuleQueryPlugin.getrules(yhxmlist, org, showdisable, "yhxm");
            for (DynamicObject rule : yhxmrules) {
                int row = this.getModel().createNewEntryRow("entity");
                this.getModel().setValue("ruleid", rule.get("id"), row);
                this.getModel().setValue("rulename", rule.get("name"), row);
                this.getModel().setValue("rulemodifydate", rule.get("modifytime"), row);
                query = QueryServiceHelper.queryOne((String)"tpo_discount_items", (String)"subtable.projname as projname", (QFilter[])new QFilter[]{new QFilter("subtable.id", "=", rule.get("itemchoicename"))});
                String projname = query.getString("projname");
                this.getModel().setValue("type", (Object)projname, row);
                this.getModel().setValue("profitsenable", rule.get("enable"), row);
                this.getModel().setValue("ruletype", rule.get("ruletype"), row);
                this.setBackgroundAndImage(row, rule.getString("ruletype"));
            }
            DynamicObjectCollection accerules = NewTccityjRuleQueryPlugin.getrules(accelist, org, showdisable, "acce");
            for (DynamicObject rule : accerules) {
                int row = this.getModel().createNewEntryRow("entity");
                this.getModel().setValue("ruleid", rule.get("id"), row);
                this.getModel().setValue("rulename", rule.get("name"), row);
                this.getModel().setValue("rulemodifydate", rule.get("modifytime"), row);
                query = QueryServiceHelper.queryOne((String)"tpo_tccit_yearitems", (String)"subtable.projname as projname", (QFilter[])new QFilter[]{new QFilter("subtable.id", "=", rule.get("depreciatetype"))});
                String projname = query.getString("projname");
                this.getModel().setValue("type", (Object)projname, row);
                this.getModel().setValue("profitsenable", rule.get("enable"), row);
                this.getModel().setValue("ruletype", rule.get("ruletype"), row);
                this.setBackgroundAndImage(row, rule.getString("ruletype"));
            }
            DynamicObjectCollection nstzrules = NewTccityjRuleQueryPlugin.getrules(nstzlist, org, showdisable, "nstz");
            for (DynamicObject rule : nstzrules) {
                int row = this.getModel().createNewEntryRow("entity");
                this.getModel().setValue("ruleid", rule.get("id"), row);
                this.getModel().setValue("rulename", rule.get("name"), row);
                this.getModel().setValue("rulemodifydate", rule.get("modifytime"), row);
                query = QueryServiceHelper.queryOne((String)"tpo_tccit_yearitems", (String)"subtable.projname as projname", (QFilter[])new QFilter[]{new QFilter("subtable.id", "=", rule.get("item"))});
                String projname = query.getString("projname");
                this.getModel().setValue("type", (Object)projname, row);
                this.getModel().setValue("profitsenable", rule.get("enable"), row);
                this.getModel().setValue("ruletype", rule.get("ruletype"), row);
                this.setBackgroundAndImage(row, rule.getString("ruletype"));
            }
            this.getModel().endInit();
            this.getView().updateView("entity");
        }
    }

    private void loadCard(List<Long> number, boolean showdisable, String type) {
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue(ORG);
        DynamicObject query = null;
        this.getModel().deleteEntryData("entity");
        if (this.getModel().getDataEntityType().getProperty("entity") != null) {
            DynamicObjectCollection rules = NewTccityjRuleQueryPlugin.getrules(number, org, showdisable, type);
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("entity");
                this.getModel().setValue("ruleid", rule.get("id"), row);
                this.getModel().setValue("rulename", rule.get("name"), row);
                this.getModel().setValue("rulemodifydate", rule.get("modifytime"), row);
                query = type.equals("profits") || type.equals("nstz") ? QueryServiceHelper.queryOne((String)"tpo_tccit_yearitems", (String)"subtable.projname as projname", (QFilter[])new QFilter[]{new QFilter("subtable.id", "=", rule.get("item"))}) : (type.equals("acce") ? QueryServiceHelper.queryOne((String)"tpo_tccit_yearitems", (String)"subtable.projname as projname", (QFilter[])new QFilter[]{new QFilter("subtable.id", "=", rule.get("depreciatetype"))}) : QueryServiceHelper.queryOne((String)"tpo_discount_items", (String)"subtable.projname as projname", (QFilter[])new QFilter[]{new QFilter("subtable.id", "=", rule.get("itemchoicename"))}));
                String projname = query.getString("projname");
                this.getModel().setValue("type", (Object)projname, row);
                this.getModel().setValue("profitsenable", rule.get("enable"), row);
                this.getModel().setValue("ruletype", rule.get("ruletype"), row);
                this.setBackgroundAndImage(row, rule.getString("ruletype"));
            }
            this.getModel().endInit();
            this.getView().updateView("entity");
        }
    }

    private static DynamicObjectCollection getrules(List<Long> number, DynamicObject org, boolean showdisable, String type) {
        DynamicObjectCollection rules;
        block18: {
            rules = new DynamicObjectCollection();
            ArrayList<Long> ruleids = new ArrayList<Long>();
            if (null == org) break block18;
            if (type.equals("profits")) {
                DynamicObjectCollection sharingRules = NewTccityjRuleQueryPlugin.getSbxSharePlan(org, "profits");
                for (DynamicObject sharingRule : sharingRules) {
                    Long ruleid = sharingRule.getLong("ruleid");
                    ruleids.add(ruleid);
                }
                for (Long id : number) {
                    DynamicObjectCollection rule;
                    QFilter qFilter3 = new QFilter(ORG, "=", org.get("id"));
                    QFilter qFilter4 = new QFilter("ruletype", "=", (Object)"private");
                    QFilter qFilter5 = new QFilter("item", "=", (Object)id);
                    QFilter qFilter6 = new QFilter("enable", "in", (Object)"1");
                    QFilter qFilter7 = new QFilter("id", "in", ruleids);
                    if (showdisable) {
                        QFilter[] allfilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).or(qFilter7).and(qFilter5)};
                        rule = QueryServiceHelper.query((String)"tccit_profits_rule", (String)"id,enable,ruletype,name,modifytime,item", (QFilter[])allfilter);
                        rules.addAll((Collection)rule);
                        continue;
                    }
                    QFilter[] enalbefilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).and(qFilter6).or(qFilter7).and(qFilter5).and(qFilter6)};
                    rule = QueryServiceHelper.query((String)"tccit_profits_rule", (String)"id,enable,ruletype,name,modifytime,item", (QFilter[])enalbefilter);
                    rules.addAll((Collection)rule);
                }
            } else if (type.equals("acce")) {
                DynamicObjectCollection sharingRules = NewTccityjRuleQueryPlugin.getSbxSharePlan(org, "depreciate");
                for (DynamicObject sharingRule : sharingRules) {
                    Long ruleid = sharingRule.getLong("ruleid");
                    ruleids.add(ruleid);
                }
                for (Long id : number) {
                    DynamicObjectCollection rule;
                    QFilter qFilter3 = new QFilter(ORG, "=", org.get("id"));
                    QFilter qFilter4 = new QFilter("ruletype", "=", (Object)"private");
                    QFilter qFilter5 = new QFilter("depreciatetype", "=", (Object)id);
                    QFilter qFilter6 = new QFilter("enable", "in", (Object)"1");
                    QFilter qFilter7 = new QFilter("id", "in", ruleids);
                    if (showdisable) {
                        QFilter[] allfilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).or(qFilter7).and(qFilter5)};
                        rule = QueryServiceHelper.query((String)"tccit_depreciate_rule", (String)"id,enable,ruletype,name,modifytime,depreciatetype", (QFilter[])allfilter);
                        rules.addAll((Collection)rule);
                        continue;
                    }
                    QFilter[] enalbefilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).and(qFilter6).or(qFilter7).and(qFilter5).and(qFilter6)};
                    rule = QueryServiceHelper.query((String)"tccit_depreciate_rule", (String)"id,enable,ruletype,name,modifytime,depreciatetype", (QFilter[])enalbefilter);
                    rules.addAll((Collection)rule);
                }
            } else if (type.equals("yhxm")) {
                DynamicObjectCollection sharingRules = NewTccityjRuleQueryPlugin.getSbxSharePlan(org, "income");
                for (DynamicObject sharingRule : sharingRules) {
                    Long ruleid = sharingRule.getLong("ruleid");
                    ruleids.add(ruleid);
                }
                for (Long id : number) {
                    DynamicObjectCollection rule;
                    QFilter qFilter3 = new QFilter(ORG, "=", org.get("id"));
                    QFilter qFilter4 = new QFilter("ruletype", "=", (Object)"private");
                    QFilter qFilter5 = new QFilter("itemchoicename", "=", (Object)id);
                    QFilter qFilter6 = new QFilter("enable", "in", (Object)"1");
                    QFilter qFilter7 = new QFilter("id", "in", ruleids);
                    if (showdisable) {
                        QFilter[] allfilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).or(qFilter7).and(qFilter5)};
                        rule = QueryServiceHelper.query((String)"tccit_preferential_item", (String)"id,enable,ruletype,name,modifytime,itemchoicename", (QFilter[])allfilter);
                        rules.addAll((Collection)rule);
                        continue;
                    }
                    QFilter[] enalbefilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).and(qFilter6).or(qFilter7).and(qFilter5).and(qFilter6)};
                    rule = QueryServiceHelper.query((String)"tccit_preferential_item", (String)"id,enable,ruletype,name,modifytime,itemchoicename", (QFilter[])enalbefilter);
                    rules.addAll((Collection)rule);
                }
            } else {
                DynamicObjectCollection sharingRules = NewTccityjRuleQueryPlugin.getSbxSharePlan(org, "yjother");
                for (DynamicObject sharingRule : sharingRules) {
                    Long ruleid = sharingRule.getLong("ruleid");
                    ruleids.add(ruleid);
                }
                for (Long id : number) {
                    DynamicObjectCollection rule;
                    QFilter qFilter3 = new QFilter(ORG, "=", org.get("id"));
                    QFilter qFilter4 = new QFilter("ruletype", "=", (Object)"private");
                    QFilter qFilter5 = new QFilter("item", "=", (Object)id);
                    QFilter qFilter6 = new QFilter("enable", "in", (Object)"1");
                    QFilter qFilter7 = new QFilter("id", "in", ruleids);
                    if (showdisable) {
                        QFilter[] allfilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).or(qFilter7).and(qFilter5)};
                        rule = QueryServiceHelper.query((String)"tccit_other_rule", (String)"id,enable,ruletype,name,modifytime,item", (QFilter[])allfilter);
                        rules.addAll((Collection)rule);
                        continue;
                    }
                    QFilter[] enalbefilter = new QFilter[]{qFilter3.and(qFilter4).and(qFilter5).and(qFilter6).or(qFilter7).and(qFilter5).and(qFilter6)};
                    rule = QueryServiceHelper.query((String)"tccit_other_rule", (String)"id,enable,ruletype,name,modifytime,item", (QFilter[])enalbefilter);
                    rules.addAll((Collection)rule);
                }
            }
        }
        return rules;
    }

    private static DynamicObjectCollection getSbxSharePlan(DynamicObject org, String type) {
        ArrayList sbxPlanQfilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("orgentity.org", "=", org.get("id")).and(new QFilter("ruleentity.type", "=", (Object)type))});
        return QueryServiceHelper.query((String)"tccit_sbx_shareplan", (String)"ruleentity.rule as ruleid, ruleentity.rule.group as groupid,ruleentity.type as type", (QFilter[])sbxPlanQfilters.toArray(new QFilter[0]));
    }

    private void setBackgroundAndImage(int row, String ruletype) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        if ("private".equals(ruletype)) {
            propertiesMap.put("bc", "#FFF2E9");
            propertiesMap.put("src", "/icons/pc/label/swy_zy_61_61.png");
        } else {
            propertiesMap.put("bc", "#E7F0FF");
            propertiesMap.put("src", "/icons/pc/label/swy_fp_61_61.png");
        }
        pmap.put("currentflex", propertiesMap);
        pmap.put("currentimage", propertiesMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod("entity", "setCustomProperties", new Object[]{row, pmap});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (profigsKeys.contains(key)) {
            Object pkid;
            EntryGrid itemsEntity = (EntryGrid)this.getControl("entity");
            int[] selectRows = itemsEntity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("ruleid", selectRows[0]) : null;
            if (key.contains("profits") && !"flex".equals(key)) {
                pkid = null;
            }
            String currentnode = this.getPageCache().get("currentnode");
            String map = this.getPageCache().get("typemap");
            Map currenttypes = (Map)SerializationUtils.fromJsonString((String)map, Map.class);
            String currenttype = (String)currenttypes.get(currentnode);
            if (currentnode.equals("0")) {
                if (QueryServiceHelper.exists((String)"tccit_profits_rule", (Object)pkid)) {
                    this.openRuleForm("tccit_profits_rule", pkid);
                } else if (QueryServiceHelper.exists((String)"tccit_depreciate_rule", (Object)pkid)) {
                    this.openRuleForm("tccit_depreciate_rule", pkid);
                } else if (QueryServiceHelper.exists((String)"tccit_preferential_item", (Object)pkid)) {
                    this.openRuleForm("tccit_preferential_item", pkid);
                } else {
                    this.openRuleForm("tccit_other_rule", pkid);
                }
            } else if (currenttype.equals("profits")) {
                this.openRuleForm("tccit_profits_rule", pkid);
            } else if (currenttype.equals("acce")) {
                this.openRuleForm("tccit_depreciate_rule", pkid);
            } else if (currenttype.equals("yhxm")) {
                this.openRuleForm("tccit_preferential_item", pkid);
            } else {
                this.openRuleForm("tccit_other_rule", pkid);
            }
        }
    }

    private void openRuleForm(String formId, Object pkid) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(formId);
        if (pkid == null) {
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkid);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("pkid", pkid);
        customParams.put("ruletype", this.getView().getFormShowParameter().getCustomParams().get("ruletype"));
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Long> searchAllLeaf(Long currentid, String projtype) {
        QFilter filter1 = new QFilter("subtable.parentid", "=", (Object)currentid);
        QFilter filter2 = new QFilter("type", "=", (Object)projtype);
        ArrayList<Long> leaflist = new ArrayList<Long>();
        DynamicObjectCollection dcs1 = null;
        dcs1 = projtype.equals("acce") || projtype.equals("profits") || projtype.equals("nstz") ? QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"subtable.id as id", (QFilter[])new QFilter[]{filter1, filter2}) : QueryServiceHelper.query((String)"tpo_discount_items", (String)"subtable.id as id", (QFilter[])new QFilter[]{filter1, filter2});
        if (dcs1.isEmpty()) {
            leaflist.add(currentid);
        } else {
            for (DynamicObject child : dcs1) {
                Long childid = Long.parseLong(child.getString("id"));
                List<Long> curentchildlist = this.searchAllLeaf(childid, projtype);
                String schildlist = SerializationUtils.toJsonString(curentchildlist);
                this.getPageCache().put(child.getString("id"), schildlist);
                if (1 == curentchildlist.size()) {
                    leaflist.add(childid);
                    continue;
                }
                leaflist.addAll(this.searchAllLeaf(childid, projtype));
            }
        }
        return leaflist;
    }

    public List<TreeNode> getNodeList(DynamicObject org, boolean showdisable) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        HashMap<String, String> typemap = new HashMap<String, String>();
        int sumchild = 0;
        TreeNode root = new TreeNode();
        root.setId("0");
        QFilter pfilter1 = new QFilter("subtable.typecopy", "in", (Object)"profits");
        QFilter pfilter2 = new QFilter("subtable.parentid", "=", (Object)0L);
        DynamicObjectCollection res1 = QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{pfilter1});
        DynamicObjectCollection profits = QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{pfilter1, pfilter2});
        ArrayList<Long> profitslist = new ArrayList<Long>();
        for (DynamicObject profit : profits) {
            String profitsId = profit.getString("id");
            String profitsprojtype = profit.getString("type");
            List<Long> rootlist = this.searchAllLeaf(Long.parseLong(profitsId), profitsprojtype);
            profitslist.addAll(rootlist);
            String profitschildlist = SerializationUtils.toJsonString(rootlist);
            this.getPageCache().put(profitsId, profitschildlist);
        }
        String profitschildlist = SerializationUtils.toJsonString(profitslist);
        this.getPageCache().put("profitslist", profitschildlist);
        QFilter filter1 = new QFilter("number", "=", (Object)"2021_discount_items").or("number", "=", (Object)"2021_discount_items_hdzs");
        QFilter filter2 = new QFilter("subtable.typecopy", "in", (Object)"yhxm");
        QFilter filter3 = new QFilter("subtable.parentid", "=", (Object)0L);
        DynamicObjectCollection res2 = QueryServiceHelper.query((String)"tpo_discount_items", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{filter1, filter2});
        DynamicObjectCollection yhxms = QueryServiceHelper.query((String)"tpo_discount_items", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{filter1, filter2, filter3});
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject yhxm : yhxms) {
            String yhxmId = yhxm.getString("id");
            String yhxmtype = yhxm.getString("type");
            List<Long> yhxmrlist = this.searchAllLeaf(Long.parseLong(yhxmId), yhxmtype);
            ids.addAll(yhxmrlist);
            String yhxmschildlist = SerializationUtils.toJsonString(yhxmrlist);
            this.getPageCache().put(yhxmId, yhxmschildlist);
        }
        this.getPageCache().put("yhxmlist", SerializationUtils.toJsonString(ids));
        QFilter afilter1 = new QFilter("subtable.typecopy", "in", (Object)"acce");
        QFilter afilter2 = new QFilter("subtable.parentid", "=", (Object)0L);
        DynamicObjectCollection res3 = QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{afilter1});
        DynamicObject acce = QueryServiceHelper.queryOne((String)"tpo_tccit_yearitems", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{afilter1, afilter2});
        String acceId = acce.getString("id");
        String accetype = acce.getString("type");
        List<Long> accerlist = this.searchAllLeaf(Long.parseLong(acceId), accetype);
        String acceschildlist = SerializationUtils.toJsonString(accerlist);
        this.getPageCache().put(acceId, acceschildlist);
        this.getPageCache().put("accelist", acceschildlist);
        QFilter nfilter1 = new QFilter("subtable.typecopy", "in", (Object)"nstz");
        QFilter nfilter2 = new QFilter("subtable.parentid", "=", (Object)0L);
        DynamicObjectCollection res4 = QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{nfilter1});
        DynamicObject nstz = QueryServiceHelper.queryOne((String)"tpo_tccit_yearitems", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{nfilter1, nfilter2});
        String nstzId = nstz.getString("id");
        String nstztype = nstz.getString("type");
        List<Long> nstzlist = this.searchAllLeaf(Long.parseLong(nstzId), nstztype);
        String nstzchildlist = SerializationUtils.toJsonString(nstzlist);
        this.getPageCache().put(nstzId, nstzchildlist);
        this.getPageCache().put("nstzlist", nstzchildlist);
        collection.addAll((Collection)res1);
        collection.addAll((Collection)res2);
        collection.addAll((Collection)res3);
        collection.addAll((Collection)res4);
        for (DynamicObject entry : collection) {
            String Id = entry.getString("id");
            String name = entry.getString("projname");
            String parentid = entry.getString("parentid");
            String projtype = entry.getString("type");
            typemap.put(Id, projtype);
            TreeNode leftRoot = new TreeNode();
            leftRoot.setParentid(parentid);
            leftRoot.setId(Id);
            String schildlist = this.getPageCache().get(Id);
            if (schildlist == null) continue;
            List childlist = SerializationUtils.fromJsonStringToList((String)schildlist, Long.class);
            int currentunm = NewTccityjRuleQueryPlugin.getrules(childlist, org, showdisable, projtype).size();
            if (parentid.equals("0")) {
                sumchild += currentunm;
            }
            String num = String.valueOf(currentunm);
            leftRoot.setText(name + "(" + num + ")");
            nodeList.add(leftRoot);
        }
        root.setText(String.format(ResManager.loadKDString((String)"\u5168\u90e8(%s)", (String)"NewTccityjRuleQueryPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), sumchild));
        nodeList.add(root);
        String map = SerializationUtils.toJsonString(typemap);
        this.getPageCache().put("typemap", map);
        return nodeList;
    }

    public List<TreeNode> getNodeListCache(DynamicObject org, boolean showdisable) {
        int sum = 0;
        TreeNode root = new TreeNode();
        root.setId("0");
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        nodeList.add(root);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObjectCollection res1 = QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{new QFilter("subtable.typecopy", "in", (Object)"profits")});
        QFilter filter1 = new QFilter("number", "=", (Object)"2021_discount_items").or("number", "=", (Object)"2021_discount_items_hdzs");
        QFilter filter2 = new QFilter("subtable.typecopy", "in", (Object)"yhxm");
        DynamicObjectCollection res2 = QueryServiceHelper.query((String)"tpo_discount_items", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{filter1, filter2});
        DynamicObjectCollection res3 = QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{new QFilter("subtable.typecopy", "in", (Object)"acce")});
        DynamicObjectCollection res4 = QueryServiceHelper.query((String)"tpo_tccit_yearitems", (String)"type, subtable.id as id, subtable.projname as projname, subtable.parentid as parentid", (QFilter[])new QFilter[]{new QFilter("subtable.typecopy", "in", (Object)"nstz")});
        collection.addAll((Collection)res1);
        collection.addAll((Collection)res2);
        collection.addAll((Collection)res3);
        collection.addAll((Collection)res4);
        for (DynamicObject entry : collection) {
            String Id = entry.getString("id");
            String name = entry.getString("projname");
            String parentid = entry.getString("parentid");
            String type = entry.getString("type");
            TreeNode leftRoot = new TreeNode();
            leftRoot.setParentid(parentid);
            leftRoot.setId(Id);
            String schildlist = this.getPageCache().get(Id);
            if (schildlist == null) continue;
            List childlist = SerializationUtils.fromJsonStringToList((String)schildlist, Long.class);
            int currentunm = NewTccityjRuleQueryPlugin.getrules(childlist, org, showdisable, type).size();
            if (parentid.equals("0")) {
                sum += currentunm;
            }
            String num = String.valueOf(currentunm);
            leftRoot.setText(name + "(" + num + ")");
            nodeList.add(leftRoot);
        }
        root.setText(String.format(ResManager.loadKDString((String)"\u5168\u90e8(%s)", (String)"NewTccityjRuleQueryPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), sum));
        nodeList.add(root);
        return nodeList;
    }
}

