/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.common.enums.TccitRuleQueryEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SharingEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
TabSelectListener {
    private static final String TABAP = "tabap";
    private static final String CURRENT_TAB = "current_tab";
    private static final String ORG = "org";
    private static final String TAB = "tab";
    private static final String ITEM_CLOSE = "bar_close";
    private static final String systemType = "taxc-tccit";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String PLANENTITY = "planentity";
    private static final String RULEENTITY = "ruleentity";
    private static final String ORGENTITY = "orgentity";

    public void initialize() {
        this.setShareTypeVisible();
    }

    public void registerListener(EventObject e) {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.addRowClickListener((RowClickEventListener)this);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"flex_addorg", "vector_addorg", "label_addorg", "label_moreorg", "labelcreate"});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        Toolbar toolbarMain = (Toolbar)this.getControl("tbmain");
        toolbarMain.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue(ORG, this.getOrgid(customParams));
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            Long orgid = PermissionUtils.getDefaultOrgId();
            this.getModel().setValue(ORG, (Object)orgid);
        }
        if ((org = (DynamicObject)this.getModel().getValue(ORG)) != null && !customParams.containsKey("initialized")) {
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put("orgid", org.getString("id"));
            custom.put("initialized", Boolean.TRUE);
            QFilter filter = new QFilter(ORG, "=", (Object)org.getLong("id"));
            QFilter typeFilter = new QFilter("shareType", "=", customParams.get("shareMeType")).or(new QFilter("shareType", "=", (Object)""));
            DynamicObject plan = QueryServiceHelper.queryOne((String)"tccit_rule_sharing", (String)"id", (QFilter[])new QFilter[]{filter, typeFilter});
            if (plan != null) {
                this.showBill(plan.getLong("id"), custom);
            } else {
                this.showBill(null, custom);
            }
        }
        this.setShareTypeVisible();
    }

    public Object getOrgid(Map<String, Object> customParams) {
        Object orgId = customParams.get("orgid");
        if (orgId != null) {
            return orgId;
        }
        return "";
    }

    private void updateAddLableName() {
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity(ORGENTITY);
        if (null == orgEntity || orgEntity.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_moreorg"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_addorg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_moreorg"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_addorg"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.resetPlanName(0);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(RULEENTITY);
        Object shareMeType = this.getView().getFormShowParameter().getCustomParams().get("shareMeType");
        for (TccitRuleQueryEnum tccitRuleQueryEnum : TccitRuleQueryEnum.values()) {
            if (!shareMeType.equals(tccitRuleQueryEnum.getCode())) continue;
            this.setFilter(entity, tccitRuleQueryEnum.getName());
        }
        this.setShareTypeVisible();
    }

    public void afterBindData(EventObject e) {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.selectCard(Integer.valueOf(0));
        planentity.entryRowClick(Integer.valueOf(0));
        this.updateAddLableName();
        this.setVisible();
    }

    private void setVisible() {
        int row = this.getModel().getEntryRowCount(PLANENTITY);
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", PLANENTITY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata", "planflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", PLANENTITY});
        }
    }

    private void setShareTypeVisible() {
        Object shareMeType = this.getView().getFormShowParameter().getCustomParams().get("shareMeType");
        for (TccitRuleQueryEnum tccitRuleQueryEnum : TccitRuleQueryEnum.values()) {
            if (shareMeType.equals(tccitRuleQueryEnum.getCode())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{tccitRuleQueryEnum.getName() + TAB});
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{tccitRuleQueryEnum.getName() + TAB});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (ORG.equals(e.getProperty().getName())) {
            this.getModel().setDataChanged(false);
            HashMap<String, Object> custom = new HashMap<String, Object>();
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org != null) {
                String orgid = org.getString("id");
                custom.put("orgid", orgid);
                Object shareMeType = this.getView().getFormShowParameter().getCustomParams().get("shareMeType");
                custom.put("shareMeType", shareMeType);
                QFilter filter = new QFilter(ORG, "=", (Object)Long.parseLong(orgid));
                QFilter typeFilter = new QFilter("shareType", "=", shareMeType).or(new QFilter("shareType", "=", (Object)""));
                DynamicObject plan = QueryServiceHelper.queryOne((String)"tccit_rule_sharing", (String)"id", (QFilter[])new QFilter[]{filter, typeFilter});
                if (plan != null) {
                    this.showBill(plan.getLong("id"), custom);
                } else {
                    this.showBill(null, custom);
                }
            }
        } else if ("planname".equals(e.getProperty().getName())) {
            this.getModel().setDataChanged(false);
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            int[] selectRows = planentity.getSelectRows();
            if (!"true".equals(this.getPageCache().get("refresh")) && selectRows != null && selectRows.length > 0) {
                this.getModel().setValue("name", e.getChangeSet()[0].getNewValue(), selectRows[0]);
            }
            this.updateAddLableName();
        } else if ("autoshar".equals(e.getProperty().getName())) {
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            int[] selectRows = planentity.getSelectRows();
            if (selectRows.length > 0 && !"true".equals(this.getPageCache().get("refresh"))) {
                this.getModel().setValue("entryautoshar", e.getChangeSet()[0].getNewValue(), selectRows[0]);
            }
        } else if ("orgid".equals(e.getProperty().getName())) {
            this.updateAddLableName();
        }
        this.setShareTypeVisible();
    }

    private void showBill(Object pkId, Map<String, Object> customParams) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        billShowParameter.getCustomParams().putAll(customParams);
        if (pkId != null) {
            billShowParameter.setPkId(pkId);
            this.getModel().setValue("id", pkId);
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
            billShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            billShowParameter.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().invokeOperation("refresh");
    }

    private void refreshRuleList(String type) {
        BillList list = (BillList)this.getControl(type + "list");
        if ("income".equals(type)) {
            list.addPackageDataListener(event -> this.visiblePackageData((PackageDataEvent)event));
        }
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(RULEENTITY);
        if (entity != null) {
            for (DynamicObject object : entity) {
                if (!type.equals(object.getString("type"))) continue;
                ids.add(object.getLong("ruleid"));
            }
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        filterParameter.setFilter(idsFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filterParameter.setFilter(enableFilter);
        list.setFilterParameter((FilterParameter)filterParameter);
        list.refreshData();
    }

    public void visiblePackageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject d = e.getRowData();
        if ("5".equals(d.getString("itemchoicename.projtype")) || "7".equals(d.getString("itemchoicename.projtype")) || "8".equals(d.getString("itemchoicename.projtype"))) {
            if ("datefield".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u7b2c\u4e00\u7b14\u9879\u76ee\u6536\u5165\u5e74\u5ea6 : %s", (String)"SharingEditPlugin_0", (String)systemType, (Object[])new Object[0]), ((Object[])e.getFormatValue())[0]));
            }
        } else if ("datefield".equals(columnDesc.getKey())) {
            e.setFormatValue((Object)" ");
        }
    }

    private void setFilter(DynamicObjectCollection entity, String type) {
        BillList list = (BillList)this.getControl(type + "list");
        ListFilterParameter filterParameter = new ListFilterParameter();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (entity != null) {
            for (DynamicObject object : entity) {
                if (!type.equals(object.getString("type"))) continue;
                ids.add(object.getLong("ruleid"));
            }
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        filterParameter.setFilter(idsFilter);
        list.setFilterParameter((FilterParameter)filterParameter);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Vector && "vector_addorg".equals(((Vector)source).getKey()) || source instanceof Label && "label_addorg".equals(((Label)source).getKey()) || source instanceof Label && "label_moreorg".equals(((Label)source).getKey()) || source instanceof Container && "flex_addorg".equals(((Container)source).getKey())) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            this.showOrgSelect();
        } else if (source instanceof Label && "labelcreate".equals(((Label)source).getKey())) {
            Button button = (Button)this.getControl("button_addplan");
            button.click();
        }
    }

    private boolean checkPlanNotSelected() {
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] selectedRows = planentity.getSelectRows();
        if (selectedRows == null || selectedRows.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5171\u4eab\u65b9\u6848\u88ab\u9009\u4e2d\uff0c\u8bf7\u5148\u6dfb\u52a0\u5171\u4eab\u65b9\u6848\u3002", (String)"SharingEditPlugin_1", (String)systemType, (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isCurrentSelect(int row) {
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] rows = planentity.getSelectRows();
        return Arrays.stream(rows).allMatch(s -> s == row);
    }

    private void showOrgSelect() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)2);
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u88ab\u5171\u4eab\u7ec4\u7ec7", (String)"SharingEditPlugin_2", (String)systemType, (Object[])new Object[0]));
        Optional<DynamicObject> optional = this.getModel().getEntryEntity(PLANENTITY).stream().filter(s -> this.isCurrentSelect(s.getInt("seq") - 1)).findFirst();
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        if (optional.isPresent()) {
            DynamicObject planentity = optional.get();
            DynamicObjectCollection orgEntity = planentity.getDynamicObjectCollection(ORGENTITY);
            for (DynamicObject entity : orgEntity) {
                ListSelectedRow row = new ListSelectedRow();
                DynamicObject org = entity.getDynamicObject("orgid");
                row.setName(org.getString("name"));
                row.setNumber(org.getString("number"));
                row.setPrimaryKeyValue(org.get("id"));
                listSelectedRowCollection.add((Object)row);
            }
        }
        parameter.setListSelectedRowCollection(listSelectedRowCollection);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"SharingEditPlugin_3", (String)systemType, (Object[])new Object[0]));
            return;
        }
        List filters = parameter.getListFilterParameter().getQFilters();
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add(org.getLong("id"));
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)OrgUtils.getLocalDefaultViewId(), orgList, (boolean)true);
        subOrgIds = OrgUtils.mergeOrgIds((List)subOrgIds, (String)"3");
        filters.add(new QFilter("id", "in", (Object)subOrgIds.toArray()));
        filters.add(new QFilter("id", "in", TaxcMainDataServiceHelper.queryTaxcMainOrgIds().getData()));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectorg"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        Object shareMeType = this.getView().getFormShowParameter().getCustomParams().get("shareMeType");
        int newRow = evt.getRow();
        Integer startRowIndex = newRow;
        this.resetPlanName(startRowIndex);
        List<TccitRuleQueryEnum> code = TccitRuleQueryEnum.getByCode(shareMeType.toString());
        Tab tab = (Tab)this.getControl(TABAP);
        String startTab = code.get(0).getName() + TAB;
        tab.selectTab(startTab);
        tab.activeTab(startTab);
        this.updateAddLableName();
    }

    private void resetPlanName(Integer startRowIndex) {
        DynamicObject[] planentities;
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        if ((planentities = this.getModel().getEntryEntity(PLANENTITY, startRowIndex.intValue(), startRowIndex + 1)) != null && planentities.length > 0) {
            this.getModel().setValue("planname", (Object)planentities[0].getString("name"));
            this.getModel().setValue("autoshar", (Object)planentities[0].getBoolean("entryautoshar"));
        } else {
            this.getModel().setValue("planname", (Object)"");
            this.getModel().setValue("autoshar", (Object)Boolean.FALSE);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (e.getEntryProp().getName().equals(PLANENTITY)) {
            DynamicObjectCollection planen;
            CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (rowDataEntities != null && rowDataEntities.length > 0) {
                int rowIndex = rowDataEntities[0].getRowIndex();
                planentity.selectCard(Integer.valueOf(rowIndex));
                planentity.selectRowsChanged(Collections.singletonList(rowIndex), null);
            }
            if (CollectionUtils.isNotEmpty((Collection)(planen = this.getModel().getEntryEntity(PLANENTITY))) && planen.size() == 1) {
                this.getModel().setValue("shareType", this.getView().getFormShowParameter().getCustomParam("shareMeType"));
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        Object shareMeType = this.getView().getFormShowParameter().getCustomParams().get("shareMeType");
        if (e.getEntryProp().getName().equals(PLANENTITY)) {
            this.resetPlanName(e.getRowIndexs()[0] - 1);
            for (TccitRuleQueryEnum tccitRuleQueryEnum : TccitRuleQueryEnum.values()) {
                if (!shareMeType.equals(tccitRuleQueryEnum.getCode())) continue;
                this.refreshRuleList(tccitRuleQueryEnum.getName());
            }
            this.updateAddLableName();
        }
        this.setShareTypeVisible();
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
        int[] rows = planentity.getSelectRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        for (TccitRuleQueryEnum tccitRuleQueryEnum : TccitRuleQueryEnum.values()) {
            if (!tabKey.equals(tccitRuleQueryEnum.getName() + TAB)) continue;
            this.refreshRuleList(tccitRuleQueryEnum.getName());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        block8: {
            block7: {
                if (!"selectorg".equals(evt.getActionId())) break block7;
                ListSelectedRowCollection orgs = (ListSelectedRowCollection)evt.getReturnData();
                if (!CollectionUtils.isNotEmpty((Collection)orgs)) break block8;
                EntryGrid planentity = (EntryGrid)this.getControl(PLANENTITY);
                int[] selectRows = planentity.getSelectRows();
                int planIndex = selectRows[0];
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, planIndex);
                this.getModel().deleteEntryData(ORGENTITY);
                int[] rows = this.getModel().batchCreateNewEntryRow(ORGENTITY, orgs.size());
                for (int row = 0; row < rows.length; ++row) {
                    ListSelectedRow selectedRow = orgs.get(row);
                    this.getModel().setValue("orgid", selectedRow.getPrimaryKeyValue(), row, planIndex);
                }
                break block8;
            }
            if ("tccit_select_rule".equals(evt.getActionId())) {
                EntryGrid planentity;
                int[] rows;
                Map idmap = (Map)evt.getReturnData();
                Object shareMeType = this.getView().getFormShowParameter().getCustomParams().get("shareMeType");
                if (idmap != null && (rows = (planentity = (EntryGrid)this.getControl(PLANENTITY)).getSelectRows()) != null && rows.length > 0) {
                    int planindex = rows[0];
                    this.getModel().deleteEntryData(RULEENTITY);
                    int count = 0;
                    for (Map.Entry entry : idmap.entrySet()) {
                        Object[] objects = (Object[])entry.getValue();
                        count += objects.length;
                    }
                    this.getModel().batchCreateNewEntryRow(RULEENTITY, count);
                    int index = 0;
                    for (Map.Entry entry : idmap.entrySet()) {
                        String type = (String)entry.getKey();
                        Object[] value = (Object[])entry.getValue();
                        if (value.length <= 0) continue;
                        for (int i = 0; i < value.length; ++i) {
                            this.getModel().setValue("type", (Object)type, index, planindex);
                            this.getModel().setValue("ruleid", value[i], index, planindex);
                            ++index;
                        }
                    }
                    for (TccitRuleQueryEnum tccitRuleQueryEnum : TccitRuleQueryEnum.values()) {
                        if (!shareMeType.equals(tccitRuleQueryEnum.getCode())) continue;
                        this.refreshRuleList(tccitRuleQueryEnum.getName());
                    }
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DeleteEntry deleteEntry;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"SharingEditPlugin_4", (String)systemType, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int planCount = this.getModel().getEntryRowCount(PLANENTITY);
            if (planCount == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e3a\u7a7a\u3002", (String)"SharingEditPlugin_5", (String)systemType, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection planentity = this.getModel().getEntryEntity(PLANENTITY);
            HashSet<String> planMap = new HashSet<String>(planentity.size());
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(PLANENTITY);
            for (int row = 0; row < planentity.size(); ++row) {
                String errMsg;
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, row);
                int orgCount = this.getModel().getEntryRowCount(ORGENTITY);
                String planName = ((DynamicObject)planentity.get(row)).getString("name");
                if (planMap.contains(planName)) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\uff08%s\uff09\u91cd\u590d\uff0c\u8bf7\u8bbe\u7f6e\u4e0d\u540c\u7684\u65b9\u6848\u540d\u79f0\u3002", (String)"SharingEditPlugin_6", (String)systemType, (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    return;
                }
                planMap.add(planName);
                if (orgCount == 0) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u88ab\u5171\u4eab\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u88ab\u5171\u4eab\u7ec4\u7ec7\u3002", (String)"SharingEditPlugin_7", (String)systemType, (Object[])new Object[0]), planName);
                    this.getView().showErrorNotification(errMsg);
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection ruleentity = this.getModel().getEntryEntity(RULEENTITY);
                if (ruleentity.size() != 0) continue;
                String errMsg2 = String.format(ResManager.loadKDString((String)"\u65b9\u6848\uff08%s\uff09\u914d\u7f6e\u6709\u8bef\uff0c\u5171\u4eab\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u5171\u4eab\u89c4\u5219\u3002", (String)"SharingEditPlugin_8", (String)systemType, (Object[])new Object[0]), planName);
                this.getView().showErrorNotification(errMsg2);
                args.setCancel(true);
                return;
            }
            this.getModel().setEntryCurrentRowIndex(PLANENTITY, currentRowIndex);
        } else if (args.getSource() instanceof Refresh) {
            this.getPageCache().put("refresh", "true");
        } else if (args.getSource() instanceof DeleteEntry && "deleteorg".equals((deleteEntry = (DeleteEntry)args.getSource()).getOperateKey())) {
            args.setCancel(true);
            EntryGrid entrye = (EntryGrid)this.getControl(ORGENTITY);
            entrye.getSelectRows();
            String orgName = this.getModel().getEntryRowEntity(ORGENTITY, entrye.getSelectRows()[0]).getString("orgid.name");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgDeleteConform", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"SharingEditPlugin_9", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"SharingEditPlugin_10", (String)systemType, (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u662f\u5426\u5c06\u201c%1$s\u201d\u4ece\u201c%2$s\u201d\u89c4\u5219\u4e2d\u5254\u9664\uff1f", (String)"SharingEditPlugin_11", (String)systemType, (Object[])new Object[0]), orgName, this.getModel().getValue("planname"));
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DeleteEntry deleteEntry;
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("editrule")) {
            if (this.checkPlanNotSelected()) {
                return;
            }
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put(ORG, this.getModel().getValue(ORG));
            custom.put(RULEENTITY, this.getModel().getEntryEntity(RULEENTITY));
            Tab tabap = (Tab)this.getControl(TABAP);
            custom.put(CURRENT_TAB, tabap.getCurrentTab());
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tccit_select_rule", (IFormView)this.getView(), custom, (IFormPlugin)this);
        } else if (args.getOperateKey().equals("refresh")) {
            if ("true".equals(this.getPageCache().get("refresh"))) {
                this.getPageCache().put("refresh", "false");
            }
        } else if (args.getSource() instanceof DeleteEntry && "deleteplan".equals((deleteEntry = (DeleteEntry)args.getSource()).getOperateKey())) {
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        this.setVisible();
        this.setShareTypeVisible();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String resultMsg;
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)ITEM_CLOSE) && StringUtil.isNotBlank((CharSequence)(resultMsg = this.checkChangeData()))) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ITEM_CLOSE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingEditPlugin_12", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingEditPlugin_13", (String)systemType, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingEditPlugin_14", (String)systemType, (Object[])new Object[0]);
            this.getView().showConfirm(msg, resultMsg, options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    private String checkChangeData() {
        DynamicObjectCollection planCollection = this.getModel().getEntryEntity(PLANENTITY);
        if (planCollection.isEmpty()) {
            return "";
        }
        StringBuilder msg = new StringBuilder();
        for (DynamicObject newPlan : planCollection) {
            String name;
            StringBuilder words = new StringBuilder();
            String newName = newPlan.getString("name");
            DynamicObject oldPlan = BusinessDataServiceHelper.loadSingle((String)"tccit_sharing", (String)"id,name,autoshar,createtime,ruleentity,ruleentity.ruleid,ruleentity.id,orgentity,orgentity.orgid,orgentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)newPlan.getLong("id"))});
            if (ObjectUtils.isEmpty((Object)oldPlan)) {
                String name2 = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u4e3a\u65b0\u589e\u65b9\u6848\u8fd8\u672a\u4fdd\u5b58\uff01", (String)"SharingEditPlugin_15", (String)systemType, (Object[])new Object[0]), newName);
                if (StringUtil.isBlank((CharSequence)msg)) {
                    msg.append(name2);
                    continue;
                }
                msg.append(SEPARATOR).append(name2);
                continue;
            }
            List ruleEntityList = oldPlan.getDynamicObjectCollection(RULEENTITY).stream().map(o -> o.getString("ruleid")).collect(Collectors.toList());
            List orgEntityList = oldPlan.getDynamicObjectCollection(ORGENTITY).stream().map(o -> o.getString("orgid_id")).collect(Collectors.toList());
            String oldName = oldPlan.getString("name");
            String oldAutoshar = oldPlan.getString("autoshar");
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = newPlan.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().forEach(ruleRow -> ruleList.add(ruleRow.getString("ruleid")));
            DynamicObjectCollection orgCol = newPlan.getDynamicObjectCollection(ORGENTITY);
            orgCol.stream().forEach(orgRow -> orgList.add(orgRow.getDynamicObject("orgid").getString("id")));
            String newAutoshar = newPlan.getString("entryautoshar");
            if (!newName.equals(oldName)) {
                name = ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0", (String)"SharingEditPlugin_16", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!newAutoshar.equals(oldAutoshar)) {
                name = ResManager.loadKDString((String)"\u81ea\u52a8\u5171\u4eab", (String)"SharingEditPlugin_17", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!CollectionUtils.isEqualCollection(ruleList, ruleEntityList)) {
                name = ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u5361\u7247", (String)"SharingEditPlugin_18", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            if (!CollectionUtils.isEqualCollection(orgList, orgEntityList)) {
                name = ResManager.loadKDString((String)"\u88ab\u5171\u4eab\u8303\u56f4", (String)"SharingEditPlugin_19", (String)systemType, (Object[])new Object[0]);
                words.append(name).append(",");
            }
            name = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848\uff08%s\uff09\u53d8\u66f4\u5b57\u6bb5\uff1a", (String)"SharingEditPlugin_20", (String)systemType, (Object[])new Object[0]), newName);
            if (!StringUtil.isNotBlank((CharSequence)words)) continue;
            words.deleteCharAt(words.lastIndexOf(","));
            if (StringUtil.isBlank((CharSequence)msg)) {
                msg.append(name).append((CharSequence)words);
                continue;
            }
            msg.append(SEPARATOR).append(name).append((CharSequence)words);
        }
        return msg.toString();
    }

    private int getSelectRows() {
        int rowIndex = 0;
        EntryGrid planEntry = (EntryGrid)this.getControl(PLANENTITY);
        int[] ids = planEntry.getSelectRows();
        if (!ObjectUtils.isEmpty((Object)ids)) {
            rowIndex = ids[0];
        }
        return rowIndex;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"orgDeleteConform", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                EntryGrid entrye = (EntryGrid)this.getControl(ORGENTITY);
                this.getModel().deleteEntryRows(ORGENTITY, entrye.getSelectRows());
                this.updateAddLableName();
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                return;
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)callBackId, (CharSequence)ITEM_CLOSE) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().close();
        }
    }
}

