/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.rule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.tccit.common.enums.TccitRuleQueryEnum;

public class SharingRuleSelectPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String CURRENT_TAB = "current_tab";
    private static final String LISTSTR = "list";
    private static final String TAB = "tab";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    public void initialize() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        Object shareMeType = parentView.getFormShowParameter().getCustomParams().get("shareMeType");
        JSONObject org = (JSONObject)customParams.get("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"SharingRuleSelectPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        QFilter q1 = new QFilter("org", "=", (Object)org.getLong("id"));
        QFilter q2 = new QFilter("ruletype", "=", (Object)"public");
        QFilter q3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        for (TccitRuleQueryEnum tccitRuleQueryEnum : TccitRuleQueryEnum.values()) {
            if (!shareMeType.equals(tccitRuleQueryEnum.getCode())) continue;
            this.setFilter(tccitRuleQueryEnum.getName() + LISTSTR, q1, q2, q3);
            if (!"incomelist".equals(tccitRuleQueryEnum.getName() + LISTSTR)) continue;
            BillList list = (BillList)this.getControl("incomelist");
            list.addPackageDataListener(event -> this.visiblePackageData((PackageDataEvent)event));
        }
        this.setShareTypeVisible();
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        Object shareMeType = parentView.getFormShowParameter().getCustomParams().get("shareMeType");
        JSONArray ruleentity = (JSONArray)customParams.get("ruleentity");
        for (TccitRuleQueryEnum tccitRuleQueryEnum : TccitRuleQueryEnum.values()) {
            if (!shareMeType.equals(tccitRuleQueryEnum.getCode())) continue;
            this.selectRules(ruleentity, tccitRuleQueryEnum.getName() + LISTSTR, tccitRuleQueryEnum.getName());
        }
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.activeTab(customParams.get(CURRENT_TAB).toString());
        this.setShareTypeVisible();
    }

    public void visiblePackageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject d = e.getRowData();
        if ("5".equals(d.getString("itemchoicename.projtype")) || "7".equals(d.getString("itemchoicename.projtype")) || "8".equals(d.getString("itemchoicename.projtype"))) {
            if ("datefield".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)String.format(ResManager.loadKDString((String)"\u7b2c\u4e00\u7b14\u9879\u76ee\u6536\u5165\u5e74\u5ea6 : %s", (String)"SharingRuleSelectPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]), ((Object[])e.getFormatValue())[0]));
            }
        } else if ("datefield".equals(columnDesc.getKey())) {
            e.setFormatValue((Object)" ");
        }
    }

    private void selectRules(JSONArray ruleentity, String billList, String type) {
        BillList list = (BillList)this.getControl(billList);
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        for (int i = 0; i < ruleentity.size(); ++i) {
            JSONObject jsonObject = ruleentity.getJSONObject(i);
            String type1 = jsonObject.getString("type");
            if (!type1.equals(type)) continue;
            Long ruleid = jsonObject.getLong("ruleid");
            listSelectedRowCollection.add((Object)new ListSelectedRow((Object)ruleid));
        }
        if (list != null) {
            list.putSelectedRows(listSelectedRowCollection);
        }
    }

    private void setFilter(String billList, QFilter ... filters) {
        BillList list = (BillList)this.getControl(billList);
        ListFilterParameter filterParameter = new ListFilterParameter();
        for (QFilter filter : filters) {
            filterParameter.setFilter(filter);
        }
        if (list != null) {
            list.setFilterParameter((FilterParameter)filterParameter);
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        Object shareMeType = this.getView().getParentView().getFormShowParameter().getCustomParams().get("shareMeType");
        if (source instanceof Button && "btnok".equals(((Button)source).getKey())) {
            HashMap<String, Object[]> result = new HashMap<String, Object[]>();
            boolean lengthFlag = false;
            for (TccitRuleQueryEnum tccitRuleQueryEnum : TccitRuleQueryEnum.values()) {
                if (!shareMeType.equals(tccitRuleQueryEnum.getCode())) continue;
                BillList list = (BillList)this.getControl(tccitRuleQueryEnum.getName() + LISTSTR);
                ListSelectedRowCollection rows = list.getSelectedRows();
                Object[] ids = rows.getPrimaryKeyValues();
                result.put(tccitRuleQueryEnum.getName(), ids);
                if (ids.length <= 0) continue;
                lengthFlag = true;
            }
            if (!lengthFlag) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u89c4\u5219\u3002", (String)"SharingRuleSelectPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
        this.setShareTypeVisible();
    }

    private void setShareTypeVisible() {
        Object shareMeType = this.getView().getParentView().getFormShowParameter().getCustomParams().get("shareMeType");
        for (TccitRuleQueryEnum tccitRuleQueryEnum : TccitRuleQueryEnum.values()) {
            if (shareMeType.equals(tccitRuleQueryEnum.getCode())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{tccitRuleQueryEnum.getName() + TAB});
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{tccitRuleQueryEnum.getName() + TAB});
        }
    }
}

