/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.enums.DataType;

public class TccitOtherRulePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ITEM_NAME = "item";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ITEM_NAME});
        BasedataEdit item = (BasedataEdit)this.getControl(ITEM_NAME);
        item.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (ITEM_NAME.equals(evt.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"TccitOtherRulePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long orgid = org.getLong("id");
            FormShowParameter formShowParameter = evt.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            customParams.put("type", "nstz");
            customParams.put("caption", ResManager.loadKDString((String)"\u9879\u76ee\u9009\u62e9", (String)"TccitOtherRulePlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            formShowParameter.setCustomParam("orgid", (Object)orgid);
            formShowParameter.setCustomParam("template", (Object)"qysdsyj");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (ITEM_NAME.equals(e.getProperty().getName())) {
            this.buildComboItems();
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            if (oldValue != null && oldValue.getString("number").equals("30101")) {
                int rowCount = this.getModel().getEntryRowCount("entryentity");
                for (int i = 0; i < rowCount; ++i) {
                    this.getModel().setValue("datatype", (Object)DataType.ZJQS.getCode(), i);
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.buildComboItems();
    }

    private void buildComboItems() {
        DynamicObject item = (DynamicObject)this.getModel().getValue(ITEM_NAME);
        ComboEdit datatype = (ComboEdit)this.getControl("datatype");
        if (item != null && "30101".equals(item.getString("number"))) {
            datatype.setComboItems(DataType.buildDataType(Arrays.asList(DataType.ZJQS, DataType.JSFLQS, DataType.CYSLDSQS)));
        } else {
            datatype.setComboItems(DataType.buildDataType(Collections.singletonList(DataType.ZJQS)));
        }
    }
}

