/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.rule;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.rule.CustomDataSourceService;

public class TccitPreferentialItemPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ITEM_CHOICE_NAME = "itemchoicename";
    private static final String DATE_FIELD = "datefield";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ITEM_CHOICE_NAME});
        BasedataEdit item = (BasedataEdit)this.getControl(ITEM_CHOICE_NAME);
        item.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl("table");
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        if (orgid != null) {
            String levyType = OrgGroupService.getLevyType(Long.valueOf(orgid));
            this.getModel().setValue("levytype", (Object)levyType);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            DynamicObject dynamicObject;
            String number;
            Object date = this.getModel().getValue(DATE_FIELD);
            if (null == date) {
                this.getView().getModel().setValue(DATE_FIELD, (Object)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
            }
            if ((number = (dynamicObject = (DynamicObject)this.getModel().getValue(ITEM_CHOICE_NAME)).getString("number")) != null) {
                if (number.startsWith("MSSR")) {
                    this.getModel().setValue("type", (Object)"1");
                } else if (number.startsWith("JJSR")) {
                    this.getModel().setValue("type", (Object)"2");
                } else if (number.startsWith("SD") || number.startsWith("YJ-SDJM2021")) {
                    this.getModel().setValue("type", (Object)"3");
                } else if (number.startsWith("JJKC")) {
                    this.getModel().setValue("type", (Object)"5");
                } else {
                    this.getModel().setValue("type", (Object)Character.valueOf(number.charAt(0)));
                }
            }
            StringBuilder msg = new StringBuilder();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject object : entryEntity) {
                DynamicObject table = (DynamicObject)object.get("table");
                if (table == null) continue;
                String conditionjson = object.getString("conditionjson");
                if (!CustomDataSourceService.isRdesdGxqyyhmx(table.getLong("id")) && !CustomDataSourceService.isRdesdyhmx(table.getLong("id")) || !StringUtil.isBlank((CharSequence)conditionjson)) continue;
                String bizNameTips = ResManager.loadKDString((String)"\u4e1a\u52a1\u540d\u79f0\uff1a", (String)"TccitPreferentialItemPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
                String tableTips = ResManager.loadKDString((String)"\u6570\u636e\u6e90\uff1a", (String)"TccitPreferentialItemPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]);
                String needTips = ResManager.loadKDString((String)"\u9700\u8981\u6307\u5b9a\u8fc7\u6ee4\u6761\u4ef6", (String)"TccitPreferentialItemPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]);
                msg.append(bizNameTips).append("\u3010").append(object.getString("bizname")).append("\u3011").append(tableTips).append("\u3010").append(table.getString("bizname")).append("\u3011").append(needTips).append("\t\n");
            }
            if (StringUtil.isNotBlank((CharSequence)msg.toString())) {
                args.setCancel(true);
                this.getView().showTipNotification(msg.toString());
                return;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"TccitPreferentialItemPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (ITEM_CHOICE_NAME.equals(evt.getProperty().getName())) {
            long orgid = org.getLong("id");
            String levyType = OrgGroupService.getLevyType(orgid);
            if ("hdzs".equals(levyType)) {
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.setCustomParam("orgid", (Object)orgid);
                formShowParameter.setCustomParam("template", (Object)"hdsdsyj");
                QFilter qFilter = new QFilter("template", "=", (Object)"hdsdsyj");
                formShowParameter.getTreeFilterParameter().setQFilters(Collections.singletonList(qFilter));
                formShowParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.setCustomParam("orgid", (Object)orgid);
                formShowParameter.setCustomParam("template", (Object)"qysdsyj");
                QFilter jmseFilter = new QFilter("longnumber", "not like", (Object)"YJ-JMSE2021").and(new QFilter("longnumber", "not like", (Object)"YJ-JMSE2021.%"));
                QFilter qFilter = new QFilter("template", "=", (Object)"qysdsyj");
                formShowParameter.setTreeFilterParameter(new TreeFilterParameter(jmseFilter));
                formShowParameter.getListFilterParameter().setFilter(jmseFilter.and(qFilter));
            }
        } else if ("table".equals(evt.getProperty().getName())) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            String levyType = OrgGroupService.getLevyType(org.getLong("id"));
            if ("hdzs".equals(levyType)) {
                QFilter filter = new QFilter("entityname", "!=", (Object)"tccit_getreduce_acc");
                formShowParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }
}

