/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.rule;

import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.tccit.business.org.OrgGroupService;

public class TccitProfitsItemPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BasedataFuzzySearchListener {
    private static final String ITEM_NAME = "item";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ITEM_NAME});
        BasedataEdit item = (BasedataEdit)this.getControl(ITEM_NAME);
        item.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl(ITEM_NAME);
        edit.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        if (orgid != null) {
            String levyType = OrgGroupService.getLevyType(Long.valueOf(orgid));
            this.getModel().setValue("levytype", (Object)levyType);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (ITEM_NAME.equals(evt.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"TccitProfitsItemPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long orgid = org.getLong("id");
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            customParams.put("type", "profits");
            customParams.put("caption", ResManager.loadKDString((String)"\u9879\u76ee\u9009\u62e9", (String)"TccitProfitsItemPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            formShowParameter.setCustomParam("orgid", (Object)orgid);
            String levyType = OrgGroupService.getLevyType(orgid);
            if ("hdzs".equals(levyType)) {
                formShowParameter.setCustomParam("template", (Object)"hdsdsyj");
                QFilter qFilter = new QFilter("template", "=", (Object)"hdsdsyj");
                formShowParameter.getTreeFilterParameter().setQFilters(Collections.singletonList(qFilter));
                formShowParameter.getListFilterParameter().setFilter(qFilter);
                formShowParameter.getListFilterParameter().setFilter(new QFilter("isleaf", "=", (Object)"1"));
            } else {
                formShowParameter.setCustomParam("template", (Object)"qysdsyj");
                QFilter qFilter = new QFilter("template", "=", (Object)"qysdsyj");
                formShowParameter.getTreeFilterParameter().setQFilters(Collections.singletonList(qFilter));
                formShowParameter.getListFilterParameter().setFilter(qFilter);
                formShowParameter.getListFilterParameter().setFilter(new QFilter("isleaf", "=", (Object)"1"));
            }
        }
    }

    public void handleData(BasedataFuzzySearchEvent basedataFuzzySearchEvent) {
        basedataFuzzySearchEvent.getQueryData().clear();
    }
}

