/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.rule;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;
import kd.taxc.tccit.business.org.OrgGroupService;

public class TccitRuleConfigPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener {
    private static Log logger = LogFactory.getLog(TccitRuleConfigPlugin.class);
    private static String TREE_ORG = "treeviewap";
    private static final String ENTITY_PREFERENTIAL_ITEM = "tccit_preferential_item";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String CURRENT_TEMP_NODE = "CURRENT_TEMP_NODE";
    private static final String CURRENT_TAB = "CURRENT_TAB";
    private static final String RULE_TYPE_DEPRECIATE = "depreciate";
    private static final String INCOME_RULE_TAB = "preferential";
    private static final String DEPRECIATE_RULE_TAB = "depreciationtab";
    private static final String DEPRECIATE_ENTITY = "depreciateentity";
    private static final String PROFITS_TAB = "profitstab";
    private static final String PROFITS_ENTITY = "profitsentity";
    private static final String OTHER_TAB = "othertab";
    private static final String OTHER_ENTITY = "otherentity";
    private static Set<String> profigsKeys = Sets.newHashSet((Object[])new String[]{"cardflexpanelap12", "cardflexpanelap22", "cardentryflexpanelap42", "cardentryflexpanelap2", "cardflexpanelap4", "profits_image", "cardentryflexpanelap32", "cardflexpanelap32", "cardentryflexpanelap52", "profits_flex", "profitsup", "profitsdown", "profitsadd", "profitslabel"});
    private static Set<String> itemKeys = Sets.newHashSet((Object[])new String[]{"incomeadd", "incomeup", "incomedown", "incomelabel", "cardentryflexpanelap", "cardflexpanelap", "cardflexpanelap1", "cardflexpanelap2", "cardflexpanelap3", "cardflexpanelap5", "labelap_modifydate1", "labelap_discounttype", "labelap_paydate", "labelap61", "labelap6"});
    private static Set<String> depreciateKeys = Sets.newHashSet((Object[])new String[]{"rolloutadd", "rolloutup", "rolloutdown", "rolloutlabel", "cardentryflexpanelap1", "namelap", "cardflexpanelap11", "cardflexpanelap21", "cardflexpanelap31", "depreciate_modifydate", "depreciatemodifydate", "depreciate_type", "depreciatetype", "labelap611", "labelap62"});
    private static Set<String> otherKeys = Sets.newHashSet((Object[])new String[]{"cardflexpanelap121", "cardflexpanelap221", "cardentryflexpanelap421", "cardentryflexpanelap21", "cardflexpanelap41", "other_image", "cardentryflexpanelap321", "cardflexpanelap321", "cardentryflexpanelap521", "other_flex", "otherup", "otherdown", "otheradd", "otherlabel"});
    private static Map<String, String> addRulePageMap = new HashMap<String, String>(8);

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_ORG);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        Search sl = (Search)this.getControl("entitysearchap");
        sl.addEnterListener(this::orgSearchListener);
        this.addClickListeners(itemKeys.toArray(new String[0]));
        this.addClickListeners(depreciateKeys.toArray(new String[0]));
        this.addClickListeners(profigsKeys.toArray(new String[0]));
        this.addClickListeners(otherKeys.toArray(new String[0]));
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.refreshData();
            String tab = this.getPageCache().get(CURRENT_TAB);
            this.loadCurrentTab(null == tab ? PROFITS_TAB : tab);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put(CURRENT_TAB, tabKey);
        this.loadCurrentTab(tabKey);
    }

    private void loadPreferentialItemCard() {
        logger.info(SerializationUtils.toJsonString((Object)this.getModel().getDataEntity(true)));
        if (this.getModel().getDataEntityType().getProperty("incomeentity") != null) {
            this.getModel().deleteEntryData("incomeentity");
            long orgid = Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE));
            QFilter org = new QFilter("org", "=", (Object)orgid);
            QFilter ruleTypeFilter = new QFilter("ruletype", "=", this.getView().getFormShowParameter().getCustomParams().get("ruletype"));
            String levyType = OrgGroupService.getLevyType(orgid);
            QFilter levytypeFilter = new QFilter("levytype", "=", (Object)levyType);
            DynamicObjectCollection rules = QueryServiceHelper.query((String)ENTITY_PREFERENTIAL_ITEM, (String)"id,org.name as org,org.status as status,ruletype,type,enable,name,modifytime,itemchoicename.projtype,datefield", (QFilter[])new QFilter[]{org, ruleTypeFilter, levytypeFilter}, (String)"id");
            Map discounttypeMap = MetadataUtil.getComboItemsMap((String)"tpo_discount_tree", (String)"projtype");
            CardEntry incomeentity = (CardEntry)this.getControl("incomeentity");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow("incomeentity");
                this.getModel().setValue("incomeid", rule.get("id"), row);
                this.getModel().setValue("incomerulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("incomemodifydate", rule.get("modifytime"), row);
                String discountTypeNumber = (String)rule.get("itemchoicename.projtype");
                this.getModel().setValue("discounttype", discounttypeMap.get(discountTypeNumber), row);
                this.getModel().setValue("datefield", rule.get("datefield"), row);
                this.getModel().setValue("incomeenable", rule.get("enable"), row);
                this.getModel().setValue("incomeruletype", rule.get("ruletype"), row);
                if ("5".equals(discountTypeNumber) || "7".equals(discountTypeNumber) || "8".equals(discountTypeNumber)) {
                    incomeentity.setChildVisible(true, row, new String[]{"cardflexpanelap5"});
                } else {
                    incomeentity.setChildVisible(false, row, new String[]{"cardflexpanelap5"});
                }
                this.setBackgroundAndImage(row, "income", rule.getString("ruletype"));
            }
            this.getModel().endInit();
            this.getView().updateView("incomeentity");
        }
    }

    private void loadDepreciateCard() {
        logger.info(SerializationUtils.toJsonString((Object)this.getModel().getDataEntity(true)));
        if (this.getModel().getDataEntityType().getProperty(DEPRECIATE_ENTITY) != null) {
            this.getModel().deleteEntryData(DEPRECIATE_ENTITY);
            QFilter org = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE)));
            QFilter ruleTypeFilter = new QFilter("ruletype", "=", this.getView().getFormShowParameter().getCustomParams().get("ruletype"));
            DynamicObject[] rules = BusinessDataServiceHelper.load((String)addRulePageMap.get("customap_depreciate"), (String)"id,ruletype,depreciatetype,enable,name,modifytime", (QFilter[])new QFilter[]{org, ruleTypeFilter}, (String)"id");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow(DEPRECIATE_ENTITY);
                this.getModel().setValue("depreciateid", rule.get("id"), row);
                this.getModel().setValue("depreciaterulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("depreciatemodifydate", rule.get("modifytime"), row);
                this.getModel().setValue("depreciatetype", rule.getDynamicObject("depreciatetype").get("name"), row);
                this.getModel().setValue("depreciateenable", rule.get("enable"), row);
                this.getModel().setValue("depreciateruletype", rule.get("ruletype"), row);
                this.setBackgroundAndImage(row, RULE_TYPE_DEPRECIATE, rule.getString("ruletype"));
            }
            this.getModel().endInit();
            this.getView().updateView(DEPRECIATE_ENTITY);
        }
    }

    private void loadProfitsCard() {
        logger.info(SerializationUtils.toJsonString((Object)this.getModel().getDataEntity(true)));
        if (this.getModel().getDataEntityType().getProperty(PROFITS_ENTITY) != null) {
            this.getModel().deleteEntryData(PROFITS_ENTITY);
            long orgid = Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE));
            QFilter org = new QFilter("org", "=", (Object)orgid);
            QFilter ruleTypeFilter = new QFilter("ruletype", "=", this.getView().getFormShowParameter().getCustomParams().get("ruletype"));
            String levyType = OrgGroupService.getLevyType(orgid);
            QFilter levytypeFilter = new QFilter("levytype", "=", (Object)levyType);
            DynamicObject[] rules = BusinessDataServiceHelper.load((String)"tccit_profits_rule", (String)"id,ruletype,item,enable,name,modifytime", (QFilter[])new QFilter[]{org, ruleTypeFilter, levytypeFilter}, (String)"id");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow(PROFITS_ENTITY);
                this.getModel().setValue("profitsid", rule.get("id"), row);
                this.getModel().setValue("profitsrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("profitsmodifydate", rule.get("modifytime"), row);
                this.getModel().setValue("profitstype", rule.getDynamicObject("item").get("name"), row);
                this.getModel().setValue("profitsenable", rule.get("enable"), row);
                this.getModel().setValue("profitsruletype", rule.get("ruletype"), row);
                this.setBackgroundAndImage(row, "profits", rule.getString("ruletype"));
            }
            this.getModel().endInit();
            this.getView().updateView(PROFITS_ENTITY);
        }
    }

    private void loadOtherCard() {
        logger.info(SerializationUtils.toJsonString((Object)this.getModel().getDataEntity(true)));
        if (this.getModel().getDataEntityType().getProperty(OTHER_ENTITY) != null) {
            this.getModel().deleteEntryData(OTHER_ENTITY);
            QFilter org = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get(CURRENT_NODE) == null ? "0" : this.getPageCache().get(CURRENT_NODE)));
            QFilter ruleTypeFilter = new QFilter("ruletype", "=", this.getView().getFormShowParameter().getCustomParams().get("ruletype"));
            DynamicObject[] rules = BusinessDataServiceHelper.load((String)"tccit_other_rule", (String)"id,ruletype,item,enable,name,modifytime", (QFilter[])new QFilter[]{org, ruleTypeFilter}, (String)"id");
            this.getModel().beginInit();
            for (DynamicObject rule : rules) {
                int row = this.getModel().createNewEntryRow(OTHER_ENTITY);
                this.getModel().setValue("otherid", rule.get("id"), row);
                this.getModel().setValue("otherrulename", (Object)rule.getString("name"), row);
                this.getModel().setValue("othermodifydate", rule.get("modifytime"), row);
                this.getModel().setValue("othertype", rule.getDynamicObject("item").get("name"), row);
                this.getModel().setValue("otherenable", rule.get("enable"), row);
                this.getModel().setValue("otherruletype", rule.get("ruletype"), row);
                this.setBackgroundAndImage(row, "other", rule.getString("ruletype"));
            }
            this.getModel().endInit();
            this.getView().updateView(OTHER_ENTITY);
        }
    }

    private void setBackgroundAndImage(int row, String type, String ruletype) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        if ("private".equals(ruletype)) {
            propertiesMap.put("bc", "#FFF2E9");
            propertiesMap.put("src", "/icons/pc/label/swy_zy_61_61.png");
        } else {
            propertiesMap.put("bc", "#E7F0FF");
            propertiesMap.put("src", "/icons/pc/label/swy_fp_61_61.png");
        }
        pmap.put(type + "_flex", propertiesMap);
        pmap.put(type + "_image", propertiesMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod(type + "entity", "setCustomProperties", new Object[]{row, pmap});
    }

    public void click(EventObject evt) {
        Object pkid;
        int[] selectRows;
        EntryGrid itemsEntity;
        String key = ((Control)evt.getSource()).getKey();
        if (profigsKeys.contains(key)) {
            itemsEntity = (EntryGrid)this.getControl(PROFITS_ENTITY);
            selectRows = itemsEntity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("profitsid", selectRows[0]) : null;
            if (key.contains("profits") && !"profits_flex".equals(key)) {
                pkid = null;
            }
            this.openRuleForm("tccit_profits_rule", pkid);
        }
        if (itemKeys.contains(key)) {
            itemsEntity = (EntryGrid)this.getControl("incomeentity");
            selectRows = itemsEntity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("incomeid", selectRows[0]) : null;
            if (key.contains("income")) {
                pkid = null;
            }
            this.openRuleForm(ENTITY_PREFERENTIAL_ITEM, pkid);
        }
        if (depreciateKeys.contains(key)) {
            itemsEntity = (EntryGrid)this.getControl(DEPRECIATE_ENTITY);
            selectRows = itemsEntity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("depreciateid", selectRows[0]) : null;
            if (key.contains("rollout")) {
                pkid = null;
            }
            this.openRuleForm(addRulePageMap.get("customap_depreciate"), pkid);
        }
        if (otherKeys.contains(key)) {
            itemsEntity = (EntryGrid)this.getControl(OTHER_ENTITY);
            selectRows = itemsEntity.getSelectRows();
            Object object = pkid = selectRows.length > 0 ? this.getModel().getValue("otherid", selectRows[0]) : null;
            if (key.contains("other") && !"other_flex".equals(key)) {
                pkid = null;
            }
            this.openRuleForm("tccit_other_rule", pkid);
        }
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl(TREE_ORG)), (String[])btns, (String)TREE_ORG);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        String eventName = e.getEventName();
        if ("addNewRule".equals(eventName)) {
            if (OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)this.getPageCache().get(CURRENT_NODE), (String)"tccit", (String)"qysds")) {
                return;
            }
            this.openRuleForm(addRulePageMap.get(e.getKey()), null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        this.refreshData();
    }

    private void openRuleForm(String formId, Object pkid) {
        String orgId = this.getPageCache().get(CURRENT_NODE);
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(CURRENT_TEMP_NODE))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"TccitRuleConfigPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            String nodeId = this.getPageCache().get(CURRENT_TEMP_NODE);
            TreeView treeView = (TreeView)this.getControl(TREE_ORG);
            TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)nodeId);
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(nodeId))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TccitRuleConfigPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), treeNode.getText()));
                return;
            }
            if (OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)nodeId, (String)"tccit", (String)"qysds")) {
                return;
            }
            if (!treeNode.getType().equals("1")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u7ec4\u7ec7\u5217\u8868\u8fdb\u884c\u542f\u7528\u3002", (String)"TccitRuleConfigPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), treeNode.getText()));
                return;
            }
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(formId);
        if (pkid == null) {
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkid);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("pkid", pkid);
        customParams.put("orgid", orgId);
        customParams.put("ruletype", this.getView().getFormShowParameter().getCustomParams().get("ruletype"));
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        String current = this.getPageCache().get(CURRENT_NODE);
        if (nodeId.equals(current)) {
            current = null;
            this.getPageCache().put(CURRENT_NODE, "0");
        }
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(nodeId))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TccitRuleConfigPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), treeNode.getText()));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            return;
        }
        String status = OrgUtils.getOrgStatusById((String)nodeId);
        if (!"1".equals(status)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u7ec4\u7ec7\u5217\u8868\u8fdb\u884c\u542f\u7528\u3002", (String)"TccitRuleConfigPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), treeNode.getText()));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            return;
        }
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(nodeId)).getData()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TccitRuleConfigPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        if (OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)nodeId, (String)"tccit", (String)"qysds")) {
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            return;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQysdsByOrgIds(Collections.singletonList(Long.parseLong(nodeId)));
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getMessage());
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            return;
        }
        if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u201c%s\u201d\u5c1a\u672a\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u5148\u5230\u57fa\u7840\u6570\u636e-\u7a0e\u52a1\u4fe1\u606f\u754c\u9762\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f", (String)"TccitRuleConfigPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]), treeNode.getText()));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            return;
        }
        Boolean qysdsEnable = (Boolean)TaxcMainDataServiceHelper.isTaxcMainQysdsEnableByOrgId((Long)Long.parseLong(nodeId)).getData();
        if (!qysdsEnable.booleanValue()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u4f01\u4e1a\u6240\u5f97\u7a0e\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u8fdb\u884c\u542f\u7528\u3002", (String)"TccitRuleConfigPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]), treeNode.getText()));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            return;
        }
        DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
        Optional<String> first = taxMain.getDynamicObjectCollection("categoryentryentity").stream().map(d -> d.getString("taxpayertype")).findFirst();
        String taxpayertype = null;
        if (first.isPresent()) {
            taxpayertype = first.get();
        }
        pageCache.put("taxpayertype", taxpayertype);
        pageCache.remove(CURRENT_TEMP_NODE);
        pageCache.put(CURRENT_NODE, nodeId);
        String tab = this.getPageCache().get(CURRENT_TAB);
        String levyType = OrgGroupService.getLevyType(Long.valueOf(nodeId));
        this.setTabVisible(levyType);
        this.loadCurrentTab(null == tab ? PROFITS_TAB : tab);
    }

    private void setTabVisible(String type) {
        if ("hdzs".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DEPRECIATE_RULE_TAB, OTHER_TAB});
            this.getView().setVisible(Boolean.TRUE, new String[]{PROFITS_TAB, INCOME_RULE_TAB});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{PROFITS_TAB, INCOME_RULE_TAB, DEPRECIATE_RULE_TAB, OTHER_TAB});
        }
    }

    private void loadCurrentTab(String tabKey) {
        if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(CURRENT_NODE))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"TccitRuleConfigPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        if (INCOME_RULE_TAB.equals(tabKey)) {
            this.loadPreferentialItemCard();
        } else if (DEPRECIATE_RULE_TAB.equals(tabKey)) {
            this.loadDepreciateCard();
        } else if (PROFITS_TAB.equals(tabKey)) {
            this.loadProfitsCard();
        } else if (OTHER_TAB.equals(tabKey)) {
            this.loadOtherCard();
        }
    }

    public void afterCreateNewData(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    private void refreshData() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        treeView.deleteAllNodes();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    private void orgSearchListener(SearchEnterEvent event) {
        IPageCache pageCache = this.getPageCache();
        String treeCache = pageCache.get(TREE_ORG);
        if (treeCache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TccitRuleConfigPlugin_9", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
        List nodes = SearchUtil.getList((String)event.getText(), (TreeNode)root);
        if (!nodes.isEmpty()) {
            TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)((TreeNode)nodes.get(0)).getId());
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TccitRuleConfigPlugin_9", (String)"taxc-tccit", (Object[])new Object[0]));
    }

    private void checkNode(TreeView treeView, IPageCache cache) {
        String status;
        Object orgid = this.getView().getFormShowParameter().getCustomParam("orgid");
        if (orgid != null) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)String.valueOf(orgid));
            return;
        }
        if (cache.get(CURRENT_NODE) != null && "1".equals(status = OrgUtils.getOrgStatusById((String)cache.get(CURRENT_NODE))) && ((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(cache.get(CURRENT_NODE))).getData()).booleanValue()) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)cache.get(CURRENT_NODE));
            return;
        }
        DynamicObject org = null;
        try {
            org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        }
        catch (Exception ee) {
            org = null;
            logger.error("\u83b7\u53d6\u7ec4\u7ec7\u5f02\u5e38", (Throwable)ee);
        }
        if (org != null && "1".equals(org.getString("enable")) && ((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)org.getString("id"));
        } else {
            TreeUtils.checkFirstNode((IPageCache)cache, (TreeView)treeView);
        }
    }

    static {
        addRulePageMap.put("customap_income", ENTITY_PREFERENTIAL_ITEM);
        addRulePageMap.put("customap_depreciate", "tccit_depreciate_rule");
    }
}

