/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.seasonal;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.declare.DeclareShowService;
import kd.taxc.tccit.common.constant.DiscountTypeConstant;

public class DeclareShowPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String ORG = "org";
    private static final String PARA_ORG = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TABPAGEAP1 = "tabpageap1";
    private static final String TABPAGEAP2 = "tabpageap2";
    private static final String TABPAGEAP3 = "tabpageap3";
    private static final String TABPAGEAP4 = "tabpageap4";
    public static final String SHOW_NONTAX = "shownontax";
    public static final String SHOW_TREDUCED = "showtreduced";
    public static final String SHOW_INCRED = "showincred";
    public static final String SHOW_TECH_INCRED = "showtechincred";
    public static final String DECLARETYPE = "declaretype";
    private static final String[] tab_keys = new String[]{"tabpageap1", "tabpageap2", "tabpageap3", "tabpageap4"};

    public void registerListener(EventObject e) {
        this.addClickListeners(tab_keys);
    }

    private void setActiveTab(String tabKey) {
        HashMap<String, Object> stylemap = new HashMap<String, Object>(2);
        stylemap.put("bc", "#F3F6FF");
        String linestyle = "2px_solid_#5582F3";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", linestyle);
        style.put("b", border);
        stylemap.put("s", style);
        this.getView().updateControlMetadata(tabKey, stylemap);
        HashMap<String, Object> stylemap1 = new HashMap<String, Object>(2);
        stylemap1.put("bc", "#ffffff");
        String linestyle1 = "0px_solid_#ffffff";
        HashMap style1 = new HashMap();
        HashMap<String, String> border1 = new HashMap<String, String>();
        border1.put("b", linestyle1);
        style1.put("b", border1);
        stylemap1.put("s", style1);
        Arrays.asList(tab_keys).forEach(key -> {
            if (!key.equals(tabKey)) {
                this.getView().updateControlMetadata(key, stylemap1);
            }
        });
        this.showTab(tabKey);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (Arrays.asList(tab_keys).contains(key)) {
            this.setActiveTab(key);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue(ORG, (Object)this.getParam(PARA_ORG));
        this.getModel().setValue("startdate", (Object)DateUtils.stringToDate((String)this.getParam(SKSSQQ)));
        this.getModel().setValue("enddate", (Object)DateUtils.stringToDate((String)this.getParam(SKSSQZ)));
        this.getView().setEnable(Boolean.FALSE, new String[]{ORG});
        this.getView().setEnable(Boolean.FALSE, new String[]{"daterange"});
        this.getView().setVisible(Boolean.valueOf(!"3".equals(customParams.get("datatype"))), new String[]{TABPAGEAP2, TABPAGEAP3, TABPAGEAP4});
        this.setActiveTab(TABPAGEAP1);
    }

    public void tabSelected(TabSelectEvent event) {
        this.showTab(event.getTabKey());
    }

    private void showTab(String tableKey) {
        String formId = "";
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (TABPAGEAP1.equals(tableKey)) {
            DynamicObject object;
            formId = "bdtaxr_declare";
            customParams.put("from", "history");
            customParams.put("btn_visible", false);
            String templatetype = (String)customParams.get("templatetype");
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setId(Long.valueOf(Long.parseLong(customParams.getOrDefault("sbbid", "0"))));
            requestModel.setOrgId(Long.valueOf(Long.parseLong(customParams.getOrDefault(PARA_ORG, "0"))));
            requestModel.setTemplateType(templatetype);
            requestModel.setOperation("read");
            requestModel.setSkssqq((String)customParams.get(SKSSQQ));
            requestModel.setSkssqz((String)customParams.get(SKSSQZ));
            DynamicObject dynamicObject = object = "bdtaxr_taxbureau_sbb".equals(customParams.get("entityid")) ? DeclareShowService.queryHistoryNsrxx(templatetype, this.getParam(PARA_ORG), this.getParam(SKSSQQ), this.getParam(SKSSQZ)) : DeclareShowService.queryNsrxx(templatetype, this.getParam(PARA_ORG), this.getParam(SKSSQQ), this.getParam(SKSSQZ));
            if (object != null && StringUtils.isNotEmpty((CharSequence)object.getString("templateid"))) {
                customParams.put("templateid", object.getString("templateid"));
            }
            if ("bdtaxr_history_sbb".equals(customParams.get("entityid"))) {
                requestModel.setDataSource("history");
            }
            if ("bdtaxr_taxbureau_sbb".equals(customParams.get("entityid"))) {
                requestModel.setDataSource("taxBureau");
            }
            requestModel.setRefresh(Boolean.valueOf(false));
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        } else if (TABPAGEAP2.equals(tableKey)) {
            formId = "tccit_taxdata_tree";
            customParams = Maps.newHashMapWithExpectedSize((int)16);
            customParams.put(PARA_ORG, this.getParam(PARA_ORG));
            String skssqq = this.getParam(SKSSQQ);
            customParams.put(SKSSQQ, skssqq);
            String skssqz = this.getParam(SKSSQZ);
            customParams.put(SKSSQZ, skssqz);
            customParams.put("status", "3");
            customParams.put("from", "history");
            customParams.put("show_adddeduction", this.getParam("show_adddeduction"));
            customParams.put("show_diffdeduction", this.getParam("show_diffdeduction"));
            Map<String, String> itemchoiceCard = this.getItemchoiceCard(customParams);
            for (Map.Entry<String, String> entry : itemchoiceCard.entrySet()) {
                customParams.put(entry.getKey(), entry.getValue());
            }
            customParams.put("readonly", Boolean.TRUE);
        } else if (TABPAGEAP3.equals(tableKey)) {
            customParams.put(PARA_ORG, this.getParam(PARA_ORG));
            String skssqq = this.getParam(SKSSQQ);
            customParams.put(SKSSQQ, skssqq);
            String skssqz = this.getParam(SKSSQZ);
            customParams.put(SKSSQZ, skssqz);
            BillShowParameter parameter = new BillShowParameter();
            parameter.setCustomParams(customParams);
            parameter.setFormId("tccit_seasonal_policy");
            parameter.setBillStatus(BillOperationStatus.VIEW);
            QFilter q1 = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)this.getParam(SKSSQQ)));
            QFilter q2 = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)this.getParam(SKSSQZ)));
            QFilter q3 = new QFilter(PARA_ORG, "=", (Object)Long.parseLong(this.getParam(PARA_ORG)));
            QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)customParams.getOrDefault("draftpurpose", "nssb"));
            DynamicObject policy = QueryServiceHelper.queryOne((String)"tccit_seasonal_policy", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, draftpurposeFilter});
            if (policy != null) {
                parameter.setPkId(policy.get("id"));
                parameter.getOpenStyle().setShowType(ShowType.InContainer);
                parameter.getOpenStyle().setTargetKey("flexcontent");
                this.getView().showForm((FormShowParameter)parameter);
            }
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)formId)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(formId);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("flexcontent");
            parameter.setCustomParams(customParams);
            parameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(parameter);
        }
    }

    private Map<String, String> getItemchoiceCard(Map<String, Object> customParams) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        String orgid = String.valueOf(customParams.get(PARA_ORG));
        String skssqq = String.valueOf(customParams.get(SKSSQQ));
        String skssqz = String.valueOf(customParams.get(SKSSQZ));
        QFilter q1 = new QFilter(PARA_ORG, "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)skssqq));
        QFilter q3 = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)skssqz));
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", customParams.getOrDefault("draftpurpose", "nssb"));
        DynamicObjectCollection itemchoics = QueryServiceHelper.query((String)"tccit_seasonal_policy", (String)"levytype,itemchoiceentity.itemchoiceid as id,itemchoiceentity.type as type", (QFilter[])new QFilter[]{q1, q2, q3, draftpurposeFilter});
        if (CollectionUtils.isEmpty((Collection)itemchoics)) {
            return result;
        }
        result.put("levytype", ((DynamicObject)itemchoics.get(0)).getString("levytype"));
        result.put(SHOW_NONTAX, Boolean.toString(itemchoics.stream().anyMatch(s -> "1".equals(s.getString("type")))));
        result.put(SHOW_TREDUCED, Boolean.toString(itemchoics.stream().anyMatch(s -> "2".equals(s.getString("type")))));
        result.put(SHOW_INCRED, Boolean.toString(itemchoics.stream().anyMatch(s -> "3".equals(s.getString("type")) && !DiscountTypeConstant.techIds.contains(s.getLong("id")))));
        result.put(SHOW_TECH_INCRED, Boolean.toString(itemchoics.stream().anyMatch(s -> DiscountTypeConstant.techIds.contains(Objects.nonNull(s.get("id")) ? s.getLong("id") : 0L))));
        return result;
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String paramtype = (String)customParams.get(param);
        return paramtype;
    }
}

