/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.seasonal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.tccit.common.constant.DiscountTypeConstant;

public class DiscountItemPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        JSONArray items = (JSONArray)params.get("items");
        HashSet<Long> list1 = new HashSet<Long>();
        HashSet<Long> list2 = new HashSet<Long>();
        HashSet<Long> list3 = new HashSet<Long>();
        HashSet<Long> list4 = new HashSet<Long>();
        HashSet<Long> list3and4 = new HashSet<Long>();
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                JSONObject item = items.getJSONObject(i);
                String type = item.getString("type");
                Long discountitemId = item.getLong("itemchoiceid");
                if ("1".equals(type)) {
                    list1.add(discountitemId);
                    continue;
                }
                if ("2".equals(type)) {
                    list2.add(discountitemId);
                    continue;
                }
                list3and4.add(discountitemId);
                if (DiscountTypeConstant.techIds.contains(discountitemId)) {
                    list4.add(discountitemId);
                    continue;
                }
                list3.add(discountitemId);
            }
        }
        this.initEntryEntity(list1, "flexpanelap1", "entryentity1", "discountitem1");
        this.initEntryEntity(list2, "flexpanelap2", "entryentity2", "discountitem2");
        this.initEntryEntity(list3and4, "flexpanelap3", "entryentity3", "discountitem3");
        this.writeToParentCache(params, list1, list2, list3, list4);
    }

    private void initEntryEntity(Set<Long> list1, String flexkey, String entryentity, String key) {
        if (list1.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{flexkey});
        } else {
            for (Long id : list1) {
                int row = this.getModel().createNewEntryRow(entryentity);
                this.getModel().setValue(key, (Object)id, row);
            }
        }
    }

    private void writeToParentCache(Map<String, Object> params, Set<Long> list1, Set<Long> list2, Set<Long> list3, Set<Long> list4) {
        IPageCache parentPageCache = this.getParentPageCache(params);
        parentPageCache.put("shownontax", String.valueOf(list1.size() > 0));
        parentPageCache.put("showtreduced", String.valueOf(list2.size() > 0));
        parentPageCache.put("showincred", String.valueOf(list3.size() > 0));
        parentPageCache.put("showtechincred", String.valueOf(list4.size() > 0));
    }

    private IPageCache getParentPageCache(Map<String, Object> params) {
        String pageId = (String)params.get("parentpageid");
        return (IPageCache)this.getView().getView(pageId).getService(IPageCache.class);
    }
}

