/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.seasonal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.DraftExportConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.SeasonCalcObserver;
import kd.taxc.tccit.business.draft.ApportionService;
import kd.taxc.tccit.business.draft.BranchCalcPageService;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.draft.SeasonalCalcSummaryPageService;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.business.policy.SeasonalPolicyService;
import kd.taxc.tccit.common.utils.SeasonalNameTypeUtils;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class SeasonalCalcPagePlugin
extends AbstractEngine
implements SeasonCalcObserver,
IDraftTypeObserver {
    private static final String PEOPLE_AVG = "peopleavg";
    private static final String ASSETS_AVG = "assetsavg";
    private static final String BUSINESS_TYPE = "businesstype";
    private static final String IS_SMALL_TYPE = "matchsmall";
    private static final String MYPARENTID = "myparentid";
    private static final String MYPKID = "mypkid";
    private static final String ITEM_NO = "itemno";
    private static final String ITEM_TYPE = "itemtype";
    private static final String NAME = "name";
    private static final String SUM_AMOUNT = "sumamount";
    private static final String ORGID = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TYPE = "type";
    private static final String IS_SMALL = "issmall";
    private static final String ENTITY_NAME = "treeentryentity";
    private static final ArrayList<String> SPECIAL_EXTENDS = Lists.newArrayList((Object[])new String[]{"12(1)", "12(2)", "12(3)", "12(4)", "12(5)"});
    private Map<String, Long> keyIds = new HashMap<String, Long>();
    private static final List<String> headItemTypes = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "6a", "6a(X)", "6b", "6b(X)", "6c", "6c(X)", "6d", "6d(X)", "6e", "6e(X)", "7", "7(X)", "8", "9", "10", "11", "12", "12(X)", "13", "14", "15", "16", "17", "17(1)", "18", "18(1)", "19", "19(1)", "19(2)", "20", "21", "22"});
    private static List<String> calcList = Lists.newArrayList((Object[])new String[]{"6a(X)", "6b(X)", "6c(X)", "6d(X)", "6e(X)", "6a", "6b", "6c", "6d", "6e", "7(X)", "17(1)", "18(1)", "19(1)", "19(2)", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12(X)", "12(1)", "12(2)", "12(3)", "12(4)", "12(5)", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"});
    private List<String> showHeadItemTypes = new ArrayList<String>();
    private final Set<String> dynamicRows = Sets.newHashSet((Object[])new String[]{"6a(X)", "6b(X)", "6c(X)", "6d(X)", "6e(X)", "7(X)", "3.X"});
    private Set<String> HEAD_LEVEL1 = Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22"});
    private Set<String> HEAD_LEVEL2 = Sets.newHashSet((Object[])new String[]{"6a", "6b", "6c", "6d", "6e", "7(X)", "12(1)", "12(X)", "17(1)", "18(1)", "19(1)", "19(2)", "12(2)", "12(3)", "12(4)", "12(5)", "3.X"});
    private Set<String> HEAD_LEVEL3 = Sets.newHashSet((Object[])new String[]{"6a(X)", "6b(X)", "6c(X)", "6d(X)", "6e(1)", "6e(2)", "6e(3)"});
    public final List<String> branchItemTypes = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"});
    public final List<String> hdzsItemTypes = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "3.X", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"});
    private static List<String> hdzsCalcList = Lists.newArrayList((Object[])new String[]{"1", "2", "3.X", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"});
    private static Pattern pattern = Pattern.compile("[^0-9]");
    private Map<String, DynamicObjectCollection> dynamicData;
    private Boolean isContinue = Boolean.TRUE;
    private SeasonalCalcSummaryPageService seasonalCalcSummaryPageService = new SeasonalCalcSummaryPageService();
    private ApportionService apportionService = new ApportionService();
    private BranchCalcPageService branchCalcPageService = new BranchCalcPageService();

    public void initialize() {
    }

    public void afterCreateNewData(EventObject e) {
        String entityId = this.getView().getEntityId();
        String pluginName = DraftExportConstant.getClassName((String)entityId);
        IPageCache parentPageCache = null;
        if (this.getView().getParentView() != null) {
            parentPageCache = this.getView().getParentView().getParentView().getPageCache();
        }
        if (parentPageCache != null) {
            parentPageCache.put("draftPageId", this.getView().getPageId());
            parentPageCache.put("entryEntityName", ENTITY_NAME);
            parentPageCache.put("draftDataDtoPluginName", pluginName);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        String skssqq = (String)customParams.get(SKSSQQ);
        String skssqz = (String)customParams.get(SKSSQZ);
        String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
        String billstatus = customParams.getOrDefault("billstatus", "A");
        String businesstype = this.seasonalCalcSummaryPageService.getBusinesstype(orgid, skssqq, skssqz, draftpurpose);
        BigDecimal peopleavg = this.seasonalCalcSummaryPageService.initAvg(orgid, skssqq, skssqz, "people", customParams).setScale(0, 4);
        this.getModel().setValue(PEOPLE_AVG, (Object)peopleavg);
        BigDecimal zcze = this.seasonalCalcSummaryPageService.initAvg(orgid, skssqq, skssqz, "assets", customParams);
        this.getModel().setValue(ASSETS_AVG, (Object)zcze);
        this.getModel().setValue(BUSINESS_TYPE, (Object)businesstype);
        customParams.put(PEOPLE_AVG, String.valueOf(peopleavg));
        customParams.put(ASSETS_AVG, String.valueOf(zcze));
        customParams.put(BUSINESS_TYPE, businesstype);
        this.calc(businesstype, customParams, billstatus.equals("A"));
        if (billstatus.equals("A")) {
            this.seasonalCalcSummaryPageService.updateSeasonalDraftData(Long.valueOf(orgid), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), customParams);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        DynamicObject dataEntity = changeSet[0].getDataEntity();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        String levytype = customParams.getOrDefault("levytype", "czzs");
        String businesstype = (String)this.getModel().getValue(BUSINESS_TYPE);
        DynamicObject object = StatusUtils.queryOne((String)"draft_qysdsjb", (String)((String)customParams.get("orgid")), (String)((String)customParams.get(SKSSQQ)), (String)((String)customParams.get(SKSSQZ)), (String)((String)customParams.get("draftpurpose")));
        if (this.isContinue.booleanValue() && object != null && !"A".equals(object.getString("billstatus"))) {
            String orgName = Optional.ofNullable(this.getView().getParentView()).map(s -> s.getParentView()).map(s -> (DynamicObject)s.getModel().getValue(ORGID)).map(s -> s.getString(NAME)).orElseGet(() -> "");
            String taxlimitStr = DateUtils.getTaxLimitTips((Date)skssqq, (Date)skssqz);
            String statusName = "B".equals(object.getString("billstatus")) ? ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"SeasonalCalcPagePlugin_3", (String)"taxc-tccit", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba1\u6838", (String)"SeasonalCalcPagePlugin_4", (String)"taxc-tccit", (Object[])new Object[0]);
            String tips = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u5e95\u7a3f\u5df2%3$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"SeasonalCalcPagePlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), orgName, taxlimitStr, statusName);
            this.getView().showTipNotification(tips);
            this.isContinue = Boolean.FALSE;
            this.rollbackPropertyChange(e);
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTITY_NAME});
            return;
        }
        if (SUM_AMOUNT.equals(name)) {
            String itemNo = dataEntity.getString(ITEM_NO);
            if (Lists.newArrayList((Object[])new String[]{"4", "5", "8", "13", "14", "20", "3", "10", "12"}).contains(itemNo)) {
                if (Lists.newArrayList((Object[])new String[]{"3", "12", "20"}).contains(itemNo) && (((BigDecimal)newValue).compareTo(BigDecimal.ZERO) < 0 || ((BigDecimal)newValue).compareTo(BigDecimal.ONE) > 0)) {
                    this.rollbackPropertyChange(e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u51650~1\u4ee5\u5185\u7684\u6570\u503c", (String)"SeasonalCalcPagePlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                    return;
                }
                QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
                QFilter skssqqFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
                QFilter skssqzFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
                DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
                this.seasonalCalcSummaryPageService.putDataMap(itemNo, SUM_AMOUNT, (BigDecimal)newValue);
                String type = itemNo.equals("3") ? "2" : "1";
                this.seasonalCalcSummaryPageService.updateData(orgFilter, skssqqFilter, skssqzFilter, itemNo, (BigDecimal)newValue, type, draftTypeObjectVo);
                this.calc(businesstype, customParams, true);
                this.seasonalCalcSummaryPageService.updateSeasonalDraftData(orgid, skssqq, skssqz, customParams);
                this.getView().updateView(ENTITY_NAME);
                this.getView().sendFormAction(this.getView());
                if ("czzs".equals(levytype)) {
                    this.setLockRows(businesstype);
                } else {
                    this.setLockRows();
                }
                LocaleString msg = new LocaleString(ResManager.loadKDString((String)"\u8bf7\u7a0d\u7b49", (String)"SeasonalCalcPagePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
                this.getView().showLoading(msg, 2000);
            }
        }
    }

    private void calc(String businesstype, Map<String, Object> customParams, boolean calc) {
        String levytype = (String)customParams.getOrDefault("levytype", "czzs");
        if ("czzs".equals(levytype)) {
            DynamicObject[] dynamicObjects;
            if ("1".equals(businesstype) || "2".equals(businesstype)) {
                this.dynamicData = this.initDynamicRows(this.dynamicRows, customParams);
                dynamicObjects = calc ? this.buildHeadOfficeSummary(this.dynamicData, businesstype, customParams) : this.seasonalCalcSummaryPageService.queryCurrentPeriod(customParams, "1");
                List<String> showItemTypes = calc ? this.showHeadItemTypes : Arrays.stream(dynamicObjects).map(s -> s.getString(ITEM_TYPE)).collect(Collectors.toList());
                this.queryHeadData(dynamicObjects, showItemTypes);
                TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ENTITY_NAME);
                treeEntryGrid.setCollapse(false);
                if ("workflowview".equals(this.getView().getFormShowParameter().getCustomParam("scene"))) {
                    treeEntryGrid.setCollapse(true);
                }
            } else if ("3".equals(businesstype)) {
                dynamicObjects = calc ? this.buildBranchOfficeSummary(customParams) : this.seasonalCalcSummaryPageService.queryCurrentPeriod(customParams, "2");
                List<String> showItemTypes = calc ? this.branchItemTypes : Arrays.stream(dynamicObjects).map(s -> s.getString(ITEM_TYPE)).collect(Collectors.toList());
                this.queryBranchData(dynamicObjects, showItemTypes);
            }
            this.setLockRows(businesstype);
            boolean calcResult = this.calcTaxAmountSplitPage(customParams, calc);
            if (calcResult) {
                this.getView().getParentView().getPageCache().put("zlbChanged", Boolean.TRUE.toString());
            }
        } else {
            this.dynamicData = this.initDynamicRows(this.dynamicRows, customParams);
            DynamicObject[] dynamicObjects = this.buildHdzsOfficeSummary(this.dynamicData, businesstype, customParams);
            this.queryHdzsData(dynamicObjects);
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ENTITY_NAME);
            treeEntryGrid.setCollapse(false);
            if ("workflowview".equals(this.getView().getFormShowParameter().getCustomParam("scene"))) {
                treeEntryGrid.setCollapse(true);
            }
            this.setLockRows();
        }
    }

    public boolean calcTaxAmountSplitPage(Map<String, Object> customParams, boolean calc) {
        if (!calc || !this.branchCalcPageService.checkBeforeCalcSplit(customParams)) {
            return false;
        }
        DynamicObjectCollection taxAmountCalcObj = this.seasonalCalcSummaryPageService.queryCurrentPeriodByItemNo(customParams, "1", "15");
        BigDecimal itemNo_15_Sum = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)taxAmountCalcObj)) {
            itemNo_15_Sum = ((DynamicObject)taxAmountCalcObj.get(0)).getBigDecimal(SUM_AMOUNT);
        }
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        DynamicObject policy = SeasonalPolicyService.getPolicy(orgid, skssqq, skssqz, draftpurpose);
        BigDecimal qbfzjgftbl = policy.getBigDecimal("qbfzjgftbl");
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        DynamicObjectCollection seasonalSplitSjjtCollection = this.branchCalcPageService.querySeasonalSplitSjjtCollection(customParams);
        if (seasonalSplitSjjtCollection.size() > 0 && ((DynamicObject)seasonalSplitSjjtCollection.get(0)).getBigDecimal("itemno15sum").compareTo(itemNo_15_Sum) == 0 && ((DynamicObject)seasonalSplitSjjtCollection.get(0)).getBigDecimal("qbfzjgftbl").compareTo(qbfzjgftbl) == 0) {
            return false;
        }
        DynamicObject[] taxAmountSpiltDraftArray = this.apportionService.querySecondStepTaxSplitDraft(customParams, draftTypeObjectVo);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        for (DynamicObject taxAmountSpiltDraft : taxAmountSpiltDraftArray) {
            if (null == taxAmountSpiltDraft.getDynamicObject("taxorg")) continue;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)draftTypeObjectVo.getSeasonalCalcSplit().getNumber());
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            dynamicObject.set("unifiedsocialcode", (Object)taxAmountSpiltDraft.getString("unifiedsocialcode"));
            dynamicObject.set("branchorgid", (Object)taxAmountSpiltDraft.getDynamicObject("taxorg").getLong("id"));
            dynamicObject.set("branchspiltratio", (Object)taxAmountSpiltDraft.getBigDecimal("rate"));
            dynamicObject.set("branchybtse", (Object)taxAmountSpiltDraft.getBigDecimal("rate").multiply(itemNo_15_Sum).multiply(qbfzjgftbl).setScale(2, RoundingMode.HALF_UP));
            dynamicObject.set("branchreductionratio", (Object)BigDecimal.ZERO);
            dynamicObject.set("branchreductiontax", (Object)dynamicObject.getBigDecimal("branchybtse").multiply(new BigDecimal("0.4")).multiply(dynamicObject.getBigDecimal("branchreductionratio")).setScale(2, RoundingMode.HALF_UP));
            dynamicObject.set("sjybtsdse", (Object)dynamicObject.getBigDecimal("branchybtse").subtract(dynamicObject.getBigDecimal("branchreductiontax")));
            dynamicObject.set("draftnumber", customParams.get("draftnumber"));
            dynamicObject.set(TYPE, (Object)"1");
            dynamicObject.set("itemno15sum", (Object)itemNo_15_Sum);
            dynamicObject.set("qbfzjgftbl", (Object)qbfzjgftbl);
            sum.add((Object)dynamicObject);
        }
        this.seasonalCalcSummaryPageService.clearCurrentPeriod(orgid, skssqq, skssqz, draftTypeObjectVo.getSeasonalCalcSplit().getNumber(), "1");
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        return true;
    }

    private void setLockRows() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY_NAME);
        int index = 0;
        HashSet headUnLockRows = Sets.newHashSet((Object[])new String[]{"10", "12"});
        for (DynamicObject dynamicObject : entryEntity) {
            this.getView().setEnable(Boolean.valueOf(headUnLockRows.contains(dynamicObject.getString(ITEM_NO))), index, new String[]{SUM_AMOUNT});
            ++index;
        }
    }

    private void setLockRows(String businesstype) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY_NAME);
        int index = 0;
        HashSet headUnLockRows = Sets.newHashSet((Object[])new String[]{"13", "14", "20"});
        String branchUnlockRow = "3";
        for (DynamicObject dynamicObject : entryEntity) {
            if ("3".equals(businesstype)) {
                this.getView().setEnable(Boolean.valueOf(branchUnlockRow.equals(dynamicObject.getString(ITEM_NO))), index, new String[]{SUM_AMOUNT});
            } else {
                this.getView().setEnable(Boolean.valueOf(headUnLockRows.contains(dynamicObject.getString(ITEM_NO))), index, new String[]{SUM_AMOUNT});
            }
            ++index;
        }
    }

    private List<String> rebuildHeadItemType(List<String> headItemTypes) {
        for (String headItemType : headItemTypes) {
            List<String> list = null;
            if (this.dynamicRows.contains(headItemType) && !CollectionUtils.isEmpty(list = this.seasonalCalcSummaryPageService.getDynamicItemTypeMap().get(headItemType))) {
                for (String s2 : list) {
                    this.showHeadItemTypes.add(s2);
                }
                continue;
            }
            if ("12(X)".equals(headItemType)) {
                this.showHeadItemTypes.removeIf(s -> s.equals(headItemType));
                this.showHeadItemTypes.addAll(SPECIAL_EXTENDS);
                continue;
            }
            this.showHeadItemTypes.add(headItemType);
        }
        return this.showHeadItemTypes;
    }

    private Map<String, DynamicObjectCollection> initDynamicRows(Set<String> dynamicRows, Map<String, Object> customParams) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)dynamicRows.size());
        for (String dynamicRow : dynamicRows) {
            DynamicObjectCollection rows = this.seasonalCalcSummaryPageService.getDynamicRows(dynamicRow, customParams);
            map.put(dynamicRow, rows);
        }
        return map;
    }

    private DynamicObject[] buildHdzsOfficeSummary(Map<String, DynamicObjectCollection> dynamicData, String businesstype, Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        Map<String, String> headNameMap = SeasonalNameTypeUtils.getInstance().getHdzsNameMap();
        for (String itemType : hdzsCalcList) {
            DynamicObject dynamicObject;
            if (this.dynamicRows.contains(itemType)) {
                DynamicObjectCollection dynamicObjects = dynamicData.get(itemType);
                int index = 1;
                for (DynamicObject object : dynamicObjects) {
                    dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber());
                    String dynamicitemtype = itemType.replace("X", String.valueOf(index++));
                    dynamicObject.set(ITEM_NO, (Object)dynamicitemtype);
                    dynamicObject.set(ITEM_TYPE, (Object)dynamicitemtype);
                    this.seasonalCalcSummaryPageService.recordDynamicRows(itemType, dynamicitemtype);
                    dynamicObject.set(NAME, (Object)object.getDynamicObject("rule").getString(NAME));
                    dynamicObject.set(SUM_AMOUNT, (Object)this.seasonalCalcSummaryPageService.putDataMap(dynamicitemtype, SUM_AMOUNT, object.getBigDecimal("nontaxtotal")));
                    dynamicObject.set(TYPE, (Object)"1");
                    dynamicObject.set(ORGID, (Object)orgid);
                    dynamicObject.set(SKSSQQ, (Object)skssqq);
                    dynamicObject.set(SKSSQZ, (Object)skssqz);
                    dynamicObject.set(IS_SMALL, this.getModel() == null ? Boolean.FALSE : this.getModel().getValue(IS_SMALL_TYPE));
                    sum.add((Object)dynamicObject);
                }
                continue;
            }
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber());
            dynamicObject.set(ITEM_NO, (Object)itemType);
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            dynamicObject.set(NAME, (Object)this.getName(headNameMap, itemType, orgid, skssqq, skssqz, draftTypeObjectVo));
            dynamicObject.set(SUM_AMOUNT, (Object)this.seasonalCalcSummaryPageService.hdzsCalc(itemType, orgid, skssqq, skssqz, draftTypeObjectVo, businesstype, customParams));
            dynamicObject.set(TYPE, (Object)"1");
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            dynamicObject.set(IS_SMALL, this.getModel() == null ? Boolean.FALSE : this.getModel().getValue(IS_SMALL_TYPE));
            sum.add((Object)dynamicObject);
        }
        Boolean smallMatch = Objects.nonNull(customParams.get(IS_SMALL_TYPE)) ? Boolean.valueOf((String)customParams.get(IS_SMALL_TYPE)) : Boolean.FALSE;
        sum.forEach(s -> s.set(IS_SMALL, (Object)smallMatch));
        this.rebuildHeadItemType(this.hdzsItemTypes);
        this.refreshHeadLevel();
        this.buildTree("1", this.showHeadItemTypes, sum);
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        QFilter typeFilter = new QFilter(TYPE, "=", (Object)"1");
        DeleteServiceHelper.delete((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber(), (QFilter[])new QFilter[]{orgFilter, dateFilter, typeFilter});
        String itemno = this.checkAmountValue(sum);
        if (StringUtil.isNotBlank((CharSequence)itemno)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c%s\u884c \u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d\uff01", (String)"SeasonalCalcPagePlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), itemno));
            return (DynamicObject[])sum.toArray((Object[])new DynamicObject[0]);
        }
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private DynamicObject[] buildHeadOfficeSummary(Map<String, DynamicObjectCollection> dynamicData, String businesstype, Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        DynamicObjectCollection sum = new DynamicObjectCollection();
        Map<String, String> headNameMap = "nssb".equals(draftpurpose) ? SeasonalNameTypeUtils.getInstance().getHeadNameMap() : SeasonalNameTypeUtils.getInstance().getJtHeadNameMap();
        for (String itemType : calcList) {
            DynamicObject dynamicObject;
            if (this.dynamicRows.contains(itemType)) {
                DynamicObjectCollection dynamicObjects = dynamicData.get(itemType);
                int index = 1;
                for (DynamicObject object : dynamicObjects) {
                    dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber());
                    dynamicObject.set(TYPE, (Object)"1");
                    dynamicObject.set(ORGID, (Object)orgid);
                    dynamicObject.set(SKSSQQ, (Object)skssqq);
                    dynamicObject.set(SKSSQZ, (Object)skssqz);
                    String dynamicitemtype = itemType.replace("X", String.valueOf(index++));
                    dynamicObject.set(ITEM_NO, (Object)dynamicitemtype);
                    dynamicObject.set(ITEM_TYPE, (Object)dynamicitemtype);
                    this.seasonalCalcSummaryPageService.recordDynamicRows(itemType, dynamicitemtype);
                    dynamicObject.set(NAME, (Object)object.getString(NAME));
                    dynamicObject.set(SUM_AMOUNT, (Object)this.getDynamicSumAmount(dynamicitemtype, SUM_AMOUNT, object));
                    sum.add((Object)dynamicObject);
                }
                continue;
            }
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber());
            dynamicObject.set(TYPE, (Object)"1");
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            dynamicObject.set(ITEM_NO, (Object)itemType);
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            String name = this.getName(headNameMap, itemType, orgid, skssqq, skssqz, draftTypeObjectVo);
            dynamicObject.set(NAME, (Object)name);
            dynamicObject.set(SUM_AMOUNT, (Object)this.seasonalCalcSummaryPageService.getSumAmount(itemType, SUM_AMOUNT, orgid, skssqq, skssqz, businesstype, customParams));
            if ("12(X)".equals(itemType) || StringUtil.isBlank((CharSequence)name)) continue;
            sum.add((Object)dynamicObject);
        }
        Boolean smallMatch = Objects.nonNull(customParams.get(IS_SMALL_TYPE)) ? Boolean.valueOf((String)customParams.get(IS_SMALL_TYPE)) : Boolean.FALSE;
        sum.stream().forEach(s -> s.set(IS_SMALL, (Object)smallMatch));
        this.rebuildHeadItemType(headItemTypes);
        this.refreshHeadLevel();
        this.buildTree("1", this.showHeadItemTypes, sum);
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        QFilter typeFilter = new QFilter(TYPE, "=", (Object)"1");
        DeleteServiceHelper.delete((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber(), (QFilter[])new QFilter[]{orgFilter, dateFilter, typeFilter});
        String itemno = this.checkAmountValue(sum);
        if (StringUtil.isNotBlank((CharSequence)itemno)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c%s\u884c \u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d\uff01", (String)"SeasonalCalcPagePlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), itemno));
            return (DynamicObject[])sum.toArray((Object[])new DynamicObject[0]);
        }
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private String checkAmountValue(DynamicObjectCollection sum) {
        for (DynamicObject object : sum) {
            BigDecimal bigDecimal = object.getBigDecimal(SUM_AMOUNT);
            String amountStr = String.valueOf(bigDecimal);
            String[] split = (amountStr = amountStr.replace("-", "")).split("\\.");
            if (split[0].length() <= 13) continue;
            return object.getString(ITEM_NO);
        }
        return "";
    }

    private void refreshHeadLevel() {
        this.seasonalCalcSummaryPageService.getDynamicItemTypeMap().forEach((k, v) -> {
            if (this.HEAD_LEVEL2.contains(k)) {
                this.HEAD_LEVEL2.addAll((Collection<String>)v);
            }
            this.HEAD_LEVEL2.remove(k);
            if (this.HEAD_LEVEL3.contains(k)) {
                this.HEAD_LEVEL3.addAll((Collection<String>)v);
            }
            this.HEAD_LEVEL3.remove(k);
        });
    }

    private BigDecimal getDynamicSumAmount(String rowType, String columnType, DynamicObject object) {
        BigDecimal total = object.getBigDecimal("total");
        return this.seasonalCalcSummaryPageService.putDataMap(rowType, columnType, total);
    }

    private DynamicObject[] buildBranchOfficeSummary(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        ArrayList showItems = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"});
        DynamicObjectCollection sum = new DynamicObjectCollection();
        Map<String, String> branchNameMap = "nssb".equals(draftpurpose) ? SeasonalNameTypeUtils.getInstance().getBranchNameMap() : SeasonalNameTypeUtils.getInstance().getJtBranchNameMap();
        for (String itemType : showItems) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber());
            dynamicObject.set(ITEM_NO, (Object)itemType);
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            dynamicObject.set(NAME, (Object)this.getName(branchNameMap, itemType, orgid, skssqq, skssqz, draftTypeObjectVo));
            dynamicObject.set(SUM_AMOUNT, (Object)this.seasonalCalcSummaryPageService.branchCalc(itemType, SUM_AMOUNT, orgid, skssqq, skssqz, draftTypeObjectVo));
            dynamicObject.set(TYPE, (Object)"2");
            dynamicObject.set(ORGID, (Object)orgid);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            dynamicObject.set(IS_SMALL, (Object)Boolean.FALSE);
            sum.add((Object)dynamicObject);
        }
        this.buildTree("2", showItems, sum);
        QFilter orgFilter = new QFilter(ORGID, "=", (Object)orgid);
        QFilter dateFilter = new QFilter(SKSSQQ, "=", (Object)skssqq).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        QFilter typeFilter = new QFilter(TYPE, "=", (Object)"2");
        DeleteServiceHelper.delete((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber(), (QFilter[])new QFilter[]{orgFilter, dateFilter, typeFilter});
        String itemno = this.checkAmountValue(sum);
        if (StringUtil.isNotBlank((CharSequence)itemno)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c%s\u884c \u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d\uff01", (String)"SeasonalCalcPagePlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), itemno));
            return (DynamicObject[])sum.toArray((Object[])new DynamicObject[0]);
        }
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
    }

    private String getName(Map<String, String> map, String itemType, Long orgid, Date skssqq, Date skssqz, DraftTypeObjectVo draftTypeObjectVo) {
        if (SPECIAL_EXTENDS.contains(itemType)) {
            DynamicObject middApitude = this.seasonalCalcSummaryPageService.findMiddApitude(itemType, orgid, skssqq, skssqz, draftTypeObjectVo.getJmsdMiddApitude().getNumber());
            if (middApitude != null) {
                return middApitude.getString("itemname");
            }
        } else {
            return map.get(itemType);
        }
        return "";
    }

    private void queryHeadData(DynamicObject[] query, List<String> showItemTypes) {
        this.getModel().deleteEntryData(ENTITY_NAME);
        DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity(ENTITY_NAME);
        DynamicObjectType dynamicObjectType = treeEntryEntity.getDynamicObjectType();
        DynamicObject firstObj = null;
        for (String itemType : showItemTypes) {
            DynamicObject object;
            Optional<DynamicObject> optional = Arrays.stream(query).filter(s -> s.getString("itemType").equals(itemType)).findFirst();
            if (!optional.isPresent()) continue;
            firstObj = object = optional.get();
            if (SPECIAL_EXTENDS.contains(object.getString(ITEM_NO)) && object.getBigDecimal(SUM_AMOUNT).compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObject keyObject = new DynamicObject(dynamicObjectType);
            keyObject.set("id", (Object)object.getLong(MYPKID));
            keyObject.set("pid", (Object)object.getLong(MYPARENTID));
            this.getModel().createNewEntryRow(ENTITY_NAME, keyObject);
            keyObject.set(ITEM_NO, (Object)object.getString(ITEM_NO));
            keyObject.set(NAME, (Object)object.getString(NAME));
            keyObject.set(SUM_AMOUNT, (Object)object.getBigDecimal(SUM_AMOUNT));
        }
        this.getModel().setValue(IS_SMALL_TYPE, (Object)(firstObj != null ? firstObj.getBoolean(IS_SMALL) : false));
    }

    private void queryBranchData(DynamicObject[] query, List<String> showItemTypes) {
        this.getModel().deleteEntryData(ENTITY_NAME);
        for (String itemType : showItemTypes) {
            DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity(ENTITY_NAME);
            DynamicObjectType dynamicObjectType = treeEntryEntity.getDynamicObjectType();
            DynamicObject object = Arrays.stream(query).filter(s -> s.getString("itemType").equals(itemType)).findFirst().get();
            DynamicObject keyObject = new DynamicObject(dynamicObjectType);
            keyObject.set("id", (Object)object.getLong(MYPKID));
            keyObject.set("pid", (Object)object.getLong(MYPARENTID));
            this.getModel().createNewEntryRow(ENTITY_NAME, keyObject);
            keyObject.set(ITEM_NO, (Object)object.getString(ITEM_NO));
            keyObject.set(NAME, (Object)object.getString(NAME));
            keyObject.set(SUM_AMOUNT, (Object)object.getBigDecimal(SUM_AMOUNT));
        }
    }

    private void queryHdzsData(DynamicObject[] query) {
        this.getModel().deleteEntryData(ENTITY_NAME);
        DynamicObject firstObj = null;
        for (String itemType : this.showHeadItemTypes) {
            DynamicObject object;
            DynamicObjectCollection treeEntryEntity = this.getModel().getEntryEntity(ENTITY_NAME);
            DynamicObjectType dynamicObjectType = treeEntryEntity.getDynamicObjectType();
            Optional<DynamicObject> optional = Arrays.stream(query).filter(s -> s.getString("itemType").equals(itemType)).findFirst();
            if (!optional.isPresent()) continue;
            firstObj = object = optional.get();
            DynamicObject keyObject = new DynamicObject(dynamicObjectType);
            keyObject.set("id", (Object)object.getLong(MYPKID));
            keyObject.set("pid", (Object)object.getLong(MYPARENTID));
            this.getModel().createNewEntryRow(ENTITY_NAME, keyObject);
            keyObject.set(ITEM_NO, (Object)object.getString(ITEM_NO));
            keyObject.set(NAME, (Object)object.getString(NAME));
            keyObject.set(SUM_AMOUNT, (Object)object.getBigDecimal(SUM_AMOUNT));
        }
        this.getModel().setValue(IS_SMALL_TYPE, (Object)(firstObj != null ? firstObj.getBoolean(IS_SMALL) : false));
    }

    private void buildTree(String type, List<String> showItems, DynamicObjectCollection sum) {
        for (String itemType : showItems) {
            Optional<DynamicObject> first = sum.stream().filter(s -> s.getString(ITEM_NO).equals(itemType)).findFirst();
            if (!first.isPresent()) continue;
            DynamicObject dynamicObject = first.get();
            dynamicObject.set(MYPKID, (Object)this.getPkId(type, itemType));
            dynamicObject.set(MYPARENTID, (Object)this.getParentId(type, itemType));
        }
    }

    private Long getPkId(String type, String itemType) {
        Long pkId = 0L;
        if (type.equals("1")) {
            pkId = this.showHeadItemTypes.indexOf(itemType) + 1;
            this.keyIds.put(itemType, pkId);
        } else if (type.equals("2")) {
            pkId = this.branchItemTypes.indexOf(itemType) + 1;
            this.keyIds.put(itemType, pkId);
        }
        return pkId;
    }

    private Long getParentId(String type, String id) {
        if (type.equals("1")) {
            if (this.HEAD_LEVEL1.contains(id)) {
                return 0L;
            }
            if (this.HEAD_LEVEL2.contains(id)) {
                if (id.indexOf(40) > 0) {
                    String[] split = id.split("\\(");
                    return this.keyIds.get(split[0]);
                }
                if (id.indexOf(46) > 0) {
                    String[] split = id.split("\\.");
                    return this.keyIds.get(split[0]);
                }
                return this.keyIds.get(pattern.matcher(id).replaceAll(""));
            }
            if (this.HEAD_LEVEL3.contains(id)) {
                return this.keyIds.get(id.substring(0, 2));
            }
        } else if (type.equals("2")) {
            return 0L;
        }
        return 0L;
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        String skssqq = (String)customParams.get(SKSSQQ);
        String skssqz = (String)customParams.get(SKSSQZ);
        String draftpurpose = (String)customParams.getOrDefault("draftpurpose", "nssb");
        String businesstype = this.seasonalCalcSummaryPageService.getBusinesstype(orgid, skssqq, skssqz, draftpurpose);
        BigDecimal peopleavg = this.seasonalCalcSummaryPageService.initAvg(orgid, skssqq, skssqz, "people", customParams).setScale(0, 4);
        BigDecimal zcze = this.seasonalCalcSummaryPageService.initAvg(orgid, skssqq, skssqz, "assets", customParams);
        customParams.put(PEOPLE_AVG, String.valueOf(peopleavg));
        customParams.put(ASSETS_AVG, String.valueOf(zcze));
        customParams.put(BUSINESS_TYPE, businesstype);
        if ("1".equals(businesstype) || "2".equals(businesstype)) {
            this.dynamicData = this.initDynamicRows(this.dynamicRows, customParams);
            this.buildHeadOfficeSummary(this.dynamicData, businesstype, customParams);
        } else if ("3".equals(businesstype)) {
            this.buildBranchOfficeSummary(customParams);
        }
        this.seasonalCalcSummaryPageService.updateSeasonalDraftData(Long.valueOf(orgid), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), customParams);
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }

    public void deleteData(EngineModel model) {
        String orgId = model.getOrgId();
        String startDate = model.getStartDate();
        String endDate = model.getEndDate();
        String draftpurpose = model.getCustom().getOrDefault("draftpurpose", "nssb");
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(draftpurpose);
        String entityName = draftTypeObjectVo.getSeasonalCalcDet().getNumber();
        String declaretype = (String)model.getCustom().get("declaretype");
        String type = "311".equals(declaretype) ? "2" : "1";
        this.seasonalCalcSummaryPageService.clearCurrentPeriod(Long.parseLong(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), entityName, type);
        if ("sjjt".equals(draftpurpose)) {
            entityName = draftTypeObjectVo.getSeasonalCalcSplit().getNumber();
            this.seasonalCalcSummaryPageService.clearCurrentPeriod(Long.parseLong(orgId), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), entityName, "1");
        }
    }
}

