/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.seasonal;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.tccit.business.draft.BranchCalcPageService;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class SeasonalCalcSplitPagePlugin
extends AbstractEngine
implements IDraftTypeObserver {
    private BranchCalcPageService branchCalcPageService = new BranchCalcPageService();

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection splitCollection = this.branchCalcPageService.querySeasonalSplitSjjtCollection(customParams);
        if (splitCollection.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", splitCollection.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : splitCollection) {
                model.setValue("pkid", (Object)dynamicObject.getLong("id"), rowIndex);
                model.setValue("unifiedsocialcode", (Object)dynamicObject.getString("unifiedsocialcode"), rowIndex);
                model.setValue("branchorgid", (Object)dynamicObject.getLong("branchorgid"), rowIndex);
                model.setValue("branchspiltratio", (Object)dynamicObject.getBigDecimal("branchspiltratio"), rowIndex);
                model.setValue("branchybtse", (Object)dynamicObject.getBigDecimal("branchybtse"), rowIndex);
                model.setValue("branchreductionratio", (Object)dynamicObject.getBigDecimal("branchreductionratio"), rowIndex);
                model.setValue("branchreductiontax", (Object)dynamicObject.getBigDecimal("branchreductiontax"), rowIndex);
                model.setValue("sjybtsdse", (Object)dynamicObject.getBigDecimal("sjybtsdse"), rowIndex);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("branchreductionratio".equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            BigDecimal ratio = (BigDecimal)changeSet[0].getNewValue();
            DynamicObject dataEntity = changeSet[0].getDataEntity();
            Long id = dataEntity.getLong("pkid");
            DynamicObject taxAmountSplitObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tccit_seasonal_split_sjjt");
            taxAmountSplitObj.set("branchreductiontax", (Object)taxAmountSplitObj.getBigDecimal("branchybtse").multiply(new BigDecimal("0.4").multiply(ratio).setScale(2, 4)));
            taxAmountSplitObj.set("sjybtsdse", (Object)taxAmountSplitObj.getBigDecimal("branchybtse").subtract(taxAmountSplitObj.getBigDecimal("branchreductiontax")));
            taxAmountSplitObj.set("branchreductionratio", (Object)ratio);
            SaveServiceHelper.update((DynamicObject)taxAmountSplitObj);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", dataEntity.getInt("seq") - 1);
            entryRowEntity.set("branchreductiontax", (Object)taxAmountSplitObj.getBigDecimal("branchreductiontax"));
            entryRowEntity.set("sjybtsdse", (Object)taxAmountSplitObj.getBigDecimal("sjybtsdse"));
            this.getView().updateView("entryentity", dataEntity.getInt("seq") - 1);
        }
    }

    public void deleteData(EngineModel model) {
    }
}

