/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.seasonal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tccit.business.draft.ApportionService;
import kd.taxc.tccit.business.draft.BranchCalcPageService;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.pojo.InitSeasonalPolicyVo;
import kd.taxc.tccit.business.policy.SeasonalPolicyService;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.constant.DiscountTypeConstant;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.formplugin.policy.AbstractPolicyPlugin;
import org.apache.commons.collections.CollectionUtils;

public class SeasonalPolicyEdit
extends AbstractPolicyPlugin {
    private static final String RULE_CONFIG = "tccit_rule_config";
    private static final String DISCOUNT_ENTITY = "tccit_conf_tax_reduction";
    private static final String POLICY_ENTITY = "tccit_seasonal_policy";
    private static final String BRANCH_SHARE_NAME = "tccit_branch_share_bill";
    private static final String DISCOUNT_FLEX_KEY = "discountflex";
    protected static final String BRANCH_ENTRY = "branchapitudeentryentity";
    private Set<String> changeFields = new LinkedHashSet<String>(Arrays.asList("prepaytype", "illegal", "sospersonnum", "eospersonnum", "suittype"));
    private boolean isInit = false;
    private ApportionService apportionService = new ApportionService();
    private BranchCalcPageService branchCalcPageService = new BranchCalcPageService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("fastsetting")) {
            HashMap<String, String> customParams = new HashMap<String, String>();
            Object org = this.getModel().getValue("orgid");
            if (org != null) {
                customParams.put("orgid", ((DynamicObject)org).getString("id"));
                customParams.put("ruletype", "private");
            }
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)RULE_CONFIG, (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals(RULE_CONFIG)) {
            this.refreshDiscountFlex();
            this.refreshRuleFlex();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0";
        String startDate = (String)customParams.get("skssqq");
        String endDate = (String)customParams.get("skssqz");
        this.initCommonData(POLICY_ENTITY, orgid, startDate, endDate, Boolean.FALSE);
        this.getModel().setValue("draftpurpose", (Object)customParams.getOrDefault("draftpurpose", "nssb"));
    }

    @Override
    public void afterBindData(EventObject e) {
        String orgid;
        this.isInit = true;
        super.afterBindData(e);
        this.setBranchApitudeIcon();
        this.refreshDiscountFlex();
        this.refreshRuleFlex();
        this.refreshMustInput();
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        treeEntry.setCollapse(false);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        String string = orgid = customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0";
        if (skssqq != null && skssqz != null && DateUtils.getMonthOfDate((Date)skssqq) == DateUtils.getMonthOfDate((Date)skssqz)) {
            this.getModel().setValue("taxperiod", (Object)DateUtils.stringToDate((String)((String)customParams.get("skssqq"))));
        }
        this.initSuitType();
        this.setChildVisible();
        this.setVisiable();
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            IPageCache parentCache = (IPageCache)parentView.getService(IPageCache.class);
            parentCache.put("levytype", String.valueOf(this.getModel().getValue("levytype")));
        }
        this.isInit = false;
    }

    private void setBranchApitudeIcon() {
        if (this.setBranchApitudeVisible()) {
            return;
        }
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        int index = 0;
        for (DynamicObject object : dynamicObject.getDynamicObjectCollection(BRANCH_ENTRY)) {
            HashMap<String, String> propertiesMap = new HashMap<String, String>(8);
            HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(8);
            propertiesMap.put("src", this.ICONS.get(object.getString("branchapitudetype")));
            pmap.put("imageap11", propertiesMap);
            client.invokeControlMethod(BRANCH_ENTRY, "setCustomProperties", new Object[]{index++, pmap});
        }
    }

    private boolean setBranchApitudeVisible() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("declaretype", this.getModel().getValue("declaretype"));
        if (!this.branchCalcPageService.checkBeforeCalcSplit(customParams)) {
            return true;
        }
        String orgid = customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0";
        String startDate = (String)customParams.get("skssqq");
        String endDate = (String)customParams.get("skssqz");
        EngineModel model = new EngineModel(String.valueOf(orgid), startDate, endDate);
        List<DynamicObject> branchShareBills = this.apportionService.getBranchShareBills(model);
        if (CollectionUtils.isEmpty(branchShareBills)) {
            return true;
        }
        this.getView().setVisible(Boolean.valueOf(!branchShareBills.get(0).getBoolean("participation")), new String[]{"branchmsgflex"});
        return branchShareBills.get(0).getBoolean("participation");
    }

    private void setVisiable() {
        String levytype = (String)this.getModel().getValue("levytype");
        String residenttype = (String)this.getModel().getValue("residenttype");
        if ("jmqy".equals(residenttype) && "hdzs".equals(levytype)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexcheckcollectway", "flextaxableincomerate"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap14"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexcheckcollectway", "flextaxableincomerate"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap14"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"fastsetting"});
    }

    private void setFiledValue(String orgid) {
        DynamicObject cardObject;
        Optional<DynamicObject> qysdsCard;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String startDate = (String)customParams.get("skssqq");
        String endDate = (String)customParams.get("skssqz");
        String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
        DynamicObject draftBill = StatusUtils.queryOne((String)"draft_qysdsjb", (String)orgid, (String)startDate, (String)endDate, (String)draftpurpose);
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainQysdsByOrgIds(Collections.singletonList(Long.parseLong(orgid)));
        if (listTaxResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listTaxResult.getData())) && (qysdsCard = (cardObject = (DynamicObject)((List)listTaxResult.getData()).get(0)).getDynamicObjectCollection("categoryentryentity").stream().filter(e -> "qysds".equals(e.getString("taxtype"))).findFirst()).isPresent()) {
            DynamicObject object = qysdsCard.get();
            String levytype = draftBill != null ? this.getLevyTypeMapper(draftBill.getString("type"), object.getString("levytype")) : object.getString("levytype");
            String residenttype = object.getString("residenttype");
            String approvedcollectionmethod = object.getString("approvedcollectionmethod");
            BigDecimal taxableincometaxrate = object.getBigDecimal("taxableincometaxrate");
            this.getModel().setValue("levytype", (Object)levytype);
            this.getModel().setValue("residenttype", (Object)residenttype);
            if ("jmqy".equals(residenttype) && "hdzs".equals(levytype)) {
                this.getModel().setValue("checkcollectway", (Object)approvedcollectionmethod);
                this.getModel().setValue("taxableincomerate", (Object)taxableincometaxrate);
            }
        }
    }

    private String getLevyTypeMapper(String type, String defaultType) {
        if ("WP11".equals(type)) {
            return "czzs";
        }
        if ("WP13".equals(type)) {
            return "hdzs";
        }
        return defaultType;
    }

    private void initSuitType() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("apitudeentryentity");
        boolean exists = !CollectionUtils.isEmpty((Collection)entryEntity) && entryEntity.stream().anyMatch(s -> "1".equals(s.getString("apitudetype")));
        this.getView().setVisible(Boolean.valueOf(exists), new String[]{"suittype"});
        FieldEdit control = (FieldEdit)this.getControl("suittype");
        control.setMustInput(exists);
        FieldProp property = (FieldProp)this.getModel().getProperty("suittype");
        property.setMustInput(exists);
        Object value = this.getModel().getValue("suittype");
        if (value == null) {
            this.getModel().setValue("suittype", (Object)(exists ? "1" : null));
        }
    }

    private void refreshMustInput() {
        String declaretype = (String)this.getModel().getValue("declaretype");
        IFormView parentView = this.getView().getParentView();
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        pageCache.put("declaretype", declaretype);
        if ("311".equals(declaretype) || "312".equals(declaretype)) {
            this.setMustInput(Boolean.FALSE, "sospersonnum", "eospersonnum");
        } else {
            this.setMustInput(Boolean.TRUE, "sospersonnum", "eospersonnum");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (!this.isInit && this.changeFields.contains(name)) {
            this.savePolicy();
        }
        if (Sets.newHashSet((Object[])new String[]{"zjgftbl", "czjzfpbl"}).contains(name)) {
            BigDecimal zjgftbl = Optional.ofNullable((BigDecimal)this.getModel().getValue("zjgftbl")).orElseGet(() -> BigDecimal.ZERO);
            BigDecimal czjzfpbl = Optional.ofNullable((BigDecimal)this.getModel().getValue("czjzfpbl")).orElseGet(() -> BigDecimal.ZERO);
            ChangeData[] changeSet = e.getChangeSet();
            ChangeData changeData = changeSet[0];
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (newValue != null && (newValue.compareTo(BigDecimal.ZERO) < 0 || newValue.compareTo(new BigDecimal("1")) >= 0)) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u51650~1\u4ee5\u5185\u7684\u6570\u503c", (String)"SeasonalPolicyEdit_0", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
            BigDecimal sum = zjgftbl.add(czjzfpbl);
            if (sum.compareTo(new BigDecimal("1")) > 0) {
                this.getView().getParentView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010\u603b\u673a\u6784\u5206\u644a\u6bd4\u4f8b\u3001\u8d22\u653f\u96c6\u4e2d\u5206\u914d\u6bd4\u4f8b\u5408\u8ba1\u503c\u4e3a%s\u8d85\u8fc71\uff0c\u8bf7\u4fee\u6539\u3011", (String)"SeasonalPolicyEdit_1", (String)"taxc-tccit", (Object[])new Object[0]), sum.toString()));
                this.rollbackPropertyChange(e);
                return;
            }
            this.getModel().setValue("qbfzjgftbl", (Object)new BigDecimal("1").subtract(zjgftbl).subtract(czjzfpbl));
            this.savePolicy();
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void savePolicy() {
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)POLICY_ENTITY, (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String orgid = customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0";
            String startDate = (String)customParams.get("skssqq");
            String endDate = (String)customParams.get("skssqz");
            String draftpurpose = (String)customParams.get("draftpurpose");
            StatusUtils.updateStatus((String)"draft_qysdsjb", (String)orgid, (String)startDate, (String)endDate, (String)"1", (String)draftpurpose);
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SeasonalPolicyEdit_2", (String)"taxc-tccit", (Object[])new Object[0]));
            DeclareStepsUtils.resetParentSteps((int)TaxStepsConstant.getTccitSeasonal().size(), (String)"1", (String)"1", (IFormView)this.getView());
        } else {
            this.getView().getParentView().showErrorNotification(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void refreshRuleFlex() {
        Object org = this.getModel().getValue("orgid");
        if (org == null) {
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("items", this.getModel().getEntryEntity("ruleentryentity"));
        customParams.put("declaretype", this.getView().getFormShowParameter().getCustomParam("declaretype"));
        customParams.put("orgid", this.getView().getFormShowParameter().getCustomParam("orgid"));
        PageShowCommon.showForm((String)DISCOUNT_FLEX_KEY, (String)DISCOUNT_ENTITY, (IFormView)this.getView(), customParams);
    }

    private void refreshDiscountFlex() {
        Object org = this.getModel().getValue("orgid");
        if (org == null) {
            return;
        }
        DynamicObjectCollection ruleentryentity = this.getModel().getEntryEntity("itemchoiceentity");
        Optional<DynamicObject> type1 = ruleentryentity.stream().filter(e -> "1".equals(e.getString("type"))).findFirst();
        Optional<DynamicObject> type2 = ruleentryentity.stream().filter(e -> "2".equals(e.getString("type"))).findFirst();
        Optional<DynamicObject> type3 = ruleentryentity.stream().filter(e -> "3".equals(e.getString("type"))).findFirst();
        Optional<DynamicObject> type4 = ruleentryentity.stream().filter(e -> DiscountTypeConstant.techIds.contains(e.getLong("itemchoiceid"))).findFirst();
        IPageCache parentPageCache = this.getView().getParentView().getPageCache();
        parentPageCache.put("shownontax", String.valueOf(type1.isPresent()));
        parentPageCache.put("showtreduced", String.valueOf(type2.isPresent()));
        parentPageCache.put("showincred", String.valueOf(type3.isPresent()));
        parentPageCache.put("showtechincred", String.valueOf(type4.isPresent()));
    }

    @Override
    public void initCustom(String orgid, String startDate, String endDate) {
        Date date1 = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)endDate));
        Date date2 = DateUtils.stringToDate((String)endDate);
        String declaretype = (String)this.getModel().getValue("declaretype");
        List<Object> orgidList = Lists.newArrayList((Object[])new Long[]{Long.parseLong(orgid)});
        orgidList = this.initTreeentryentity(orgid, startDate, endDate, declaretype, orgidList);
        this.setFiledValue(orgid);
        this.initItemchoiceentity(orgidList);
        this.initRuleEntity(orgidList);
        this.initPersonNum(orgid, startDate, endDate, orgidList);
        this.initfpbl(orgid, startDate, endDate, declaretype);
        this.initBranchAptitude(POLICY_ENTITY, Long.valueOf(orgid), startDate, endDate);
    }

    private void initBranchAptitude(String entity, Long orgid, String startDate, String endDate) {
        if (this.setBranchApitudeVisible()) {
            return;
        }
        List<DynamicObject> branchOrgObjList = this.apportionService.getBranchOrgList(orgid, startDate, endDate);
        if (CollectionUtils.isEmpty(branchOrgObjList)) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(BRANCH_ENTRY);
        DataEntityPropertyCollection propertyCollection = entityType.getProperties();
        for (IDataEntityProperty property : mainPros) {
            if (!BRANCH_ENTRY.equals(property.getName())) continue;
            this.getModel().deleteEntryData(BRANCH_ENTRY);
            for (DynamicObject branchOrgObj : branchOrgObjList) {
                for (DynamicObject aptitude : branchOrgObj.getDynamicObjectCollection("apitudeentryentity")) {
                    Date apitudestartdate = aptitude.getDate("apitudestartdate");
                    Date apitudeenddate = aptitude.getDate("apitudeenddate");
                    if (apitudestartdate.compareTo(DateUtils.stringToDate((String)endDate)) > 0 || apitudeenddate != null && apitudeenddate.compareTo(DateUtils.stringToDate((String)startDate)) < 0) continue;
                    int index = this.getModel().createNewEntryRow(BRANCH_ENTRY);
                    for (IDataEntityProperty entityProperty : propertyCollection) {
                        if (entityProperty.getName().equals("id") || entityProperty.getName().equals("exporttype") || entityProperty.getName().equals("creditrating") || !aptitude.getDynamicObjectType().getProperties().containsKey((Object)entityProperty.getName().replace("branch", ""))) continue;
                        this.getModel().getEntryRowEntity(BRANCH_ENTRY, index).set(entityProperty.getName(), aptitude.get(entityProperty.getName().replace("branch", "")));
                    }
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                    dynamicObject.set("id", (Object)branchOrgObj.getLong("taxorg.org.id"));
                    this.getModel().getEntryRowEntity(BRANCH_ENTRY, index).set("branchorgid", (Object)dynamicObject);
                }
            }
        }
        this.getView().updateView();
        this.getView().sendFormAction(this.getView());
    }

    private void initfpbl(String orgid, String startDate, String endDate, String declareType) {
        if ("210".equals(declareType)) {
            Date start = DateUtils.stringToDate((String)startDate);
            Date end = DateUtils.stringToDate((String)endDate);
            int monthDiff = DateUtils.getMonthDiff((Date)start, (Date)end);
            Date s1 = DateUtils.addMonth((Date)start, (int)(-monthDiff));
            Date s2 = DateUtils.getLastDateOfMonth2((Date)DateUtils.addMonth((Date)end, (int)(-monthDiff)));
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
            QFilter filter = QFilter.of((String)"orgid.id=? and startdate=? and enddate=? and draftpurpose=? and declaretype = ?", (Object[])new Object[]{Long.parseLong(orgid), s1, s2, draftpurpose, "210"});
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)POLICY_ENTITY, (String)"zjgftbl,czjzfpbl,qbfzjgftbl", (QFilter[])new QFilter[]{filter});
            this.getModel().setValue("zjgftbl", (Object)(dynamicObject == null ? new BigDecimal("0.25") : dynamicObject.getBigDecimal("zjgftbl")));
            this.getModel().setValue("czjzfpbl", (Object)(dynamicObject == null ? new BigDecimal("0.25") : dynamicObject.getBigDecimal("czjzfpbl")));
            this.getModel().setValue("qbfzjgftbl", (Object)(dynamicObject == null ? new BigDecimal("0.50") : dynamicObject.getBigDecimal("qbfzjgftbl")));
        } else {
            this.getModel().setValue("zjgftbl", (Object)BigDecimal.ZERO);
            this.getModel().setValue("czjzfpbl", (Object)BigDecimal.ZERO);
            this.getModel().setValue("qbfzjgftbl", (Object)BigDecimal.ZERO);
        }
    }

    private void initPersonNum(String orgid, String startDate, String endDate, List<Long> orgidList) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
        InitSeasonalPolicyVo initSeasonalPolicyVo = SeasonalPolicyService.initSeasonalPolicy(Long.parseLong(orgid), DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), draftpurpose);
        boolean fzjg = OrgGroupService.isFzjg(Long.parseLong(orgid), DateUtils.stringToDate((String)endDate));
        if (!fzjg && initSeasonalPolicyVo.getSospersonnum().equals(initSeasonalPolicyVo.getEospersonnum())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u66f4\u65b0\u4ece\u4e1a\u4eba\u6570", (String)"SeasonalPolicyEdit_3", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        this.getModel().setValue("sospersonnum", (Object)initSeasonalPolicyVo.getSospersonnum());
        this.getModel().setValue("eospersonnum", (Object)initSeasonalPolicyVo.getEospersonnum());
    }

    private void initRuleEntity(List<Long> orgidList) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        HashMap ruleMap = new HashMap();
        orgidList.forEach(org -> {
            Map<RuleTypeEnum, List<DynamicObject>> typeEnumListMap = RuleService.getAllSharingAndOrgRuleList(org, customParams.get("draftpurpose").toString(), (String)this.getModel().getValue("levytype"));
            for (Map.Entry<RuleTypeEnum, List<DynamicObject>> entry : typeEnumListMap.entrySet()) {
                RuleTypeEnum key = entry.getKey();
                List<DynamicObject> value = entry.getValue();
                List ruleList = (List)ruleMap.get((Object)key);
                if (CollectionUtils.isEmpty((Collection)ruleList)) {
                    ruleMap.put(key, value);
                    continue;
                }
                ruleList.addAll(value);
            }
        });
        if (ruleMap.size() > 0) {
            for (Map.Entry typeEnumListEntry : ruleMap.entrySet()) {
                RuleTypeEnum ruleTypeEnum = (RuleTypeEnum)((Object)typeEnumListEntry.getKey());
                List ruleList = (List)typeEnumListEntry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)ruleList)) continue;
                this.getModel().beginInit();
                for (DynamicObject rule : ruleList) {
                    int row = this.getModel().createNewEntryRow("ruleentryentity");
                    this.getModel().setValue("itemtype", (Object)ruleTypeEnum.getName(), row);
                    this.getModel().setValue("ruleid", (Object)rule.getLong("id"), row);
                }
                this.getModel().endInit();
                this.getView().updateView("ruleentryentity");
            }
        }
    }

    private void initItemchoiceentity(List<Long> orgidList) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ArrayList incomeRuleList = new ArrayList();
        orgidList.forEach(org -> incomeRuleList.addAll(RuleService.getSharingAndOrgRuleList(org, RuleTypeEnum.INCOME, customParams.get("draftpurpose").toString(), (String)this.getModel().getValue("levytype"))));
        if (CollectionUtils.isNotEmpty(incomeRuleList)) {
            HashSet<Long> ids = new HashSet<Long>(incomeRuleList.size());
            this.getModel().beginInit();
            for (DynamicObject rule : incomeRuleList) {
                DynamicObject item = rule.getDynamicObject("itemchoicename");
                if (null == item || ids.contains(item.getLong("id"))) continue;
                Long itemchoiceid = item.getLong("id");
                ids.add(itemchoiceid);
                int row = this.getModel().createNewEntryRow("itemchoiceentity");
                this.getModel().setValue("itemchoiceid", (Object)itemchoiceid, row);
                this.getModel().setValue("type", (Object)this.getType(item), row);
            }
            this.getModel().endInit();
            this.getView().updateView("itemchoiceentity");
        }
    }

    private String getType(DynamicObject item) {
        String number = item.getString("number");
        String type = "1";
        if (number.startsWith("MSSR")) {
            type = "1";
        } else if (number.startsWith("JJSR")) {
            type = "2";
        } else if (number.startsWith("SD") || number.startsWith("YJ-SDJM2021")) {
            type = "3";
        }
        return type;
    }

    private List<Long> initTreeentryentity(String orgid, String startDate, String endDate, String declaretype, List<Long> orgidList) {
        if ("210".equals(declaretype) || "220".equals(declaretype) || "230".equals(declaretype)) {
            DynamicObjectCollection collection = OrgUtils.queryOrgGroupDetailForCollectedOrg((String)"qysds", (String)orgid, (String)endDate);
            orgidList = collection.stream().map(c -> c.getLong("orgid")).collect(Collectors.toList());
            DynamicObjectCollection objects = OrgGroupService.getOrgGroupDynamicObjects(orgid, endDate, "qysds", "2");
            DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
            DynamicObjectType dynamicObjectType = treeentryentity.getDynamicObjectType();
            long[] pks = DBServiceHelper.genLongIds((String)"tccit_seasonal_policy.treeentryentity", (int)objects.size());
            HashMap<Long, Integer> map = new HashMap<Long, Integer>(pks.length);
            this.getModel().beginInit();
            for (int i = 0; i < pks.length; ++i) {
                map.put(((DynamicObject)objects.get(i)).getLong("orgrow.id"), i);
                DynamicObject dd = new DynamicObject(dynamicObjectType);
                dd.set("id", (Object)pks[i]);
                if (i != 0) {
                    Integer a = (Integer)map.get(((DynamicObject)objects.get(i)).getLong("orgrow.pid"));
                    dd.set("pid", a == null ? null : Long.valueOf(pks[a]));
                }
                int row = this.getModel().createNewEntryRow("treeentryentity", dd);
                this.getModel().setValue("taxorg", (Object)((DynamicObject)objects.get(i)).getLong("orgrow.orgid"), row);
                this.getModel().setValue("declaration", (Object)((DynamicObject)objects.get(i)).getString("declare"), row);
                this.getModel().setValue("shareid", (Object)((DynamicObject)objects.get(i)).getString("share"), row);
                this.getModel().setValue("kdqjyqylx", (Object)((DynamicObject)objects.get(i)).getString("kdqjyqylx"), row);
            }
            this.getModel().endInit();
            this.getView().updateView("treeentryentity");
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
            treeEntry.setCollapse(false);
        }
        return orgidList;
    }

    private void setMustInput(Boolean mustInput, String ... fields) {
        for (String field : fields) {
            FieldEdit control = (FieldEdit)this.getControl(field);
            control.setMustInput(mustInput.booleanValue());
            FieldProp property = (FieldProp)this.getModel().getProperty(field);
            property.setMustInput(mustInput.booleanValue());
        }
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }

    public void deleteData(EngineModel model) {
        String orgId = model.getOrgId();
        String startDate = model.getStartDate();
        String endDate = model.getEndDate();
        String draftpurpose = model.getCustom().getOrDefault("draftpurpose", "nssb");
        SeasonalPolicyService.delete(orgId, startDate, endDate, draftpurpose);
    }
}

