/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.seasonal;

import java.util.EventObject;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.enums.RuleCodeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateNewPlugin;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class SeasonalRuleTemplatePlugin
extends RuleTemplateNewPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(SeasonalRuleTemplatePlugin.class);
    private static final String[] DISABLEBUTTON = new String[]{"name", "item", "entryentity", "normalentryentity", "quickentryentity", "originentryentity"};
    private static final String[] INVISABLEBUTTON = new String[]{"bar_disable", "bar_save"};

    public void initialize() {
        String parentform = this.getView().getFormShowParameter().getParentFormId();
        if (null != parentform && "tccit_yj_rule_query".equals(parentform)) {
            this.getView().setEnable(Boolean.valueOf(false), DISABLEBUTTON);
            this.getView().setVisible(Boolean.valueOf(false), INVISABLEBUTTON);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield");
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit normalamountfield = (BasedataEdit)this.getControl("normalamountfield");
        normalamountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit quickamountfield = (BasedataEdit)this.getControl("quickamountfield");
        quickamountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit originamountfield = (BasedataEdit)this.getControl("originamountfield");
        originamountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tablefield = (BasedataEdit)this.getControl("table");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit normaltable = (BasedataEdit)this.getControl("normaltable");
        normaltable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit quicktable = (BasedataEdit)this.getControl("quicktable");
        quicktable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit origintable = (BasedataEdit)this.getControl("origintable");
        origintable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().endsWith("amountfield")) {
            DynamicObject taxation;
            String key = evt.getProperty().getName();
            String suffix = key.replace("amountfield", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(suffix + "entryentity");
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue(suffix + "table", rowIndex);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"SeasonalRuleTemplatePlugin_0", (String)"taxc-tctb-common", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter id = new QFilter("tableid", "=", tabletype.get("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(id);
            String entityName = ((BasedataEdit)evt.getSource()).getView().getFormShowParameter().getFormId();
            if (RuleTypeEnum.REDUCE.getEntry().equals(entityName) && "tdm_balance_new".equals(tabletype.get("name"))) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
            if (RuleTypeEnum.INCOME.getEntry().equals(entityName) && null != (taxation = (DynamicObject)this.getModel().getValue("taxation")) && taxation.getString("number").equals("MS") && "tdm_balance_new".equals(tabletype.get("name"))) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(suffix + "amountfield", rowIndex);
        } else if (evt.getProperty().getName().endsWith("table")) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            logger.info("\u9884\u7f34\u6570\u636e\u6e90\u8fc7\u6ee4\u7801\uff1a{}", (Object)formId);
            String ruleType = RuleCodeEnum.getRuleType((String)formId);
            if (StringUtil.isNotBlank((CharSequence)ruleType)) {
                QFilter filter = new QFilter("basedataid.billno", "=", (Object)ruleType);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
            }
        }
    }
}

