/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.seasonal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tccit.common.DeclareCompanyTypeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportPluginNew;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.sbb.SbbQueryService;
import kd.taxc.tccit.common.utils.DateRangeUtils;

public class TccitDeclarationEditPlugin
extends AbstractDeclareReportPluginNew {
    private static final String TEMPLATE_TYPE = "qysdsjb";
    private static final String TEMPLATE_TYPE_HDZS = "qysds_hdzs_jb";
    private static final Set<String> LIST = Sets.newHashSet((Object[])new String[]{"100", "210", "220", "230"});
    public static final String INIT_START_AND_END_DATE = "initStartAndEndDate";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String orgid = this.getPageCache().get("orgid");
        String endDate = this.getPageCache().get("skssqz");
        String declareCompanyType = DeclareCompanyTypeUtils.getDeclareCompanyType((String)orgid, (String)endDate);
        this.setVisibleOrHide(declareCompanyType);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject org;
        String key = evt.getItemKey();
        if ("save".equals(key) && null != (org = (DynamicObject)this.getModel().getValue("org")) && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TccitDeclarationEditPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        super.beforeItemClick(evt);
    }

    public void loadData(Date startDate, Date endDate, Boolean needMsg) {
        super.loadData(startDate, endDate, Boolean.FALSE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date newValue;
        String initStartAndEndDate;
        String name = e.getProperty().getName();
        ChangeData change = e.getChangeSet()[0];
        if ((name.equals("skssqq") || name.equals("skssqz")) && !"true".equals(initStartAndEndDate = this.getPageCache().get(INIT_START_AND_END_DATE)) && (newValue = (Date)change.getNewValue()) != null) {
            Map<String, Date> dateRange = DateRangeUtils.getDateRange(this.getTaxLimits()[0], newValue);
            this.getModel().setValue("skssqq", (Object)dateRange.get("startdate"));
            this.getModel().setValue("skssqz", (Object)dateRange.get("enddate"));
        }
        if (name.equals("skssqq") || name.equals("org")) {
            super.propertyChanged(e);
        }
        if (name.equals("org")) {
            DynamicObject qysdsCard;
            ChangeData[] changeSet = e.getChangeSet();
            ChangeData changeData = changeSet[0];
            Object newValue2 = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            String templateType = this.getTemplateType();
            if (TEMPLATE_TYPE_HDZS.equals(templateType) && (qysdsCard = OrgGroupService.getQysdsCard(newValue2 != null ? ((DynamicObject)newValue2).getString("id") : "0")) != null && "fjmqy".equals(qysdsCard.getString("residenttype"))) {
                this.getModel().setValue("org", oldValue);
            }
        }
    }

    public void orgCheckResultHandle(String oldorgid, String orgid, boolean checkResult) {
        if (checkResult) {
            this.getModel().setValue("org", (Object)oldorgid);
        } else {
            this.getPageCache().put("orgid", orgid);
            this.getPageCache().put("oldorgid", orgid);
            this.getPageCache().put(INIT_START_AND_END_DATE, "true");
            this.initStartAndEndDate(true);
            this.getPageCache().put(INIT_START_AND_END_DATE, "false");
            this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"), Boolean.FALSE);
        }
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        DynamicObject qysdsCard = OrgGroupService.getQysdsCard(orgid);
        if (qysdsCard != null && "fjmqy".equals(qysdsCard.getString("residenttype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5c45\u6c11\u4f01\u4e1a\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\uff0c\u6682\u4e0d\u652f\u6301\u7533\u62a5\u3002", (String)"TccitDeclarationEditPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return false;
        }
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)"tccit", (String)"zerodeclare", (long)Long.parseLong(orgid));
        if (zerodeclare && qysdsCard != null && "hdzs".equals(qysdsCard.getString("levytype"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5f53\u524d\u5f81\u6536\u65b9\u5f0f\u4e0d\u652f\u6301\u6838\u5b9a\u96f6\u7533\u62a5\u3002", (String)"TccitDeclarationEditPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
            return false;
        }
        return super.checkOrgTaxConfig(orgid, skssqq, skssqz);
    }

    protected String[] getTaxLimits() {
        Map customParams;
        String draftpurpose;
        String orgId = this.getPageCache().get("orgid") != null ? this.getPageCache().get("orgid") : "0";
        Boolean isAjflag = DeadlineService.getDeadline(orgId, draftpurpose = (customParams = this.getView().getFormShowParameter().getCustomParams()).getOrDefault("draftpurpose", "nssb"));
        if (isAjflag.booleanValue()) {
            return new String[]{"season"};
        }
        return new String[]{"month"};
    }

    public String getTemplateType() {
        String templateType = TEMPLATE_TYPE;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean recalc = customParams.getOrDefault("recalc", false);
        if ("history".equals(customParams.get("from")) && !recalc) {
            return customParams.getOrDefault("templatetype", templateType);
        }
        String orgid = this.getPageCache().get("orgid");
        if (StringUtil.isEmpty((CharSequence)orgid)) {
            return templateType;
        }
        DynamicObject qysdsCard = OrgGroupService.getQysdsCard(orgid);
        if (qysdsCard != null) {
            String levytype = qysdsCard.getString("levytype");
            if ("czzs".equals(levytype)) {
                templateType = TEMPLATE_TYPE;
            } else if ("hdzs".equals(levytype)) {
                templateType = TEMPLATE_TYPE_HDZS;
            }
            return templateType;
        }
        return templateType;
    }

    public DynamicObject getDeclareMain(String orgid, String startDate, String endDate, Object type) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)startDate));
        QFilter q3 = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)endDate));
        QFilter q4 = new QFilter("type", "=", (Object)TEMPLATE_TYPE).or("type", "=", (Object)TEMPLATE_TYPE_HDZS);
        return QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billstatus,billno,zerodeclare", (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
        this.calStaticData();
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        this.initStartAndEndDate(true);
    }

    protected void calStaticData() {
        String cache_sbbid = this.getPageCache().get("cache_sbbid");
        String templateid = this.getPageCache().get("templateid");
        String orgid = this.getPageCache().get("orgid");
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        String declareCompanyType = DeclareCompanyTypeUtils.getDeclareCompanyType((String)orgid, (String)endDate);
        this.getPageCache().put("declareCompanyType", declareCompanyType);
        Boolean noNeedApply = DeclareCompanyTypeUtils.noNeedApply((String)declareCompanyType, (String)orgid, (String)startDate, (String)endDate);
        this.getView().setVisible(Boolean.valueOf(noNeedApply == false), new String[]{"summary1", "tabcontent"});
        if (noNeedApply.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u4e0d\u5c31\u5730\u9884\u7f34\u6240\u5f97\u7a0e\u7684\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u72ec\u7acb\u586b\u62a5\u7533\u62a5\u8868\uff01", (String)"TccitDeclarationEditPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        DynamicObject orgGroup = DeclareCompanyTypeUtils.getOrgGroup((String)orgid, (String)endDate);
        String parentId = "";
        String orgname = "";
        if (orgGroup != null) {
            parentId = orgGroup.getString("parentid");
            long fzorgId = orgGroup.getLong("orgid");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bastax_taxorg", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)fzorgId)});
            orgname = dynamicObject.getString("taxpayer");
        }
        BigDecimal bqybtse = this.getBqybtse(orgid, declareCompanyType, templateid, cache_sbbid);
        this.getModel().setValue("bqybtse", (Object)bqybtse);
        this.getModel().setValue("ynssde", (Object)this.getYnssde(parentId, declareCompanyType));
        this.getModel().setValue("bqjmse", (Object)this.getBqjmse(orgid, declareCompanyType, templateid, cache_sbbid));
        this.getModel().setValue("fpbl", (Object)this.getFpbl(parentId, declareCompanyType, orgname));
        this.getModel().setValue("bqynssde", (Object)this.getBqynssde(orgid, declareCompanyType, templateid, cache_sbbid));
        BigDecimal fpsdse = this.getFpsdse(orgid, declareCompanyType, orgname);
        this.getModel().setValue("fpsdse", (Object)fpsdse);
        this.setVisibleOrHide(declareCompanyType);
        BigDecimal amount = declareCompanyType.equals("311") ? fpsdse : bqybtse;
        this.updateTaxDeclareMain(orgid, amount);
    }

    private void updateTaxDeclareMain(String orgid, BigDecimal bqjmse) {
        String sbbid = this.getCurrentSbbid(orgid, 0);
        String defaultSbbid = "0";
        if (StringUtil.isEmpty((CharSequence)sbbid) || defaultSbbid.equals(sbbid)) {
            return;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sbbid), (String)"tctb_declare_main");
        if (object != null) {
            object.set("bqybtse", (Object)bqjmse);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    private BigDecimal getFpsdse(String orgid, String declareCompanyType, String name) {
        if (declareCompanyType.equals("311")) {
            String sbbid = this.getCurrentSbbid(orgid, 0);
            return SbbQueryService.getQysdsZb(sbbid, "fsjybsdse");
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getFpbl(String parentId, String declareCompanyType, String name) {
        if (declareCompanyType.equals("311")) {
            String sbbid = this.getParentSbbid(parentId);
            return SbbQueryService.getSumQysdsZjgxx(sbbid, "fpbl", name);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getYnssde(String parentId, String declareCompanyType) {
        if (declareCompanyType.equals("311")) {
            String sbbid = this.getParentSbbid(parentId);
            BigDecimal ynsdse = SbbQueryService.getQysdsZjgxx(sbbid, "ynsdse");
            return ynsdse;
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getBqynssde(String orgid, String declareCompanyType, String templateid, String cache_sbbid) {
        if (this.isQysdsJb2015Template(templateid)) {
            DynamicObject qysdsZb2015 = SbbQueryService.getQysdsZb2015(cache_sbbid);
            return qysdsZb2015 == null ? BigDecimal.ZERO : (qysdsZb2015.getBigDecimal("byynsdse").compareTo(BigDecimal.ZERO) == 0 ? qysdsZb2015.getBigDecimal("sjlre") : qysdsZb2015.getBigDecimal("byynsdse"));
        }
        if (this.isQysdsHDCITQR2020Template(templateid)) {
            return SbbQueryService.getHdzs2018Zb(cache_sbbid, "ynssde");
        }
        String sbbid = this.getCurrentSbbid(orgid, 0);
        if (LIST.contains(declareCompanyType)) {
            return SbbQueryService.getQysdsZb(sbbid, "sjlre");
        }
        return BigDecimal.ZERO;
    }

    private boolean isQysdsJb2015Template(String templateid) {
        return "895435166112038912".equals(templateid);
    }

    private boolean isQysdsHDCITQR2020Template(String templateid) {
        return "935447447721750528".equals(templateid);
    }

    private String getCurrentSbbid(String orgid, int month) {
        String startdate = this.getPageCache().get("skssqq");
        String enddate = this.getPageCache().get("skssqz");
        return YbnsrService.queryYbnsrPre((String)orgid, (String)TEMPLATE_TYPE, (String)startdate, (String)enddate, (int)month);
    }

    private String getParentSbbid(String orgid) {
        QFilter skssqzfilter;
        QFilter skssqqfilter;
        QFilter typeFilter;
        String startdate = this.getPageCache().get("skssqq");
        String enddate = this.getPageCache().get("skssqz");
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter[] qFilterArr = new QFilter[]{orgFilter, typeFilter = new QFilter("type", "=", (Object)TEMPLATE_TYPE), skssqqfilter = new QFilter("skssqq", ">=", (Object)DateUtils.stringToDate((String)startdate)), skssqzfilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)DateUtils.stringToDate((String)enddate)))};
        DynamicObjectCollection temp = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)" * ", (QFilter[])qFilterArr);
        if (null != temp && temp.size() > 0) {
            return ((DynamicObject)temp.get(0)).getString("id");
        }
        return "";
    }

    private BigDecimal getBqjmse(String orgid, String declareCompanyType, String templateid, String cache_sbbid) {
        if (this.isQysdsJb2015Template(templateid)) {
            DynamicObject qysdsFbJmmx2015 = SbbQueryService.getQysdsFbJmmx2015(cache_sbbid);
            return qysdsFbJmmx2015 == null ? BigDecimal.ZERO : qysdsFbJmmx2015.getBigDecimal("total");
        }
        if (this.isQysdsHDCITQR2020Template(templateid)) {
            return SbbQueryService.getHdzs2018Zb(cache_sbbid, "jfhtjxxwlqy");
        }
        String sbbid = this.getCurrentSbbid(orgid, 0);
        return SbbQueryService.getQysdsZb(sbbid, "jmsdse");
    }

    private BigDecimal getBqybtse(String orgid, String declareCompanyType, String templateid, String cache_sbbid) {
        if (this.isQysdsJb2015Template(templateid)) {
            DynamicObject qysdsZb2015 = SbbQueryService.getQysdsZb2015(cache_sbbid);
            if (declareCompanyType.equals("100")) {
                return qysdsZb2015 == null ? BigDecimal.ZERO : (qysdsZb2015.getBigDecimal("byswjgqdyjsde").compareTo(BigDecimal.ZERO) == 0 ? (qysdsZb2015.getBigDecimal("bysjynsdse").compareTo(BigDecimal.ZERO) == 0 ? qysdsZb2015.getBigDecimal("bysjybsdse") : qysdsZb2015.getBigDecimal("bysjynsdse")) : qysdsZb2015.getBigDecimal("byswjgqdyjsde"));
            }
            if (Lists.newArrayList((Object[])new String[]{"210", "220"}).contains(declareCompanyType)) {
                return qysdsZb2015 == null ? BigDecimal.ZERO : qysdsZb2015.getBigDecimal("zjgstsdse").add(qysdsZb2015.getBigDecimal("czjzfpsdse")).add(qysdsZb2015.getBigDecimal("zjgdlscjybmyftsdse"));
            }
            if (Lists.newArrayList((Object[])new String[]{"311", "312"}).contains(declareCompanyType)) {
                return qysdsZb2015 == null ? BigDecimal.ZERO : qysdsZb2015.getBigDecimal("jgfpsdse");
            }
            return BigDecimal.ZERO;
        }
        if (this.isQysdsHDCITQR2020Template(templateid)) {
            return SbbQueryService.getHdzs2018Zb(cache_sbbid, "bqsjybsdse");
        }
        String sbbid = this.getCurrentSbbid(orgid, 0);
        return SbbQueryService.getQysdsZb(sbbid, "fsjybsdse");
    }

    private void setVisibleOrHide(String declareCompanyType) {
        if (LIST.contains(declareCompanyType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap30", "flexpanelap32", "flexpanelap34"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap31", "flexpanelap33", "flexpanelap35"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap30", "flexpanelap32", "flexpanelap34"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap31", "flexpanelap33", "flexpanelap35"});
        }
    }

    public void init() {
    }

    public String getTaxType() {
        return null;
    }

    public Map<String, Object> chooseDeclareFormByDataType(String orgid, String type, String startDate, String endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject dyo = TccitDeclarationEditPlugin.getDeclareMain(orgid, startDate, endDate);
        String declareStatus = "";
        String billstatus = "";
        String datatype = "";
        if (null != dyo) {
            declareStatus = dyo.getString("declarestatus");
            billstatus = dyo.getString("billstatus");
            datatype = dyo.getString("datatype");
            this.getPageCache().put("taxPayerType", dyo.getString("type"));
        }
        map.put("declarestatus", declareStatus);
        map.put("billstatus", billstatus);
        map.put("datatype", datatype);
        return map;
    }

    public static DynamicObject getDeclareMain(String orgid, String startDate, String endDate) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)startDate));
        QFilter q3 = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)endDate));
        QFilter q4 = new QFilter("type", "in", Arrays.asList(TEMPLATE_TYPE, TEMPLATE_TYPE_HDZS));
        return QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billstatus,declarestatus,datatype,type", (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    protected String getUniKey(String orgId, String skssqq, String skssqz, String templateType) {
        return String.format("%1s_%2s_%3s_%4s", orgId, skssqq, skssqz, templateType);
    }
}

