/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.seasonal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.provision.impl.QysdsjbCreateProvisionServiceImpl;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.dto.DraftPluginDto;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.AbstractDraftPlugin;
import kd.taxc.bdtaxr.common.taxdeclare.draft.DraftStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.file.ExcelUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.apitude.ApitudeMiddService;
import kd.taxc.tccit.business.batch.DeclareHelperService;
import kd.taxc.tccit.business.calc.SeasonalCalcTask;
import kd.taxc.tccit.business.declare.DeclareCompanyTypeService;
import kd.taxc.tccit.business.draft.ApportionService;
import kd.taxc.tccit.business.draft.BranchCalcPageService;
import kd.taxc.tccit.business.draft.DeadlineService;
import kd.taxc.tccit.business.draft.DraftMainService;
import kd.taxc.tccit.business.draft.IDraftTypeObserver;
import kd.taxc.tccit.business.org.OrgGroupService;
import kd.taxc.tccit.business.pojo.DataResultVo;
import kd.taxc.tccit.business.pojo.DraftTypeObjectVo;
import kd.taxc.tccit.business.policy.SeasonalPolicyService;
import kd.taxc.tccit.business.taxbook.BranchTaxbookBusinessService;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.common.utils.DateRangeUtils;
import kd.taxc.tccit.common.utils.DraftEntityUtils;
import kd.taxc.tccit.formplugin.seasonal.SeasonalPolicyEdit;
import org.apache.commons.collections.CollectionUtils;

public class TccitDeclarationPlugin
extends AbstractDraftPlugin
implements IDraftTypeObserver,
BeforeF7SelectListener {
    public static final String SHOW_NONTAX = "shownontax";
    public static final String SHOW_TREDUCED = "showtreduced";
    public static final String SHOW_INCRED = "showincred";
    public static final String SHOW_TECH_INCRED = "showtechincred";
    public static final String DECLARETYPE = "declaretype";
    public static final String ORG_LIST = "orglist";
    public static final String LEVY_TYPE = "levytype";
    public static final String UNSUBMIT_KEY = "unsubmit";
    public static final String AUDIT_KEY = "audit";
    public static final String UNAUDIT_KEY = "unaudit";
    public static final String CHECKJTD_KEY = "checkjtd";
    public static final String DELETEJTD_KEY = "deletejtd";
    public static final String VIEWFLOWCHART_KEY = "viewflowchart";
    public static final String EXPORTSHEET = "exportsheet";
    private DeclareHelperService declareHelperService = new DeclareHelperService();
    private BranchCalcPageService branchCalcPageService = new BranchCalcPageService();
    private ApportionService apportionService = new ApportionService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit accountorgBase = (BasedataEdit)this.getView().getControl("accountorg");
        accountorgBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.getView().setVisible(Boolean.FALSE, new String[]{"newjtd", UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY, CHECKJTD_KEY, DELETEJTD_KEY, "fastsetting"});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
        super.afterCreateNewData(e);
        boolean isSjjt = "sjjt".equals(draftpurpose);
        Long taxOrg = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElse(0L);
        Date endDate = (Date)this.getModel().getValue("skssqz");
        boolean isNotSubmitOrAudit = "A".equals(this.getPageCache().get("cache_billstatus"));
        if (isSjjt) {
            Long mainPkId = customParams.getOrDefault("mainPkId", 0L);
            Long accountorg = Optional.ofNullable(QueryServiceHelper.queryOne((String)"tpo_declare_main_tsd", (String)"accountorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mainPkId)})).map(s -> s.getLong("accountorg")).orElseGet(() -> 0L);
            Long orgs = status.equals((Object)OperationStatus.EDIT) ? accountorg : this.declareHelperService.getDefaultAccountOrg(taxOrg);
            this.getModel().setValue("accountorg", (Object)orgs);
            this.getView().setEnable(Boolean.valueOf(orgs.compareTo(0L) != 0), new String[]{"accountorg"});
            this.getPageCache().put("accountorg", String.valueOf(orgs));
            if (orgs == 0L) {
                return;
            }
            if (customParams.get("orgid") == null || customParams.get("skssqq") == null || customParams.get("skssqz") == null) {
                if (this.getModel().getDataEntity().getDate("skssqq") == null || this.getModel().getDataEntity().getDate("skssqz") == null) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"next", EXPORTSHEET, "recalc"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"forward"});
                    return;
                }
                DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange((List)Lists.newArrayList((Object[])new Long[]{taxOrg}), (Long)DeclareTaxType.QYSDS.getBaseTaxId(), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)this.getModel().getDataEntity().getDate("skssqq"), (Date)this.getModel().getDataEntity().getDate("skssqz")).getData();
                Optional<DynamicObject> jtfa = dynamicObjectCollection.stream().filter(s -> StringUtil.isBlank((CharSequence)s.getString("ruleentity.rule.booktype"))).findFirst();
                if (dynamicObjectCollection.size() == 0 || !jtfa.isPresent() || jtfa.get().getString("ruleentity.rule.enable").equals("0")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"TccitDeclarationPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.FALSE, new String[]{"next", EXPORTSHEET, "recalc"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"forward"});
                    return;
                }
            }
        }
        this.getView().setVisible(Boolean.valueOf(isSjjt), new String[]{"accountorg"});
        boolean fzjg = OrgGroupService.isFzjg(taxOrg, endDate);
        this.getView().setVisible(Boolean.valueOf(!fzjg), new String[]{"next"});
        this.getView().setVisible(Boolean.valueOf(!fzjg && isNotSubmitOrAudit), new String[]{"recalc"});
        if (fzjg) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u7f16\u5236\u5e95\u7a3f\u3002", (String)"TccitDeclarationPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        DynamicObject qysdsCard = OrgGroupService.getQysdsCard(String.valueOf(taxOrg));
        this.getView().setVisible(Boolean.valueOf(qysdsCard == null || !"fjmqy".equals(qysdsCard.getString("residenttype"))), new String[]{"next"});
        this.getView().setVisible(Boolean.valueOf((qysdsCard == null || !"fjmqy".equals(qysdsCard.getString("residenttype"))) && isNotSubmitOrAudit), new String[]{"recalc", "refetch"});
        if (qysdsCard != null && "fjmqy".equals(qysdsCard.getString("residenttype"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u5c45\u6c11\u4f01\u4e1a\u6682\u4e0d\u652f\u6301\u7f16\u5236\u5e95\u7a3f", (String)"TccitDeclarationPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        String noNeedLoadData = this.getView().getPageCache().get("no_need_load_data");
        if ("true".equals(noNeedLoadData)) {
            DraftStepsUtils.resetSteps((int)this.getDeclarePageMap().size(), (String)"0", (String)"0", (IFormView)this.getView());
            this.getView().setVisible(Boolean.FALSE, new String[]{"next", "recalc"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"next"});
            this.getView().setVisible(Boolean.valueOf(isNotSubmitOrAudit), new String[]{"recalc"});
        }
        if ("workflowview".equals(this.getView().getFormShowParameter().getCustomParam("scene"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"next"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"refetch"});
    }

    protected boolean doCustomInAfterCreateNewData(String orgId, String skssqq, String skssqz) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
        DataResultVo dataResultVo = DraftMainService.hasIntersection(orgId, skssqq, skssqz, draftpurpose);
        if (!dataResultVo.getSuccess().booleanValue()) {
            this.getView().showErrorNotification(dataResultVo.getMessage());
            this.getView().getPageCache().put("no_need_load_data", "true");
            return false;
        }
        this.getView().getPageCache().put("no_need_load_data", "false");
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
        boolean isSjjt = "sjjt".equals(draftpurpose);
        String name = e.getProperty().getName();
        if (name.equals("org") || name.equals("skssqq") || name.equals("skssqz")) {
            Long taxOrg = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElse(0L);
            Date startDate = (Date)this.getModel().getValue("skssqq");
            Date endDate = (Date)this.getModel().getValue("skssqz");
            if (name.equals("org")) {
                String levytype = OrgGroupService.getLevyType(taxOrg);
                this.getPageCache().put(LEVY_TYPE, levytype);
                DynamicObject qysdsCard = OrgGroupService.getQysdsCard(String.valueOf(taxOrg));
                this.getView().setVisible(Boolean.valueOf(qysdsCard == null || !"fjmqy".equals(qysdsCard.getString("residenttype"))), new String[]{"next", "recalc", "refetch"});
                if (qysdsCard != null && "fjmqy".equals(qysdsCard.getString("residenttype"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u5c45\u6c11\u4f01\u4e1a\u6682\u4e0d\u652f\u6301\u7f16\u5236\u5e95\u7a3f", (String)"TccitDeclarationPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.FALSE, new String[]{"fastsetting", "refresh"});
                    return;
                }
            }
            if (name.equals("skssqq") || name.equals("skssqz")) {
                Date newValue = (Date)e.getChangeSet()[0].getNewValue();
                String[] taxLimits = this.getTaxLimits();
                if (newValue != null && taxLimits != null && taxLimits.length > 0) {
                    Map<String, Date> dateRange = DateRangeUtils.getDateRange(taxLimits[0], newValue);
                    this.getModel().setValue("skssqq", (Object)dateRange.get("startdate"));
                    this.getModel().setValue("skssqz", (Object)dateRange.get("enddate"));
                }
            }
            if (isSjjt) {
                Long orgs;
                Long defaultAccountOrg = orgs = this.declareHelperService.getDefaultAccountOrg(taxOrg);
                this.getModel().setValue("accountorg", (Object)defaultAccountOrg);
                this.getView().setEnable(Boolean.valueOf(orgs > 0L), new String[]{"accountorg"});
                this.getPageCache().put("accountorg", String.valueOf(defaultAccountOrg));
                if (defaultAccountOrg == 0L) {
                    String msg = String.format(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TccitDeclarationPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getString("name")).orElse(""));
                    this.getView().showErrorNotification(msg);
                }
                if (this.getModel().getDataEntity().getDate("skssqq") == null || this.getModel().getDataEntity().getDate("skssqz") == null) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"next", EXPORTSHEET, "recalc"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"forward", "fastsetting", "refresh", "tabcontent"});
                    return;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"tabcontent"});
                DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange((List)Lists.newArrayList((Object[])new Long[]{taxOrg}), (Long)DeclareTaxType.QYSDS.getBaseTaxId(), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)this.getModel().getDataEntity().getDate("skssqq"), (Date)this.getModel().getDataEntity().getDate("skssqz")).getData();
                Optional<DynamicObject> jtfa = dynamicObjectCollection.stream().filter(s -> StringUtil.isBlank((CharSequence)s.getString("ruleentity.rule.booktype"))).findFirst();
                if (dynamicObjectCollection.size() == 0 || !jtfa.isPresent() || jtfa.get().getString("ruleentity.rule.enable").equals("0")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"TccitDeclarationPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.FALSE, new String[]{"next", EXPORTSHEET, "recalc"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"forward", "fastsetting", "refresh", "tabcontent"});
                    return;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"tabcontent"});
            }
            boolean isNotSubmitOrAudit = "A".equals(this.getPageCache().get("cache_billstatus"));
            boolean fzjg = OrgGroupService.isFzjg(taxOrg, endDate);
            this.getView().setVisible(Boolean.valueOf(!fzjg), new String[]{"next"});
            this.getView().setVisible(Boolean.valueOf(!fzjg && isNotSubmitOrAudit), new String[]{"recalc"});
            if (fzjg) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u7f16\u5236\u5e95\u7a3f\u3002", (String)"TccitDeclarationPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{"fastsetting", "refresh"});
                return;
            }
            if (this.isValidDateNoMsg(startDate, endDate)) {
                DataResultVo dataResultVo = DraftMainService.hasIntersection(String.valueOf(taxOrg), DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), draftpurpose);
                this.getView().setVisible(dataResultVo.getSuccess(), new String[]{"next"});
                this.getView().setVisible(Boolean.valueOf(dataResultVo.getSuccess() != false && isNotSubmitOrAudit), new String[]{"recalc"});
                if (!dataResultVo.getSuccess().booleanValue()) {
                    this.getView().showErrorNotification(dataResultVo.getMessage());
                    this.getView().setVisible(Boolean.FALSE, new String[]{"fastsetting", "refresh"});
                    return;
                }
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"refetch"});
        }
        if (name.equals("accountorg")) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            String draftnumber = (String)this.getModel().getValue("draftnumber");
            Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElseGet(() -> 0L);
            Long accountorgId = Optional.ofNullable(newValue).map(s -> ((DynamicObject)s).getLong("id")).orElseGet(() -> 0L);
            String draftBillName = this.getDraftBillName(draftpurpose);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)draftBillName, (String)"accountorg", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)draftnumber).and(new QFilter("org", "=", (Object)orgId))});
            if (dynamicObject != null) {
                dynamicObject.set("accountorg", (Object)accountorgId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
        }
    }

    protected String getMsg() {
        return ResManager.loadKDString((String)"\u91cd\u7f6e\u5e95\u7a3f\u5c06\u5bfc\u81f4\u539f\u6709\u5e95\u7a3f\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"TccitDeclarationPlugin_40", (String)"taxc-tccit", (Object[])new Object[0]);
    }

    public TccitDeclarationPlugin() {
        super.setDeclarePageMap(TaxStepsConstant.getTccitSeasonal());
    }

    protected void runEngineBeforeNextStep(DraftPluginDto draftPluginDto) {
        if (!"2".equals(draftPluginDto.getFocusPage())) {
            return;
        }
        String orgId = draftPluginDto.getOrgId();
        String startdate = draftPluginDto.getStartDate();
        String enddate = draftPluginDto.getEndDate();
        String focusPage = draftPluginDto.getFocusPage();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("orgid", orgId);
        params.put("startdate", startdate);
        params.put("enddate", enddate);
        params.put("focusPage", focusPage);
        params.put("refetch", "recalc");
        params.put("jobid", this.getJobId());
        String operateType = draftPluginDto.getOperateType();
        params.put("operateType", operateType);
        List orglist = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ORG_LIST), List.class);
        params.put(ORG_LIST, orglist.stream().map(Long::parseLong).collect(Collectors.toList()));
        params.put(DECLARETYPE, this.getPageCache().get(DECLARETYPE));
        params.put(SHOW_NONTAX, this.getPageCache().get(SHOW_NONTAX));
        params.put(SHOW_TREDUCED, this.getPageCache().get(SHOW_TREDUCED));
        params.put(SHOW_INCRED, this.getPageCache().get(SHOW_INCRED));
        params.put("draftpurpose", this.getPageCache().get("draftpurpose"));
        params.put(LEVY_TYPE, this.getPageCache().get(LEVY_TYPE));
        draftPluginDto.setAsyn("1");
        this.dispatch(params);
    }

    public void taskEndCallBack(TaskInfo taskInfo) {
        String data = taskInfo.getData();
        Map customs = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        String calcType = (String)customs.get("calcType");
        String focusPage = (String)customs.get("focusPage");
        String orgid = (String)customs.get("orgid");
        this.showInnerTbPage("2", orgid);
    }

    protected String getTaskClassName() {
        return SeasonalCalcTask.class.getName();
    }

    protected void markEditStatus() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"refetch"});
    }

    private EngineModel createEngineModel(DraftPluginDto draftPluginDto) {
        EngineModel engineModel = new EngineModel(draftPluginDto.getOrgId(), draftPluginDto.getStartDate(), draftPluginDto.getEndDate());
        List orglist = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ORG_LIST), List.class);
        engineModel.addCustom(ORG_LIST, orglist.stream().map(Long::parseLong).collect(Collectors.toList()));
        engineModel.addCustom(DECLARETYPE, (Object)this.getPageCache().get(DECLARETYPE));
        engineModel.addCustom(SHOW_NONTAX, (Object)this.getPageCache().get(SHOW_NONTAX));
        engineModel.addCustom(SHOW_TREDUCED, (Object)this.getPageCache().get(SHOW_TREDUCED));
        engineModel.addCustom(SHOW_INCRED, (Object)this.getPageCache().get(SHOW_INCRED));
        engineModel.addCustom("draftpurpose", (Object)this.getPageCache().get("draftpurpose"));
        engineModel.addCustom(LEVY_TYPE, (Object)this.getPageCache().get(LEVY_TYPE));
        DynamicObject policy = SeasonalPolicyService.getPolicy(Long.parseLong(engineModel.getOrgId()), DateUtils.stringToDate2((String)engineModel.getStartDate()), DateUtils.stringToDate2((String)engineModel.getEndDate()), engineModel.getCustom().getOrDefault("draftpurpose", "nssb"));
        engineModel.addCustom("policy", (Object)policy);
        return engineModel;
    }

    protected String[] getTaxLimits() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
        String orgId = this.getPageCache().get("orgid") != null ? this.getPageCache().get("orgid") : "0";
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        TaxResult isEnableResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId));
        if (!isEnableResult.isSuccess()) {
            this.getView().showErrorNotification(isEnableResult.getMessage());
            return new String[0];
        }
        DynamicObject object = StatusUtils.queryOne((String)"draft_qysdsjb", (String)orgId, (String)skssqq, (String)skssqz, (String)draftpurpose);
        if (object != null) {
            String taxLimit = DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
            return new String[]{taxLimit};
        }
        String[] taxlimit = new String[]{"month"};
        if ("nssb".equals(draftpurpose)) {
            String[] stringArray;
            Boolean isAjflag = DeadlineService.getDeadline(orgId);
            if (isAjflag.booleanValue()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "season";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "month";
            }
            taxlimit = stringArray;
        } else if ("sjjt".equals(draftpurpose)) {
            if ("true".equals(customParams.get("viewDraft"))) {
                return new String[]{(String)customParams.get("limit")};
            }
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange((List)Lists.newArrayList((Object[])new Long[]{Long.valueOf(orgId)}), (Long)DeclareTaxType.QYSDS.getBaseTaxId(), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)this.getModel().getDataEntity().getDate("skssqq"), (Date)this.getModel().getDataEntity().getDate("skssqz")).getData();
            Optional<DynamicObject> jtfa = dynamicObjectCollection.stream().filter(s -> StringUtil.isBlank((CharSequence)s.getString("ruleentity.rule.booktype"))).findFirst();
            if (dynamicObjectCollection.size() == 0 || !jtfa.isPresent() || jtfa.get().getString("ruleentity.rule.enable").equals("0")) {
                return new String[0];
            }
            return new String[]{jtfa.get().getString("ruleentity.rule.cycle")};
        }
        return taxlimit;
    }

    public String getTemplateType() {
        return "draft_qysdsjb";
    }

    public Map<String, Object> createCustomParams(String orgId, String startdate, String enddate, String status, String focuspage) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(SHOW_NONTAX, this.getPageCache().get(SHOW_NONTAX));
        customParams.put(SHOW_TREDUCED, this.getPageCache().get(SHOW_TREDUCED));
        customParams.put(SHOW_INCRED, this.getPageCache().get(SHOW_INCRED));
        customParams.put(SHOW_TECH_INCRED, this.getPageCache().get(SHOW_TECH_INCRED));
        customParams.put(DECLARETYPE, this.getPageCache().get(DECLARETYPE));
        customParams.put("draftpurpose", this.getPageCache().get("draftpurpose"));
        customParams.put(LEVY_TYPE, StringUtil.isNotBlank((CharSequence)this.getPageCache().get(LEVY_TYPE)) ? this.getPageCache().get(LEVY_TYPE) : "czzs");
        if ("3".equals(focuspage)) {
            customParams.put("templatetype", this.getTemplateType());
            customParams.put("draftnumber", this.getModel().getValue("draftnumber"));
            customParams.put("ParentCache", "true");
            customParams.put("refresh", String.valueOf(!"3".equals(status)));
        }
        return customParams;
    }

    public boolean checkBeforeNextStep(String orgId, String startdate, String enddate, String status, String focusPage) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(draftpurpose);
        if (StringUtil.isBlank((CharSequence)startdate) || StringUtil.isBlank((CharSequence)enddate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u8d77\u6216\u6b62\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TccitDeclarationPlugin_38", (String)"taxc-tccit", (Object[])new Object[0]));
            return false;
        }
        boolean fzjg = OrgGroupService.isFzjg(Long.parseLong(StringUtil.isEmpty((CharSequence)orgId) ? "0" : orgId), DateUtils.stringToDate2((String)enddate));
        if (fzjg) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u7f16\u5236\u5e95\u7a3f\u3002", (String)"TccitDeclarationPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return false;
        }
        if ("1".equals(status) && "2".equals(focusPage)) {
            Optional<DynamicObject> exists;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TccitDeclarationPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]));
                return false;
            }
            IFormView policyview = this.getView().getView(this.getPageCache().get("declarepageid"));
            DynamicObject registertype = (DynamicObject)policyview.getModel().getValue("registertype");
            if (registertype != null && registertype.getString("longnumber").startsWith("400")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e\u529f\u80fd\u672a\u5411\u4e2a\u4f53\u7ecf\u8425\u4f01\u4e1a\u5f00\u653e\uff0c\u8bf7\u5728\u57fa\u7840\u8d44\u6599\u4fee\u6539\u4f01\u4e1a\u767b\u8bb0\u6ce8\u518c\u7c7b\u578b", (String)"TccitDeclarationPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection treeentryentity = policyview.getModel().getEntryEntity("treeentryentity");
            Optional<DynamicObject> first = treeentryentity.stream().filter(s -> "2".equals(s.get("declaration"))).findFirst();
            if (first.isPresent() && QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{new QFilter("id", "=", first.get().get("taxorg.id")), new QFilter("istaxpayer", "=", (Object)"0")})) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u603b\u7ec4\u7ec7\u4e3a\u975e\u7eb3\u7a0e\u4e3b\u4f53\uff0c\u4fdd\u5b58\u5931\u8d25, \u8bf7\u4fee\u6539\u6c47\u603b\u65b9\u6848\u3002", (String)"TccitDeclarationPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection bastaxTaxorgList = QueryServiceHelper.query((String)"bastax_taxorg", (String)"status,org.name as name,org.id as id", (QFilter[])new QFilter[]{new QFilter("id", "in", treeentryentity.stream().map(s -> s.get("taxorg.id")).collect(Collectors.toList())), new QFilter("status", "=", (Object)"0")});
            List thirdOrgs = treeentryentity.stream().filter(e -> "312".equals(e.getString("kdqjyqylx"))).map(s -> s.getLong("taxorg.id")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)bastaxTaxorgList) && (exists = bastaxTaxorgList.stream().filter(e -> !thirdOrgs.contains(e.getLong("id"))).findFirst()).isPresent()) {
                StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u5b58\u5728", (String)"TccitDeclarationPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]));
                for (DynamicObject object : bastaxTaxorgList) {
                    builder.append(String.format(ResManager.loadKDString((String)"\u3010%s\u3011", (String)"TccitDeclarationPlugin_9", (String)"taxc-tccit", (Object[])new Object[0]), object.getString("name")));
                }
                builder.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u7981\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u4fee\u6539\u6c47\u603b\u65b9\u6848\u540e\u540c\u6b65\u66f4\u65b0\u5206\u652f\u673a\u6784\u5206\u644a\u53f0\u8d26", (String)"TccitDeclarationPlugin_11", (String)"taxc-tccit", (Object[])new Object[0]));
                this.getView().showErrorNotification(builder.toString());
                return false;
            }
            List orglist = treeentryentity.stream().map(e -> e.getString("taxorg_id")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(orglist)) {
                orglist.add(orgId);
            }
            this.getPageCache().put(ORG_LIST, SerializationUtils.toJsonString(orglist));
            if ("sjjt".equals(draftpurpose) && this.getModel().getValue("accountorg") == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TccitDeclarationPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getString("name")).orElse(""));
                this.getView().showErrorNotification(msg);
                return false;
            }
            DataResultVo dataResultVo = BranchTaxbookBusinessService.checkBrankShare(Long.parseLong(orgId), DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate));
            if (!dataResultVo.getSuccess().booleanValue()) {
                this.getView().showErrorNotification(dataResultVo.getMessage());
                return false;
            }
            if (StringUtil.isNotBlank((CharSequence)dataResultVo.getMessage())) {
                this.getView().showTipNotification(dataResultVo.getMessage());
            }
        }
        String declaretype = this.getPageCache().get(DECLARETYPE);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter startFilter = new QFilter("skssqq", ">=", (Object)DateUtils.stringToDate((String)startdate));
        QFilter endFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)DateUtils.stringToDate((String)enddate)));
        if (focusPage.equals("3") && "210".equals(declaretype)) {
            DynamicObjectCollection summaryList = QueryServiceHelper.query((String)draftTypeObjectVo.getApportion().getNumber(), (String)"id,income,emolument,totalassets", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
            BigDecimal totalIncome = BigDecimal.ZERO;
            BigDecimal totalemolument = BigDecimal.ZERO;
            BigDecimal totalassets = BigDecimal.ZERO;
            for (DynamicObject summary : summaryList) {
                totalIncome = totalIncome.add(summary.getBigDecimal("income"));
                totalemolument = totalemolument.add(summary.getBigDecimal("emolument"));
                totalassets = totalassets.add(summary.getBigDecimal("totalassets"));
            }
        }
        if (focusPage.equals("3")) {
            DynamicObjectCollection assertAcceList = QueryServiceHelper.query((String)draftTypeObjectVo.getAssertAcce().getNumber(), (String)"id,currentadjustamount,preadjustamount", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
            for (DynamicObject object : assertAcceList) {
                BigDecimal currentadjustamount = object.getBigDecimal("currentadjustamount");
                BigDecimal preadjustamount = object.getBigDecimal("preadjustamount");
                if (currentadjustamount.compareTo(BigDecimal.ZERO) < 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u671f\u7eb3\u7a0e\u8c03\u6574\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e0", (String)"TccitDeclarationPlugin_12", (String)"taxc-tccit", (Object[])new Object[0]));
                    return false;
                }
                if (currentadjustamount.compareTo(preadjustamount) >= 0) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u671f\u7eb3\u7a0e\u8c03\u6574\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e\u4e0a\u671f\u7eb3\u7a0e\u8c03\u6574\u91d1\u989d", (String)"TccitDeclarationPlugin_13", (String)"taxc-tccit", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected DynamicObject queryDynamicObject(String focuspage, String templateType, String orgId, String startdate, String enddate) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Date startDate = DateUtils.stringToDate((String)startdate);
        Date endDate = DateUtils.stringToDate((String)enddate);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)customParams.getOrDefault("draftpurpose", "nssb"));
        return QueryServiceHelper.queryOne((String)"tccit_seasonal_policy", (String)"id", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, draftpurposeFilter});
    }

    protected void deleteAllDraftData(String templateType, String orgId, String startdate, String enddate) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Date startDate = DateUtils.stringToDate((String)startdate);
        Date endDate = DateUtils.stringToDate((String)enddate);
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        this.deleteAllDraftExceptAdjustData(templateType, orgId, startdate, enddate);
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        QFilter draftpurposeFilter = new QFilter("draftpurpose", "=", (Object)customParams.getOrDefault("draftpurpose", "nssb"));
        DeleteServiceHelper.delete((String)"tccit_seasonal_policy", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, draftpurposeFilter});
        QFilter[] orgAndDateFilter = new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgId)), new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate))};
        DeleteServiceHelper.delete((String)draftTypeObjectVo.getAdjustRecord().getNumber(), (QFilter[])orgAndDateFilter);
    }

    protected void deleteAllDraftExceptAdjustData(String templateType, String orgId, String startdate, String enddate) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = (String)customParams.get("draftpurpose");
        DraftTypeObjectVo draftTypeObjectVo = this.getDraftTypeObjectVo(customParams);
        Date startDate = DateUtils.stringToDate((String)startdate);
        Date endDate = DateUtils.stringToDate((String)enddate);
        QFilter[] orgAndDateFilter = new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgId)), new QFilter("skssqq", "=", (Object)startDate).and(new QFilter("skssqz", "=", (Object)endDate))};
        DeleteServiceHelper.delete((String)draftTypeObjectVo.getSeasonalCalcDet().getNumber(), (QFilter[])orgAndDateFilter);
        DynamicObject dgobject = StatusUtils.queryOne((String)templateType, (String)orgId, (String)startdate, (String)enddate, (String)draftpurpose);
        if (dgobject != null) {
            String entity = DraftEntityUtils.getEntityByDraftPurpose(draftpurpose);
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)dgobject.get("id"), (String)entity);
            object.set("ismodified", (Object)0);
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
            entryentity.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
        new ApitudeMiddService(draftTypeObjectVo).clearMiddApitude(Long.valueOf(orgId), startDate, endDate);
    }

    protected String getNumberPrefix() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        String billType = DeclareCompanyTypeService.getDgType(org.getString("id"), DateUtils.format((Date)skssqz), "seasonal");
        return "sjjt".equals(draftpurpose) ? "EITACCURE-" + billType : "CIT-" + billType;
    }

    protected void loadData(Date startDate, Date endDate) {
        if ("workflowview".equals(this.getView().getFormShowParameter().getCustomParam("scene"))) {
            this.showInnerTbPage("3", this.getPageCache().get("orgid"));
        } else {
            this.showInnerTbPage("1", this.getPageCache().get("orgid"));
        }
    }

    protected void setButtonVisible(String focuspage) {
        super.setButtonVisible(focuspage);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = (String)customParams.get("draftpurpose");
        DynamicObject object = StatusUtils.queryOne((String)this.getTemplateType(), (String)this.getPageCache().get("orgid"), (String)this.getPageCache().get("skssqq"), (String)this.getPageCache().get("skssqz"), (String)draftpurpose);
        if ("nssb".equals(draftpurpose) && object != null && ("B".equals(this.getPageCache().get("cache_declarestatus")) || "C".equals(this.getPageCache().get("cache_declarestatus")))) {
            if ("A".equals(object.getString("billstatus"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{VIEWFLOWCHART_KEY});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"submit", UNSUBMIT_KEY, "edit", AUDIT_KEY, UNAUDIT_KEY, "createsbb", "fastsetting"});
            if ("3".equals(focuspage)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"createsbb"});
            } else if ("2".equals(focuspage)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{EXPORTSHEET});
            }
            return;
        }
        this.setBtnStatus(object, focuspage);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Long taxOrg = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElse(0L);
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxOrg), (Date)startDate, (Date)endDate);
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        customQFilters.add(new QFilter("id", "in", (Object)orgRelations));
    }

    protected void newJtd() {
        super.newJtd();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String draftpurpose = this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
        String orgid = this.getPageCache().get("orgid");
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        DynamicObject declare = this.queryDraftBillObject(this.getTemplateType(), orgid, skssqq, skssqz, draftpurpose);
        if (declare.getString("generatebusinessdoc").equals("true")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u5df2\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"TccitDeclarationPlugin_14", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        Object billstatus = declare.get("billstatus");
        if (!"C".equals(billstatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5df2\u5ba1\u6838\u7684\u5e95\u7a3f\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"TccitDeclarationPlugin_15", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        DynamicObject item = QueryServiceHelper.queryOne((String)"itp_proviston_item", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"JTSX-0001"), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (item == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u63d0\u4e8b\u9879\u672a\u542f\u7528\u3002", (String)"TccitDeclarationPlugin_16", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        DynamicObject seasonalPolicy = SeasonalPolicyService.getPolicy(Long.valueOf(orgid), DateUtils.stringToDate2((String)skssqq), DateUtils.stringToDate2((String)skssqz), draftpurpose);
        if (null == seasonalPolicy) {
            return;
        }
        if (this.branchCalcPageService.checkBeforeCalcSplit(seasonalPolicy.getString("draftpurpose"), seasonalPolicy.getString(DECLARETYPE), seasonalPolicy.getString(LEVY_TYPE), "A") && (seasonalPolicy.getString(DECLARETYPE).equals("210") || seasonalPolicy.getString(DECLARETYPE).equals("220") || seasonalPolicy.getString(DECLARETYPE).equals("230")) && "czzs".equals(seasonalPolicy.getString(LEVY_TYPE))) {
            DynamicObject[] branchOrgArray;
            for (DynamicObject dynamicObject : branchOrgArray = BusinessDataServiceHelper.load((String)"tccit_seasonal_split_sjjt", (String)"branchorgid,branchybtse,org,draftnumber,skssqq,skssqz", (QFilter[])new QFilter[]{new QFilter("draftnumber", "in", (Object)declare.getString("billno"))})) {
                Long orgRelation = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)dynamicObject.getDynamicObject("branchorgid").getLong("id")).getData();
                if (null != orgRelation) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u8ba1\u63d0\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"TccitDeclarationPlugin_17", (String)"taxc-tccit", (Object[])new Object[0]), dynamicObject.getDynamicObject("branchorgid").getString("name")));
                return;
            }
            QysdsjbCreateProvisionServiceImpl qysdsjbCreateProvisionService = new QysdsjbCreateProvisionServiceImpl();
            qysdsjbCreateProvisionService.createBranchProvision(AccrualListEnum.QYSDSJB, Collections.singletonList(declare));
        }
        String entity = DraftEntityUtils.getEntityByDraftPurpose(draftpurpose);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)declare.get("id"), (String)entity);
        list.add(this.createParams(dynamicObject, item));
        String responseList = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxprovisionService", (String)"createTaxprovision", (Object[])new Object[]{SerializationUtils.toJsonString(list)});
        BaseResult data = (BaseResult)SerializationUtils.fromJsonString((String)responseList, BaseResult.class);
        if (data.getCode().equals(BaseResult.OK)) {
            List responses = (List)data.getData();
            String billno = dynamicObject.getString("billno");
            dynamicObject.set("generatebusinessdoc", (Object)Boolean.TRUE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"TccitDeclarationPlugin_18", (String)"taxc-tccit", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{VIEWFLOWCHART_KEY});
            this.getView().setEnable(Boolean.FALSE, new String[]{"newjtd", UNAUDIT_KEY});
            this.getView().setEnable(Boolean.TRUE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u751f\u6210\u8ba1\u63d0\u5355\u6210\u529f", (String)"TccitDeclarationPlugin_19", (String)"taxc-tccit", (Object[])new Object[0]), billno);
            OperatorDialogUtils.operateDialog((String)"qysds", (String)"tccit_sjjt_list", (String)ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355", (String)"TccitDeclarationPlugin_20", (String)"taxc-tccit", (Object[])new Object[0]), (String)operateDescription, (Long)dynamicObject.getLong("org.id"));
        } else {
            this.getView().showErrorNotification(data.getMessage());
        }
    }

    public Map<String, Object> createParams(DynamicObject dynamicObject, DynamicObject item) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        List entryentity = (List)dynamicObject.get("entryentity");
        if (entryentity.size() > 0) {
            Object bqybtse = ((DynamicObject)entryentity.get(0)).get("bqybtse");
            map.put("total", bqybtse);
        } else {
            map.put("total", new BigDecimal(0));
        }
        DynamicObject org = (DynamicObject)dynamicObject.get("org");
        DynamicObject accountorg = (DynamicObject)dynamicObject.get("accountorg");
        String billno = dynamicObject.getString("billno");
        String userId = RequestContext.get().getUserId();
        map.put("taxtype", 3);
        map.put("taxsystem", 1);
        map.put("coins", 1);
        map.put("provistonitem", item.get("id"));
        map.put("taxorg", org.getLong("id"));
        map.put("accountorg", accountorg.getLong("id"));
        map.put("startdate", dynamicObject.get("skssqq"));
        map.put("enddate", dynamicObject.get("skssqz"));
        String draftpurpose = dynamicObject.getString("draftpurpose");
        String entity = DraftEntityUtils.getEntityByDraftPurpose(draftpurpose);
        map.put("entitytype", entity);
        map.put("entitynumber", billno);
        map.put("creator", userId);
        map.put("modifier", userId);
        map.put("entrydate", dynamicObject.get("skssqz"));
        return map;
    }

    public String getAttachmentFieldName() {
        return "attachmentpanelap";
    }

    public String getAttachmentPanelName() {
        return "flexpanelapat";
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String orgId;
        String callBackId = e.getCallBackId();
        if ("recalc".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            super.confirmCallBack(e);
            orgId = this.getPageCache().get("orgid");
            String draftpurpose = this.getDraftpurpose();
            String templateType = this.getTemplateType();
            String entity = DraftEntityUtils.getEntityByDraftPurpose(draftpurpose);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u91cd\u65b0\u8ba1\u7b97\u6210\u529f", (String)"TccitDeclarationPlugin_21", (String)"taxc-tccit", (Object[])new Object[0]), this.getModel().getValue("draftnumber"));
            OperatorDialogUtils.operateDialog((String)"qysds", (String)entity, (String)ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97", (String)"TccitDeclarationPlugin_22", (String)"taxc-tccit", (Object[])new Object[0]), (String)operateDescription, (Long)(StringUtil.isNotEmpty((CharSequence)orgId) ? Long.parseLong(orgId) : RequestContext.get().getOrgId()));
            if (templateType.equals("draft_qysdsjb") && draftpurpose.equals("sjjt")) {
                DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange((List)Lists.newArrayList((Object[])new Long[]{Long.valueOf(orgId)}), (Long)DeclareTaxType.QYSDS.getBaseTaxId(), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)this.getModel().getDataEntity().getDate("skssqq"), (Date)this.getModel().getDataEntity().getDate("skssqz")).getData();
                Optional<DynamicObject> jtfa = dynamicObjectCollection.stream().filter(s -> StringUtil.isBlank((CharSequence)s.getString("ruleentity.rule.booktype"))).findFirst();
                if (dynamicObjectCollection.size() == 0 || !jtfa.isPresent() || jtfa.get().getString("ruleentity.rule.enable").equals("0")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"TccitDeclarationPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                    this.getView().setVisible(Boolean.FALSE, new String[]{"next", EXPORTSHEET, "recalc"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"forward"});
                }
            }
        }
        if ("refetch".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            orgId = this.getPageCache().get("orgid");
            String startdate = this.getPageCache().get("skssqq");
            String enddate = this.getPageCache().get("skssqz");
            String draftpurpose = this.getPageCache().get("draftpurpose");
            if (orgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TccitMainPlugin_11", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            String templateType = this.getTemplateType();
            EngineHandler handler = EngineHandlerFactory.createHandler((String)TemplateEnum.getEnumByDraftType((String)templateType).getDeclareType());
            EngineModel engineModel = this.getEngineModel(orgId, startdate, enddate, draftpurpose);
            engineModel.addCustom("operateType", (Object)"refetch");
            handler.getEngineList().forEach(engine -> {
                if (!(engine instanceof SeasonalPolicyEdit)) {
                    engine.deleteData(engineModel);
                }
            });
            this.deleteAllDraftExceptAdjustData(templateType, orgId, startdate, enddate);
            this.getPageCache().put("operateType", "refetch");
            String newFocusPage = "2";
            String status = StatusUtils.getStatus((String)this.getTemplateType(), (String)orgId, (String)startdate, (String)enddate, (String)draftpurpose);
            DynamicObject object = this.queryDynamicObject(null, this.getTemplateType(), orgId, startdate, enddate);
            if (object == null) {
                throw new KDBizException("Org Params Error!");
            }
            Long policyId = object.getLong("id");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)policyId, (String)"tccit_seasonal_policy");
            DynamicObjectCollection orgcol = obj.getDynamicObjectCollection("treeentryentity");
            List<String> orglist = new ArrayList<String>(16);
            if (CollectionUtils.isNotEmpty((Collection)orgcol)) {
                orglist = orgcol.stream().map(el -> el.getString("taxorg_id")).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(orglist)) {
                orglist.add(orgId);
            }
            this.getPageCache().put(ORG_LIST, SerializationUtils.toJsonString(orglist));
            try {
                this.runEngineBeforeNextStep(new DraftPluginDto(orgId, startdate, enddate, status, newFocusPage, "refetch"));
                StatusUtils.updateStatus((String)this.getTemplateType(), (String)orgId, (String)startdate, (String)enddate, (String)newFocusPage, (String)draftpurpose);
                String pageid = this.getPageCache().get("declarepageid");
                IFormView childView = this.getView().getView(pageid);
                Map customParams = childView.getFormShowParameter().getCustomParams();
                customParams.put("isfetchData", "true");
                childView.invokeOperation("refresh");
                childView.updateView();
                this.getView().sendFormAction(childView);
            }
            catch (Exception t) {
                throw new KDBizException("Run Engine Params Error Or Refresh Error." + t.getMessage());
            }
        }
    }

    private String getDraftpurpose() {
        return this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
    }

    public void itemClick(ItemClickEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"TccitDeclarationPlugin_23", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        TaxResult isEnableResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
        if (!isEnableResult.isSuccess()) {
            this.getView().showErrorNotification(isEnableResult.getMessage());
            return;
        }
        super.itemClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"TccitDeclarationPlugin_23", (String)"taxc-tccit", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        TaxResult isEnableResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
        if (!isEnableResult.isSuccess()) {
            this.getView().showErrorNotification(isEnableResult.getMessage());
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        String draftpurpose = this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
        String orgid = this.getPageCache().get("orgid");
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        String focuspage = this.getPageCache().get("focuspage");
        DynamicObject object = this.queryDraftBillObject(this.getTemplateType(), orgid, skssqq, skssqz, draftpurpose);
        switch (itemKey) {
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.setBtnStatus(object, focuspage);
                break;
            }
            case "checkjtd": {
                this.checkJtd(object);
                break;
            }
            case "deletejtd": {
                this.deleteJtd(object);
                break;
            }
            case "fastsetting": {
                this.openRule();
            }
        }
    }

    private void openRule() {
        HashMap<String, String> customParams = new HashMap<String, String>();
        String orgId = this.getPageCache().get("orgid");
        customParams.put("orgid", orgId);
        customParams.put("ruletype", "private");
        PageShowCommon.showBillList((String)"bos_templatetreelist", (ShowType)ShowType.MainNewTabPage, (String)"tccit_yj_rule_group", (IFormView)this.getView(), customParams, null);
    }

    private void deleteJtd(DynamicObject object) {
        if (object != null) {
            DynamicObject jtdObject = DraftMainService.queryJtd(object.getString("billno"));
            if (jtdObject == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u672a\u751f\u6210\u8ba1\u63d0\u5355", (String)"TccitDeclarationPlugin_24", (String)"taxc-tccit", (Object[])new Object[0]));
            } else {
                if (!"A".equals(jtdObject.getString("billstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u5168\u90e8\u8ba1\u63d0\u5355\u53ef\u4ee5\u5220\u9664", (String)"TccitDeclarationPlugin_25", (String)"taxc-tccit", (Object[])new Object[0]));
                    return;
                }
                DraftMainService.deleteJtd(object);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355\u6210\u529f", (String)"TccitDeclarationPlugin_26", (String)"taxc-tccit", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.TRUE, new String[]{VIEWFLOWCHART_KEY});
                this.getView().setEnable(Boolean.TRUE, new String[]{UNAUDIT_KEY, "newjtd"});
                this.getView().setEnable(Boolean.FALSE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u5220\u9664\u8ba1\u63d0\u5355\u6210\u529f", (String)"TccitDeclarationPlugin_27", (String)"taxc-tccit", (Object[])new Object[0]), object.getString("billno"));
                OperatorDialogUtils.operateDialog((String)"qysds", (String)"tccit_sjjt_list", (String)ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355", (String)"TccitDeclarationPlugin_28", (String)"taxc-tccit", (Object[])new Object[0]), (String)operateDescription, (Long)object.getLong("org"));
            }
        }
    }

    private void checkJtd(DynamicObject object) {
        if (object != null) {
            this.openProvistonBillPage(object.getString("org"), object.getString("taxsystem"), object.getString("billno"));
        }
    }

    private void openProvistonBillPage(String orgId, String taxsystem, String draftBillNo) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appid = formShowParameter.getAppId();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("itp_proviston_taxes");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", draftBillNo);
        hashMap.put("orgId", orgId);
        hashMap.put("taxsystem", taxsystem);
        hashMap.put("appid", appid);
        listShowParameter.setCustomParams((Map)hashMap);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void setBtnStatus(DynamicObject dynamicObject, String focuspage) {
        String billstatus;
        if (this.getTemplateType().equals("draft_qysdsjb") && this.getDraftpurpose().equals("sjjt")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"createsbb", "fastsetting"});
            if (dynamicObject != null) {
                billstatus = dynamicObject.getString("billstatus");
                if ("3".equals(focuspage)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{EXPORTSHEET});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{EXPORTSHEET});
                }
                if ("A".equals(billstatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"recalc", "refetch"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"edit", "newjtd", CHECKJTD_KEY, DELETEJTD_KEY});
                    if ("1".equals(focuspage)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"fastsetting"});
                    } else if ("2".equals(focuspage)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"fastsetting"});
                    }
                }
                if ("B".equals(billstatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"newjtd", CHECKJTD_KEY, DELETEJTD_KEY});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"recalc", "refetch"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"newjtd"});
                    if (dynamicObject.getString("generatebusinessdoc").equals("false")) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
                    } else {
                        this.getView().setEnable(Boolean.TRUE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
                    }
                }
                if ("C".equals(billstatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"newjtd", CHECKJTD_KEY, DELETEJTD_KEY});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"recalc", "refetch"});
                    if (dynamicObject.getString("generatebusinessdoc").equals("false")) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{VIEWFLOWCHART_KEY});
                        this.getView().setEnable(Boolean.TRUE, new String[]{"newjtd"});
                        this.getView().setEnable(Boolean.FALSE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{VIEWFLOWCHART_KEY});
                        this.getView().setEnable(Boolean.TRUE, new String[]{CHECKJTD_KEY, DELETEJTD_KEY});
                        this.getView().setEnable(Boolean.FALSE, new String[]{"newjtd", UNAUDIT_KEY});
                    }
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit", UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY});
            }
            if (Arrays.asList("1", "3").contains(focuspage)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"refetch"});
            }
        }
        if (this.getTemplateType().equals("draft_qysdsjb") && this.getDraftpurpose().equals("nssb")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"newjtd", CHECKJTD_KEY, DELETEJTD_KEY});
            if (dynamicObject != null) {
                billstatus = dynamicObject.getString("billstatus");
                if ("A".equals(billstatus)) {
                    if ("3".equals(focuspage)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"recalc", "createsbb", EXPORTSHEET});
                        this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
                    } else {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"recalc"});
                        this.getView().setVisible(Boolean.FALSE, new String[]{"edit", "createsbb", EXPORTSHEET});
                        if ("1".equals(focuspage)) {
                            this.getView().setVisible(Boolean.TRUE, new String[]{"fastsetting"});
                        } else if ("2".equals(focuspage)) {
                            this.getView().setVisible(Boolean.FALSE, new String[]{"fastsetting"});
                        }
                    }
                }
                if ("B".equals(billstatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"createsbb"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{EXPORTSHEET, "recalc", "refetch"});
                    if ("3".equals(focuspage)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{EXPORTSHEET});
                    }
                }
                if ("C".equals(billstatus)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"createsbb"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{EXPORTSHEET, "recalc", "refetch"});
                    if ("3".equals(focuspage)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{EXPORTSHEET});
                    }
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"submit", UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY});
            }
        }
    }

    public void export() {
        this.exportQysds();
    }

    private void exportQysds() {
        String skssqz;
        String skssqq;
        DynamicObject org;
        String orgName;
        String draftnumber = (String)this.getModel().getValue("draftnumber");
        Map<String, String> excelData = this.createExcelData(draftnumber, orgName = (org = (DynamicObject)this.getModel().getValue("org")).getString("name"), skssqq = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), skssqz = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
        if (excelData == null) {
            return;
        }
        DynamicObject templateObject = TemplateUtils.getTemplateObjectById((String)"qysds_draft_calc", (String)"1752074145069661184");
        String jsonString = templateObject.getString("content_tag");
        String levyType = this.getPageCache().get(LEVY_TYPE);
        HashMap<String, String> sheetNameMap = new HashMap<String, String>();
        ArrayList<String> hidedSheetList = new ArrayList<String>(1);
        hidedSheetList.add("sheet2");
        if ("hdzs".equals(levyType)) {
            String hdsheetName = ResManager.loadKDString((String)"\u7eb3\u7a0e\u603b\u89c8\u8868\uff08\u6838\u5b9a\u5f81\u6536\u9884\u7f34\u5e95\u7a3f\uff09", (String)"TccitDeclarationPlugin_32", (String)"taxc-tccit", (Object[])new Object[0]);
            sheetNameMap.put("sheet1", hdsheetName);
        } else {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("orgid", org.getString("id"));
            customParams.put("skssqq", skssqq);
            customParams.put("skssqz", skssqz);
            this.createTaxAmountSplitZLBExcelData(customParams, excelData, hidedSheetList);
            sheetNameMap.put("sheet1", ResManager.loadKDString((String)"\u7a0e\u989d\u8ba1\u7b97\u603b\u89c8\u8868", (String)"TccitDeclarationPlugin_33", (String)"taxc-tccit", (Object[])new Object[0]));
            sheetNameMap.put("sheet2", ResManager.loadKDString((String)"\u7a0e\u989d\u5206\u644a\u603b\u89c8\u8868", (String)"TccitDeclarationPlugin_34", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        String name = ResManager.loadKDString((String)"\u7eb3\u7a0e\u603b\u89c8\u8868", (String)"TccitDeclarationPlugin_35", (String)"taxc-tccit", (Object[])new Object[0]);
        String fileName = draftnumber + "_" + orgName + "_" + skssqq + "\uff5e" + skssqz + "_" + name;
        String urls = ExcelUtils.createExcelFile(excelData, (String)jsonString, (String)fileName, Arrays.asList("tccit_seasonal_calc_det#1", "tccit_seasonal_split_sjjt#1"), sheetNameMap, hidedSheetList);
        String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
        String entityNum = "tccit_seasonal_declare";
        PermissionUtils.putTempFilePermissionCache((String)urls, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
        this.getView().openUrl(urls);
    }

    private Map<String, String> createExcelData(String draftnumber, String orgName, String skssqq, String skssqz) {
        HashMap<String, String> excelData = new HashMap<String, String>(160);
        excelData.put("draftnumber", draftnumber);
        excelData.put("org", orgName);
        excelData.put("skssqq", skssqq);
        excelData.put("skssqz", skssqz);
        IFormView childView = this.getView().getView(this.getPageCache().get("draftPageId"));
        if (childView == null) {
            return null;
        }
        IDataModel childModel = childView.getModel();
        String entryEntityName = this.getPageCache().get("entryEntityName");
        DynamicObjectCollection col = childModel.getEntryEntity(entryEntityName);
        Boolean matchsmall = (Boolean)childModel.getValue("matchsmall");
        BigDecimal peopleavg = (BigDecimal)childModel.getValue("peopleavg");
        BigDecimal assetsavg = (BigDecimal)childModel.getValue("assetsavg");
        excelData.put("businesstype", this.getbusinessTypeName(childView, childModel));
        String yes = ResManager.loadKDString((String)"\u662f", (String)"TccitDeclarationPlugin_36", (String)"taxc-tccit", (Object[])new Object[0]);
        String not = ResManager.loadKDString((String)"\u5426", (String)"TccitDeclarationPlugin_37", (String)"taxc-tccit", (Object[])new Object[0]);
        excelData.put("matchsmall", matchsmall != false ? yes : not);
        excelData.put("peopleavg", DataFormat.formatMicrometer(String.valueOf(peopleavg)));
        excelData.put("assetsavg", DataFormat.formatMicrometer(String.valueOf(assetsavg)));
        int j = 1;
        for (DynamicObject object : col) {
            String itemnoKey = "tccit_seasonal_calc_det_" + j + "_itemno";
            String nameKey = "tccit_seasonal_calc_det_" + j + "_name";
            String sumamountKey = "tccit_seasonal_calc_det_" + j + "_sumamount";
            excelData.put(itemnoKey, object.getString("itemno"));
            excelData.put(nameKey, object.getString("name"));
            excelData.put(sumamountKey, DataFormat.formatMicrometer(object.getString("sumamount")));
            ++j;
        }
        return excelData;
    }

    private Map<String, String> createTaxAmountSplitZLBExcelData(Map<String, Object> customParams, Map<String, String> excelData, List<String> hidenSheetList) {
        customParams.put(DECLARETYPE, this.getPageCache().get(DECLARETYPE));
        customParams.put(LEVY_TYPE, this.getPageCache().get(LEVY_TYPE));
        if (!this.branchCalcPageService.checkBeforeCalcSplit(customParams)) {
            return excelData;
        }
        EngineModel model = new EngineModel(String.valueOf(customParams.get("orgid")), (String)customParams.get("skssqq"), (String)customParams.get("skssqz"));
        List<DynamicObject> branchShareBills = this.apportionService.getBranchShareBills(model);
        if (CollectionUtils.isNotEmpty(branchShareBills) && branchShareBills.get(0).getBoolean("participation")) {
            return excelData;
        }
        hidenSheetList.clear();
        DynamicObject[] splitCollection = this.branchCalcPageService.loadSeasonalSplitSjjtCollection(customParams);
        int i = 1;
        for (DynamicObject dynamicObject : splitCollection) {
            excelData.put("tccit_seasonal_split_sjjt_" + i + "_seq", String.valueOf(i));
            excelData.put("tccit_seasonal_split_sjjt_" + i + "_branchorgid", dynamicObject.getDynamicObject("branchorgid").getString("name"));
            excelData.put("tccit_seasonal_split_sjjt_" + i + "_branchspiltratio", dynamicObject.getBigDecimal("branchspiltratio").compareTo(BigDecimal.ZERO) == 0 ? DataFormat.formatMicrometer(dynamicObject.getString("branchspiltratio")) : dynamicObject.getString("branchspiltratio"));
            excelData.put("tccit_seasonal_split_sjjt_" + i + "_branchybtse", DataFormat.formatMicrometer(dynamicObject.getString("branchybtse")));
            excelData.put("tccit_seasonal_split_sjjt_" + i + "_branchreductionratio", DataFormat.formatMicrometer(dynamicObject.getString("branchreductionratio")));
            excelData.put("tccit_seasonal_split_sjjt_" + i + "_branchreductiontax", DataFormat.formatMicrometer(dynamicObject.getString("branchreductiontax")));
            excelData.put("tccit_seasonal_split_sjjt_" + i + "_sjybtsdse", DataFormat.formatMicrometer(dynamicObject.getString("sjybtsdse")));
            ++i;
        }
        return excelData;
    }

    private String getbusinessTypeName(IFormView childView, IDataModel childModel) {
        String businesstype = (String)childModel.getValue("businesstype");
        ComboEdit comboEdit = (ComboEdit)childView.getControl("businesstype");
        ComboProp property = (ComboProp)comboEdit.getProperty();
        List comboItems = property.getComboItems();
        Optional<String> first = comboItems.stream().filter(e -> businesstype.equals(e.getValue())).map(e -> e.getName().getLocaleValue()).findFirst();
        return first.orElse("");
    }
}

