/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.seasonal.tabselect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

public class ConfiguredTaxReductionPlugin
extends AbstractFormPlugin
implements TabSelectListener,
HyperLinkClickListener {
    private static final String TABAP = "tabap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl("entryentity1");
        entryGrid1.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid2 = (EntryGrid)this.getControl("entryentity2");
        entryGrid2.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid3 = (EntryGrid)this.getControl("entryentity3");
        entryGrid3.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        JSONArray items = (JSONArray)params.get("items");
        HashSet<Long> profitsList = new HashSet<Long>();
        HashSet<Long> incomeList = new HashSet<Long>();
        HashSet<Long> depreciateList = new HashSet<Long>();
        HashSet<Long> yjotherList = new HashSet<Long>();
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                JSONObject item = items.getJSONObject(i);
                String type = item.getString("itemtype");
                Long ruleid = item.getLong("ruleid");
                if (RuleTypeEnum.PROFITS.getName().equals(type)) {
                    profitsList.add(ruleid);
                    continue;
                }
                if (RuleTypeEnum.INCOME.getName().equals(type)) {
                    incomeList.add(ruleid);
                    continue;
                }
                if (RuleTypeEnum.DEPRECIATE.getName().equals(type)) {
                    depreciateList.add(ruleid);
                    continue;
                }
                if (!RuleTypeEnum.YJ_OTHER.getName().equals(type)) continue;
                yjotherList.add(ruleid);
            }
        }
        this.initEntryEntity(profitsList, "tabaccprofitassetliab", "entryentity", RuleTypeEnum.PROFITS.getName());
        this.initEntryEntity(incomeList, "tabpreferentialitem", "entryentity1", RuleTypeEnum.INCOME.getName());
        this.initEntryEntity(depreciateList, "tabassetdepreciationitem", "entryentity2", RuleTypeEnum.DEPRECIATE.getName());
        this.initEntryEntity(yjotherList, "tabotheritem", "entryentity3", RuleTypeEnum.YJ_OTHER.getName());
        this.setVisible(params);
    }

    private void setVisible(Map<String, Object> params) {
        Object declaretype = params.get("declaretype");
        List<String> types = Arrays.asList("210", "220", "230");
        if (!types.contains(String.valueOf(declaretype))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"org", "org1", "org2", "org3"});
        }
    }

    private void initEntryEntity(Set<Long> dataList, String tab, String entryentity, String rule) {
        if (dataList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{tab});
        } else {
            Map<Object, Object> idTypeMap = new HashMap();
            if ("tabpreferentialitem".equals(tab)) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tccit_preferential_item");
                DynamicObject[] ruleObj = BusinessDataServiceHelper.load((Object[])dataList.toArray(), (DynamicObjectType)mainEntityType);
                idTypeMap = Arrays.stream(ruleObj).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getDynamicObject("itemchoicename").getString("projtype")));
            }
            for (Long id : dataList) {
                int row = this.getModel().createNewEntryRow(entryentity);
                this.getModel().setValue(rule, (Object)id, row);
                if (!"tabpreferentialitem".equals(tab)) continue;
                String type = idTypeMap.getOrDefault(id, "");
                this.getModel().setValue("type", (Object)type, row);
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int index = evt.getRowIndex();
        String fieldName = evt.getFieldName();
        DynamicObject ruleObj = (DynamicObject)this.getModel().getValue(fieldName, index);
        long id = ruleObj.getLong("id");
        long orgId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("orgid"));
        HasPermOrgResult allPermOrgs = PermissionUtils.getAllPermOrgs((String)"tccit", (String)"tccit_yj_rule_group", (String)"47150e89000000ac");
        if (!allPermOrgs.hasAllOrgPerm() && !allPermOrgs.getHasPermOrgs().contains(orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u9884\u7f34\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ConfiguredTaxReductionPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(Objects.requireNonNull(RuleTypeEnum.getEntryByName(fieldName)));
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setPkId((Object)id);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }
}

