/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.seasonal.tabselect;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.tccit.business.draft.ApportionService;
import kd.taxc.tccit.business.draft.BranchCalcPageService;
import org.apache.commons.collections.CollectionUtils;

public class SeasonalCalcPageSelectPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String TABAP = "tabap";
    private BranchCalcPageService branchCalcPageService = new BranchCalcPageService();
    private ApportionService apportionService = new ApportionService();
    public static final Map<String, String> tabToPageMap = new HashMap<String, String>(){
        {
            this.put("taxamountcalc", "tccit_seasonal_calc_page");
            this.put("taxamountapportion", "tccit_seasonal_split_page");
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, TABAP);
    }

    public void addTabSelectListener(TabSelectListener form, String ... tabName) {
        for (int i = 0; i < tabName.length; ++i) {
            Tab tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        this.showFormInnerTabPage(evt.getTabKey());
    }

    private void showFormInnerTabPage(String tbName) {
        String flag = "loadtb-" + tbName;
        String id = this.getPageCache().get(flag);
        String zlbChanged = this.getPageCache().get("zlbChanged");
        if (id == null || zlbChanged != null) {
            FormShowParameter parameter = new FormShowParameter();
            String pageId = parameter.getPageId();
            parameter.setFormId(tabToPageMap.get(tbName));
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey(tbName);
            parameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
            parameter.setStatus(this.getView().getFormShowParameter().getStatus());
            this.getView().showForm(parameter);
            this.getPageCache().put(flag, pageId);
            this.getPageCache().remove("zlbChanged");
        } else {
            this.getView().sendFormAction(this.getView().getView(id));
        }
    }

    public void afterCreateNewData(EventObject e) {
        EngineModel model;
        List<DynamicObject> branchShareBills;
        Tab tab = (Tab)this.getControl(TABAP);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean taxAmountApportionStatus = !this.branchCalcPageService.checkBeforeCalcSplitWithoutBillStatus(customParams);
        if (taxAmountApportionStatus.booleanValue() && CollectionUtils.isNotEmpty(branchShareBills = this.apportionService.getBranchShareBills(model = new EngineModel(String.valueOf(customParams.get("orgid")), (String)customParams.get("skssqq"), (String)customParams.get("skssqz"))))) {
            taxAmountApportionStatus = !branchShareBills.get(0).getBoolean("participation");
        }
        this.getView().setVisible(taxAmountApportionStatus, new String[]{"taxamountapportion"});
        this.showFormInnerTabPage(tab.getCurrentTab());
    }
}

