/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang.StringUtils;

public class AssetDisposeList
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final String ASSET_TYPE_NAME = "assettype.projectname";
    private static final String INVEST_TYPE_NAME = "investtype.projectname";
    private static final String TRANS_TYPE_NAME = "transtype.projectname";
    private static final String ASSET_LOSS_TYPE_NAME = "assetlosstype.name";
    private static final String INVESY_NAME = "name.name";
    private static final String ASSET_TYPE_ID = "assettype.id";
    private static final String INVEST_TYPE_ID = "investtype.id";
    private static final String TRANS_TYPE_ID = "transtype.id";
    private static final String PROJECT_NAME = "projectname";
    private static final String ASSET_TYPE_PARENT_NUM = "1";
    private static final String INVEST_TYPE_PARENT_NUM = "2";
    private static final String PARENT_NUMBER = "parent.number";
    private static final String TCCIT_BIZDEF_ENTRY = "tpo_tccit_bizdef_entry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.setTccitBizDefFilterComboItems(args, ASSET_TYPE_NAME, ASSET_TYPE_PARENT_NUM);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent bffe) {
        String fieldName;
        switch (fieldName = bffe.getFieldName()) {
            case "assettype.id": 
            case "assettype.projectname": {
                bffe.addCustomParam("caption", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u578b", (String)"AssetDisposeList_0", (String)"taxc-tccit", (Object[])new Object[0]));
                bffe.setQfilters(Collections.singletonList(new QFilter(PARENT_NUMBER, "=", (Object)ASSET_TYPE_PARENT_NUM)));
                break;
            }
            case "investtype.id": 
            case "investtype.projectname": {
                bffe.addCustomParam("caption", (Object)ResManager.loadKDString((String)"\u6295\u8d44\u6027\u8d28", (String)"AssetDisposeList_1", (String)"taxc-tccit", (Object[])new Object[0]));
                bffe.setQfilters(Collections.singletonList(new QFilter(PARENT_NUMBER, "=", (Object)INVEST_TYPE_PARENT_NUM)));
                break;
            }
            case "transtype.id": 
            case "transtype.projectname": {
                bffe.addCustomParam("parentNum", (Object)"3");
                bffe.addCustomParam("caption", (Object)ResManager.loadKDString((String)"\u6295\u8d44\u8d44\u4ea7\u5904\u7f6e\u4ea4\u6613\u7c7b\u578b", (String)"AssetDisposeList_2", (String)"taxc-tccit", (Object[])new Object[0]));
                break;
            }
            case "assetlosstype.name": {
                bffe.addCustomParam("startdate", (Object)new Date());
                bffe.addCustomParam("enddate", (Object)DateUtils.stringToDate((String)"2021-01-07 00:00:00"));
                bffe.addCustomParam("pnumber", Arrays.asList("7010308", "701030801", "70103080101", "70103080102", "70103080103", "70103080104", "70103080105", "701030802", "7010309", "701030901", "701030902", "7010310", "7010311", "7010312"));
                break;
            }
            case "name.name": {
                bffe.addCustomParam("caption", (Object)ResManager.loadKDString((String)"\u6295\u8d44\u6807\u7684\u540d\u79f0", (String)"AssetDisposeList_3", (String)"taxc-tccit", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"delete", (String)callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            ListSelectedRowCollection collection = ((IListView)this.getView()).getSelectedRows();
            List bizNos = collection.stream().map(ListSelectedRow::getBillNo).collect(Collectors.toList());
            DeleteServiceHelper.delete((String)billFormId, (QFilter[])new QFilter[]{new QFilter("billno", "in", bizNos)});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AssetDisposeList_4", (String)"taxc-tccit", (Object[])new Object[0]));
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.clearSelection();
            billlist.refreshData();
        }
    }

    private void setTccitBizDefFilterComboItems(FilterContainerInitArgs args, String fieldName, String parentNum) {
        CommonFilterColumn cfc = (CommonFilterColumn)args.getFilterColumn(fieldName);
        QFilter parentFilter = new QFilter(PARENT_NUMBER, "=", (Object)parentNum);
        DynamicObjectCollection assetType = QueryServiceHelper.query((String)TCCIT_BIZDEF_ENTRY, (String)"id,projectname", (QFilter[])new QFilter[]{parentFilter}, (String)"number");
        List collect = assetType.stream().map(at -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(String.valueOf(at.getLong("id")));
            comboItem.setCaption(new LocaleString(at.getString(PROJECT_NAME)));
            return comboItem;
        }).collect(Collectors.toList());
        cfc.setComboItems(collect);
    }
}

