/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.draft.AcceDiffService;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class AssetLossPreTaxEdit
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    private static final String ASSET_LOSS_TYPE = "assetlosstype";
    private static final String ASSET_NO = "assetno";
    private static final String ACCOUNTORG = "accountorg";
    private static final String ORG = "org";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit type = (BasedataEdit)this.getView().getControl(ASSET_LOSS_TYPE);
        type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit assetNo = (BasedataEdit)this.getView().getControl(ASSET_NO);
        assetNo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountorg = (BasedataEdit)this.getView().getControl(ACCOUNTORG);
        accountorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        BasedataEdit source = (BasedataEdit)event.getSource();
        switch (fieldKey = source.getFieldKey()) {
            case "assetlosstype": {
                this.assetLossTypeF7(event);
                break;
            }
            case "assetno": {
                event.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801", (String)"AssetLossPreTaxEdit_0", (String)"taxc-tccit", (Object[])new Object[0]));
                if (this.getModel().getValue(ACCOUNTORG) != null) {
                    String orgNumber = ((DynamicObject)this.getModel().getValue(ACCOUNTORG)).getString("number");
                    event.addCustomQFilter(new QFilter("taxorg.number", "=", (Object)orgNumber));
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6838\u7b97\u7ec4\u7ec7", (String)"AssetLossPreTaxEdit_1", (String)"taxc-tccit", (Object[])new Object[0]));
                event.setCancel(true);
                break;
            }
            case "accountorg": {
                if (this.getModel().getValue(ORG) != null) {
                    Date now = new Date();
                    DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
                    List accountOrgs = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(org.getLong("id")), (Date)now, (Date)now);
                    ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter().getShowParameter();
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)accountOrgs));
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7a0e\u52a1\u7ec4\u7ec7", (String)"AssetLossPreTaxEdit_3", (String)"taxc-tccit", (Object[])new Object[0]));
                event.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObject org;
        String name = args.getProperty().getName();
        if (ASSET_NO.equals(name)) {
            DynamicObject assetNos = (DynamicObject)args.getChangeSet()[0].getNewValue();
            if (assetNos == null) {
                this.getModel().setValue("cleanupdate", (Object)"");
                this.getModel().setValue("assetorigin", (Object)"");
                this.getModel().setValue("ljjszjtxe", (Object)"");
                this.getModel().setValue("jszjqc", (Object)"");
                this.getModel().setValue("name", (Object)"");
                this.getModel().setValue("zctype", (Object)"");
                return;
            }
            String assetcode = assetNos.getString("assetcode");
            String assetname = assetNos.getString("assetname");
            String assetsvalue = assetNos.getString("assetsvalue");
            long tarOrgId = assetNos.getDynamicObject("taxorg").getLong("masterid");
            Date cleaningdate = assetNos.getDate("cleaningdate");
            DynamicObject zjData = AcceDiffService.getAcceDiff(assetcode, tarOrgId);
            this.getModel().setValue("cleanupdate", (Object)cleaningdate);
            if (zjData != null) {
                this.getModel().setValue("assetorigin", (Object)zjData.getString("assetsvalue"));
                this.getModel().setValue("ljjszjtxe", (Object)zjData.getString("swjsljzjtxe"));
                this.getModel().setValue("jszjqc", (Object)zjData.getString("acceleratedepretype"));
                this.getModel().setValue("name", (Object)zjData.getString("assetsname"));
                this.getModel().setValue("zctype", (Object)zjData.getString("zctype"));
            } else {
                this.getModel().setValue("assetorigin", (Object)assetsvalue);
                this.getModel().setValue("name", (Object)assetname);
            }
        }
        if (ACCOUNTORG.equals(name)) {
            this.getModel().setValue(ASSET_NO, null);
        }
        if (ORG.equals(name) && (org = (DynamicObject)args.getChangeSet()[0].getNewValue()) == null) {
            this.getModel().setValue(ACCOUNTORG, null);
        }
    }

    private void assetLossTypeF7(BeforeF7SelectEvent bfse) {
        FormShowParameter fsp = bfse.getFormShowParameter();
        fsp.setCaption(ResManager.loadKDString((String)"\u8d44\u4ea7\u635f\u5931\u7c7b\u578b", (String)"AssetLossPreTaxEdit_2", (String)"taxc-tccit", (Object[])new Object[0]));
        fsp.setCustomParam("startdate", (Object)new Date());
        fsp.setCustomParam("enddate", (Object)DateUtils.stringToDate((String)"2021-01-07 00:00:00"));
    }
}

