/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class AssetLossPreTaxList
extends AbstractListPlugin {
    private static final String TOOLBARAP = "toolbarap";
    private static final String BILLLISTAP = "billlistap";
    private static final String RECORD_TYPE = "recordtype";
    private static final String ASSET_LOSS = "selectedAssetLoss";
    private static final String ASSET_LOSS_MAP = "tpo_assetlossmap_tree";
    private static final String ASSET_LOSS_PRE_TAX = "tccit_asset_loss_pre_tax";
    private static final String SYNCDATA_KEY = "syncdata";
    private static final String ENTITY = "tccit_asset_loss_syncdata";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key = evt.getOperateKey();
        if ("tblzcsslx".equals(key)) {
            BillList billlist = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)list)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"AssetLossPreTaxList_0", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)ASSET_LOSS_MAP, (boolean)false, (int)0);
            showParameter.setCaption(ResManager.loadKDString((String)"\u8d44\u4ea7\u635f\u5931\u7c7b\u578b", (String)"AssetLossPreTaxList_1", (String)"taxc-tccit", (Object[])new Object[0]));
            showParameter.setCustomParam("startdate", (Object)new Date());
            showParameter.setCustomParam("enddate", (Object)DateUtils.stringToDate((String)"2021-01-07 00:00:00"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ASSET_LOSS));
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (SYNCDATA_KEY.equals(key)) {
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("customCaption", ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e", (String)"AssetLossPreTaxList_2", (String)"taxc-tccit", (Object[])new Object[0]));
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)ENTITY, (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (ASSET_LOSS.equals(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
            if (null != returnData) {
                Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
                DynamicObject assetLossMap = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ASSET_LOSS_MAP));
                String recordType = assetLossMap.getString(RECORD_TYPE);
                BillList billlist = (BillList)this.getControl(BILLLISTAP);
                ListSelectedRowCollection list = billlist.getSelectedRows();
                Object[] keys = list.getPrimaryKeyValues();
                DynamicObject[] records = BusinessDataServiceHelper.load((Object[])keys, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ASSET_LOSS_PRE_TAX));
                Arrays.stream(records).peek(i -> i.set(RECORD_TYPE, (Object)recordType)).forEach(i -> i.set("assetlosstype", primaryKeyValue));
                SaveServiceHelper.update((DynamicObject[])records);
                billlist.clearSelection();
                billlist.refresh();
            }
        } else if ("taskcloseback".equals(evt.getActionId()) && EmptyCheckUtils.isNotEmpty((Object)evt.getReturnData())) {
            TaskInfo taskInfo;
            Map result;
            String taskInfoStr;
            Object returnData = evt.getReturnData();
            if (returnData instanceof Map && StringUtil.isNotBlank((CharSequence)(taskInfoStr = (String)(result = (Map)returnData).get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String data = taskInfo.getData();
                Map customs = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                String message = (String)customs.get("message");
                this.getView().showMessage(message);
            }
            BillList billlist = (BillList)this.getControl(BILLLISTAP);
            billlist.refresh();
        }
    }
}

