/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.taxbook.BranchShareDialogService;

public class BranchShareDialogPlugin
extends AbstractFormPlugin {
    private static final String ENTITY_NAME = "tccit_branch_share_bill";
    private static BranchShareDialogService branchShareDialogService = new BranchShareDialogService();

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(s -> this.packageData((PackageDataEvent)s));
    }

    public void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        String key = columnDesc.getKey();
        DynamicObject d = e.getRowData();
        if ("taxpayer".equals(key) && Objects.equals("0", d.get("hbfnszt"))) {
            String msg = String.format(ResManager.loadKDString((String)"%s\uff08\u72ec\u7acb\u751f\u4ea7\u7ecf\u8425\u90e8\u95e8\uff09", (String)"BranchShareDialogPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), d.getString("org.name"));
            e.setFormatValue((Object)msg);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        FormShowParameter parameter = args.getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        String caption = (String)customParams.get("caption");
        parameter.setCaption(caption);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancel", "btok"});
    }

    public void afterCreateNewData(EventObject evt) {
        OperationResult operationResult;
        List allErrorInfo;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String text = (String)customParams.get("text");
        Label labelap = (Label)this.getControl("labelap");
        labelap.setText(text);
        String periodStr = (String)customParams.get("period");
        Date period = DateUtils.stringToDate((String)periodStr);
        this.getModel().setValue("period", (Object)period);
        String operateKey = (String)customParams.get("operateKey");
        if ("datacollect".equals(operateKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"income", "salary", "asset", "billstatus"});
        }
        this.getModel().clearNoDataRow();
        JSONArray pkids = (JSONArray)customParams.get("pkids");
        String selectFields = "id,org,unifiedsocialcode,taxoffice,sumscheme,declaration,period,income,salary,asset,sharerate,billstatus,auditor,auditdate,datasource,shareid,datastatus,nsrmc,taxorg,billno,hbfnszt,orgname,participation,operator,operatetime,refreshtime,initsharerate,org_id,taxoffice_id,sumscheme_id,auditor_id,taxorg_id";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)}, (String)"declaration");
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(bills.length);
        billList.addAll(Arrays.asList(bills));
        JSONObject optResult = (JSONObject)customParams.get("operationResult");
        if (optResult != null && (allErrorInfo = (operationResult = (OperationResult)optResult.toJavaObject(OperationResult.class)).getAllErrorInfo()).size() > 0) {
            this.getView().showOperationResult(operationResult);
        }
        if (billList.size() > 0) {
            this.setData(billList);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        String key = source.getKey();
        if ("cancel".equals(key)) {
            this.getView().close();
        } else if ("btok".equals(key)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
            StringBuilder sb = new StringBuilder();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String operateKey = (String)customParams.get("operateKey");
            if ("datacollect".equals(operateKey)) {
                for (DynamicObject dyo : entryentity) {
                    String datastatus = dyo.getString("datastatus");
                    if (!"1".equals(datastatus)) continue;
                    String hbfnszt = dyo.getString("hbfnszt");
                    if (Objects.equals("0", hbfnszt)) {
                        sb.append(ResManager.loadKDString((String)"\u72ec\u7acb\u751f\u4ea7\u7ecf\u8425\u90e8\u95e8", (String)"BranchShareDialogPlugin_1", (String)"taxc-tccit", (Object[])new Object[0])).append("\u3001");
                        continue;
                    }
                    sb.append(dyo.getString("taxorg.taxpayer")).append("\u3001");
                }
                if (sb.length() > 0) {
                    Date period = (Date)model.getValue("period");
                    String yyyy = DateUtils.format((Date)period, (String)"yyyy");
                    String confirmMsg = String.format(ResManager.loadKDString((String)"%1$s\u5728%2$s\u5e74\u5df2\u751f\u6210\u6570\u636e\uff0c\u91cd\u65b0\u91c7\u96c6\u5c06\u4f1a\u8986\u76d6\u5f53\u524d\u6570\u636e\uff0c\u662f\u5426\u9700\u8981\u91cd\u65b0\u91c7\u96c6\uff1f", (String)"BranchShareDialogPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), sb.substring(0, sb.length() - 1), yyyy);
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("datacollect", (IFormPlugin)this);
                    this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, confirmCallBackListener);
                } else {
                    this.runEngine();
                    this.getView().returnDataToParent((Object)true);
                    this.getView().close();
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if ("datacollect".equals(callBackId)) {
            if (MessageBoxResult.Cancel.getValue() == result.getValue()) {
                this.getView().close();
            } else {
                this.runEngine();
                this.getView().returnDataToParent((Object)true);
                this.getView().close();
            }
        }
    }

    private void setData(List<DynamicObject> billList) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", billList.size());
        for (int i = 0; i < billList.size(); ++i) {
            DynamicObject entry = billList.get(i);
            model.setValue("billid", entry.get("id"), i);
            model.setValue("org", entry.get("org"), i);
            model.setValue("taxorg", entry.get("taxorg"), i);
            model.setValue("sumschemename", (Object)entry.getDynamicObject("sumscheme").getString("name"), i);
            model.setValue("declaration", entry.get("declaration"), i);
            model.setValue("shareid", entry.get("shareid"), i);
            model.setValue("income", entry.get("income"), i);
            model.setValue("salary", entry.get("salary"), i);
            model.setValue("asset", entry.get("asset"), i);
            model.setValue("datastatus", entry.get("datastatus"), i);
            model.setValue("hbfnszt", entry.get("hbfnszt"), i);
            model.setValue("sumschemeid", (Object)entry.getDynamicObject("sumscheme").getLong("id"), i);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void runEngine() {
        IDataModel model = this.getModel();
        Date period = (Date)model.getValue("period");
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        branchShareDialogService.save(period, entryentity);
    }
}

