/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class BranchShareImportPlugin
extends BatchImportPlugin {
    private static Log logger = LogFactory.getLog(BranchShareImportPlugin.class);
    private static final String ENTITY_NAME = "tccit_branch_share_bill";
    private static final String PERIOD = "period";
    private static final String ORG = "org";
    private static final String INCOME = "income";
    private static final String SALARY = "salary";
    private static final String ASSET = "asset";
    private static final String NUMBER = "number";
    private static final Map<String, String> AMOUNT_CHECK = new HashMap<String, String>();

    public String getDefaultImportType() {
        return "override";
    }

    public String getDefaultKeyFields() {
        return "id";
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Map option = this.ctx.getOption();
        if (!option.get("importtype").toString().equals("override")) {
            return this.mockResult(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6dfb\u52a0\u65b0\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u66f4\u65b0\u5df2\u6709\u6570\u636e\u3002", (String)"BranchShareImportPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            StringBuilder message = new StringBuilder();
            ImportBillData data = it.next();
            this.validBillData(data, message);
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                logger.log(Integer.valueOf(data.getStartIndex()), message.toString()).fail();
                it.remove();
            }
            data.getData().put("datasource", (Object)"3");
            data.getData().put("datastatus", (Object)"1");
            RequestContext context = RequestContext.get();
            data.getData().put("operator", (Object)context.getUserName());
            data.getData().put("operatetime", (Object)DateUtils.formatHMS((Date)new Date()));
        }
        return super.save(rowdatas, logger);
    }

    private void validBillData(ImportBillData data, StringBuilder message) {
        if (data == null || CollectionUtils.isEmpty((Map)data.getData())) {
            return;
        }
        this.checkOrgAndPeriod(data, message);
        this.checkAmount(data, message, SALARY);
    }

    private void checkAmount(ImportBillData data, StringBuilder message, String key) {
        QFilter periodFilter;
        BigDecimal amount = data.getData().getBigDecimal(key);
        if (amount.compareTo(BigDecimal.ZERO) < 0) {
            BranchShareImportPlugin.appendMsg(message, AMOUNT_CHECK.get(key));
        }
        Date period = data.getData().getDate(PERIOD);
        JSONObject org = data.getData().getJSONObject(ORG);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)org.getString(NUMBER));
        if (!result.isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData())) {
            return;
        }
        DynamicObject taxMain = (DynamicObject)result.getData();
        QFilter orgFilter = new QFilter(ORG, "=", (Object)taxMain.getLong("taxorg.id"));
        DynamicObject obj = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"billstatus,declaration,participation", (QFilter[])new QFilter[]{orgFilter, periodFilter = new QFilter(PERIOD, "=", (Object)period)});
        if (obj == null) {
            return;
        }
        if ("2".equals(obj.getString("declaration")) && "false".equals(obj.getString("participation"))) {
            BranchShareImportPlugin.appendMsg(message, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7%s\u4e3a\u603b\u673a\u6784\uff0c\u65e0\u9700\u5f15\u5165\u6570\u636e", (String)"BranchShareImportPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), org.get((Object)NUMBER)));
        }
    }

    private void checkOrgAndPeriod(ImportBillData data, StringBuilder message) {
        JSONObject org = data.getData().getJSONObject(ORG);
        Date period = data.getData().getDate(PERIOD);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)org.getString(NUMBER));
        if (!result.isSuccess()) {
            BranchShareImportPlugin.appendMsg(message, result.getMessage());
            return;
        }
        if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
            BranchShareImportPlugin.appendMsg(message, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728,\u7f16\u7801%s", (String)"BranchShareImportPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), org.get((Object)NUMBER)));
            return;
        }
        DynamicObject taxMain = (DynamicObject)result.getData();
        QFilter orgFilter = new QFilter(ORG, "=", (Object)taxMain.getLong("taxorg.id"));
        QFilter periodFilter = new QFilter(PERIOD, "=", (Object)period);
        if (!QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{orgFilter, periodFilter})) {
            BranchShareImportPlugin.appendMsg(message, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7%1$s\uff0c\u6240\u5c5e\u7a0e\u671f%2$s\uff0c\u5728\u5206\u652f\u673a\u6784\u7a0e\u6b3e\u5206\u644a\u56e0\u7d20\u53f0\u8d26\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u67e5\u8be2\u53f0\u8d26\u751f\u6210\u7ec4\u7ec7\u548c\u7a0e\u671f\u6570\u636e", (String)"BranchShareImportPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]), org.get((Object)NUMBER), period));
        }
        if (!period.equals(DateUtils.getFirstDateOfYear((Date)period))) {
            BranchShareImportPlugin.appendMsg(message, ResManager.loadKDString((String)"\u8bf7\u586b\u5217\u6bcf\u5e74\u76841\u67081\u65e5", (String)"BranchShareImportPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]));
        }
    }

    private static void appendMsg(StringBuilder errors, String msg) {
        errors.append(msg).append("\n");
    }

    private ApiResult mockResult(String resultData) {
        ApiResult result = new ApiResult();
        result.setMessage(resultData);
        result.setSuccess(false);
        return result;
    }

    static {
        AMOUNT_CHECK.put(SALARY, ResManager.loadKDString((String)"\u804c\u5de5\u85aa\u916c\uff1a\u91d1\u989d\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"BranchShareImportPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
    }
}

