/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.taxbook.BranchShareDialogService;
import kd.taxc.tccit.business.taxbook.BranchShareServiceHelper;
import kd.taxc.tccit.business.taxbook.BranchTaxbookBusinessService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

public class BranchShareListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(BranchShareListPlugin.class);
    private static final String PERIOD = "period";
    private static final String NODEIDS = "nodeIds";
    private static final String IS_ROOT = "isRoot";
    private static final String FILTERORG = "filterOrg";
    private static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    private static final String BRANCH_SHARE_DIALOG = "tccit_branch_share_dialog";
    private static final String TCCIT_SHARERATE_ADJUST = "tccit_sharerate_adjust";
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private Map<String, String> ITEMNUMBERMAP = new HashMap<String, String>(){
        {
            this.put("asset", "2021-SWTZ-ZFJGSYS-0001");
            this.put("asset_", "2021-SWTZ-ZFJGSYS-0001_");
            this.put("income", "2021-SWTZ-ZFJGSYS-0002");
            this.put("income_", "2021-SWTZ-ZFJGSYS-0002_");
            this.put("salary", "2021-SWTZ-ZFJGSYS-0003");
            this.put("salary_", "2021-SWTZ-ZFJGSYS-0003_");
        }
    };
    private final List<String> workFlowOperationList = Arrays.asList("submit", "unsubmit", "audit", "unaudit");
    private static BranchShareDialogService branchShareDialogService = new BranchShareDialogService();

    public void initialize() {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.addPackageDataListener(this::packageData);
    }

    public void afterCreateNewData(EventObject evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String nodeIds = (String)customParams.get(NODEIDS);
        String periodStr = (String)customParams.get(PERIOD);
        Boolean isRoot = (Boolean)customParams.get(IS_ROOT);
        this.getPageCache().put(NODEIDS, nodeIds);
        this.getPageCache().put(PERIOD, periodStr);
        if (customParams.get(FILTERORG) != null) {
            this.getPageCache().put(FILTERORG, (String)customParams.get(FILTERORG));
        }
        if (isRoot != null) {
            this.getPageCache().put(IS_ROOT, isRoot.toString());
        }
    }

    public void setFilter(SetFilterEvent e) {
        List eQFilters = e.getQFilters();
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        ListView source = (ListView)e.getSource();
        ListSelectedRowCollection selectedRows = source.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            QFilter[] filters1 = e.getFilters();
            ArrayList filters = filters1 != null ? this.getqFilters(Arrays.stream(filters1).collect(Collectors.toList())) : new ArrayList();
            e.setFilters(filters.toArray(new QFilter[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String nodeIds = this.getPageCache().get(NODEIDS);
        String periodStr = this.getPageCache().get(PERIOD);
        if (StringUtil.isBlank((CharSequence)nodeIds) || StringUtil.isBlank((CharSequence)periodStr)) {
            args.setCancel(true);
            return;
        }
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("datacollect".equals(operateKey)) {
            this.doDataCollect(nodeIds, periodStr, operateKey);
        } else if (this.workFlowOperationList.contains(operateKey)) {
            this.filterSelectedRows(args);
            if (EmptyCheckUtils.isEmpty((Object)args.getListSelectedData())) {
                args.setCancel(true);
            } else {
                super.beforeDoOperation(args);
            }
        } else {
            super.beforeDoOperation(args);
        }
    }

    private void filterSelectedRows(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tccit_branch_share_bill", (String)"id,declaration,participation", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        Map<Long, DynamicObject> map = collection.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d, (k, v) -> k));
        listSelectedData.removeIf(row -> {
            DynamicObject bill = (DynamicObject)map.get(row.getPrimaryKeyValue());
            if (bill != null) {
                String declaration = bill.getString("declaration");
                boolean participation = bill.getBoolean("participation");
                if ("2".equals(declaration) && !participation) {
                    return true;
                }
            }
            return false;
        });
    }

    private void doDataCollect(String nodeIds, String periodStr, String operateKey) {
        if (StringUtil.isBlank((CharSequence)nodeIds) || StringUtil.isBlank((CharSequence)periodStr)) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        Object[] pkids = billList.getSelectedRows().getPrimaryKeyValues();
        String selectFields = "id,org,unifiedsocialcode,taxoffice,sumscheme,declaration,period,income,salary,asset,sharerate,billstatus,auditor,auditdate,datasource,shareid,datastatus,nsrmc,taxorg,billno,hbfnszt,orgname,participation,operator,operatetime,refreshtime,initsharerate,org_id,taxoffice_id,sumscheme_id,auditor_id,taxorg_id";
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"tccit_branch_share_bill", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkids)}, (String)"declaration");
        OperationResult operationResult = new OperationResult();
        operationResult.setBillCount(bills.length);
        ArrayList<DynamicObject> showBillList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            if (!this.validate(operationResult, bill)) continue;
            showBillList.add(bill);
            operationResult.getSuccessPkIds().add(bill.getPkValue());
        }
        List allErrorInfo = operationResult.getAllErrorInfo();
        if (showBillList.size() == 0) {
            if (allErrorInfo.size() > 0) {
                this.getView().getParentView().showOperationResult(operationResult);
            } else {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u91c7\u96c6\u6570\u636e\u7684\u7ec4\u7ec7", (String)"BranchShareListPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]));
            }
            return;
        }
        BranchShareServiceHelper.addDataCollectLog(showBillList);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("caption", ResManager.loadKDString((String)"\u5206\u652f\u673a\u6784\u4e09\u56e0\u7d20\u6570\u636e\u91c7\u96c6", (String)"BranchShareListPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
        customParams.put("text", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5df2\u52fe\u9009\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff1a", (String)"BranchShareListPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
        customParams.put("operateKey", operateKey);
        customParams.put("pkids", showBillList.stream().map(b -> b.get("id")).collect(Collectors.toList()));
        customParams.put(PERIOD, periodStr);
        customParams.put("operationResult", operationResult);
        PageShowCommon.showForm((OperationStatus)OperationStatus.VIEW, (ShowType)ShowType.Modal, (String)BRANCH_SHARE_DIALOG, (IFormView)this.getView(), (Map)customParams, (IFormPlugin)this);
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc = (ColumnDesc)e.getSource();
        String key = columnDesc.getKey();
        DynamicObject d = e.getRowData();
        if ("income".equals(key) || "salary".equals(key) || "asset".equals(key) || "sharerate".equals(key) || "billstatus".equals(key)) {
            boolean participation = d.getBoolean("participation");
            String declaration = d.getString("declaration");
            if ("2".equals(declaration) && !participation) {
                e.setNoLinkKey(Arrays.asList("income", "salary", "asset", "sharerate"));
                e.setFormatValue((Object)"*");
            }
        }
        if ("datasource".equals(key) && "3".equals(e.getRowData().getString("datasource"))) {
            e.getNoLinkKey().addAll(Arrays.asList("income", "salary", "asset"));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public void setListFields(List<ListField> listFields) {
                ListField declaration = new ListField("org");
                declaration.setListFieldKey("org");
                declaration.setFieldName("org");
                declaration.setEntityName("tccit_branch_share_bill");
                listFields.add(declaration);
                ListField participation = new ListField("orgname");
                participation.setListFieldKey("orgname");
                participation.setFieldName("orgname");
                participation.setEntityName("tccit_branch_share_bill");
                listFields.add(participation);
                ListField hbfnszt = new ListField("hbfnszt");
                hbfnszt.setListFieldKey("hbfnszt");
                hbfnszt.setFieldName("hbfnszt");
                hbfnszt.setEntityName("tccit_branch_share_bill");
                listFields.add(hbfnszt);
                super.setListFields(listFields);
            }

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                for (DynamicObject datum : data) {
                    if (Objects.equals("0", datum.get("hbfnszt"))) continue;
                    datum.set("orgname", datum.get("org.name"));
                }
                return data;
            }

            public List<QFilter> getQFilters() {
                List qFilters = super.getQFilters();
                return BranchShareListPlugin.this.getqFilters(qFilters);
            }
        });
    }

    public List<QFilter> getqFilters(List<QFilter> qFilters) {
        String nodeIds = this.getPageCache().get(NODEIDS);
        String periodStr = this.getPageCache().get(PERIOD);
        String isRoot = this.getPageCache().get(IS_ROOT);
        if (StringUtil.isBlank((CharSequence)nodeIds) || StringUtil.isBlank((CharSequence)periodStr)) {
            QFilter id = new QFilter("id", "=", (Object)0L);
            qFilters.add(id);
            return qFilters;
        }
        List<Long> collect = Arrays.stream(nodeIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        DynamicObject[] orgGroups = BranchTaxbookBusinessService.queryOrgGroup(collect);
        boolean findOrg = false;
        ArrayList<Long> orgIdList = new ArrayList<Long>(16);
        if (orgGroups != null && orgGroups.length > 0 && this.getView().getParentView() != null) {
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView().getParentView());
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            for (DynamicObject orgGroup : orgGroups) {
                DynamicObjectCollection orgrows = orgGroup.getDynamicObjectCollection("orgrow");
                for (DynamicObject orgrow : orgrows) {
                    DynamicObject org = orgrow.getDynamicObject("orgid");
                    long orgId = org.getLong("id");
                    if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgs.contains(orgId)) continue;
                    orgIdList.add(orgId);
                }
            }
            if (!"true".equals(isRoot)) {
                qFilters.add(new QFilter("sumscheme", "in", collect));
            }
        }
        QFilter org = new QFilter("org", "in", orgIdList);
        qFilters.add(org);
        Date period = DateUtils.stringToDate((String)periodStr);
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)period);
        QFilter periodFilter = new QFilter(PERIOD, ">=", (Object)firstDateOfYear).and(PERIOD, "<=", (Object)lastDateOfYear);
        qFilters.add(periodFilter);
        QFilter isShareFilter = new QFilter("shareid", "=", (Object)"true");
        qFilters.add(isShareFilter);
        QFilter usableFilter = new QFilter("usable", "=", (Object)"1");
        qFilters.add(usableFilter);
        this.filterHandle(qFilters);
        return qFilters;
    }

    private void filterHandle(List<QFilter> qFilters) {
        for (QFilter qFilter : qFilters) {
            if (!"orgname".equals(qFilter.getProperty())) continue;
            qFilter.or(new QFilter("org.name", "like", qFilter.getValue()));
        }
    }

    private void toShareRateUpdate(HyperLinkClickArgs args) {
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow row = list.getCurrentSelectedRowInfo();
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"tccit_branch_share_bill");
        BigDecimal sharerate = dyo.getBigDecimal("sharerate");
        BigDecimal initsharerate = dyo.getBigDecimal("initsharerate");
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("sharerate", sharerate);
        customParams.put("initsharerate", initsharerate);
        customParams.put("id", row.getPrimaryKeyValue());
        FormShowParameter param = new FormShowParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "sharerate");
        param.setCloseCallBack(closeCallBack);
        param.setFormId(TCCIT_SHARERATE_ADJUST);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.NonModal);
        this.getView().showForm(param);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String nodeIds = this.getPageCache().get(NODEIDS);
        String periodStr = this.getPageCache().get(PERIOD);
        if (StringUtil.isBlank((CharSequence)nodeIds) || StringUtil.isBlank((CharSequence)periodStr)) {
            return;
        }
        Date period = DateUtils.stringToDate((String)periodStr);
        period = DateUtils.addYear((Date)period, (int)-1);
        Date skssqq = DateUtils.getFirstDateOfYear((Date)period);
        Date skssqz = DateUtils.getLastDateOfYear((Date)period);
        BillList billList = (BillList)this.getControl("billlistap");
        Object focusRowPkId = billList.getFocusRowPkId();
        this.getPageCache().put("detailId", String.valueOf(focusRowPkId));
        String fieldName = args.getFieldName();
        if (fieldName.equals("sharerate")) {
            this.toShareRateUpdate(args);
            return;
        }
        if (fieldName.endsWith("str")) {
            fieldName = fieldName.substring(0, fieldName.lastIndexOf("str"));
        }
        this.getPageCache().put("fieldName", fieldName);
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"tccit_branch_share_bill");
        customParams.put("orgid", dyo.getString("org.id"));
        customParams.put(RuleTypeEnum.STANDBOOK.getName(), "1");
        if (Objects.equals("0", dyo.get("hbfnszt"))) {
            List<Long> independentAndSubOrg = branchShareDialogService.getIndependentAndSubOrg(dyo.get("sumscheme.id"), skssqq);
            independentAndSubOrg.add(0L);
            customParams.put("orgList", independentAndSubOrg);
            customParams.put("hbfnszt", dyo.getString("hbfnszt"));
        }
        if ("2".equals(dyo.getString("declaration"))) {
            List<Long> zjgFtzzList = branchShareDialogService.getZjgFtzzList(dyo.get("sumscheme.id"), skssqq);
            customParams.put("orgList", zjgFtzzList);
        }
        customParams.put("declaration", dyo.getString("declaration"));
        customParams.put("skssqq", DateUtils.format((Date)skssqq));
        customParams.put("skssqz", DateUtils.format((Date)skssqz));
        customParams.put("columnType", fieldName);
        customParams.put("entrytype", fieldName);
        customParams.put("itemnumber", this.ITEMNUMBERMAP.get(fieldName));
        customParams.put("entryname", "tccit_branch_share_detail");
        String billstatus = dyo.getString("billstatus");
        customParams.put("billstatus", billstatus);
        boolean notEditAble = "B".equals(billstatus) || "C".equals(billstatus);
        OperationStatus operationStatus = notEditAble ? OperationStatus.VIEW : OperationStatus.EDIT;
        customParams.put("showNotEditableTips", notEditAble);
        PageShowCommon.showForm((OperationStatus)operationStatus, (ShowType)ShowType.Floating, (String)TCCIT_DETAIL_TZ_DIALOG, (IFormView)this.getView(), (Map)customParams, (IFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        BigDecimal sumRate;
        String actionId = evt.getActionId();
        if (TCCIT_DETAIL_TZ_DIALOG.equals(actionId)) {
            BigDecimal amount;
            QFilter[] adjustFilter;
            String detailId = this.getPageCache().get("detailId");
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(detailId), (String)"tccit_branch_share_bill");
            String fieldName = this.getPageCache().get("fieldName");
            QFilter orgFilter = new QFilter("org", "=", (Object)dyo.getLong("org.id"));
            String periodStr = this.getPageCache().get(PERIOD);
            Date period = DateUtils.stringToDate((String)periodStr);
            period = DateUtils.addYear((Date)period, (int)-1);
            Date skssqq = DateUtils.getFirstDateOfYear((Date)period);
            QFilter startFilter = new QFilter("skssqq", "=", (Object)skssqq);
            Date skssqz = DateUtils.getLastDateOfYear((Date)period);
            QFilter endFilter = new QFilter("skssqz", "=", (Object)skssqz);
            QFilter entrytypeFilter = new QFilter("entrytype", "=", (Object)fieldName);
            QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)this.ITEMNUMBERMAP.get(fieldName)).or(new QFilter("itemnumber", "=", (Object)(this.ITEMNUMBERMAP.get(fieldName) + "_")));
            List<Long> independentAndSubOrg = branchShareDialogService.getIndependentAndSubOrg(dyo.get("sumscheme.id"), skssqq);
            List<Long> zjgFtzzList = branchShareDialogService.getZjgFtzzList(dyo.get("sumscheme.id"), skssqq);
            if ("0".equals(dyo.getString("hbfnszt"))) {
                ArrayList<Long> taxorgList = new ArrayList<Long>();
                taxorgList.addAll(independentAndSubOrg);
                taxorgList.add(0L);
                QFilter taxorgFilter = new QFilter("taxorg", "in", taxorgList);
                adjustFilter = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, taxorgFilter};
            } else if ("2".equals(dyo.getString("declaration"))) {
                QFilter taxorgFilter = new QFilter("taxorg", "in", zjgFtzzList);
                adjustFilter = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter, taxorgFilter};
            } else {
                adjustFilter = new QFilter[]{orgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter};
            }
            String selectPrope = "ruleid,entrytype,adjustamount,totalamount";
            DynamicObject[] adjustDetails = BusinessDataServiceHelper.load((String)"tccit_adjust_detail", (String)selectPrope, (QFilter[])adjustFilter);
            if (adjustDetails.length == 0) {
                QFilter[] detailFilter;
                QFilter taxorgFilter;
                if (Objects.equals("0", dyo.get("hbfnszt"))) {
                    taxorgFilter = new QFilter("taxorg", "in", independentAndSubOrg);
                    detailFilter = new QFilter[]{taxorgFilter, startFilter, endFilter, entrytypeFilter, itemnumberFilter};
                } else if ("2".equals(dyo.getString("declaration"))) {
                    taxorgFilter = new QFilter("taxorg", "in", zjgFtzzList);
                    detailFilter = new QFilter[]{startFilter, endFilter, entrytypeFilter, itemnumberFilter, taxorgFilter};
                } else {
                    detailFilter = adjustFilter;
                }
                DynamicObject[] deductTzDetails = BusinessDataServiceHelper.load((String)"tccit_branch_share_detail", (String)"amount,fetchamount", (QFilter[])detailFilter);
                amount = Arrays.stream(deductTzDetails).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                amount = amount.setScale(2, 4);
            } else {
                amount = Arrays.stream(adjustDetails).map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                amount = amount.setScale(2, 4);
            }
            dyo.set(fieldName, (Object)amount);
            RequestContext context = RequestContext.get();
            Date update = new Date();
            if ("true".equals(evt.getReturnData())) {
                dyo.set("operator", (Object)context.getUserName());
                dyo.set("operatetime", (Object)DateUtils.formatHMS((Date)update));
            }
            SaveServiceHelper.update((DynamicObject)dyo);
        }
        if ("sharerate".equals(actionId) && null != (sumRate = (BigDecimal)evt.getReturnData())) {
            if (sumRate.compareTo(BigDecimal.ONE) != 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u914d\u6bd4\u4f8b\u5408\u8ba1\u503c\u4e3a%s\uff0c\u4e0d\u7b49\u4e8e1\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u5206\u914d\u6bd4\u4f8b\u660e\u7ec6\u6570\u636e", (String)"BranchShareListPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), sumRate.toPlainString()));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u914d\u6bd4\u4f8b\u5408\u8ba1\u503c\u7b49\u4e8e1\uff0c\u6ee1\u8db3\u7a0e\u6cd5\u8981\u6c42", (String)"BranchShareListPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
            }
        }
        if (BRANCH_SHARE_DIALOG.equals(actionId) && evt.getReturnData() != null && ((Boolean)evt.getReturnData()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u96c6\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u8ba1\u7b97\u5206\u914d\u6bd4\u4f8b\uff01", (String)"BranchShareListPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }

    private boolean validate(OperationResult operationResult, DynamicObject bill) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObject org = bill.getDynamicObject("org");
        collection.add((Object)org);
        if (OrgCheckUtil.orgAuth((String)org.getString("id"), (IFormView)this.getView().getParentView(), (DynamicObjectCollection)collection, (boolean)false)) {
            OperateErrorInfo ob = new OperateErrorInfo("", ErrorLevel.Error, bill.getPkValue());
            ob.setMessage(String.format(ResManager.loadKDString((String)"%s:\u60a8\u6682\u65e0\u8be5\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ec4\u7ec7", (String)"BranchShareListPlugin_9", (String)"taxc-tccit", (Object[])new Object[0]), org.getString("name")));
            operationResult.addErrorInfo(ob);
            return false;
        }
        if (OrgCheckUtil.orgEnable(null, (DynamicObjectCollection)collection, (boolean)false)) {
            OperateErrorInfo ob = new OperateErrorInfo("", ErrorLevel.Error, bill.getPkValue());
            ob.setMessage(String.format(ResManager.loadKDString((String)"%s:\u8be5\u7ec4\u7ec7\u672a\u542f\u7528", (String)"BranchShareListPlugin_10", (String)"taxc-tccit", (Object[])new Object[0]), org.getString("name")));
            operationResult.addErrorInfo(ob);
            return false;
        }
        String billstatus = bill.getString("billstatus");
        if ("B".equals(billstatus)) {
            OperateErrorInfo ob = new OperateErrorInfo("", ErrorLevel.Error, bill.getPkValue());
            ob.setMessage(String.format(ResManager.loadKDString((String)"%s:\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u652f\u6301\u6570\u636e\u91c7\u96c6", (String)"BranchShareListPlugin_11", (String)"taxc-tccit", (Object[])new Object[0]), org.getString("name")));
            operationResult.addErrorInfo(ob);
            return false;
        }
        if ("C".equals(billstatus)) {
            OperateErrorInfo ob = new OperateErrorInfo("", ErrorLevel.Error, bill.getPkValue());
            ob.setMessage(String.format(ResManager.loadKDString((String)"%s:\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u4e0d\u652f\u6301\u6570\u636e\u91c7\u96c6", (String)"BranchShareListPlugin_12", (String)"taxc-tccit", (Object[])new Object[0]), org.getString("name")));
            operationResult.addErrorInfo(ob);
            return false;
        }
        String declaration = bill.getString("declaration");
        boolean participation = bill.getBoolean("participation");
        if ("2".equals(declaration) && !participation) {
            operationResult.setBillCount(operationResult.getBillCount() - 1);
            return false;
        }
        String shareid = bill.getString("shareid");
        if ("false".equals(shareid)) {
            OperateErrorInfo ob = new OperateErrorInfo("", ErrorLevel.Error, bill.getPkValue());
            ob.setMessage(String.format(ResManager.loadKDString((String)"%s:\u5f53\u524d\u5206\u652f\u673a\u6784\u4e0d\u53c2\u4e0e\u7a0e\u6b3e\u5206\u644a\uff0c\u65e0\u9700\u91c7\u96c6\u6570\u636e", (String)"BranchShareListPlugin_14", (String)"taxc-tccit", (Object[])new Object[0]), org.getString("name")));
            operationResult.addErrorInfo(ob);
            return false;
        }
        return true;
    }
}

