/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tccit.business.taxbook.BranchShareServiceHelper;
import kd.taxc.tccit.business.taxbook.BranchTaxbookBusinessService;

public class BranchSharePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final Log LOGGER = LogFactory.getLog(BranchSharePlugin.class);
    private static final String KEY_SEARCH = "entitysearchap";
    private static final String KEY_TREEVIEW = "orgtree";
    private static final String KEY_TOOLBAR = "toolbarap";
    private static final String NO_RIGHT = "noRight";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String NODEIDS = "nodeIds";
    private static final String FILTERORG = "filterOrg";
    private static final String PERIOD = "period";
    private static final String IS_ROOT = "isRoot";
    private static final String ENTITY_NAME = "tccit_branch_share_bill";
    private static final String LISTCONTENT = "listcontent";
    private static final String BILLLISTAP = "billlistap";
    private static final String ORG_GROUP_ENTITY_NAME = "tctb_org_group_latest";
    private static final String ROOT_NODE_ID = "0";

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{KEY_TOOLBAR});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search sl = (Search)this.getControl(KEY_SEARCH);
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        sl.addEnterListener(searchEnterEvent -> {
            if (!StringUtil.isEmpty((CharSequence)searchEnterEvent.getText())) {
                ArrayList<String> dataKey = new ArrayList<String>();
                dataKey.add("number");
                pageCache.put(NO_RIGHT, String.valueOf(false));
                SearchUtil.searchMember((String)searchEnterEvent.getText().toLowerCase().trim(), (boolean)false, (IFormView)view, (IPageCache)pageCache, (TreeView)treeView, (String)KEY_TREEVIEW, dataKey);
            } else {
                this.getPageCache().put("_resultlist", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"BranchSharePlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            }
        });
        this.addClickListeners(new String[]{"searchbefore", "searchnext"});
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache pageCache = this.getPageCache();
        DynamicObjectCollection dcs = TreeUtils.getOrgLists();
        if (dcs == null || dcs.isEmpty()) {
            return;
        }
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        pageCache.put("hasAllOrgPerm", Objects.toString(hasPermOrgResult.hasAllOrgPerm()));
        pageCache.put("hasPermOrgs", Objects.toString(hasPermOrgResult.getHasPermOrgs()));
        Date period = (Date)this.getModel().getValue(PERIOD);
        this.createTreeView(period);
    }

    private void createTreeView(Date period) {
        if (period == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u7a0e\u671f", (String)"BranchSharePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        List hasPermOrgs = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("hasPermOrgs"), Long.class);
        List<DynamicObject> enableOrgs = BranchTaxbookBusinessService.queryEnableOrgGroups(hasPermOrgs, period);
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(enableOrgs.size());
        TreeNode parentNode = new TreeNode();
        parentNode.setParentid("");
        parentNode.setId(ROOT_NODE_ID);
        parentNode.setText(ResManager.loadKDString((String)"\u5168\u90e8\u6c47\u603b\u65b9\u6848", (String)"BranchSharePlugin_16", (String)"taxc-tccit", (Object[])new Object[0]));
        nodeList.add(parentNode);
        StringBuilder nodeIds = new StringBuilder(ROOT_NODE_ID);
        for (DynamicObject enableOrg : enableOrgs) {
            String id = enableOrg.getString("id");
            TreeNode leftRoot = new TreeNode();
            leftRoot.setParentid(ROOT_NODE_ID);
            leftRoot.setId(id);
            leftRoot.setText(enableOrg.getString("name"));
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>(8);
            data.put("number", enableOrg.getString("number").toLowerCase());
            leftRoot.setData(data);
            nodeList.add(leftRoot);
            nodeIds.append(id).append(",");
        }
        nodeIds.deleteCharAt(nodeIds.length() - 1);
        this.getPageCache().put(NODEIDS, nodeIds.toString());
        TreeUtils.build((TreeView)tree, nodeList, (IPageCache)this.getPageCache(), (boolean)false);
        this.getView().getPageCache().put("isRefresh", "true");
        String currentNodeId = this.getPageCache().get(CURRENT_NODE);
        if (EmptyCheckUtils.isNotEmpty((Object)currentNodeId) && !ROOT_NODE_ID.equals(currentNodeId) && nodeIds.toString().contains(currentNodeId)) {
            this.setDefaultNode(tree, currentNodeId);
        } else {
            long loginOrgId = RequestContext.get().getOrgId();
            String defaultOrgGroup = BranchTaxbookBusinessService.getDefaultOrgGroup(loginOrgId, enableOrgs);
            this.setDefaultNode(tree, defaultOrgGroup);
        }
        TreeUtils.expand((TreeView)tree, (IPageCache)this.getPageCache(), (int)1);
    }

    private void setDefaultNode(TreeView tree, String defaultNodeId) {
        TreeNode node = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)tree, (String)defaultNodeId);
        tree.focusNode(node);
        tree.treeNodeClick(node.getParentid(), node.getId());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        if (PERIOD.equals(name)) {
            Object newValue = changeSet[0].getNewValue();
            if (Objects.isNull(newValue)) {
                IFormView childView = this.getView().getView(this.getPageCache().get(LISTCONTENT));
                childView.getPageCache().put(PERIOD, null);
                childView.invokeOperation("refresh");
                this.getView().sendFormAction(childView);
                return;
            }
            this.getPageCache().remove(CURRENT_NODE);
            this.createTreeView((Date)newValue);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String current = this.getPageCache().get(CURRENT_NODE);
        if (this.checkPeriod()) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)nodeId);
        if (this.currentOrgGroupNoRight(Long.parseLong(nodeId))) {
            if (null != treeNode) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u201c%s\u201d\u7ec4\u7ec7\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BranchSharePlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), treeNode.getText()));
            }
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            return;
        }
        this.getView().showLoading(null);
        this.changeNode(nodeId);
        this.getView().hideLoading();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IFormView childView = this.getView().getView(this.getPageCache().get(LISTCONTENT));
        if (childView == null) {
            return;
        }
        BillList billList = (BillList)childView.getControl(BILLLISTAP);
        Date period = (Date)this.getModel().getValue(PERIOD);
        List<String> itemList = Arrays.asList("viewsumscheme", "refresh", "datacollect", "calcshare", "submit", "newdata", "audit");
        if (itemList.contains(itemKey) && this.checkPeriod()) {
            return;
        }
        if ("viewsumscheme".equals(itemKey)) {
            this.doViewSumScheme(period);
        } else if ("refresh".equals(itemKey)) {
            this.createTreeView(period);
        } else {
            int hasPrem;
            if ("import".equals(itemKey) && (hasPrem = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)"tccit", (String)"tccit_branch_share", (String)"4730fc9f000003ae")) != 1) {
                return;
            }
            if ("datacollect".equals(itemKey)) {
                hasPrem = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)"tccit", (String)"tccit_branch_share", (String)"4BFDNW+KTO6K");
                if (hasPrem != 1 || this.doDataCollect(billList, period)) {
                    return;
                }
            } else if ("calcshare".equals(itemKey)) {
                hasPrem = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)"tccit", (String)"tccit_branch_share", (String)"4BFDR=I7E6Z5");
                if (hasPrem != 1 || this.doCalcShare(billList, period)) {
                    return;
                }
            } else if ("submit".equals(itemKey)) {
                hasPrem = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)"tccit", (String)"tccit_branch_share", (String)"804f6478000000ac");
                if (hasPrem != 1) {
                    return;
                }
                if (!this.checkShareRate(billList.getSelectedRows().getPrimaryKeyValues(), period)) {
                    return;
                }
            } else if ("newdata".equals(itemKey)) {
                String currentNode = this.getPageCache().get(CURRENT_NODE);
                if (StringUtil.isBlank((CharSequence)currentNode)) {
                    currentNode = this.getPageCache().get(NODEIDS);
                }
                BranchTaxbookBusinessService.newData(currentNode, period);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5b8c\u6210\u6c47\u603b\u65b9\u6848\u540c\u6b65\u3002", (String)"BranchShareServiceHelper_7", (String)"taxc-tccit", (Object[])new Object[0]));
                itemKey = "refresh";
            } else {
                if ("unsubmit".equals(itemKey) ? (hasPrem = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)"tccit", (String)"tccit_branch_share", (String)"80513207000000ac")) != 1 : ("audit".equals(itemKey) ? (hasPrem = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)"tccit", (String)"tccit_branch_share", (String)"47162f66000000ac")) != 1 : "unaudit".equals(itemKey) && (hasPrem = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)"tccit", (String)"tccit_branch_share", (String)"47165e8e000000ac")) != 1)) {
                    return;
                }
                BranchSharePlugin.writeOperate(billList.getSelectedRows().getPrimaryKeyValues(), itemKey);
                billList.refresh();
            }
            billList.itemClick("bar" + itemKey, itemKey);
            this.getView().sendFormAction(childView);
        }
    }

    private boolean checkPeriod() {
        Date period = (Date)this.getModel().getValue(PERIOD);
        if (period == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u7a0e\u671f", (String)"BranchSharePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkShareRate(Object[] ids, Date period) {
        DynamicObject[] load;
        ArrayList<String> msgList = new ArrayList<String>();
        for (DynamicObject obj : load = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_NAME))) {
            BigDecimal sharerate = obj.getBigDecimal("sharerate");
            if (BigDecimal.ZERO.compareTo(sharerate) <= 0 && BigDecimal.ONE.compareTo(sharerate) >= 0) continue;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff08\u7a0e\u52a1\u7ec4\u7ec7\uff09\u5f53\u524d\u5206\u914d\u6bd4\u4f8b\u8d85\u51fa\u6570\u503c\u8303\u56f4[0,1]\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u5206\u914d\u6bd4\u4f8b\u660e\u7ec6\u6570\u636e\u3002", (String)"BranchShareServiceHelper_6", (String)"taxc-tccit", (Object[])new Object[0]), obj.getString("org.name")));
            return false;
        }
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
        Date lastDateOfYear = DateUtils.getLastDateOfYear1((Date)period);
        QFilter periodFilter = new QFilter(PERIOD, ">=", (Object)firstDateOfYear).and(PERIOD, "<=", (Object)lastDateOfYear);
        QFilter usableFilter = new QFilter("usable", "=", (Object)"1");
        Map<String, String> sumschemeMap = Arrays.stream(load).collect(Collectors.toMap(k -> k.getDynamicObject("sumscheme").getString("id"), v -> v.getDynamicObject("sumscheme").getString("name"), (key1, key2) -> key1));
        for (Map.Entry<String, String> entry : sumschemeMap.entrySet()) {
            String key = entry.getKey();
            QFilter sumschemeFilter = new QFilter("sumscheme", "=", (Object)Long.parseLong(key));
            DynamicObjectCollection rateList = QueryServiceHelper.query((String)ENTITY_NAME, (String)"sharerate", (QFilter[])new QFilter[]{sumschemeFilter, periodFilter, usableFilter});
            BigDecimal sumrate = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)rateList)) {
                sumrate = rateList.stream().map(e -> e.getBigDecimal("sharerate")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (sumrate.compareTo(BigDecimal.ONE) == 0) continue;
            String msg = ResManager.loadKDString((String)"\u6c47\u603b\u65b9\u6848<%1$s>\u5206\u914d\u6bd4\u4f8b\u5408\u8ba1\u503c\u4e3a%2$s\uff0c\u4e0d\u7b49\u4e8e1\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u5206\u914d\u6bd4\u4f8b\u660e\u7ec6\u6570\u636e", (String)"BranchSharePlugin_4", (String)"taxc-tccit", (Object[])new Object[0]);
            msgList.add(String.format(msg, entry.getValue(), sumrate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sumrate));
        }
        if (CollectionUtils.isEmpty(msgList)) {
            return true;
        }
        if (msgList.size() > 1) {
            String showMsg = msgList.stream().collect(Collectors.joining(System.getProperty("line.separator")));
            this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setMessage(showMsg);
            this.getView().showOperationResult(operationResult);
            return false;
        }
        this.getView().showErrorNotification((String)msgList.get(0));
        return false;
    }

    private boolean doCalcShare(BillList billList, Date period) {
        String nodeId = this.getPageCache().get(CURRENT_NODE);
        try {
            BranchShareServiceHelper.doCalcShare(this.getView(), nodeId, period);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u91cd\u65b0\u8ba1\u7b97\u5206\u914d\u6bd4\u4f8b", (String)"BranchSharePlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
            billList.refresh();
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return true;
        }
        return false;
    }

    private boolean doDataCollect(BillList billList, Date period) {
        if (period == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u7a0e\u671f", (String)"BranchSharePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return true;
        }
        String nodeId = this.getPageCache().get(CURRENT_NODE);
        int selectedRowCount = billList.getSelectedRows().size();
        if (selectedRowCount == 0) {
            if (ROOT_NODE_ID.equals(nodeId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u91c7\u96c6\u6570\u636e\u7684\u7ec4\u7ec7", (String)"BranchSharePlugin_8", (String)"taxc-tccit", (Object[])new Object[0]));
                return true;
            }
            billList.selectAllRows();
        }
        return false;
    }

    private void doViewSumScheme(Date period) {
        String currentNode = this.getPageCache().get(CURRENT_NODE);
        if (EmptyCheckUtils.isEmpty((Object)currentNode) || ROOT_NODE_ID.equals(currentNode)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u6c47\u603b\u65b9\u6848", (String)"BranchSharePlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        if (period == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u7a0e\u671f", (String)"BranchSharePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)ORG_GROUP_ENTITY_NAME, (Object)Long.parseLong(currentNode), (IFormView)this.getView(), null, (OperationStatus)OperationStatus.VIEW);
        BranchShareServiceHelper.addViewSumSchemeLog(currentNode);
    }

    private DynamicObject queryOrgGroup(QFilter orgFilter) {
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        Date period = (Date)this.getModel().getValue(PERIOD);
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)period);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)lastDateOfYear).and(new QFilter("invaliddate", ">=", (Object)firstDateOfYear).or(new QFilter("invaliddate", "=", null)));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)ORG_GROUP_ENTITY_NAME, (String)"id", (QFilter[])new QFilter[]{taxtypeFilter, statusFilter, dateFilter, orgFilter}, (String)"invaliddate desc", (int)1);
        if (load == null || load.length == 0) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((String)ORG_GROUP_ENTITY_NAME, (String)"id,orgrow.orgid,orgrow.declaration,orgrow.shareid,participation", (QFilter[])new QFilter[]{new QFilter("id", "=", load[0].get("id"))});
    }

    private void changeNode(String nodeId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        String nodes = ROOT_NODE_ID.equals(nodeId) ? this.getPageCache().get(NODEIDS) : nodeId;
        customParams.put(NODEIDS, nodes);
        customParams.put(FILTERORG, this.getPageCache().get(FILTERORG));
        Date period = (Date)this.getModel().getValue(PERIOD);
        if (period == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u7a0e\u671f", (String)"BranchSharePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        TreeNode root = (TreeNode)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)treeView.getKey(), TreeNode.class);
        if (root != null && StringUtils.equals((CharSequence)nodeId, (CharSequence)root.getId())) {
            customParams.put(IS_ROOT, Boolean.TRUE);
        }
        if (StringUtil.isNotBlank((CharSequence)nodes)) {
            this.isChangedGroup(nodes, period);
        }
        customParams.put(PERIOD, DateUtils.format((Date)period));
        this.getPageCache().put(CURRENT_NODE, nodeId);
        String childPageId = PageShowCommon.showBillList((String)LISTCONTENT, (String)ENTITY_NAME, (IFormView)this.getView(), customParams);
        this.getPageCache().put(LISTCONTENT, childPageId);
    }

    private void isChangedGroup(String nodeIds, Date period) {
        List<Long> nodeList = Arrays.stream(nodeIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        String isRoot = this.getPageCache().get(IS_ROOT);
        if ("true".equals(isRoot)) {
            return;
        }
        DynamicObject[] orgGroups = BranchTaxbookBusinessService.queryOrgGroup(nodeList);
        if (orgGroups.length <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u5931\u6548\uff01", (String)"BranchSharePlugin_17", (String)"taxc-tccit", (Object[])new Object[0]));
            this.createTreeView(period);
            return;
        }
        String groupId = orgGroups[0].getString("id");
        String groupName = orgGroups[0].getString("name");
        DynamicObjectCollection taxbookList = BranchTaxbookBusinessService.getTaxbookData(period, Long.parseLong(groupId));
        if (CollectionUtils.isEmpty((Collection)taxbookList)) {
            return;
        }
        DynamicObjectCollection orgrow = orgGroups[0].getDynamicObjectCollection("orgrow");
        Optional<DynamicObject> gtotalOrg = orgrow.stream().filter(e -> "2".equals(e.getString("declaration"))).findFirst();
        Optional<DynamicObject> ttotalOrg = taxbookList.stream().filter(e -> "2".equals(e.getString("declaration"))).findFirst();
        if (gtotalOrg.isPresent()) {
            DynamicObject object = gtotalOrg.get();
            long aLong = object.getDynamicObject("orgid").getLong("id");
            List<Long> enableOrg = BranchTaxbookBusinessService.filterEnableOrg(Collections.singletonList(aLong), DateUtils.getFirstDateOfYear((Date)period));
            if (CollectionUtils.isEmpty(enableOrg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u5931\u6548\uff01", (String)"BranchSharePlugin_17", (String)"taxc-tccit", (Object[])new Object[0]));
                this.createTreeView(period);
                return;
            }
            if (object.getBoolean("shareid") && !ttotalOrg.isPresent()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d<%s>\u65b9\u6848\u6216\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u5b58\u5728\u66f4\u65b0\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u6570\u636e\u91c7\u96c6\u5e76\u8ba1\u7b97\u5206\u914d\u6bd4\u4f8b\uff0c\u5426\u5219\u5f53\u524d\u6c47\u603b\u65b9\u6848\u5206\u644a\u53f0\u8d26\u6570\u636e\u4e0d\u53ef\u7528\u3002", (String)"BranchSharePlugin_18", (String)"taxc-tccit", (Object[])new Object[0]), groupName));
                return;
            }
            if (object.getBoolean("shareid") && ttotalOrg.isPresent() && !ttotalOrg.get().getBoolean("shareid")) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d<%s>\u65b9\u6848\u6216\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u5b58\u5728\u66f4\u65b0\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u6570\u636e\u91c7\u96c6\u5e76\u8ba1\u7b97\u5206\u914d\u6bd4\u4f8b\uff0c\u5426\u5219\u5f53\u524d\u6c47\u603b\u65b9\u6848\u5206\u644a\u53f0\u8d26\u6570\u636e\u4e0d\u53ef\u7528\u3002", (String)"BranchSharePlugin_18", (String)"taxc-tccit", (Object[])new Object[0]), groupName));
                return;
            }
        }
        List<Long> collect1 = orgrow.stream().filter(e -> "3".equals(e.getString("declaration"))).map(e -> e.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
        List<Long> groupNsztOrg = BranchTaxbookBusinessService.getNsztOrg(collect1);
        List<Long> enableGroupList = BranchTaxbookBusinessService.filterEnableOrg(groupNsztOrg, DateUtils.getFirstDateOfYear((Date)period));
        List gList = orgrow.stream().filter(e -> enableGroupList.contains(e.getDynamicObject("orgid").getLong("id"))).collect(Collectors.toList());
        Map tMap = taxbookList.stream().filter(e -> "1".equals(e.getString("hbfnszt"))).filter(e -> "3".equals(e.getString("declaration"))).collect(Collectors.toMap(k -> k.getLong("org"), Function.identity(), (v1, v2) -> v1));
        if (gList.size() != tMap.size()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d<%s>\u65b9\u6848\u6216\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u5b58\u5728\u66f4\u65b0\u53d8\u52a8\uff0c\u4e24\u8fb9\u6570\u636e\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u6570\u636e\u91c7\u96c6\u5e76\u8ba1\u7b97\u5206\u914d\u6bd4\u4f8b\uff0c\u5426\u5219\u5f53\u524d\u6c47\u603b\u65b9\u6848\u5206\u644a\u53f0\u8d26\u6570\u636e\u4e0d\u53ef\u7528\u3002", (String)"BranchSharePlugin_19", (String)"taxc-tccit", (Object[])new Object[0]), groupName));
            return;
        }
        for (DynamicObject row : gList) {
            DynamicObject taxbook = (DynamicObject)tMap.get(row.getDynamicObject("orgid").getLong("id"));
            if (Objects.isNull(taxbook)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d<%s>\u65b9\u6848\u6216\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u5b58\u5728\u66f4\u65b0\u53d8\u52a8\uff0c\u4e24\u8fb9\u7ec4\u7ec7\u4e0d\u5b8c\u5168\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u6570\u636e\u91c7\u96c6\u5e76\u8ba1\u7b97\u5206\u914d\u6bd4\u4f8b\uff0c\u5426\u5219\u5f53\u524d\u6c47\u603b\u65b9\u6848\u5206\u644a\u53f0\u8d26\u6570\u636e\u4e0d\u53ef\u7528\u3002", (String)"BranchSharePlugin_20", (String)"taxc-tccit", (Object[])new Object[0]), groupName));
                return;
            }
            if (row.getString("shareid").equals(taxbook.getString("shareid"))) continue;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d<%s>\u65b9\u6848\u6216\u7a0e\u52a1\u7ec4\u7ec7\u72b6\u6001\u5b58\u5728\u66f4\u65b0\u53d8\u52a8\uff0c\u5b58\u5728\u540c\u7ec4\u7ec7\u5206\u644a\u72b6\u6001\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u6570\u636e\u91c7\u96c6\u5e76\u8ba1\u7b97\u5206\u914d\u6bd4\u4f8b\uff0c\u5426\u5219\u5f53\u524d\u6c47\u603b\u65b9\u6848\u5206\u644a\u53f0\u8d26\u6570\u636e\u4e0d\u53ef\u7528\u3002", (String)"BranchSharePlugin_21", (String)"taxc-tccit", (Object[])new Object[0]), groupName));
            return;
        }
    }

    private boolean currentOrgGroupNoRight(long orgId) {
        QFilter orgFilter = new QFilter("orgrow.orgid", "=", (Object)orgId);
        DynamicObject orgGroup = this.queryOrgGroup(orgFilter);
        if (orgGroup == null) {
            return false;
        }
        return orgGroup.getDynamicObjectCollection("orgrow").stream().allMatch(d -> this.currentOrgNoRight(this.getPageCache(), d.getString("orgid.id")));
    }

    private boolean currentOrgNoRight(IPageCache pageCache, String nodeId) {
        Boolean hasAllOrgPerm = (Boolean)SerializationUtils.fromJsonString((String)pageCache.get("hasAllOrgPerm"), Boolean.TYPE);
        List hasPermOrgs = SerializationUtils.fromJsonStringToList((String)pageCache.get("hasPermOrgs"), Long.class);
        if (StringUtils.isNumeric((CharSequence)nodeId)) {
            return (null == hasAllOrgPerm || hasAllOrgPerm == false) && !hasPermOrgs.contains(Long.parseLong(nodeId));
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "like", (Object)("%" + nodeId + "%")).or("name", "like", (Object)("%" + nodeId + "%"))});
        return (null == hasAllOrgPerm || hasAllOrgPerm == false) && collection.stream().noneMatch(v -> hasPermOrgs.contains(v.getLong("id")));
    }

    private static void writeOperate(Object[] ids, String itemKey) {
        for (Object id : ids) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
            String billstatus = dynamicObject.getString("billstatus");
            String declaration = dynamicObject.getString("declaration");
            String participation = dynamicObject.getString("participation");
            if ("2".equals(declaration) && "false".equals(participation) || "A".equals(billstatus) && !"submit".equals(itemKey) || "B".equals(billstatus) && "submit".equals(itemKey) || "B".equals(billstatus) && "unaudit".equals(itemKey) || "C".equals(billstatus) && !"unaudit".equals(itemKey)) continue;
            RequestContext context = RequestContext.get();
            dynamicObject.set("operator", (Object)context.getUserName());
            dynamicObject.set("operatetime", (Object)DateUtils.formatHMS((Date)new Date()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }
}

