/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class CommissionsFeesEditPlugin
extends ExtendAbstractBillPlugin {
    public static final String TYPE = "type";
    public static final String VALUE1 = "1";
    public static final String VALUE2 = "2";
    public static final String NONALLOWEDAMOUNT = "nonallowedamount";
    public static final String ZZJE = "zzje";
    public static final String DEDUCTLIMIT = "deductlimit";
    public static final String RATE = "rate";
    public static final String CONTRACTAMOUNT = "contractamount";
    public static final String SSJE = "ssje";
    public static final String DATASOURCE = "datasource";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String datasource = (String)this.getModel().getValue(DATASOURCE);
        if (datasource == null) {
            this.getModel().setValue(DATASOURCE, (Object)"hand");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        String name = e.getProperty().getName();
        if (TYPE.equals(name)) {
            newValue = (String)e.getChangeSet()[0].getNewValue();
            if (VALUE1.equals(newValue)) {
                this.getModel().setValue(RATE, (Object)0.05);
            }
            if (VALUE2.equals(newValue)) {
                this.getModel().setValue(RATE, (Object)0.1);
            }
            this.getModel().setValue(ZZJE, (Object)BigDecimal.ZERO);
            this.getModel().setValue(CONTRACTAMOUNT, (Object)BigDecimal.ZERO);
            this.getModel().setValue(DEDUCTLIMIT, (Object)BigDecimal.ZERO);
            this.getModel().setValue(SSJE, (Object)BigDecimal.ZERO);
        }
        if (NONALLOWEDAMOUNT.equals(name)) {
            newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
            BigDecimal zzje = (BigDecimal)this.getModel().getValue(ZZJE);
            if (newValue != null && zzje != null && ((BigDecimal)newValue).compareTo(zzje) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u8f7d\u91d1\u989d\u5e94\u5927\u4e8e\u7b49\u4e8e\u4e0d\u5141\u8bb8\u6263\u9664\u91d1\u989d", (String)"CommissionsFeesEditPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
        }
        if (CONTRACTAMOUNT.equals(name) || RATE.equals(name)) {
            BigDecimal value = (BigDecimal)this.getModel().getValue(CONTRACTAMOUNT);
            BigDecimal rate = (BigDecimal)this.getModel().getValue(RATE);
            this.getModel().setValue(DEDUCTLIMIT, (Object)BigDecimalUtil.multiplyObject((Object)value, (Object)rate, (int)2));
        }
        if (ZZJE.equals(name) || NONALLOWEDAMOUNT.equals(name) || DEDUCTLIMIT.equals(name)) {
            BigDecimal zzje = (BigDecimal)Optional.ofNullable(this.getModel().getValue(ZZJE)).orElseGet(() -> BigDecimal.ZERO);
            BigDecimal nonallowedamount = (BigDecimal)Optional.ofNullable(this.getModel().getValue(NONALLOWEDAMOUNT)).orElseGet(() -> BigDecimal.ZERO);
            BigDecimal deductlimit = (BigDecimal)Optional.ofNullable(this.getModel().getValue(DEDUCTLIMIT)).orElseGet(() -> BigDecimal.ZERO);
            BigDecimal ssje = BigDecimalUtil.min((Object)BigDecimalUtil.subtractObject((Object)zzje, (Object)nonallowedamount), (Object)deductlimit);
            this.getModel().setValue(SSJE, (Object)ssje);
        }
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }
}

