/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.taxbook.DevelopJjkcService;
import kd.taxc.tccit.common.enums.DevJjkcAmountEnum;
import kd.taxc.tccit.common.enums.DevJjkcAmtMapEnum;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;
import org.apache.commons.lang3.StringUtils;

public class DevelopJjkcEdit
extends ExtendAbstractBillPlugin
implements TabSelectListener,
BeforeF7SelectListener {
    public static final String YJ_DEDUCTIONTYPE = "yjdeductiontype";
    private static Log logger = LogFactory.getLog(DevelopJjkcEdit.class);
    private static final String YEAR = "year";
    private static final String ITEMTYPE = "itemtype";
    private static final String AMOUNT = "amount";
    private static final String ENTITY_NAME = "tccit_develop_jjkc";
    private static final String isInitialKey = "initialed";
    private final Set<String> noNeedDisableLastRowSet = Sets.newHashSet((Object[])new String[]{"zzyfhz", "xetzhfy", "yffyjjkcjejs"});
    private final Map<String, Integer[]> disableAmountRow = new HashMap<String, Integer[]>(){
        {
            this.put("yffyjjkcjejs", new Integer[]{0, 5, 7, 10});
        }
    };
    private Boolean dataChange = Boolean.TRUE;
    private static final String TABAP = "tabap";
    private final Map<String, String> TAB_ENTITY = new HashMap(){
        {
            this.put("sumtab", "zzyfhz");
            this.put("rgrytab", "rgryfy");
            this.put("zjtrtab", "zjtrfy");
            this.put("zjtab", "zjfy");
            this.put("wxzctxtab", "wxzctxfy");
            this.put("xcpsjtab", "xcpsjfy");
            this.put("qtxgtab", "qtxgfy");
            this.put("xetzhtab", "xetzhfy");
        }
    };
    private final Map<String, String> YJ_JJKC_MAPPER = new HashMap(){
        {
            this.put("JJKC011", "1");
            this.put("JJKC013", "1");
            this.put("JJKC021", "1");
            this.put("JJKC023", "1");
        }
    };
    private static final String DECLARETYPE = "declaretype";
    private static final String DEDUCTIONTYPE = "deductiontype";
    private static final String IS_MANUFACTURE_RATE = "ismanufacturerate";
    private String[] DEDUCTIONTYPELIST = new String[]{"1", "2"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("jjkcbljjsff");
        BasedataEdit yjdeductiontype = (BasedataEdit)this.getControl(YJ_DEDUCTIONTYPE);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        yjdeductiontype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.initData();
    }

    public void afterBindData(EventObject e) {
        Object declareType = this.getModel().getValue(DECLARETYPE);
        if (Objects.nonNull(declareType)) {
            this.isShowFieldAndSetValue(declareType);
            this.getModel().setDataChanged(false);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            String industry = this.getIndustryByOrgId(org.getLong("id"));
            if ("C".equals(industry)) {
                this.getModel().setValue(IS_MANUFACTURE_RATE, (Object)1);
            } else {
                this.getModel().setValue(IS_MANUFACTURE_RATE, (Object)0);
            }
        }
        this.setFieldStatus(DEDUCTIONTYPE, false);
        this.setFieldStatus(YJ_DEDUCTIONTYPE, false);
        this.getModel().setValue(YEAR, (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\u65e0\u6cd5\u4fee\u6539\u3001\u4fdd\u5b58", (String)"DevelopJjkcEdit_0", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"DevelopJjkcEdit_1", (String)"taxc-tccit", (Object[])new Object[0]));
                args.setCancel(true);
            }
            Long orgid = org.getLong("id");
            Date year = (Date)this.getModel().getValue(YEAR);
            String declareType = (String)this.getModel().getValue(DECLARETYPE);
            String deductionType = (String)this.getModel().getValue(DEDUCTIONTYPE);
            Date first = DateUtils.getFirstDateOfYear((Date)year);
            Date last = DateUtils.getLastDateOfYear((Date)year);
            QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
            QFilter yearFilter = new QFilter(YEAR, ">=", (Object)first).and(YEAR, "<=", (Object)last);
            QFilter declareFilter = new QFilter(DECLARETYPE, "=", (Object)declareType);
            QFilter deductionTypesFilter = new QFilter(DEDUCTIONTYPE, "in", Arrays.asList(this.DEDUCTIONTYPELIST));
            QFilter deductionTypeFilter = new QFilter(DEDUCTIONTYPE, "=", (Object)deductionType);
            Object pkValue = ((BillModel)this.getModel()).getPKValue();
            if ("1".equals(deductionType) || "2".equals(deductionType)) {
                if (this.isExists(pkValue, new QFilter[]{orgFilter, yearFilter, declareFilter, deductionTypesFilter})) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u3010\u5f00\u53d1\u65b0\u6280\u672f\u3001\u65b0\u4ea7\u54c1\u3001\u65b0\u5de5\u827a\u53d1\u751f\u7684\u7814\u7a76\u5f00\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u3011\u6216\u3010\u79d1\u6280\u578b\u4e2d\u5c0f\u4f01\u4e1a\u5f00\u53d1\u65b0\u6280\u672f\u3001\u65b0\u4ea7\u54c1\u3001\u65b0\u5de5\u827a\u53d1\u751f\u7684\u7814\u7a76\u5f00\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u3011\u7684\u6570\u636e\uff0c\u5f53\u524d\u7814\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u7c7b\u578b\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"DevelopJjkcEdit_2", (String)"taxc-tccit", (Object[])new Object[0]));
                }
            } else if (this.isExists(pkValue, new QFilter[]{orgFilter, yearFilter, declareFilter, deductionTypeFilter})) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u3010\u4f01\u4e1a\u4e3a\u83b7\u5f97\u521b\u65b0\u6027\u3001\u521b\u610f\u6027\u3001\u7a81\u7834\u6027\u7684\u4ea7\u54c1\u8fdb\u884c\u521b\u610f\u8bbe\u8ba1\u6d3b\u52a8\u800c\u53d1\u751f\u7684\u76f8\u5173\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u3011\uff0c\u5f53\u524d\u7814\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u7c7b\u578b\u65e0\u6cd5\u4fdd\u5b58", (String)"DevelopJjkcEdit_3", (String)"taxc-tccit", (Object[])new Object[0]));
            }
        }
    }

    private boolean isExists(Object pkValue, QFilter[] filters) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id,deductiontype", (QFilter[])filters);
        return this.isNew(pkValue, dynamicObject);
    }

    private boolean isNew(Object pkValue, DynamicObject dynamicObject) {
        return Optional.ofNullable(dynamicObject).isPresent() && !dynamicObject.get("id").equals(pkValue);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isHide;
        String operateKey = args.getOperateKey();
        Date year = (Date)this.getModel().getValue(YEAR);
        boolean bl = isHide = year.compareTo(DateUtils.stringToDate((String)"2023-01-01")) >= 0;
        if ("save".equals(operateKey)) {
            this.loadSavedSubEntrys("wtyfxmmx");
            this.loadSavedSubEntrys("zzyfhz");
            if (isHide) {
                this.loadSavedSubEntrys("yffyjjkcjejs", Arrays.asList("12", "13", "16", "17"));
            } else {
                this.loadSavedSubEntrys("yffyjjkcjejs");
            }
        }
        this.getModel().setDataChanged(false);
    }

    public BigDecimal initDevelopFee12() {
        return BigDecimal.ZERO;
    }

    public BigDecimal getDevelopFee12() {
        int index11 = this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "11");
        int index14 = this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "14");
        BigDecimal yhndkcze = this.getModel().getValue("yffyjjkcjejsamount", index11) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", index11);
        BigDecimal value14 = this.getModel().getValue("yffyjjkcjejsamount", index14) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", index14);
        BigDecimal sum = yhndkcze.multiply(value14).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        return sum;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        int index14 = this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "14");
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        String declaretype = (String)this.getModel().getValue(DECLARETYPE);
        Date year = (Date)this.getModel().getValue(YEAR);
        if (null != year) {
            boolean isCal;
            int currentyear = DateUtils.getYearOfDate((Date)year);
            boolean bl = isCal = year.compareTo(DateUtils.stringToDate((String)"2023-01-01")) >= 0;
            if (YEAR.equals(name)) {
                DynamicObject org;
                boolean oldData;
                Date oldValue = (Date)changeData.getOldValue();
                boolean bl2 = oldData = oldValue == null || DateUtils.stringToDate((String)"2023-01-01").compareTo(oldValue) <= 0;
                if (isCal != oldData) {
                    if (isCal) {
                        this.loadSavedSubEntrys("yffyjjkcjejs", Arrays.asList("12", "13", "16", "17"));
                    } else {
                        this.loadSavedSubEntrys("yffyjjkcjejs");
                    }
                }
                if ((org = (DynamicObject)this.getModel().getValue("org")) == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\u65e0\u6cd5\u4fee\u6539\u3001\u4fdd\u5b58", (String)"DevelopJjkcEdit_0", (String)"taxc-tccit", (Object[])new Object[0]));
                    return;
                }
                this.getModel().setValue("yffyjjkcjejsamount", (Object)this.getYqndjzje(year, org), 9);
                this.getModel().setValue("yffyjjkcjejsamount", (Object)this.initDevelopFee12(), this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "15"));
                this.getModel().setValue("jjkcbljjsff", null);
                if ("1".equals(declaretype)) {
                    this.setDeductionRate(currentyear, IS_MANUFACTURE_RATE);
                }
                this.getModel().setValue("jjkcbljjsff", (Object)"");
                Boolean existsValidData = DevelopJjkcService.existsValidData(year, Optional.ofNullable((DynamicObject)this.getModel().getValue(YJ_DEDUCTIONTYPE)).map(s -> s.getString("number")).orElseGet(() -> ""));
                if (!existsValidData.booleanValue()) {
                    this.getModel().setValue(YJ_DEDUCTIONTYPE, null);
                }
            } else if (DEDUCTIONTYPE.equals(name) && "1".equals(declaretype)) {
                this.setDeductionRate(currentyear, DEDUCTIONTYPE);
            } else if (YJ_DEDUCTIONTYPE.equals(name) && "1".equals(declaretype)) {
                String nunber = Optional.ofNullable((DynamicObject)newValue).map(s -> s.getString("number")).orElseGet(() -> "");
                String nameDes = Optional.ofNullable((DynamicObject)newValue).map(s -> s.getString("name")).orElseGet(() -> "");
                if (nameDes.contains("75%")) {
                    this.getModel().setValue(IS_MANUFACTURE_RATE, (Object)"0");
                } else {
                    this.getModel().setValue(IS_MANUFACTURE_RATE, (Object)this.YJ_JJKC_MAPPER.get(nunber));
                }
            } else if (Boolean.TRUE.toString().equals(this.getPageCache().get(isInitialKey))) {
                BigDecimal sum;
                BigDecimal wtjwfy;
                BigDecimal qz;
                DevJjkcAmtMapEnum amtMapEnum;
                DevJjkcAmountEnum e = DevJjkcAmountEnum.byTrigger(name, rowIndex);
                if (e != null) {
                    List<Integer> triggerIndexes = e.getTriggerIndex();
                    String triggerKey = e.getTriggerKey();
                    String targetKey = e.getTargetKey();
                    int targetIndex = e.getTargetIndex();
                    if (triggerIndexes.size() > 1) {
                        BigDecimal sum2 = BigDecimal.ZERO;
                        for (Integer index : triggerIndexes) {
                            if (index == rowIndex) {
                                sum2 = sum2.add((BigDecimal)newValue);
                                continue;
                            }
                            BigDecimal amt = (BigDecimal)this.getModel().getValue(triggerKey, index.intValue());
                            if (amt == null) continue;
                            sum2 = sum2.add(amt);
                        }
                        this.getModel().setValue(targetKey, (Object)sum2, targetIndex);
                    } else {
                        this.getModel().setValue(targetKey, newValue, targetIndex);
                    }
                }
                if ("yffyjjkcjejsamount".equals(name)) {
                    String yffyjjkcjejstype = changeData.getDataEntity().getString("yffyjjkcjejsitemtype");
                    int i = Integer.parseInt(yffyjjkcjejstype) - 1;
                    amtMapEnum = DevJjkcAmtMapEnum.byAmt(name, i);
                } else {
                    amtMapEnum = DevJjkcAmtMapEnum.byAmt(name, rowIndex);
                }
                if (amtMapEnum != null) {
                    String saveKey = amtMapEnum.getSaveKey();
                    if (rowIndex == index14 && new BigDecimal("0.00").compareTo((BigDecimal)newValue) != 0 && new BigDecimal("75.00").compareTo((BigDecimal)newValue) != 0 && new BigDecimal("100.00").compareTo((BigDecimal)newValue) != 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u52a0\u8ba1\u6263\u9664\u6bd4\u4f8b\u53ea\u80fd\u662f75\u6216100", (String)"DevelopJjkcEdit_4", (String)"taxc-tccit", (Object[])new Object[0]));
                        return;
                    }
                    this.getModel().setValue(saveKey, newValue);
                }
                if (rowIndex == 2 && "wtyfxmmxamount".equals(name) && (qz = (BigDecimal)newValue).compareTo(wtjwfy = (BigDecimal)this.getModel().getValue("wtyfxmmxamount", 1)) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u91d1\u989d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u3010\u59d4\u6258\u5883\u5916\u673a\u6784\u8fdb\u884c\u7814\u53d1\u6d3b\u52a8\u53d1\u751f\u7684\u8d39\u7528\u3011", (String)"DevelopJjkcEdit_5", (String)"taxc-tccit", (Object[])new Object[0]));
                    this.getModel().setValue("wtyfxmmxamount", (Object)0, rowIndex);
                    return;
                }
                if ("zzyfhzamount".equals(name) && rowIndex == 7 || "wtyfxmmxamount".equals(name) && (rowIndex == 0 || rowIndex == 2)) {
                    sum = BigDecimal.ZERO;
                    sum = sum.add((BigDecimal)this.getModel().getValue("zzyfhzamount", 7)).add(((BigDecimal)this.getModel().getValue("wtyfxmmxamount", 0)).multiply(new BigDecimal("0.8"))).add((BigDecimal)this.getModel().getValue("wtyfxmmxamount", 2));
                    this.getModel().setValue("yffyjjkcjejsamount", (Object)sum, 0);
                }
                if ("yffyjjkcjejsamount".equals(name) && (rowIndex == 1 || rowIndex == 2)) {
                    BigDecimal zbhje;
                    BigDecimal fyxj = (BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", 0);
                    BigDecimal fyhje = (BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", 1);
                    BigDecimal add = fyhje.add(zbhje = (BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", 2));
                    int compareTo = add.compareTo(fyxj);
                    if (compareTo != 0 && this.dataChange.booleanValue()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u5176\u4e2d\uff1a\u672c\u5e74\u8d39\u7528\u5316\u91d1\u989d\u3011+\u3010\u5176\u4e2d\uff1a\u672c\u5e74\u8d44\u672c\u5316\u91d1\u989d\u3011\u5e94\u7b49\u4e8e\u5e74\u5ea6\u7814\u53d1\u8d39\u7528\u5c0f\u8ba1\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"DevelopJjkcEdit_6", (String)"taxc-tccit", (Object[])new Object[0]));
                        if (compareTo > 0) {
                            this.dataChange = Boolean.FALSE;
                            this.getModel().setValue("yffyjjkcjejsamount", (Object)0, rowIndex);
                        }
                        return;
                    }
                }
                if ("yffyjjkcjejsamount".equals(name) && (rowIndex == 5 || rowIndex == 6)) {
                    sum = BigDecimal.ZERO;
                    sum = sum.add((BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", 5)).subtract((BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", 6));
                    this.getModel().setValue("yffyjjkcjejsamount", (Object)sum, 7);
                }
                if ("yffyjjkcjejsamount".equals(name) && (rowIndex == 7 || rowIndex == 8 || rowIndex == 9)) {
                    sum = BigDecimal.ZERO;
                    BigDecimal yhndkcze = sum.add((BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", 7)).subtract((BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", 8)).subtract((BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", 9));
                    this.getModel().setValue("yffyjjkcjejsamount", (Object)yhndkcze, 10);
                }
                if ("yffyjjkcjejsamount".equals(name) && (rowIndex == 10 || rowIndex == index14)) {
                    if ("1".equals(declaretype) || isCal) {
                        int index15 = this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "15");
                        this.getModel().setValue("yffyjjkcjejsamount", (Object)this.getDevelopFee12(), index15);
                    }
                    BigDecimal yhndkcze = (BigDecimal)this.getModel().getValue("yffyjjkcjejsamount", 10);
                    int index18 = this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "18");
                    this.getModel().setValue("yffyjjkcjejsamount", (Object)(yhndkcze.compareTo(BigDecimal.ZERO) < 0 ? yhndkcze.abs() : BigDecimal.ZERO), index18);
                }
            }
            if (IS_MANUFACTURE_RATE.equals(name)) {
                this.setDeductionRate(currentyear, IS_MANUFACTURE_RATE);
            }
            if (DECLARETYPE.equals(name)) {
                this.isShowFieldAndSetValue(newValue);
                if ("1".equals(newValue)) {
                    this.setDeductionRate(currentyear, Objects.nonNull(this.getModel().getValue(DEDUCTIONTYPE)) ? DEDUCTIONTYPE : IS_MANUFACTURE_RATE);
                }
            }
        }
        if (null == year && (DECLARETYPE.equals(name) || "busenddate".equals(name)) && Objects.nonNull(newValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5e74\u5ea6\u503c", (String)"DevelopJjkcEdit_7", (String)"taxc-tccit", (Object[])new Object[0]));
            this.getModel().setValue(name, (Object)"");
            return;
        }
        if ("busenddate".equals(name)) {
            if (Objects.isNull(newValue)) {
                this.getModel().setValue("busstartdate", null);
                return;
            }
            Date busenddate = (Date)newValue;
            Date enddate = DateUtils.getLastDateOfMonth1((Date)busenddate);
            int yearOfDate = DateUtils.getYearOfDate((Date)year);
            int busEndDateYear = DateUtils.getYearOfDate((Date)busenddate);
            if (busEndDateYear != yearOfDate || enddate.compareTo(busenddate) != 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u671f\u95f4\u6b62\u53ea\u80fd\u4e3a%s\u5e74\u5ea6\u5185\u6708\u672b\u6700\u540e\u4e00\u5929", (String)"DevelopJjkcEdit_9", (String)"taxc-tccit", (Object[])new Object[0]), yearOfDate));
                this.getModel().setValue(name, (Object)"");
            } else {
                this.getModel().setValue("busstartdate", (Object)DateUtils.getFirstDateOfYear((Date)busenddate));
            }
        }
    }

    private BigDecimal getYqndjzje(Date year, DynamicObject org) {
        String lastYearSbbid = this.getLastYearSbbid(org.getString("id"), year);
        if (StringUtils.isNotBlank((CharSequence)lastYearSbbid)) {
            QFilter ewblxhFilter = new QFilter("ewblxh", "=", (Object)"52");
            QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)lastYearSbbid);
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((String)"tccit_qysds_a107012_mx", (String)"yfhdfyje", (QFilter[])new QFilter[]{ewblxhFilter, sbbidFilter});
            if (dyo != null) {
                return dyo.getBigDecimal("yfhdfyje");
            }
        }
        return BigDecimal.ZERO;
    }

    private int getIndex(String entity, String itemType, String itemValue) {
        DynamicObjectCollection entityList = this.getModel().getEntryEntity(entity);
        Optional<DynamicObject> entityObj = entityList.stream().filter(e -> e.getString(itemType).equals(itemValue)).findFirst();
        return entityObj.map(dynamicObject -> dynamicObject.getInt("seq")).orElse(0) - 1;
    }

    private void isShowFieldAndSetValue(Object newValue) {
        Date year = (Date)this.getModel().getValue(YEAR);
        boolean isCal = year != null && year.compareTo(DateUtils.stringToDate((String)"2023-01-01")) >= 0;
        int index15 = this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "15");
        BasedataProp property = (BasedataProp)this.getModel().getProperty("jjkcbljjsff");
        if ("1".equals(newValue)) {
            this.setFieldStatus(IS_MANUFACTURE_RATE, true);
            this.setFieldStatus("jjkcbljjsff", false);
            property.setMustInput(false);
            this.getModel().setValue("jjkcbljjsff", (Object)"");
            this.setFieldStatus(YJ_DEDUCTIONTYPE, true);
            this.setFieldStatus(DEDUCTIONTYPE, false);
            this.getModel().setValue(DEDUCTIONTYPE, null);
        }
        if ("2".equals(newValue)) {
            this.setFieldStatus(IS_MANUFACTURE_RATE, false);
            this.setFieldStatus("jjkcbljjsff", true);
            property.setMustInput(true);
            BigDecimal value14 = isCal ? BigDecimal.valueOf(100L) : BigDecimal.ZERO;
            this.getModel().setValue("yffyjjkcjejsamount", (Object)value14, this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "14"));
            this.getView().setEnable(Boolean.valueOf(true), index15, new String[]{"yffyjjkcjejsamount"});
            this.setFieldStatus(DEDUCTIONTYPE, true);
            this.setFieldStatus(YJ_DEDUCTIONTYPE, false);
            this.getModel().setValue(YJ_DEDUCTIONTYPE, null);
            this.getModel().setValue("busstartdate", (Object)"");
            this.getModel().setValue("busenddate", (Object)"");
        }
        if (isCal) {
            this.getModel().setValue("yffyjjkcjejsamount", (Object)this.getDevelopFee12(), index15);
            this.getView().setEnable(Boolean.valueOf(false), index15, new String[]{"yffyjjkcjejsamount"});
        }
    }

    private void setFieldStatus(String field, boolean status) {
        this.getView().setVisible(Boolean.valueOf(status), new String[]{field});
        FieldEdit control1 = (FieldEdit)this.getControl(field);
        control1.setMustInput(status);
    }

    private void initData() {
        boolean isHide;
        this.getPageCache().put(isInitialKey, Boolean.FALSE.toString());
        BillModel model = (BillModel)this.getModel();
        Long pkValue = (Long)model.getPKValue();
        Date year = (Date)this.getModel().getValue(YEAR);
        boolean bl = isHide = year.compareTo(DateUtils.stringToDate((String)"2023-01-01")) >= 0;
        if (pkValue == null || pkValue == 0L) {
            this.initEmptySubEntrys("wtyfxmmx");
            this.initEmptySubEntrys("zzyfhz");
            this.iniYffyjjkcjejs(isHide, year);
        } else {
            this.loadSavedSubEntrys("wtyfxmmx");
            this.loadSavedSubEntrys("zzyfhz");
            if (isHide) {
                this.loadSavedSubEntrys("yffyjjkcjejs", Arrays.asList("12", "13", "16", "17"));
            } else {
                this.loadSavedSubEntrys("yffyjjkcjejs");
            }
        }
        this.getModel().setDataChanged(false);
        this.getPageCache().put(isInitialKey, Boolean.TRUE.toString());
    }

    private void iniYffyjjkcjejs(boolean isHide, Date year) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (isHide) {
            this.initEmptySubEntrys("yffyjjkcjejs", Arrays.asList("12", "13", "16", "17"));
        } else {
            this.initEmptySubEntrys("yffyjjkcjejs");
        }
        if (org != null && year != null) {
            this.getModel().setValue("yffyjjkcjejsamount", (Object)this.getYqndjzje(year, org), 9);
        }
    }

    private void loadSavedSubEntrys(String entryType, List<String> hideRow) {
        String itemtypeKey = this.formatKey(entryType, ITEMTYPE);
        String amountKey = this.formatKey(entryType, AMOUNT);
        ComboEdit comboEdit = (ComboEdit)this.getControl(itemtypeKey);
        ComboProp property = (ComboProp)comboEdit.getProperty();
        List comboItems = property.getComboItems();
        List needComboItems = comboItems.stream().filter(e -> !hideRow.contains(e.getValue())).collect(Collectors.toList());
        int size = needComboItems.size();
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryType + "entity");
        this.getModel().batchCreateNewEntryRow(entryType + "entity", size);
        hideRow.forEach(e -> {
            DevJjkcAmtMapEnum amtMapEnum = DevJjkcAmtMapEnum.byAmt(amountKey, Integer.parseInt(e) - 1);
            this.getModel().setValue(amtMapEnum.getSaveKey(), (Object)BigDecimal.ZERO);
        });
        for (int i = 0; i < size; ++i) {
            ValueMapItem comboItem = (ValueMapItem)needComboItems.get(i);
            this.getModel().setValue(itemtypeKey, (Object)comboItem.getValue(), i);
            DevJjkcAmtMapEnum amtMapEnum = DevJjkcAmtMapEnum.byAmt(amountKey, Integer.parseInt(comboItem.getValue()) - 1);
            if (amtMapEnum != null) {
                BigDecimal savedValue = (BigDecimal)this.getModel().getValue(amtMapEnum.getSaveKey());
                this.getModel().setValue(amountKey, (Object)savedValue, i);
                continue;
            }
            this.getModel().setValue(amountKey, (Object)0, i);
        }
        this.getModel().endInit();
        this.getView().updateView(entryType + "entity");
        this.setAmountDisable(entryType, size);
    }

    private void loadSavedSubEntrys(String entryType) {
        String itemtypeKey = this.formatKey(entryType, ITEMTYPE);
        String amountKey = this.formatKey(entryType, AMOUNT);
        ComboEdit comboEdit = (ComboEdit)this.getControl(itemtypeKey);
        ComboProp property = (ComboProp)comboEdit.getProperty();
        List comboItems = property.getComboItems();
        int size = comboItems.size();
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryType + "entity");
        this.getModel().batchCreateNewEntryRow(entryType + "entity", size);
        for (int i = 0; i < size; ++i) {
            ValueMapItem comboItem = (ValueMapItem)comboItems.get(i);
            this.getModel().setValue(itemtypeKey, (Object)comboItem.getValue(), i);
            DevJjkcAmtMapEnum amtMapEnum = DevJjkcAmtMapEnum.byAmt(amountKey, Integer.parseInt(comboItem.getValue()) - 1);
            if (amtMapEnum != null) {
                BigDecimal savedValue = (BigDecimal)this.getModel().getValue(amtMapEnum.getSaveKey());
                this.getModel().setValue(amountKey, (Object)savedValue, i);
                continue;
            }
            this.getModel().setValue(amountKey, (Object)0, i);
        }
        this.getModel().endInit();
        this.getView().updateView(entryType + "entity");
        this.setAmountDisable(entryType, size);
    }

    private void initEmptySubEntrys(String entryType, List<String> hideRow) {
        String itemtypeKey = this.formatKey(entryType, ITEMTYPE);
        String amountKey = this.formatKey(entryType, AMOUNT);
        ComboEdit comboEdit = (ComboEdit)this.getControl(itemtypeKey);
        ComboProp property = (ComboProp)comboEdit.getProperty();
        List comboItems = property.getComboItems();
        List needComboItems = comboItems.stream().filter(e -> !hideRow.contains(e.getValue())).collect(Collectors.toList());
        int size = needComboItems.size();
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryType + "entity");
        this.getModel().batchCreateNewEntryRow(entryType + "entity", size);
        int i = 0;
        for (ValueMapItem comboItem : needComboItems) {
            this.getModel().setValue(itemtypeKey, (Object)comboItem.getValue(), i);
            this.getModel().setValue(amountKey, (Object)0, i++);
        }
        this.getModel().endInit();
        this.getView().updateView(entryType + "entity");
        this.setAmountDisable(entryType, size);
    }

    private void initEmptySubEntrys(String entryType) {
        String itemtypeKey = this.formatKey(entryType, ITEMTYPE);
        String amountKey = this.formatKey(entryType, AMOUNT);
        ComboEdit comboEdit = (ComboEdit)this.getControl(itemtypeKey);
        ComboProp property = (ComboProp)comboEdit.getProperty();
        List comboItems = property.getComboItems();
        int size = comboItems.size();
        this.getModel().beginInit();
        this.getModel().deleteEntryData(entryType + "entity");
        this.getModel().batchCreateNewEntryRow(entryType + "entity", size);
        for (int i = 0; i < size; ++i) {
            ValueMapItem comboItem = (ValueMapItem)comboItems.get(i);
            this.getModel().setValue(itemtypeKey, (Object)comboItem.getValue(), i);
            this.getModel().setValue(amountKey, (Object)0, i);
        }
        this.getModel().endInit();
        this.getView().updateView(entryType + "entity");
        this.setAmountDisable(entryType, size);
    }

    private String formatKey(String entryType, String columnType) {
        return entryType + columnType;
    }

    private void setAmountDisable(String entryType, int size) {
        String amountKey = this.formatKey(entryType, AMOUNT);
        if (!this.noNeedDisableLastRowSet.contains(entryType)) {
            this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{amountKey});
        } else {
            int index14 = this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "14");
            this.getView().setEnable(Boolean.FALSE, index14, new String[]{amountKey});
            int index15 = this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "15");
            this.getView().setEnable(Boolean.FALSE, index15, new String[]{amountKey});
            int index18 = this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "18");
            this.getView().setEnable(Boolean.FALSE, index18, new String[]{amountKey});
            Integer[] integers = this.disableAmountRow.get(entryType);
            if (integers != null) {
                for (Integer index : integers) {
                    this.getView().setEnable(Boolean.FALSE, index.intValue(), new String[]{amountKey});
                }
            }
        }
    }

    private String getLastYearSbbid(String orgid, Date year) {
        Date skssqq = DateUtils.getFirstDateOfYear((Date)year);
        Date skssqz = DateUtils.getLastDateOfYear((Date)year);
        DynamicObject sbb = YbnsrService.queryYbnsr((String)orgid, (String)"qysdsnb", (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), (int)-12, null);
        if (sbb != null) {
            String declarestatus = sbb.getString("declarestatus");
            String billstatus = sbb.getString("billstatus");
            if (!"A".equals(billstatus) && "declared".equals(declarestatus)) {
                return sbb.getString("id");
            }
        }
        return null;
    }

    private String getIndustryByOrgId(Long orgId) {
        String industry = "";
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            Long codeandname = ((DynamicObject)result.getData()).getLong("codeandname.id");
            industry = this.getIndustry(codeandname);
        } else {
            logger.error("\u7ec4\u7ec7\u673a\u6784{}\uff1a\u6ca1\u6709\u914d\u7f6e\u6240\u5c5e\u884c\u4e1a\uff01", (Object)orgId);
        }
        return industry;
    }

    private String getIndustry(Long fid) {
        DynamicObject industryChild = QueryServiceHelper.queryOne((String)"tpo_tcvat_industrycode", (String)"number,parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fid)});
        String number = "";
        if (industryChild.getLong("parent") != 0L) {
            number = this.getIndustry(industryChild.getLong("parent"));
        }
        if (StringUtils.isEmpty((CharSequence)number)) {
            return industryChild.getString("number");
        }
        return number;
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        String key = this.TAB_ENTITY.get(tabKey);
        BillModel model = (BillModel)this.getModel();
        Long pkValue = (Long)model.getPKValue();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(key + "entity");
        if ((pkValue == null || pkValue == 0L) && CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.initEmptySubEntrys(key);
        } else {
            this.loadSavedSubEntrys(key);
        }
        this.getModel().setDataChanged(false);
    }

    private void setDeductionRate(int currentyear, String property) {
        int index = this.getIndex("yffyjjkcjejsentity", "yffyjjkcjejsitemtype", "14");
        if (property.equals(IS_MANUFACTURE_RATE)) {
            Object ismanufacturerate = this.getModel().getValue(IS_MANUFACTURE_RATE);
            if (null != ismanufacturerate) {
                if (ismanufacturerate.equals("1")) {
                    BigDecimal deductionRate = this.getDeductionRate(currentyear, "YFJJ-KCBL(TS)");
                    this.getModel().setValue("yffyjjkcjejsamount", (Object)deductionRate, index);
                } else {
                    BigDecimal deductionRate = this.getDeductionRate(currentyear, "YFFY-JJKC");
                    this.getModel().setValue("yffyjjkcjejsamount", (Object)deductionRate, index);
                }
            }
        } else {
            Object deductiontype = this.getModel().getValue(DEDUCTIONTYPE);
            if (null != deductiontype) {
                if (deductiontype.equals("2")) {
                    this.getModel().setValue(IS_MANUFACTURE_RATE, (Object)"1");
                    BigDecimal deductionRate = this.getDeductionRate(currentyear, "YFJJ-KCBL(TS)");
                    this.getModel().setValue("yffyjjkcjejsamount", (Object)deductionRate, index);
                } else {
                    this.getModel().setValue(IS_MANUFACTURE_RATE, (Object)"0");
                    BigDecimal deductionRate = this.getDeductionRate(currentyear, "YFFY-JJKC");
                    this.getModel().setValue("yffyjjkcjejsamount", (Object)deductionRate, index);
                }
            }
        }
    }

    private BigDecimal getDeductionRate(int year, String number) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        QFilter statusFilter = new QFilter("entryentity.fstatus1", "=", (Object)"1");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tcvat_assist", (String)"entryentity.fvalue1,entryentity.startdate,entryentity.enddate", (QFilter[])new QFilter[]{numberFilter, statusFilter});
        if (null != dynamicObject) {
            int startyear = 0;
            int endyear = 0;
            Date startdate = dynamicObject.getDate("entryentity.startdate");
            Date enddate = dynamicObject.getDate("entryentity.enddate");
            if (null == startdate && null == enddate) {
                return dynamicObject.getBigDecimal("entryentity.fvalue1");
            }
            if (null != startdate && null == enddate) {
                startyear = DateUtils.getYearOfDate((Date)startdate);
                if (year >= startyear) {
                    return dynamicObject.getBigDecimal("entryentity.fvalue1");
                }
                return new BigDecimal(0);
            }
            if (null == startdate && null != enddate) {
                endyear = DateUtils.getYearOfDate((Date)enddate);
                if (year <= endyear) {
                    return dynamicObject.getBigDecimal("entryentity.fvalue1");
                }
                return new BigDecimal(0);
            }
            startyear = DateUtils.getYearOfDate((Date)startdate);
            endyear = DateUtils.getYearOfDate((Date)enddate);
            if (startyear <= year && year <= endyear) {
                return dynamicObject.getBigDecimal("entryentity.fvalue1");
            }
            return new BigDecimal(0);
        }
        return new BigDecimal(0);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter;
        Object year;
        String name = evt.getProperty().getName();
        if ("jjkcbljjsff".equals(name)) {
            year = this.getModel().getValue(YEAR);
            if (Objects.isNull(year)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e74\u5ea6", (String)"DevelopJjkcEdit_8", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter listFilter = new QFilter("number", "in", (Object)new String[]{"110", "121", "122"});
            listFilter.and(new QFilter("bizdef.number", "=", (Object)"CIT-YFJJKC"));
            listFilter.and(new QFilter("validfrom", "<=", year).and(new QFilter("expired", ">=", year).or(new QFilter("expired", "is null", null))));
            listShowParameter.getListFilterParameter().setFilter(listFilter);
        }
        if (YJ_DEDUCTIONTYPE.equals(name)) {
            year = (Date)this.getModel().getValue(YEAR);
            if (year == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e74\u5ea6", (String)"DevelopJjkcEdit_8", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter typeFilter = DevelopJjkcService.createYjdeductionTypeFilter((Date)year);
            TreeFilterParameter treeFilterParameter = listShowParameter.getTreeFilterParameter();
            treeFilterParameter.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{typeFilter}));
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            listFilterParameter.getQFilters().add(typeFilter);
            listFilterParameter.getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
        }
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        Map searchResult = e.getSearchResult();
        block0: for (Map.Entry entry : searchResult.entrySet()) {
            BasedataItem key = (BasedataItem)entry.getKey();
            List value = (List)entry.getValue();
            if (!key.getFieldKey().equals("jjkcbljjsff")) continue;
            for (Object o : value) {
                boolean exists = QueryServiceHelper.exists((String)"tpo_tccit_bizdef_entry", (QFilter[])new QFilter[]{new QFilter("bizdef.number", "=", (Object)"CIT-YFJJKC").and(new QFilter("id", "=", o))});
                if (!exists) continue;
                entry.setValue(Collections.singletonList(o));
                continue block0;
            }
        }
    }
}

