/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class EquityIncentivPlugin
extends ExtendAbstractBillPlugin {
    private static final String INCENTIVESTATE = "incentivestate";
    private static final String GPRICE = "gprice";
    private static final String PRICESUM = "pricesum";
    private static final String XPRICE = "xprice";
    private static final String OUTMONEY = "outmoney";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (INCENTIVESTATE.equals(e.getProperty().getName())) {
            if ("grant".equals(this.getModel().getValue(INCENTIVESTATE))) {
                this.getModel().setValue(XPRICE, null);
                this.getModel().setValue(OUTMONEY, null);
            } else if ("exercise".equals(this.getModel().getValue(INCENTIVESTATE))) {
                this.getModel().setValue(GPRICE, null);
                this.getModel().setValue(PRICESUM, null);
            }
        }
        if (Lists.newArrayList((Object[])new String[]{"count", GPRICE, XPRICE}).contains(e.getProperty().getName())) {
            if ("grant".equals(this.getModel().getValue(INCENTIVESTATE))) {
                Integer count = this.getModel().getValue("count") != null ? (Integer)this.getModel().getValue("count") : 0;
                BigDecimal gprice = this.getModel().getValue(GPRICE) != null ? (BigDecimal)this.getModel().getValue(GPRICE) : BigDecimal.ZERO;
                this.getModel().setValue(PRICESUM, (Object)gprice.multiply(new BigDecimal(count)));
            } else if ("exercise".equals(this.getModel().getValue(INCENTIVESTATE))) {
                Integer count = this.getModel().getValue("count") != null ? (Integer)this.getModel().getValue("count") : 0;
                BigDecimal gprice = this.getModel().getValue(GPRICE) != null ? (BigDecimal)this.getModel().getValue(GPRICE) : BigDecimal.ZERO;
                BigDecimal xprice = this.getModel().getValue(XPRICE) != null ? (BigDecimal)this.getModel().getValue(XPRICE) : BigDecimal.ZERO;
                this.getModel().setValue(OUTMONEY, (Object)new BigDecimal(count).multiply(xprice.subtract(gprice)));
            }
        }
    }
}

