/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class GatherAssetsZjTxListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(GatherAssetsZjTxListPlugin.class);
    private static final String TCCIT_HJZCZJTX_ACCOUNT = "tccit_hjzczjtx_account";
    private static final String DIFF_RESULT_ENTITY = "tccit_tax_acce_diff";
    private static final String TOOLBARAP = "toolbarap";
    private static final String BILLLISTAP = "billlistap";
    private static final String JSZJTXLXBN = "jszjtxlxbn";
    private static final String DATASYNBN = "datasynbn";
    private static final String SYQZC = "syqzc";
    private static final String BZSRXCDZC = "bzsrxcdzc";
    private static final String NO_YFXCDWXZC = "noyfxcdwxzc";
    private static final String YES_YFXCDWXZC = "yesyfxcdwxzc";
    private static final Set<String> bnts = Sets.newHashSet((Object[])new String[]{"syqzc", "bzsrxcdzc", "noyfxcdwxzc", "yesyfxcdwxzc", "jszjtxlxbn"});
    private static final List<String> suzclbNumber = Lists.newArrayList((Object[])new String[]{"701020101", "701020102", "701020103", "701020104", "701020105", "701020106", "701020201", "701020202", "701020301", "701020302", "701020303", "701020304", "701020305", "701020306", "701020307", "701020308", "701020401", "701020402", "701020403", "701020404", "701020405", "701020501", "701020502"});
    private static final List<Future> futures = new ArrayList<Future>();

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARAP});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key = evt.getOperateKey();
        BillList billlist = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (bnts.contains(key)) {
            if (CollectionUtils.isEmpty((Collection)list)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u6761\u6570\u636e", (String)"GatherAssetsZjTxListPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] totalassetsMes = BusinessDataServiceHelper.load((Object[])list.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCCIT_HJZCZJTX_ACCOUNT));
            if (SYQZC.equals(key)) {
                Arrays.stream(totalassetsMes).forEach(i -> i.set("glqtnstzsx", (Object)SYQZC));
            }
            if (BZSRXCDZC.equals(key)) {
                Arrays.stream(totalassetsMes).forEach(i -> i.set("glqtnstzsx", (Object)BZSRXCDZC));
            }
            if (NO_YFXCDWXZC.equals(key)) {
                Arrays.stream(totalassetsMes).forEach(i -> i.set("yfxcdwxzc", (Object)Character.valueOf('0')));
            }
            if (YES_YFXCDWXZC.equals(key)) {
                Arrays.stream(totalassetsMes).forEach(i -> i.set("yfxcdwxzc", (Object)Character.valueOf('1')));
            }
            SaveServiceHelper.update((DynamicObject[])totalassetsMes);
            if (!JSZJTXLXBN.equals(key)) {
                billlist.clearSelection();
                billlist.refresh();
            }
        }
        if (DATASYNBN.equals(key)) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bos_org", (boolean)true, (int)2);
            showParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
            showParameter.getCustomParams().put("orgFuncId", "40");
            showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u7ec4\u7ec7\u8fdb\u884c\u6570\u636e\u540c\u6b65", (String)"GatherAssetsZjTxListPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DATASYNBN));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String name = args.getFieldName();
        HashMap newHashMap = Maps.newHashMap();
        if ("taxassetstype.name".equals(name)) {
            newHashMap.put("type", "zcajust");
            newHashMap.put("suzclbNumber", suzclbNumber);
            args.setCustomParams((Map)newHashMap);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (DATASYNBN.equals(actionId) && evt.getReturnData() != null) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
            Object[] primaryKeyValues = returnData.getPrimaryKeyValues();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5f00\u59cb\uff0c\u8bf7\u7a0d\u5019", (String)"GatherAssetsZjTxListPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), Integer.valueOf(3000));
            futures.clear();
            for (Object primaryKeyValue : primaryKeyValues) {
                Future futrue = ThreadPoolsService.getInstance().submitFutrue(() -> {
                    QFilter[] filters = new QFilter[]{new QFilter("org", "=", primaryKeyValue)};
                    Object[] load = BusinessDataServiceHelper.load((String)DIFF_RESULT_ENTITY, (String)"id,parentid,org,assetsnumber,assetsname,postingdate,taxassetstype,zctype", (QFilter[])filters);
                    if (ArrayUtils.isNotEmpty((Object[])load)) {
                        Arrays.stream(load).forEach(i -> i.set("parentid", (Object)0));
                        SaveServiceHelper.save((DynamicObject[])load);
                    }
                    DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_HJZCZJTX_ACCOUNT, (String)"assetsnumber,buytime,glqtnstzsx,yfxcdwxzc,jszjtxlx", (QFilter[])filters);
                    Map<String, DynamicObject> map = query.stream().collect(Collectors.toMap(d -> d.getString("assetsnumber"), d -> d));
                    DeleteServiceHelper.delete((String)TCCIT_HJZCZJTX_ACCOUNT, (QFilter[])filters);
                    if (ArrayUtils.isNotEmpty((Object[])load)) {
                        HashMap<String, List> diffDyos = new HashMap<String, List>();
                        ArrayList gatherAssetsObjects = Lists.newArrayList();
                        for (Object dyo : load) {
                            String mapKey = dyo.getString("org.id") + "_" + dyo.getString("assetsnumber");
                            List values = (List)diffDyos.get(mapKey);
                            if (CollectionUtils.isEmpty((Collection)values)) {
                                diffDyos.put(mapKey, Lists.newArrayList((Object[])new DynamicObject[]{dyo}));
                                DynamicObject gatherAssets = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_HJZCZJTX_ACCOUNT);
                                this.setProperty((DynamicObject)dyo, gatherAssets, map.get("assetsnumber"));
                                gatherAssetsObjects.add(gatherAssets);
                                continue;
                            }
                            values.add(dyo);
                            diffDyos.put(mapKey, values);
                        }
                        SaveServiceHelper.save((DynamicObject[])gatherAssetsObjects.toArray(new DynamicObject[0]));
                        for (DynamicObject gatherAssets : gatherAssetsObjects) {
                            ThreadPoolsService.getInstance().submitFutrue(() -> {
                                String mapKey1 = gatherAssets.getString("org.id") + "_" + gatherAssets.getString("assetsnumber");
                                List dynamicObjects1 = (List)diffDyos.get(mapKey1);
                                dynamicObjects1.forEach(i -> i.set("parentid", gatherAssets.getPkValue()));
                                SaveServiceHelper.update((DynamicObject[])dynamicObjects1.toArray(new DynamicObject[0]));
                                return null;
                            });
                        }
                    }
                    return null;
                });
                futures.add(futrue);
            }
            this.getView().addClientCallBack("datasync_callback");
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if ("datasync_callback".equals(e.getName())) {
            try {
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (Exception exception) {
                logger.error("\u540c\u6b65\u6c47\u7f34\u8d44\u4ea7\u6298\u65e7\u644a\u9500\u53f0\u8d26\u65f6\u9519\u8bef\uff1a", (Throwable)exception);
            }
            BillList billlist = (BillList)this.getControl(BILLLISTAP);
            billlist.clearSelection();
            billlist.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5b8c\u6210", (String)"GatherAssetsZjTxListPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public List<QFilter> getQFilters() {
                List qFilters = super.getQFilters();
                List<QFilter> collect = qFilters.stream().filter(qf -> !"status".equals(qf.getProperty())).collect(Collectors.toList());
                super.setQFilters(collect);
                return collect;
            }
        });
    }

    private void setProperty(DynamicObject dyo, DynamicObject gatherAssets, DynamicObject dynamicObject) {
        gatherAssets.set("org", dyo.get("org"));
        gatherAssets.set("assetsnumber", dyo.get("assetsnumber"));
        gatherAssets.set("assetsname", dyo.get("assetsname"));
        gatherAssets.set("postingdate", dyo.get("postingdate"));
        gatherAssets.set("taxassetstype", dyo.get("taxassetstype"));
        gatherAssets.set("zctype", dyo.get("zctype"));
        gatherAssets.set("enable", (Object)"1");
        if (dynamicObject != null) {
            gatherAssets.set("buytime", dynamicObject.get("buytime"));
            gatherAssets.set("glqtnstzsx", dynamicObject.get("glqtnstzsx"));
            gatherAssets.set("yfxcdwxzc", dynamicObject.get("yfxcdwxzc"));
        }
    }
}

