/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class GetReduceAccEditPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    public static final Set<Long> techId = Sets.newHashSet((Object[])new Long[]{1064511039091315712L, 1119482547752284160L});

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit item = (BasedataEdit)this.getControl("nreducename");
        item.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("nreducename".equals(name)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            Set collect = entryentity.stream().filter(s -> s.getDynamicObject("nreducename") != null).map(s -> s.getDynamicObject("nreducename").getString("number")).collect(Collectors.toSet());
            if (collect.contains("40401") || collect.contains("40402")) {
                collect.remove("40401");
                collect.remove("40402");
                if (collect.size() > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u9879\u76ee\u53f0\u8d26\u4e2d\u4e0d\u652f\u6301\u540c\u65f6\u7ef4\u62a4\u6280\u672f\u7c7b\u9879\u76ee\u548c\u975e\u6280\u672f\u7c7b\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4f18\u60e0\u4e8b\u9879\u540d\u79f0", (String)"GetReduceAccEditPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                    this.getModel().setValue("nreducename", (Object)"");
                    return;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"firstyear"});
                this.getModel().setValue("firstyear", (Object)DateUtils.stringToDate((String)"1999-01-01", (String)"yyyy-MM-dd"));
            } else {
                Object oldValue = e.getChangeSet()[0].getOldValue();
                if (oldValue != null && techId.contains(((DynamicObject)oldValue).get("id"))) {
                    this.getModel().setValue("firstyear", null);
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"firstyear"});
            }
        }
        if ("year".equals(name)) {
            this.getModel().setValue("nreducename", (Object)"");
            this.getModel().setValue("dnyhbl", (Object)"");
            this.getModel().setValue("income", (Object)0);
            this.getModel().setValue("cost", (Object)0);
            this.getModel().setValue("relaxtax", (Object)0);
            this.getModel().setValue("periodcost", (Object)0);
            this.getModel().setValue("dividescale", (Object)0);
            this.getModel().setValue("qjfyfte", (Object)0);
            this.getModel().setValue("nstz", (Object)0);
            this.getModel().setValue("xmsde", (Object)0);
            this.getModel().setValue("sonremarks", (Object)"");
            Object year = this.getModel().getValue("year");
            Object firstyear = this.getModel().getValue("firstyear");
            if (year != null && firstyear != null && DateUtils.getYearOfDate((Date)((Date)year)) - DateUtils.getYearOfDate((Date)((Date)firstyear)) < 0) {
                this.getModel().setValue("dnyhbl", (Object)"\u2014\u2014");
            }
            return;
        }
        Object reducename = this.getModel().getValue("nreducename");
        if (reducename == null) {
            return;
        }
        if ("periodcost".equals(name) || "dividescale".equals(name)) {
            Object periodcost = this.getModel().getValue("periodcost");
            Object dividescale = this.getModel().getValue("dividescale");
            Object qjfyfte = this.getModel().getValue("qjfyfte");
            if (periodcost != null && dividescale != null && qjfyfte != null && ((BigDecimal)periodcost).multiply((BigDecimal)dividescale).compareTo((BigDecimal)qjfyfte) != 0) {
                this.getModel().setValue("qjfyfte", (Object)((BigDecimal)periodcost).multiply((BigDecimal)dividescale));
            }
        }
        DynamicObject reducenameObj = (DynamicObject)reducename;
        String projtype = reducenameObj.getString("projtype");
        if ("nreducename".equals(name) || "firstyear".equals(name)) {
            Object year = this.getModel().getValue("year");
            Object firstyear = this.getModel().getValue("firstyear");
            if (reducename != null && year != null && firstyear != null) {
                String number = reducenameObj.getString("number");
                int subyear = DateUtils.getYearOfDate((Date)((Date)year)) - DateUtils.getYearOfDate((Date)((Date)firstyear));
                if (subyear < 0) {
                    this.getModel().setValue("dnyhbl", (Object)"\u2014\u2014");
                    return;
                }
                if ("9".equals(projtype)) {
                    ComboEdit comboEdit = (ComboEdit)this.getControl("dnyhbl");
                    ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                    items.add(new ComboItem(new LocaleString("50%"), "0.5"));
                    items.add(new ComboItem(new LocaleString("100%"), "1"));
                    comboEdit.setComboItems(items);
                    this.getModel().setValue("dnyhbl", null);
                    return;
                }
                if (!"40401".equals(number) && !"40402".equals(number)) {
                    String dnyhbl = "\u2014\u2014";
                    if ("1".equals(projtype)) {
                        dnyhbl = "1";
                    } else if ("4".equals(projtype)) {
                        dnyhbl = "0.5";
                    } else if ("7".equals(projtype)) {
                        if (subyear >= 0 && subyear <= 1) {
                            dnyhbl = "1";
                        } else if (subyear >= 2 && subyear <= 4) {
                            dnyhbl = "0.5";
                        }
                    } else if ("5".equals(projtype)) {
                        if (subyear >= 0 && subyear <= 2) {
                            dnyhbl = "1";
                        } else if (subyear >= 3 && subyear <= 5) {
                            dnyhbl = "0.5";
                        }
                    } else if ("8".equals(projtype)) {
                        if (subyear >= 0 && subyear <= 4) {
                            dnyhbl = "1";
                        } else if (subyear >= 5 && subyear <= 9) {
                            dnyhbl = "0.5";
                        }
                    } else if (subyear < 11 && "13".equals(projtype)) {
                        dnyhbl = "1";
                    }
                    this.getModel().setValue("dnyhbl", (Object)dnyhbl);
                }
            }
        } else {
            super.propertyChanged(e);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().equals("nreducename")) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("template", (Object)"qysdsnb");
            formShowParameter.setCustomParam("type", (Object)"yhxm");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String number;
        Long orgid;
        boolean notAuthorize;
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && (notAuthorize = LicenseCheckServiceHelper.check((Object)(orgid = Long.valueOf(org.getLong("id"))), (IFormView)this.getView(), (String)"tccit"))) {
            this.getModel().setValue("org", null);
            return;
        }
        Object nreducename = this.getView().getModel().getValue("nreducename");
        if (nreducename != null && ("40401".equals(number = ((DynamicObject)nreducename).getString("number")) || "40402".equals(number))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"firstyear"});
            this.getModel().setValue("firstyear", (Object)DateUtils.stringToDate((String)"1999-01-01", (String)"yyyy-MM-dd"));
        }
    }
}

