/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.tccit.business.taxbook.GovSubsidyDeferService;
import kd.taxc.tccit.common.utils.LocalDateUtils;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;
import org.apache.commons.lang.StringUtils;

public class GovSubsidyDeferEdit
extends ExtendAbstractBillPlugin {
    private static final String RECEIVED_SUBSIDE = "tccit_rec_subsidy";
    private static final String CARRY_FWD_LOSS = "tccit_carry_fwd_loss";
    private static final String S_AMOUNT = "s_amount";
    private static final String J_AMOUNT = "j_amount";
    private static final String LJ_SDBZ_AMOUNT = "ljsdbzamount";
    private static final String LJ_JZSY_AMOUNT = "ljjzsyamount";
    private static final String S_DELETE_ENTRY = "s_deleteentry";
    private static final String J_DELETE_ENTRY = "j_deleteentry";
    private static final String TOTAL_AMOUNT = "totalamt";
    private static GovSubsidyDeferService deferService = new GovSubsidyDeferService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateLjsdbzamount();
        this.updateLjjzsyamount();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if (S_DELETE_ENTRY.equals(key) && this.isJzsyMoreThanSdbz()) {
            args.setCancel(true);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        this.reWriteMiddTable();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String optKey;
        super.afterDoOperation(args);
        switch (optKey = args.getOperateKey()) {
            case "s_deleteentry": {
                this.updateLjsdbzamount();
                break;
            }
            case "j_deleteentry": {
                this.updateLjjzsyamount();
                break;
            }
            case "save": {
                if (!args.getOperationResult().isSuccess()) break;
                this.reWriteMiddTable();
            }
        }
    }

    private void reWriteMiddTable() {
        try (TXHandle h = TX.required();){
            try {
                Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElseGet(() -> null);
                if (orgId != null) {
                    DeleteServiceHelper.delete((String)"tccit_govdefer_middle", (QFilter[])new QFilter[]{new QFilter("billno", "=", this.getModel().getValue("billno")), new QFilter("org", "=", (Object)orgId)});
                    DynamicObjectCollection rec = this.getModel().getEntryEntity(RECEIVED_SUBSIDE);
                    DynamicObjectCollection cfl = this.getModel().getEntryEntity(CARRY_FWD_LOSS);
                    deferService.saveGovDeferMiddle(rec, cfl, year -> this.newMiddleObject((Integer)year));
                }
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "s_amount": {
                this.checkAndUpdateLjsdbzamount(args);
                break;
            }
            case "j_amount": {
                this.checkAndUpdateLjjzsyamount(args);
                break;
            }
            case "totalamt": {
                this.totalAmountChange(args);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"modifyTotalAmt", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().deleteEntryData(RECEIVED_SUBSIDE);
                this.getModel().deleteEntryData(CARRY_FWD_LOSS);
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put("cancelFlag", "true");
                this.getModel().setValue(TOTAL_AMOUNT, (Object)new BigDecimal(messageBoxClosedEvent.getCustomVaule()));
                this.getPageCache().put("cancelFlag", "false");
            }
        }
    }

    private void totalAmountChange(PropertyChangedArgs args) {
        boolean modifyExistBillTotalAmount;
        BigDecimal oldValue = (BigDecimal)args.getChangeSet()[0].getOldValue();
        BigDecimal newValue = (BigDecimal)args.getChangeSet()[0].getNewValue();
        Long billId = this.getModel().getDataEntity().getLong("id");
        String cancelFlag = this.getPageCache().get("cancelFlag");
        boolean bl = modifyExistBillTotalAmount = !"true".equals(cancelFlag) && billId != 0L;
        if (modifyExistBillTotalAmount && oldValue.compareTo(BigDecimal.ZERO) != 0 && oldValue.compareTo(newValue) != 0) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("modifyTotalAmt", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u5408\u540c\u603b\u91d1\u989d\u4f1a\u5bfc\u81f4\u53f0\u8d26\u6570\u636e\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"GovSubsidyDeferEdit_0", (String)"taxc-tccit", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, new HashMap(), oldValue.toString());
        }
    }

    private void updateLjsdbzamount() {
        IDataModel model = this.getModel();
        BigDecimal ljsdbzamount = this.calcLjAmount(RECEIVED_SUBSIDE, S_AMOUNT);
        model.setValue(LJ_SDBZ_AMOUNT, (Object)ljsdbzamount);
    }

    private void updateLjjzsyamount() {
        IDataModel model = this.getModel();
        BigDecimal ljjzsyamount = this.calcLjAmount(CARRY_FWD_LOSS, J_AMOUNT);
        model.setValue(LJ_JZSY_AMOUNT, (Object)ljjzsyamount);
    }

    private void checkAndUpdateLjsdbzamount(PropertyChangedArgs args) {
        BigDecimal totalAmt;
        IDataModel model = this.getModel();
        BigDecimal ljsdbzamount = this.calcLjAmount(RECEIVED_SUBSIDE, S_AMOUNT);
        if (ljsdbzamount.compareTo(totalAmt = (BigDecimal)model.getValue(TOTAL_AMOUNT)) > 0) {
            this.rollbackPropertyChange(args);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6536\u5230\u8865\u52a9\u91d1\u989d\u5408\u8ba1\u4e0d\u5f97\u8d85\u8fc7\u5408\u540c\u603b\u91d1\u989d", (String)"GovSubsidyDeferEdit_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        if (this.isJzsyMoreThanSdbz()) {
            this.rollbackPropertyChange(args);
            return;
        }
        model.setValue(LJ_SDBZ_AMOUNT, (Object)ljsdbzamount);
    }

    private void checkAndUpdateLjjzsyamount(PropertyChangedArgs args) {
        IDataModel model = this.getModel();
        BigDecimal ljjzsyamount = this.calcLjAmount(CARRY_FWD_LOSS, J_AMOUNT);
        if (this.isJzsyMoreThanSdbz()) {
            this.rollbackPropertyChange(args);
            return;
        }
        model.setValue(LJ_JZSY_AMOUNT, (Object)ljjzsyamount);
    }

    private BigDecimal calcLjAmount(String entryName, String amountName) {
        BigDecimal ljAmount = BigDecimal.ZERO;
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(entryName);
        for (int i = 0; i < count; ++i) {
            ljAmount = ljAmount.add((BigDecimal)model.getValue(amountName, i));
        }
        return ljAmount;
    }

    private DynamicObject newMiddleObject(Integer year) {
        DynamicObject middle = BusinessDataServiceHelper.newDynamicObject((String)"tccit_govdefer_middle");
        middle.set("year", (Object)LocalDateUtils.localDate2Date(LocalDate.of((int)year, 1, 1)));
        middle.set("org", this.getModel().getValue("org"));
        middle.set("billno", this.getModel().getValue("billno"));
        middle.set("subsidytype", this.getModel().getValue("subsidytype"));
        middle.set("htzje", this.getModel().getValue(TOTAL_AMOUNT));
        middle.set("name", this.getModel().getValue("name"));
        middle.set("govdepartment", this.getModel().getValue("govdepartment"));
        middle.set("accountingmethod", this.getModel().getValue("accountingmethod"));
        middle.set(LJ_SDBZ_AMOUNT, this.getModel().getValue(LJ_SDBZ_AMOUNT));
        middle.set(LJ_JZSY_AMOUNT, this.getModel().getValue(LJ_JZSY_AMOUNT));
        middle.set("sywjzamount", this.getModel().getValue("sywjzamount"));
        middle.set("relateassetcode", this.getModel().getValue("relateassetcode"));
        middle.set("note", this.getModel().getValue("note"));
        middle.set("billstatus", this.getModel().getValue("billstatus"));
        return middle;
    }

    private boolean isJzsyMoreThanSdbz() {
        BigDecimal ljsdbzamount = this.calcLjAmount(RECEIVED_SUBSIDE, S_AMOUNT);
        BigDecimal ljjzsyamount = this.calcLjAmount(CARRY_FWD_LOSS, J_AMOUNT);
        if (ljjzsyamount.compareTo(ljsdbzamount) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed3\u8f6c\u635f\u76ca\u91d1\u989d\u5408\u8ba1\u4e0d\u5f97\u8d85\u8fc7\u6536\u5230\u8865\u52a9\u91d1\u989d\u5408\u8ba1\u6570", (String)"GovSubsidyDeferEdit_2", (String)"taxc-tccit", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }
}

