/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class HighTechAccountListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(HighTechAccountListPlugin.class);
    private static final String KEY_RATE_1 = "keyrate1";
    private static final String KEY_RATE_2 = "keyrate2";
    private static final String KEY_RATE_3 = "keyrate3";
    private static final Set<String> sets = Sets.newHashSet((Object[])new String[]{"keyrate1", "keyrate2", "keyrate3"});

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject d = e.getRowData();
        if (sets.contains(columnDesc.getFieldKey())) {
            e.setFormatValue((Object)String.format("%s%%", d.getBigDecimal(columnDesc.getFieldKey()).multiply(new BigDecimal("100")).setScale(2, 4)));
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        ArrayList rateColumns = Lists.newArrayList((Object[])new String[]{"peoplerate", KEY_RATE_1, KEY_RATE_2, KEY_RATE_3, "incomerate", "developrate"});
        HashMap<String, String> entryRateColumnMap = new HashMap<String, String>();
        entryRateColumnMap.put("incomerate", "incometype");
        entryRateColumnMap.put("developrate", "developtype");
        String incomeType = ResManager.loadKDString((String)"\u672c\u5e74\u9ad8\u65b0\u6536\u5165\u5360\u6bd4", (String)"HighTechAccountListPlugin_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        String developType = ResManager.loadKDString((String)"\u4e09\u5e74\u7814\u53d1\u8d39\u7528\u5360\u9500\u552e\uff08\u8425\u4e1a\uff09\u6536\u5165\u7684\u6bd4\u4f8b", (String)"HighTechAccountListPlugin_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
        File file = e.getFile();
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                HashMap<Integer, String> columnNameIndexMap = new HashMap<Integer, String>();
                for (Row row : sheet) {
                    int rowNum = row.getRowNum();
                    for (Cell cell : row) {
                        int columnIndex = cell.getColumnIndex();
                        if (rowNum == 2) {
                            columnNameIndexMap.put(columnIndex, cell.getStringCellValue());
                            continue;
                        }
                        if (rowNum < 4 || !rateColumns.contains(columnNameIndexMap.get(columnIndex))) continue;
                        String entryRate = (String)columnNameIndexMap.get(columnIndex);
                        if (entryRateColumnMap.containsKey(entryRate)) {
                            Integer rateTypeIndex = columnNameIndexMap.entrySet().stream().filter(s -> ((String)s.getValue()).equals(entryRateColumnMap.get(entryRate))).map(s -> (Integer)s.getKey()).findFirst().get();
                            Cell rateType = cell.getRow().getCell(rateTypeIndex.intValue());
                            if (!rateType.getStringCellValue().equals(incomeType) && !rateType.getStringCellValue().equals(developType)) continue;
                            cell.setCellValue(this.getRate(cell));
                            cell.getCellStyle().setAlignment(HorizontalAlignment.RIGHT);
                            continue;
                        }
                        cell.setCellValue(this.getRate(cell));
                        cell.getCellStyle().setAlignment(HorizontalAlignment.RIGHT);
                    }
                }
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage());
            }
        }
    }

    private String getRate(Cell cell) {
        return String.format("%s%%", new BigDecimal(cell.getNumericCellValue()).multiply(new BigDecimal("100")).setScale(2, 4).toString());
    }
}

