/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class HighTechAccountPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    private static final String YEAR = "year";
    private static final String HIGH_TECH_SCOPE = "hightechscope";
    private static final String INCOME_ENTRYENTITY = "incomeentryentity";
    private static final String DEVELOP_ENTRYENTITY = "developentryentity";
    private static final String KEY_RATE_1 = "keyrate1";
    private static final String KEY_RATE_2 = "keyrate2";
    private static final String KEY_RATE_3 = "keyrate3";
    private static final String PEOPLES = "peoples";
    private static final String TOTAL_PEOPLES = "totalpeoples";
    private static final String PEOPLE_RATE = "peoplerate";
    private static final String INCOME_TYPE = "incometype";
    private static final String INCOME_RATE = "incomerate";
    private static final String DEVELOP_TYPE = "developtype";
    private static final String CURR_YEAR = "curryear";
    private static final String PRE_TWO_YEAR = "pretwoyear";
    private static final String PRE_THREE_YEAR = "prethreeyear";
    private static final String DEVELOP_RATE = "developrate";
    private static final List<String> INCOME_TYPES = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7"});
    private static final List<String> DEVELOP_TYPES = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"});
    private static final Set<String> DEVELOP_YEARS = Sets.newHashSet((Object[])new String[]{"curryear", "pretwoyear", "prethreeyear"});

    public void initialize() {
        BasedataEdit item = (BasedataEdit)this.getControl(HIGH_TECH_SCOPE);
        item.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(INCOME_ENTRYENTITY);
        entryGrid.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
        EntryGrid entryGrid2 = (EntryGrid)this.getControl(DEVELOP_ENTRYENTITY);
        entryGrid2.addPackageDataListener(event -> this.packageData((PackageDataEvent)event));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        Map customParams = evt.getFormShowParameter().getCustomParams();
        customParams.put("caption", ResManager.loadKDString((String)"\u9ad8\u65b0\u6280\u672f\u6240\u5c5e\u8303\u56f4", (String)"HighTechAccountPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        customParams.put("parentNum", "4,5,6,7,8,9,10,11");
    }

    public void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject d = e.getRowData();
        if (columnDesc.getEntryKey().equals(DEVELOP_ENTRYENTITY)) {
            if (d.getInt("seq") == 16 && DEVELOP_YEARS.contains(columnDesc.getKey())) {
                e.setFormatValue((Object)"\u2014\u2014");
            } else if (d.getInt("seq") == 16 && DEVELOP_RATE.equals(columnDesc.getKey())) {
                BigDecimal multiply = d.getBigDecimal(DEVELOP_RATE).multiply(new BigDecimal("100")).setScale(2, 4);
                e.setFormatValue((Object)(multiply.toString() + "%"));
            }
        } else if (columnDesc.getEntryKey().equals(INCOME_ENTRYENTITY) && d.getInt("seq") == 7 && INCOME_RATE.equals(columnDesc.getKey())) {
            BigDecimal multiply = d.getBigDecimal(INCOME_RATE).multiply(new BigDecimal("100")).setScale(2, 4);
            e.setFormatValue((Object)(multiply.toString() + "%"));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void initData() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"match1", "match2", "match3"});
        this.lockRow();
        IDataModel model = this.getModel();
        Date year = (Date)model.getValue(YEAR);
        model.beginInit();
        model.batchCreateNewEntryRow(INCOME_ENTRYENTITY, INCOME_TYPES.size());
        int income_row_Index = 0;
        for (String incomeType : INCOME_TYPES) {
            model.setValue(INCOME_TYPE, (Object)incomeType, income_row_Index);
            model.setValue(INCOME_RATE, (Object)BigDecimal.ZERO, income_row_Index);
            ++income_row_Index;
        }
        model.batchCreateNewEntryRow(DEVELOP_ENTRYENTITY, DEVELOP_TYPES.size());
        int develop_row_Index = 0;
        for (String developType : DEVELOP_TYPES) {
            model.setValue(DEVELOP_TYPE, (Object)developType, develop_row_Index);
            model.setValue(CURR_YEAR, (Object)BigDecimal.ZERO, develop_row_Index);
            model.setValue(PRE_TWO_YEAR, (Object)this.getDefault(developType, PRE_TWO_YEAR, year), develop_row_Index);
            model.setValue(PRE_THREE_YEAR, (Object)this.getDefault(developType, PRE_THREE_YEAR, year), develop_row_Index);
            ++develop_row_Index;
        }
        model.endInit();
        this.getView().updateView(INCOME_ENTRYENTITY);
        this.getView().updateView(DEVELOP_ENTRYENTITY);
    }

    private void lockRow() {
        Lists.newArrayList((Object[])new Integer[]{2, 5, 6}).stream().forEach(s -> this.getView().setEnable(Boolean.FALSE, s.intValue(), new String[]{INCOME_RATE}));
        Lists.newArrayList((Object[])new Integer[]{7, 8, 11, 12, 13, 15}).stream().forEach(s -> this.getView().setEnable(Boolean.FALSE, s.intValue(), new String[]{CURR_YEAR, PRE_TWO_YEAR, PRE_THREE_YEAR, DEVELOP_RATE}));
    }

    private BigDecimal getDefault(String row, String column, Date year) {
        String sbbColumn;
        BigDecimal result = BigDecimal.ZERO;
        if (year == null) {
            return result;
        }
        if (!this.getSbbDataMappering().containsKey(row)) {
            Date preDate = DateUtils.addYear((Date)year, (int)-1);
            String accountColumn = this.getAccountDataMappering().get(column).split("&")[0];
            result = this.getLastYearByAccount(preDate, accountColumn, row, accountColumn);
            return result;
        }
        Date preDate = DateUtils.addYear((Date)year, (int)-1);
        result = this.getLastYearBySbb(preDate, sbbColumn = this.getAccountDataMappering().get(column).split("&")[1], this.getSbbDataMappering().get(row), sbbColumn);
        if (result.compareTo(BigDecimal.ZERO) == 0) {
            String accountColumn = this.getAccountDataMappering().get(column).split("&")[0];
            result = this.getLastYearByAccount(preDate, accountColumn, row, accountColumn);
        }
        return result;
    }

    private Map<String, String> getAccountDataMappering() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PRE_TWO_YEAR, "curryear&bnd");
        map.put(PRE_THREE_YEAR, "pretwoyear&qynd");
        return map;
    }

    private Map<String, String> getSbbDataMappering() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "17");
        map.put("2", "18");
        map.put("3", "19");
        map.put("4", "20");
        map.put("5", "21");
        map.put("6", "22");
        map.put("7", "23");
        map.put("10", "26");
        map.put("11", "27");
        map.put("15", "29");
        return map;
    }

    private BigDecimal getLastYearBySbb(Date preDate, String selectFields, String item, String alias) {
        QFilter filter = new QFilter("ewblxh", "=", (Object)item);
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)this.getPreYearSbbid(preDate));
        BigDecimal result = this.getOne("tccit_qysds_a107041", selectFields, new QFilter[]{sbbidFilter, filter}, alias);
        return result;
    }

    private BigDecimal getLastYearByAccount(Date preDate, String column, String item, String alias) {
        QFilter orgFilter = new QFilter("org", "=", (Object)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
        QFilter dateFilter = new QFilter(YEAR, "=", (Object)DateUtils.getFirstDateOfYear((Date)preDate));
        QFilter seqFilter = new QFilter("developentryentity.developtype", "=", (Object)item);
        String selectFields = "developentryentity." + column + " as " + column;
        BigDecimal result = this.getOne("tccit_high_tech_account", selectFields, new QFilter[]{orgFilter, dateFilter, seqFilter}, alias);
        return result;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            String orgId = org.getString("id");
            Date year = (Date)this.getModel().getValue(YEAR);
            this.setVisibleByKey(KEY_RATE_1, this.refreshKeyMatch(orgId, KEY_RATE_1, year));
            this.setVisibleByKey(KEY_RATE_2, this.refreshKeyMatch(orgId, KEY_RATE_2, year));
            this.setVisibleByKey(KEY_RATE_3, this.refreshKeyMatch(orgId, KEY_RATE_3, year));
        }
        this.lockRow();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String optKey = args.getOperateKey();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeSet;
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        String orgId = org.getString("id");
        Date year = (Date)this.getModel().getValue(YEAR);
        if (year != null && YEAR.equals(name)) {
            Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)year);
            if (this.vaildYear(org.getLong("id"), firstDateOfYear).booleanValue()) {
                this.getModel().setValue(YEAR, null);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7%s\u5e74\u5df2\u7ecf\u5b58\u5728\u9ad8\u65b0\u6280\u672f\u4f01\u4e1a\u4f18\u60e0\u60c5\u51b5\u53f0\u8d26\uff0c\u8bf7\u52ff\u91cd\u590d\u65b0\u5efa\u53f0\u8d26\u3002", (String)"HighTechAccountPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]), DateUtils.getYearOfDate((Date)year)));
                return;
            }
            this.getModel().setValue(YEAR, (Object)firstDateOfYear);
            this.clearData();
            this.initData();
        }
        if (PEOPLES.equals(name)) {
            changeSet = args.getChangeSet();
            Integer peoples = (Integer)changeSet[0].getNewValue();
            Integer totalPeoples = (Integer)this.getModel().getValue(TOTAL_PEOPLES);
            this.setPeoPleRate(peoples, totalPeoples);
        }
        if (TOTAL_PEOPLES.equals(name)) {
            changeSet = args.getChangeSet();
            Integer totalPeoples = (Integer)changeSet[0].getNewValue();
            Integer peoples = (Integer)this.getModel().getValue(PEOPLES);
            this.setPeoPleRate(peoples, totalPeoples);
        }
        if (KEY_RATE_1.equals(name)) {
            this.setVisibleByKey(KEY_RATE_1, this.refreshKeyMatch(orgId, KEY_RATE_1, year));
        }
        if (KEY_RATE_2.equals(name)) {
            this.setVisibleByKey(KEY_RATE_2, this.refreshKeyMatch(orgId, KEY_RATE_2, year));
        }
        if (KEY_RATE_3.equals(name)) {
            this.setVisibleByKey(KEY_RATE_3, this.refreshKeyMatch(orgId, KEY_RATE_3, year));
        }
        if (INCOME_RATE.equals(name)) {
            changeSet = args.getChangeSet();
            int rowIndex = changeSet[0].getRowIndex();
            ArrayList rows = Lists.newArrayList((Object[])new Integer[]{0, 1});
            ArrayList rows2 = Lists.newArrayList((Object[])new Integer[]{3, 4});
            if (rows.contains(rowIndex)) {
                this.getModel().setValue(INCOME_RATE, (Object)this.getSum(INCOME_ENTRYENTITY, rows, INCOME_RATE), 2);
            }
            if (rows2.contains(rowIndex)) {
                BigDecimal subtract = this.getSubtract(INCOME_ENTRYENTITY, rows2, INCOME_RATE);
                if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u5e74\u4e0d\u5f81\u7a0e\u6536\u5165\u4e0d\u80fd\u5927\u4e8e\u672c\u5e74\u6536\u5165\u603b\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HighTechAccountPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
                    this.rollbackPropertyChange(args);
                    return;
                }
                this.getModel().setValue(INCOME_RATE, (Object)subtract, 5);
            }
            BigDecimal divide = this.getDivide(INCOME_ENTRYENTITY, INCOME_RATE);
            this.getModel().setValue(INCOME_RATE, (Object)divide, 6);
            this.getModel().setValue(KEY_RATE_2, (Object)divide);
        }
        if (DEVELOP_YEARS.contains(name)) {
            changeSet = args.getChangeSet();
            Object newValue = changeSet[0].getNewValue();
            int rowIndex = changeSet[0].getRowIndex();
            this.getModel().setValue(DEVELOP_RATE, (Object)this.getAdd(rowIndex), rowIndex);
            String developType = (String)this.getModel().getValue(DEVELOP_TYPE, rowIndex);
            this.getModel().setValue(name, (Object)this.get8Row(Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6"}), name), 7);
            this.getModel().setValue(name, (Object)this.get9Row(Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6"}), name), 8);
            this.getModel().setValue(name, this.get12Row(Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7"}), name), 11);
            this.getModel().setValue(name, this.get13Row(name), 12);
            this.getModel().setValue(name, this.get14Row(name), 13);
            this.refreshCountColumn();
        }
        this.getView().updateView();
        this.getView().sendFormAction(this.getView());
        this.lockRow();
    }

    private Boolean vaildYear(Long orgId, Date firstDateOfYear) {
        Long id = (Long)this.getModel().getValue("id");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter yearFilter = new QFilter(YEAR, "=", (Object)firstDateOfYear);
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"tccit_high_tech_account", (String)"id,billno", (QFilter[])new QFilter[]{idFilter, orgFilter, yearFilter});
        return accounts != null && accounts.length > 0;
    }

    private BigDecimal getAdd(int rowIndex) {
        BigDecimal curryear = (BigDecimal)this.getModel().getValue(CURR_YEAR, rowIndex);
        BigDecimal pretwo = (BigDecimal)this.getModel().getValue(PRE_TWO_YEAR, rowIndex);
        BigDecimal prethree = (BigDecimal)this.getModel().getValue(PRE_THREE_YEAR, rowIndex);
        BigDecimal add = curryear.add(pretwo).add(prethree);
        return add;
    }

    private void refreshCountColumn() {
        this.getModel().setValue(DEVELOP_RATE, (Object)this.getAdd(12), 12);
        this.getModel().setValue(DEVELOP_RATE, (Object)this.getSum(Lists.newArrayList((Object[])new String[]{"9", "13"}), DEVELOP_RATE), 13);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DEVELOP_ENTRYENTITY);
        DynamicObject row14 = (DynamicObject)entryEntity.get(13);
        DynamicObject row15 = (DynamicObject)entryEntity.get(14);
        if (row15.getBigDecimal(DEVELOP_RATE).compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue(DEVELOP_RATE, (Object)BigDecimal.ZERO, 15);
        } else {
            BigDecimal divide = row14.getBigDecimal(DEVELOP_RATE).divide(row15.getBigDecimal(DEVELOP_RATE), 4, 4);
            this.getModel().setValue(KEY_RATE_3, (Object)divide);
            this.getModel().setValue(DEVELOP_RATE, (Object)divide, 15);
        }
    }

    private Object get13Row(String column) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DEVELOP_ENTRYENTITY);
        BigDecimal row10 = ((DynamicObject)entryEntity.get(9)).getBigDecimal(column);
        BigDecimal row12 = ((DynamicObject)entryEntity.get(11)).getBigDecimal(column);
        return row10.add(row12).multiply(new BigDecimal("0.8"));
    }

    private Object get14Row(String column) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DEVELOP_ENTRYENTITY);
        BigDecimal row9 = ((DynamicObject)entryEntity.get(8)).getBigDecimal(column);
        BigDecimal row13 = ((DynamicObject)entryEntity.get(12)).getBigDecimal(column);
        return row9.add(row13);
    }

    private Object get12Row(ArrayList<String> rows, String column) {
        BigDecimal row11;
        BigDecimal row10;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DEVELOP_ENTRYENTITY);
        BigDecimal sum = this.getSum(rows, column);
        BigDecimal divide = sum.add(row10 = ((DynamicObject)entryEntity.get(9)).getBigDecimal(column)).multiply(new BigDecimal("0.4")).divide(new BigDecimal("0.6"), 2, 4);
        return divide.compareTo(row11 = ((DynamicObject)entryEntity.get(10)).getBigDecimal(column)) <= 0 ? divide : row11;
    }

    private BigDecimal getSum(List<String> rows, String column) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DEVELOP_ENTRYENTITY);
        BigDecimal sum = entryEntity.stream().filter(s -> rows.contains(s.getString(DEVELOP_TYPE))).map(s -> s.getBigDecimal(column)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum;
    }

    private BigDecimal get9Row(List<String> rows, String column) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DEVELOP_ENTRYENTITY);
        BigDecimal sum = this.getSum(rows, column);
        BigDecimal row8 = ((DynamicObject)entryEntity.get(7)).getBigDecimal(column);
        return sum.add(row8);
    }

    private BigDecimal get8Row(List<String> rows, String column) {
        BigDecimal bigDecimal;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DEVELOP_ENTRYENTITY);
        BigDecimal sum = this.getSum(rows, column);
        BigDecimal divide = sum.multiply(new BigDecimal("0.2")).divide(new BigDecimal("0.8"), 2, 4);
        return divide.compareTo(bigDecimal = ((DynamicObject)entryEntity.get(6)).getBigDecimal(column)) <= 0 ? divide : bigDecimal;
    }

    private BigDecimal getDivide(String entryEntityName, String column) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityName);
        DynamicObject row3 = (DynamicObject)entryEntity.get(2);
        DynamicObject row6 = (DynamicObject)entryEntity.get(5);
        if (row6.getBigDecimal(column).compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return row3.getBigDecimal(column).divide(row6.getBigDecimal(column), 4, 4);
    }

    private BigDecimal getSum(String entryEntityName, List<Integer> rows, String column) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityName);
        return rows.stream().map(s -> ((DynamicObject)entryEntity.get(s.intValue())).getBigDecimal(column)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getSubtract(String entryEntityName, List<Integer> rows, String column) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityName);
        DynamicObject row4 = (DynamicObject)entryEntity.get(rows.get(0).intValue());
        DynamicObject row5 = (DynamicObject)entryEntity.get(rows.get(1).intValue());
        return row4.getBigDecimal(column).subtract(row5.getBigDecimal(column));
    }

    private void setVisibleByKey(String key, Boolean aBoolean) {
        String matchImg = "match" + key.substring(key.length() - 1);
        String warnImg = "warn" + key.substring(key.length() - 1);
        if (aBoolean.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{matchImg});
            this.getView().setVisible(Boolean.FALSE, new String[]{warnImg});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{matchImg});
            this.getView().setVisible(Boolean.TRUE, new String[]{warnImg});
        }
    }

    private void clearData() {
        this.getModel().setValue(KEY_RATE_1, (Object)BigDecimal.ZERO);
        this.getModel().setValue(KEY_RATE_2, (Object)BigDecimal.ZERO);
        this.getModel().setValue(KEY_RATE_3, (Object)BigDecimal.ZERO);
        this.getModel().setValue(PEOPLES, (Object)0);
        this.getModel().setValue(TOTAL_PEOPLES, (Object)0);
        this.getModel().setValue(PEOPLE_RATE, (Object)BigDecimal.ZERO);
        this.getModel().deleteEntryData(INCOME_ENTRYENTITY);
        this.getModel().deleteEntryData(DEVELOP_ENTRYENTITY);
    }

    void setPeoPleRate(Integer peoples, Integer totalPeoples) {
        if (totalPeoples == 0) {
            this.getModel().setValue(PEOPLE_RATE, (Object)0);
            this.getModel().setValue(KEY_RATE_1, (Object)0);
            return;
        }
        BigDecimal num = new BigDecimal(peoples);
        BigDecimal totalNum = new BigDecimal(totalPeoples);
        BigDecimal rate = num.divide(totalNum, 4, 4);
        this.getModel().setValue(PEOPLE_RATE, (Object)rate);
        this.getModel().setValue(KEY_RATE_1, (Object)rate);
    }

    Boolean refreshKeyMatch(String orgId, String key, Date year) {
        DynamicObject entryRowEntity;
        if (StringUtil.isBlank((CharSequence)orgId) || year == null) {
            return Boolean.FALSE;
        }
        Boolean match = Boolean.FALSE;
        BigDecimal value = (BigDecimal)this.getModel().getValue(key);
        if (key.equals(KEY_RATE_1)) {
            BigDecimal rate = this.getRate(orgId, "kjryzb", year);
            match = value.compareTo(rate) >= 0;
        } else if (key.equals(KEY_RATE_2)) {
            BigDecimal rate = this.getRate(orgId, "gxsrzb", year);
            match = value.compareTo(rate) >= 0;
        } else if (key.equals(KEY_RATE_3) && (entryRowEntity = this.getModel().getEntryRowEntity(DEVELOP_ENTRYENTITY, 14)) != null) {
            BigDecimal rate;
            BigDecimal income = entryRowEntity.getBigDecimal(CURR_YEAR);
            match = income.compareTo(HighTechAccountPlugin.getTenthousand(5000)) <= 0 ? Boolean.valueOf(value.compareTo(rate = this.getRate(orgId, "yffyzb-sr\u22645000", year)) >= 0) : (income.compareTo(HighTechAccountPlugin.getTenthousand(20000)) <= 0 ? Boolean.valueOf(value.compareTo(rate = this.getRate(orgId, "yffyzb-5000\uff1csr\u226420000", year)) >= 0) : Boolean.valueOf(value.compareTo(rate = this.getRate(orgId, "yffyzb-sr\uff1e20000", year)) >= 0));
        }
        return match;
    }

    static BigDecimal getTenthousand(Integer amount) {
        return new BigDecimal(amount).multiply(new BigDecimal("10000"));
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }

    private BigDecimal getRate(String orgId, String code, Date year) {
        String lastDateOfYear;
        String firstDateOfYear = DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)year));
        List deductionRateList = AssistService.queryAssistParams((String)code, (String)orgId, (String)firstDateOfYear, (String)(lastDateOfYear = DateUtils.format((Date)DateUtils.getLastDateOfYear((Date)year))));
        return CollectionUtils.isEmpty((Collection)deductionRateList) ? BigDecimal.ZERO : new BigDecimal((String)deductionRateList.get(0)).divide(new BigDecimal("100"));
    }

    private BigDecimal getOne(String entityName, String selectFields, QFilter[] filters, String alias) {
        DynamicObject object = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])filters);
        BigDecimal result = object != null ? object.getBigDecimal(alias) : BigDecimal.ZERO;
        return result;
    }

    private String getPreYearSbbid(Date year) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgid = org.getLong("id");
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)year);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)year);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)firstDateOfYear).and(new QFilter("skssqz", "=", (Object)lastDateOfYear));
        QFilter typeFilter = new QFilter("type", "=", (Object)"qysdsnb");
        DynamicObjectCollection temp = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)" * ", (QFilter[])new QFilter[]{orgFilter, dateFilter, typeFilter});
        if (CollectionUtils.isEmpty((Collection)temp)) {
            return "";
        }
        return ((DynamicObject)temp.get(0)).getString("id");
    }
}

