/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class InvestAssetJzbdEdit
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    private static final String BILL_NO = "billno";
    private static final String BOOKED_TIME = "bookedtime";
    protected static final String INVEST_ASSET_JZBD = "tccit_invest_asset_jzbd";
    private static final String INVEST_JZBD_DETAIL = "tccit_invest_jzbd_detail";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit type = (BasedataEdit)this.getView().getControl("name");
        type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent bfse) {
        BasedataEdit source = (BasedataEdit)bfse.getSource();
        String fieldKey = source.getFieldKey();
        if ("name".equals(fieldKey)) {
            bfse.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u6807\u7684\u540d\u79f0", (String)"InvestAssetJzbdEdit_0", (String)"taxc-tccit", (Object[])new Object[0]));
            Object value = this.getModel().getValue("org");
            if (value != null) {
                DynamicObject org = (DynamicObject)value;
                String orgNumber = org.getString("number");
                bfse.addCustomQFilter(new QFilter("org.number", "=", (Object)orgNumber));
                bfse.addCustomQFilter(new QFilter("assetstatus", "=", (Object)"0"));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"InvestAssetJzbdEdit_1", (String)"taxc-tccit", (Object[])new Object[0]));
                bfse.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (BOOKED_TIME.equals(name)) {
            long nameId;
            DynamicObjectCollection obtainDates;
            Date obtainDate;
            ChangeData[] changeSet = args.getChangeSet();
            Date newValue = (Date)changeSet[0].getNewValue();
            DynamicObject investName = (DynamicObject)this.getModel().getValue("name");
            if (investName != null && newValue != null && (obtainDate = (Date)(obtainDates = QueryServiceHelper.query((String)"tccit_new_invest_asset", (String)"tccit_new_invest_detail.date obtainDate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(nameId = investName.getLong("id")))})).stream().map(d -> d.getDate("obtainDate")).filter(Objects::nonNull).min(Date::compareTo).orElse(null)) != null && newValue.compareTo(obtainDate) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u4ea7\u4ef7\u503c\u53d8\u52a8\u65f6\u95f4\u4e0d\u5e94\u65e9\u4e8e\u8be5\u8d44\u4ea7\u7684\u5165\u8d26\u65f6\u95f4", (String)"InvestAssetJzbdEdit_2", (String)"taxc-tccit", (Object[])new Object[0]));
                int rowIndex = changeSet[0].getRowIndex();
                Date oldValue = (Date)changeSet[0].getOldValue();
                if (oldValue != null && oldValue.compareTo(obtainDate) >= 0) {
                    this.getModel().setValue(name, (Object)oldValue, rowIndex);
                } else {
                    this.getModel().setValue(name, null, rowIndex);
                }
            }
        } else if ("amount".equals(name)) {
            String jzbdtype;
            ChangeData[] changeSet = args.getChangeSet();
            ChangeData changeData = changeSet[0];
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            if (newValue != null && StringUtils.isNotBlank((CharSequence)(jzbdtype = (String)this.getModel().getValue("jzbdtype"))) && "1".equals(jzbdtype) && newValue.compareTo(BigDecimal.ZERO) < 0) {
                this.getModel().setValue("amount", (Object)0);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s: \u5f53\u4ef7\u503c\u53d8\u52a8\u7c7b\u578b=\u3010\u8d44\u4ea7\u51cf\u503c\u635f\u5931\u3011\u65f6\uff0c\u5165\u8d26\u91d1\u989d\u5fc5\u987b\u22650", (String)"InvestAssetJzbdEdit_3", (String)"taxc-tccit", (Object[])new Object[0]), changeData.getRowIndex() + 1));
            }
        } else if ("jzbdtype".equals(name)) {
            this.getModel().setValue("amount", (Object)0);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        Map sourceData = args.getSourceData();
        JSONObject org = (JSONObject)sourceData.get("org");
        String billno = (String)sourceData.get(BILL_NO);
        QFilter[] qFilters = new QFilter[]{new QFilter(BILL_NO, "=", (Object)billno), new QFilter("org.number", "=", org.get((Object)"number"))};
        boolean exists = QueryServiceHelper.exists((String)INVEST_ASSET_JZBD, (QFilter[])qFilters);
        if (exists) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u8d44\u4ea7\u7f16\u7801\uff0c\u8bf7\u4fee\u6539", (String)"InvestAssetJzbdEdit_4", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
        boolean inNewInvestAsset = QueryServiceHelper.exists((String)"tccit_new_invest_asset", (QFilter[])qFilters);
        if (!inNewInvestAsset) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6", (String)"InvestAssetJzbdEdit_5", (String)"taxc-tccit", (Object[])new Object[0]), billno)));
            return;
        }
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"tccit_new_invest_asset", (String)"id,assetstatus,name,assettype.id assetTypeId,investtype.id investTypeId", (QFilter[])new QFilter[]{new QFilter(BILL_NO, "=", (Object)billno)});
        if (dynObj == null) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6", (String)"InvestAssetJzbdEdit_5", (String)"taxc-tccit", (Object[])new Object[0]), billno)));
            return;
        }
        String status = dynObj.getString("assetstatus");
        if ("1".equals(status)) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u5df2\u5904\u7f6e\uff0c\u8bf7\u68c0\u67e5\u5df2\u5f55\u5165\u7684\u8d44\u4ea7\u4fe1\u606f", (String)"InvestAssetJzbdEdit_6", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
        long assetTypeId = dynObj.getLong("assetTypeId");
        sourceData.put("assettype.id", assetTypeId);
        long investTypeId = dynObj.getLong("investTypeId");
        sourceData.put("investtype.id", investTypeId);
        sourceData.put("assetstatus", status);
        long assetId = dynObj.getLong("id");
        sourceData.put("name", new JSONObject().fluentPut("id", (Object)assetId));
        DynamicObjectCollection obtainDates = QueryServiceHelper.query((String)"tccit_new_invest_asset", (String)"tccit_new_invest_detail.date obtainDate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)assetId)});
        Date obtainDate = obtainDates.stream().map(d -> d.getDate("obtainDate")).filter(Objects::nonNull).min(Date::compareTo).orElse(null);
        if (obtainDate != null) {
            List detailList = ((JSONArray)JSONArray.toJSON(sourceData.get(INVEST_JZBD_DETAIL))).stream().map(o -> (JSONObject)JSONObject.toJSON((Object)o)).collect(Collectors.toList());
            for (JSONObject detail : detailList) {
                BigDecimal amount;
                Date bookedTime = detail.getDate(BOOKED_TIME);
                if (bookedTime.compareTo(obtainDate) < 0) {
                    args.setCancel(true);
                    args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u8d44\u4ea7\u4ef7\u503c\u53d8\u52a8\u65f6\u95f4\u4e0d\u5e94\u65e9\u4e8e\u8be5\u8d44\u4ea7\u7684\u53d6\u5f97\u65f6\u95f4", (String)"InvestAssetJzbdEdit_7", (String)"taxc-tccit", (Object[])new Object[0])));
                }
                try {
                    amount = detail.getBigDecimal("amount");
                }
                catch (NumberFormatException e) {
                    args.setCancel(true);
                    args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u5165\u8d26\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u503c", (String)"InvestAssetJzbdEdit_8", (String)"taxc-tccit", (Object[])new Object[0])));
                    return;
                }
                String jzbdtype = detail.getString("jzbdtype");
                if (amount == null || !StringUtils.isNotBlank((CharSequence)jzbdtype) || !"1".equals(jzbdtype) || amount.compareTo(BigDecimal.ZERO) >= 0) continue;
                this.getModel().setValue("amount", (Object)0);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u4ef7\u503c\u53d8\u52a8\u7c7b\u578b=\u3010\u8d44\u4ea7\u51cf\u503c\u635f\u5931\u3011\u65f6\uff0c\u5165\u8d26\u91d1\u989d\u5fc5\u987b\u22650", (String)"InvestAssetJzbdEdit_9", (String)"taxc-tccit", (Object[])new Object[0]));
            }
        }
    }
}

