/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.account.InvestCysyService;
import kd.taxc.tccit.common.utils.BigDecimalUtils;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;
import org.apache.commons.lang3.math.NumberUtils;

public class InvestCysyEdit
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    private InvestCysyService investCysyService = new InvestCysyService();
    private static final Map<String, List<ComboItem>> cysytypeMap = new HashMap<String, List<ComboItem>>();
    private static final String BILL_NO = "billno";
    private static final String BIZ_DATE = "bizdate";
    protected static final String INVEST_CYSY = "tccit_invest_cysy";
    private static final String ENTRY = "entryentity";
    private static final String ZJTZJNHHQY = "202";
    private static final String tabLine = "\n";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit type = (BasedataEdit)this.getView().getControl("name");
        type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent bfse) {
        BasedataEdit source = (BasedataEdit)bfse.getSource();
        String fieldKey = source.getFieldKey();
        if ("name".equals(fieldKey)) {
            bfse.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u6807\u7684\u540d\u79f0", (String)"InvestCysyEdit_3", (String)"taxc-tccit", (Object[])new Object[0]));
            Object value = this.getModel().getValue("org");
            if (value != null) {
                DynamicObject org = (DynamicObject)value;
                String orgNumber = org.getString("number");
                bfse.addCustomQFilter(new QFilter("org.number", "=", (Object)orgNumber));
                bfse.addCustomQFilter(new QFilter("assetstatus", "=", (Object)"0"));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"InvestCysyEdit_4", (String)"taxc-tccit", (Object[])new Object[0]));
                bfse.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        block15: {
            DynamicObject investName;
            String name;
            block14: {
                name = args.getProperty().getName();
                if (!BIZ_DATE.equals(name)) break block14;
                ChangeData[] changeSet = args.getChangeSet();
                Date newValue = (Date)changeSet[0].getNewValue();
                DynamicObject investName2 = (DynamicObject)this.getModel().getValue("name");
                if (investName2 == null || newValue == null) break block15;
                long nameId = investName2.getLong("id");
                DynamicObjectCollection obtainDates = this.investCysyService.getInvestAsset(nameId);
                this.updateInvestratio(obtainDates, newValue, changeSet[0].getRowIndex());
                Date obtainDate = obtainDates.stream().map(d -> d.getDate("obtainDate")).filter(Objects::nonNull).min(Date::compareTo).orElse(null);
                if (obtainDate == null || newValue.compareTo(obtainDate) >= 0) break block15;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6301\u6709\u6536\u76ca\u7684\u65f6\u95f4\u4e0d\u5e94\u65e9\u4e8e\u8be5\u8d44\u4ea7\u7684\u53d6\u5f97\u65f6\u95f4", (String)"InvestCysyEdit_5", (String)"taxc-tccit", (Object[])new Object[0]));
                int rowIndex = changeSet[0].getRowIndex();
                Date oldValue = (Date)changeSet[0].getOldValue();
                if (oldValue != null && oldValue.compareTo(obtainDate) >= 0) {
                    this.getModel().setValue(name, (Object)oldValue, rowIndex);
                } else {
                    this.getModel().setValue(name, null, rowIndex);
                }
                break block15;
            }
            if ("investtype".equals(name)) {
                DynamicObject investtype = (DynamicObject)this.getModel().getValue("investtype");
                if (investtype != null) {
                    String number = investtype.getString("number");
                    ComboEdit comboEdit = (ComboEdit)this.getControl("cysytype");
                    comboEdit.setComboItems(cysytypeMap.get(number));
                    if (!ZJTZJNHHQY.equals(number)) {
                        this.refreshInvestratioYnse();
                    }
                } else {
                    this.refreshInvestratioYnse();
                }
            } else if ("investratio".equals(name) || "ynse".equals(name)) {
                String number;
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY);
                DynamicObject investtype = (DynamicObject)this.getModel().getValue("investtype");
                Date bizdate = (Date)this.getModel().getValue(BIZ_DATE, rowIndex);
                if (investtype != null && ZJTZJNHHQY.equals(number = investtype.getString("number"))) {
                    if (bizdate == null && "investratio".equals(name)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4e1a\u52a1\u65e5\u671f\u201d\u3002", (String)"InvestCysyEdit_14", (String)"taxc-tccit", (Object[])new Object[0]));
                        this.getModel().setValue("investratio", (Object)BigDecimal.ZERO, rowIndex);
                    } else {
                        BigDecimal investratio = (BigDecimal)this.getModel().getValue("investratio", rowIndex);
                        BigDecimal ynse = (BigDecimal)this.getModel().getValue("ynse", rowIndex);
                        this.getModel().setValue("qrsrje", (Object)BigDecimalUtil.multiplyObject((Object)investratio, (Object)ynse, (int)2), rowIndex);
                    }
                }
            } else if ("name".equals(name) && (investName = (DynamicObject)this.getModel().getValue("name")) != null) {
                long nameId = investName.getLong("id");
                DynamicObjectCollection obtainDates = this.investCysyService.getInvestAsset(nameId);
                DynamicObjectCollection entryentityCols = this.getModel().getEntryEntity(ENTRY);
                for (int index = 0; index < entryentityCols.size(); ++index) {
                    Date bizDate = (Date)this.getModel().getValue(BIZ_DATE, index);
                    if (bizDate == null) continue;
                    this.updateInvestratio(obtainDates, bizDate, index);
                }
            }
        }
    }

    private void updateInvestratio(DynamicObjectCollection obtainDates, Date bizDate, int index) {
        DynamicObject object = obtainDates.stream().filter(d -> d.getDate("obtainDate") != null && d.getDate("obtainDate").compareTo(bizDate) < 0).max(Comparator.comparing(d -> d.getDate("obtainDate"))).orElse(null);
        if (object != null) {
            this.getModel().setValue("investratio", (Object)object.getBigDecimal("tzbl"), index);
        } else {
            this.getModel().setValue("investratio", (Object)BigDecimal.ZERO, index);
        }
    }

    private void refreshInvestratioYnse() {
        DynamicObjectCollection entryentityCols = this.getModel().getEntryEntity(ENTRY);
        for (int index = 0; index < entryentityCols.size(); ++index) {
            this.getModel().setValue("investratio", (Object)BigDecimal.ZERO, index);
            this.getModel().setValue("ynse", (Object)BigDecimal.ZERO, index);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject investtype = (DynamicObject)this.getModel().getValue("investtype");
        if (investtype != null && investtype.get("number") != null) {
            String number = investtype.getString("number");
            ComboEdit comboEdit = (ComboEdit)this.getControl("cysytype");
            List<ComboItem> items = cysytypeMap.get(number);
            comboEdit.setComboItems(items);
            int count = this.getModel().getEntryRowCount(ENTRY);
            Set set = items.stream().map(ComboItem::getValue).collect(Collectors.toSet());
            for (int i = 0; i < count; ++i) {
                String cysytype = (String)this.getModel().getValue("cysytype", i);
                if (set.contains(cysytype)) continue;
                this.getModel().setValue("cysytype", (Object)"", i);
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        Map sourceData = args.getSourceData();
        JSONObject org = (JSONObject)sourceData.get("org");
        String billno = (String)sourceData.get(BILL_NO);
        QFilter[] qFilters = new QFilter[]{new QFilter(BILL_NO, "=", (Object)billno), new QFilter("org.number", "=", org.get((Object)"number"))};
        boolean exists = QueryServiceHelper.exists((String)INVEST_CYSY, (QFilter[])qFilters);
        if (exists) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u8d44\u4ea7\u7f16\u7801\uff0c\u8bf7\u4fee\u6539", (String)"InvestCysyEdit_6", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
        boolean inNewInvestAsset = QueryServiceHelper.exists((String)"tccit_new_invest_asset", (QFilter[])qFilters);
        if (!inNewInvestAsset) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6", (String)"InvestCysyEdit_7", (String)"taxc-tccit", (Object[])new Object[0]), billno)));
            return;
        }
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"tccit_new_invest_asset", (String)"id,assetstatus,name,assettype.id assetTypeId,investtype.id investTypeId,investtype.number investTypeNumber", (QFilter[])new QFilter[]{new QFilter(BILL_NO, "=", (Object)billno)});
        if (dynObj == null) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6", (String)"InvestCysyEdit_7", (String)"taxc-tccit", (Object[])new Object[0]), billno)));
            return;
        }
        String status = dynObj.getString("assetstatus");
        if ("1".equals(status)) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u5df2\u5904\u7f6e\uff0c\u8bf7\u68c0\u67e5\u5df2\u5f55\u5165\u7684\u8d44\u4ea7\u4fe1\u606f", (String)"InvestCysyEdit_8", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
        long assetTypeId = dynObj.getLong("assetTypeId");
        sourceData.put("assettype.id", assetTypeId);
        long investTypeId = dynObj.getLong("investTypeId");
        sourceData.put("investtype.id", investTypeId);
        sourceData.put("assetstatus", status);
        long assetId = dynObj.getLong("id");
        sourceData.put("name", new JSONObject().fluentPut("id", (Object)assetId));
        DynamicObjectCollection obtainDates = QueryServiceHelper.query((String)"tccit_new_invest_asset", (String)"tccit_new_invest_detail.date obtainDate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)assetId)});
        Date obtainDate = obtainDates.stream().map(d -> d.getDate("obtainDate")).filter(Objects::nonNull).min(Date::compareTo).orElse(null);
        String investTypeNumber = dynObj.getString("investTypeNumber");
        List detailList = ((JSONArray)JSONArray.toJSON(sourceData.get(ENTRY))).stream().map(o -> (JSONObject)JSONObject.toJSON((Object)o)).collect(Collectors.toList());
        for (JSONObject detail : detailList) {
            BigDecimal mssrje;
            List<ComboItem> comboItems = cysytypeMap.get(investTypeNumber);
            String cysytype = (String)detail.get((Object)"cysytype");
            boolean noneMatch = comboItems.stream().noneMatch(c -> StringUtils.equals((CharSequence)cysytype, (CharSequence)c.getValue()));
            if (noneMatch) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u3010\u6301\u6709\u6536\u76ca\u7c7b\u578b\u3011\u4e0e\u3010\u6295\u8d44\u6027\u8d28\u3011\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3010\u6301\u6709\u6536\u76ca\u7c7b\u578b\u3011", (String)"InvestCysyEdit_9", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            Date bookedTime = detail.getDate(BIZ_DATE);
            if (obtainDate != null && bookedTime.compareTo(obtainDate) < 0) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u786e\u8ba4\u6301\u6709\u6536\u76ca\u7684\u65f6\u95f4\u4e0d\u5e94\u65e9\u4e8e\u8be5\u8d44\u4ea7\u7684\u53d6\u5f97\u65f6\u95f4", (String)"InvestCysyEdit_5", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            String sfsjms = detail.getString("sfsjms");
            String mssrjeStr = detail.getString("mssrje");
            if ("1".equals(sfsjms) && Objects.isNull(mssrjeStr)) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u3010\u514d\u7a0e\u6536\u5165\u91d1\u989d\u3011", (String)"InvestCysyEdit_10", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)mssrjeStr) && !NumberUtils.isCreatable((String)mssrjeStr)) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u3010\u514d\u7a0e\u6536\u5165\u91d1\u989d\u3011\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c", (String)"InvestCysyEdit_11", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            BigDecimal bigDecimal = mssrje = StringUtils.isNotBlank((CharSequence)mssrjeStr) ? new BigDecimal(mssrjeStr) : BigDecimal.ZERO;
            if (mssrje.compareTo(BigDecimal.ZERO) < 0) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u3010\u514d\u7a0e\u6536\u5165\u91d1\u989d\u3011\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c", (String)"InvestCysyEdit_11", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            String qrsrjeStr = detail.getString("qrsrje");
            if (StringUtils.isBlank((CharSequence)qrsrjeStr) || !NumberUtils.isCreatable((String)qrsrjeStr)) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u3010\u786e\u8ba4\u6536\u5165\u91d1\u989d\u3011\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c", (String)"InvestCysyEdit_12", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            BigDecimal qrsrje = new BigDecimal(qrsrjeStr);
            if (qrsrje.compareTo(BigDecimal.ZERO) < 0) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u3010\u786e\u8ba4\u6536\u5165\u91d1\u989d\u3011\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c", (String)"InvestCysyEdit_12", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            if (mssrje.compareTo(qrsrje) > 0) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u3010\u514d\u7a0e\u6536\u5165\u91d1\u989d\u3011\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u3010\u786e\u8ba4\u6536\u5165\u91d1\u989d\u3011", (String)"InvestCysyEdit_13", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            String investratioName = ResManager.loadKDString((String)"\u201c\u6295\u8d44\u6bd4\u4f8b\u201d", (String)"InvestCysyEdit_15", (String)"taxc-tccit", (Object[])new Object[0]);
            String ynseName = ResManager.loadKDString((String)"\u201c\u5408\u4f19\u4f01\u4e1a\u5e94\u7eb3\u7a0e\u6240\u5f97\u989d\u201d", (String)"InvestCysyEdit_16", (String)"taxc-tccit", (Object[])new Object[0]);
            String investratio = detail.getString("investratio");
            String ynse = detail.getString("ynse");
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put(investratioName, investratio);
            valueMap.put(ynseName, ynse);
            String checkNumericMessage = this.checkNumeric(valueMap);
            if (StringUtils.isNotBlank((CharSequence)checkNumericMessage)) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(checkNumericMessage));
                return;
            }
            if (ZJTZJNHHQY.equals(investTypeNumber) || investratio == null && ynse == null) continue;
            String investratioTipName = "";
            String ynseTipName = "";
            if (investratio != null) {
                investratioTipName = investratioName;
            }
            if (ynse != null) {
                ynseTipName = ynseName;
            }
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u5f53\u6295\u8d44\u6027\u8d28=\u201c\u76f4\u63a5\u6295\u8d44\u5883\u5185\u5408\u4f19\u4f01\u4e1a\u201d\u624d\u9700\u8981\u5f55\u5165%1$s%2$s\u3002", (String)"InvestCysyEdit_17", (String)"taxc-tccit", (Object[])new Object[0]), investratioTipName, ynseTipName)));
            return;
        }
    }

    private String checkNumeric(Map<String, String> valueMap) {
        StringBuilder message = new StringBuilder();
        for (Map.Entry<String, String> value : valueMap.entrySet()) {
            boolean isNumeric = BigDecimalUtils.checkNumeric(value.getValue());
            if (isNumeric) continue;
            InvestCysyEdit.errorMsg(message, String.format(ResManager.loadKDString((String)"%s\uff1a\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"InvestCysyEdit_18", (String)"taxc-tccit", (Object[])new Object[0]), value.getKey()));
        }
        return message.toString();
    }

    private static void errorMsg(StringBuilder errors, String msg) {
        errors.append(msg).append(tabLine);
    }

    static {
        ComboItem gxhl = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u80a1\u606f\u7ea2\u5229", (String)"InvestCysyEdit_0", (String)"taxc-tccit", (Object[])new Object[0])), "1");
        ComboItem hhqyfpsr = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5408\u4f19\u4f01\u4e1a\u5206\u914d\u6536\u5165", (String)"InvestCysyEdit_1", (String)"taxc-tccit", (Object[])new Object[0])), "2");
        ComboItem qt = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InvestCysyEdit_2", (String)"taxc-tccit", (Object[])new Object[0])), "3");
        cysytypeMap.put("209", Collections.singletonList(qt));
        cysytypeMap.put(ZJTZJNHHQY, Collections.singletonList(hhqyfpsr));
        List<ComboItem> comboItems = Arrays.asList(gxhl, qt);
        cysytypeMap.put("201", comboItems);
        cysytypeMap.put("203", comboItems);
        cysytypeMap.put("204", comboItems);
        cysytypeMap.put("205", comboItems);
        cysytypeMap.put("206", comboItems);
        cysytypeMap.put("207", comboItems);
        cysytypeMap.put("208", comboItems);
        cysytypeMap.put("210", comboItems);
        cysytypeMap.put("211", comboItems);
        cysytypeMap.put("212", comboItems);
        cysytypeMap.put("213", comboItems);
    }
}

