/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.lang.StringUtils;

public class InvestCysyList
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final String ASSET_TYPE_NAME = "assettype.projectname";
    private static final String INVEST_TYPE_NAME = "investtype.projectname";
    private static final String ASSET_TYPE_ID = "assettype.id";
    private static final String INVEST_TYPE_ID = "investtype.id";
    private static final String PROJECT_NAME = "projectname";
    private static final String ASSET_TYPE_PARENT_NUM = "1";
    private static final String INVEST_TYPE_PARENT_NUM = "2";
    private static final String PARENT_NUMBER = "parent.number";
    private static final String TCCIT_BIZDEF_ENTRY = "tpo_tccit_bizdef_entry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.setTccitBizDefFilterComboItems(args, ASSET_TYPE_NAME, ASSET_TYPE_PARENT_NUM);
        this.setTccitBizDefFilterComboItems(args, INVEST_TYPE_NAME, INVEST_TYPE_PARENT_NUM);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent bffe) {
        String fieldName = bffe.getFieldName();
        if (ASSET_TYPE_ID.equals(fieldName) || ASSET_TYPE_NAME.equals(fieldName)) {
            bffe.addCustomParam("caption", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u578b", (String)"InvestCysyList_0", (String)"taxc-tccit", (Object[])new Object[0]));
            bffe.setQfilters(Collections.singletonList(new QFilter(PARENT_NUMBER, "=", (Object)ASSET_TYPE_PARENT_NUM)));
        } else if (INVEST_TYPE_ID.equals(fieldName) || INVEST_TYPE_NAME.equals(fieldName)) {
            bffe.addCustomParam("caption", (Object)ResManager.loadKDString((String)"\u6295\u8d44\u6027\u8d28", (String)"InvestCysyList_1", (String)"taxc-tccit", (Object[])new Object[0]));
            bffe.setQfilters(Collections.singletonList(new QFilter(PARENT_NUMBER, "=", (Object)INVEST_TYPE_PARENT_NUM)));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"delete", (String)callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            ListSelectedRowCollection collection = ((IListView)this.getView()).getSelectedRows();
            List bizNos = collection.stream().map(ListSelectedRow::getBillNo).collect(Collectors.toList());
            DeleteServiceHelper.delete((String)billFormId, (QFilter[])new QFilter[]{new QFilter("billno", "in", bizNos)});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"InvestCysyList_2", (String)"taxc-tccit", (Object[])new Object[0]));
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.clearSelection();
            billlist.refreshData();
        }
    }

    private void setTccitBizDefFilterComboItems(FilterContainerInitArgs args, String fieldName, String parentNum) {
        CommonFilterColumn cfc = (CommonFilterColumn)args.getFilterColumn(fieldName);
        QFilter parentFilter = new QFilter(PARENT_NUMBER, "=", (Object)parentNum);
        DynamicObjectCollection assetType = QueryServiceHelper.query((String)TCCIT_BIZDEF_ENTRY, (String)"id,projectname", (QFilter[])new QFilter[]{parentFilter}, (String)"number");
        List collect = assetType.stream().map(at -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(String.valueOf(at.getLong("id")));
            comboItem.setCaption(new LocaleString(at.getString(PROJECT_NAME)));
            return comboItem;
        }).collect(Collectors.toList());
        cfc.setComboItems(collect);
    }
}

